/* RCS log added by Nick Haines 09-Apr-93
 *
 * $Log: ml_mach.c,v $
 * Revision 1.3  1993/04/22  12:44:46  jgmorris
 * Added ml_task_by_pid.
 *
 * Revision 1.2  93/04/09  16:48:59  nickh
 * Changed tag_ to TAG_ in various places. Hopefully this will now compile
 * with 0.93.
 * 
 * Revision 1.1  93/04/09  16:45:58  nickh
 * SML/Mach 0.75 version.
 * 
 *
 */

#include "ml_mach.h"

/* ml_task_by_pid: string[4] = 32-bit int -> bytearray[4] = port
 * Nasty hack to get the task port from the U*x pid */
ml_val_t ml_task_by_pid (msp, arg)
     ml_state_t *msp;
     ml_val_t    arg;
{
  int res;
  ml_val_t result_ptr;

  DO_SYSCALL (task_by_pid ((int) REC_SEL (arg, 0)), res);
  INT32_ALLOC (msp, result_ptr, (ml_val_t) res);
  CHK_RETURN_VAL (msp, res, result_ptr);
}

/* ml_mach_msg : 
   msg * option * send_size * rcv_size * rcv_port * timeout * notify 
   -> int32

   msg      ~= bytearray
   option    = int
   send_size = int
   rcv_size  = int
   rcv_port  = word = bytearray (4 bytes)
   timeout   = int (msec)
   notify    = word = bytearray (4 bytes)

   The return value holds the return value from the mach_msg call.
   (We need all 32 bits).

*/
ml_val_t ml_mach_msg (msp, arg)
     ml_state_t *msp;
     ml_val_t    arg;
{
  int res;
  ml_val_t result_ptr;

  mach_msg_header_t *msg  = REC_SELPTR (mach_msg_header_t, arg, 0);
  int             option  = REC_SELINT (arg, 1);
  int          send_size  = REC_SELINT (arg, 2);
  int           rcv_size  = REC_SELINT (arg, 3);
  mach_port_t   rcv_port  = (* (REC_SELPTR (mach_port_t, arg, 4)));
  int            timeout  = REC_SELINT(arg, 5);
  mach_port_t     notify  = (* (REC_SELPTR (mach_port_t, arg, 6)));

  DO_SYSCALL (mach_msg (msg, option, send_size, rcv_size, 
			rcv_port, timeout, notify), res);
  INT32_ALLOC (msp, result_ptr, (ml_val_t) res);
  CHK_RETURN_VAL(msp, res, result_ptr);
}


/* ml_task_self : unit -> port
 */
ml_val_t ml_task_self (msp,arg)
     ml_state_t *msp;
     ml_val_t    arg;
{
  int res;
  ml_val_t result_ptr;

  DO_SYSCALL (mach_task_self (), res);
  INT32_ALLOC (msp, result_ptr, (ml_val_t) res);
  CHK_RETURN_VAL (msp, 0, result_ptr);
}

/* ml_port_allocate : ipc_space * port_right -> port 
 */
ml_val_t ml_port_allocate (msp,arg)
     ml_state_t *msp;
     ml_val_t    arg;
{
  int res;
  ml_val_t result_ptr;
  mach_port_t task = * (mach_port_t *) REC_SEL (arg, 0);
  mach_port_t result_port;
  int port_right = REC_SELINT (arg, 1);

  DO_SYSCALL (mach_port_allocate (task, port_right, &result_port), res);
  INT32_ALLOC (msp, result_ptr, (ml_val_t) result_port);
  CHK_RETURN_VAL (msp, res, result_ptr);
}

/* ml_port_insert_right : ipc_space * port1 * port2 * port_right -> unit
 */
ml_val_t ml_port_insert_right (msp,arg)
     ml_state_t *msp;
     ml_val_t    arg;
{
  int res;
  mach_port_t ipc_space = (*REC_SELPTR(mach_port_t,arg, 0));
  mach_port_t port1     = (*REC_SELPTR(mach_port_t,arg, 1));
  mach_port_t port2     = (*REC_SELPTR(mach_port_t,arg, 2));
  int port_right    = REC_SELINT(arg,3);

  DO_SYSCALL (mach_port_insert_right (ipc_space, port1, port2, port_right),
	      res)
  CHK_RETURN_UNIT(msp, res);
}
