#include "ml_mach.h"
#include "ml-base.h"
#include "ml-state.h"
#include "ml-values.h"
/*
#include "ml_types.h"
*/

#include <signal.h>   /* just for SIGALRM */

typedef struct {
  mach_msg_header_t Head;
  mach_msg_type_t   CodeType;
  int               Code;
} timer_msg_type;

int             timer_value; /* in msecs,  <= 0 means no timer */
mach_port_t     ml_timer_port;
timer_msg_type  timer_msg;

/* mach_setitimer : (int * int * int * int * int) -> unit
 * To be compatible with the old setitimer.  If the first
 * value is non-zero, then die.
 */
void ml_mach_setitimer (msp, arg)
     ml_state_t *msp;
     ml_val_t arg;
{
  int secs, usecs;
  kern_return_t r;

  if (REC_SELINT(arg,0) != 0)
    Die("mach itimer supports only alarm\n");
  secs = REC_SELINT(arg,1);
  usecs = REC_SELINT(arg,2);
  timer_msg.Head.msgh_bits = MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, 0);
  timer_msg.Head.msgh_size           = sizeof(timer_msg_type);
  timer_msg.Head.msgh_remote_port    = ml_timer_port;
  timer_msg.Head.msgh_local_port     = MACH_PORT_NULL;
  timer_msg.Head.msgh_kind           = MACH_MSGH_KIND_NORMAL;
  timer_msg.Head.msgh_id             = 1234;
  timer_msg.CodeType.msgt_name       = MACH_MSG_TYPE_INTEGER_32;
  timer_msg.CodeType.msgt_size       = 32;
  timer_msg.CodeType.msgt_number     = 1;
  timer_msg.CodeType.msgt_inline     = TRUE;
  timer_msg.CodeType.msgt_longform   = FALSE;
  timer_msg.CodeType.msgt_deallocate = FALSE;
  timer_msg.CodeType.msgt_unused     = 0;
  timer_msg.Code = (secs * 1000) + (usecs / 1000);
  CHECK(r,mach_msg((mach_msg_header_t*)&timer_msg,MACH_SEND_MSG,
		   sizeof(timer_msg_type), 0, MACH_PORT_NULL,
		   MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL));
  RETURN(msp, ML_unit);
}


void *mach_timer_thread(arg)
     void *arg;
{
  timer_msg_type timer_ping;
  kern_return_t r;
/*  extern ml_state_t find_proc();  in mp.c     */
  extern void mach_signal();      /* in signal.c */
  extern mach_port_t new_exc_port;

  cthread_wire();
  CHECK(r,thread_set_exception_port(mach_thread_self(), new_exc_port));

  while(TRUE) {
    if (timer_value <= 0) {
      /* No timeout set, wait until someone sets one and wakes us */
      CHECK(r,mach_msg ((mach_msg_header_t*)&timer_ping, MACH_RCV_MSG, 0,
			sizeof(timer_msg_type), ml_timer_port,
			MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL));
      timer_value = timer_ping.Code;
    } else {
      /* Wait until timeout expires or someone sets a new timeout value */
      r = mach_msg((mach_msg_header_t*)&timer_ping,
		   MACH_RCV_MSG | MACH_RCV_TIMEOUT, 0, sizeof(timer_msg_type),
		   ml_timer_port, timer_value, MACH_PORT_NULL);
      if (r == MACH_RCV_TIMED_OUT) {
	mach_signal(VProcStates[0],SIGALRM);
      } else {
	CHECK(r,r);
	timer_value = timer_ping.Code;
      }
    }
  }
}

void mach_timer_init()
{
  kern_return_t r;

  CHECK(r,mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE,
			     &ml_timer_port));
  CHECK(r,mach_port_insert_right(mach_task_self(), ml_timer_port, 
				 ml_timer_port, MACH_MSG_TYPE_MAKE_SEND));
  timer_value = 0;
  cthread_detach(cthread_fork(mach_timer_thread,0));
}
