/* Handles the MIPS dependent exception code */

/* RCS log added by Nick Haines 25-Mar-93
 *
 * $Log: MIPS.exc.c,v $
 * Revision 1.12  1994/08/26  00:58:04  milnes
 * Added a flush to stdout and stderr before printing out unaligned access exception.
 *
 * Revision 1.11  1994/08/25  19:48:26  milnes
 * Added a flush after the mach exception handler prints so that
 * we can more closely track down the source of such errors.
 *
 * Revision 1.10  1994/04/24  17:36:26  jgmorris
 * Fixed 0.0 / 0.0 bug -- now raises Div as it's supposed to.
 *
 * Revision 1.9  94/03/10  14:50:39  jgmorris
 * More error messages.
 * 
 * Revision 1.8  94/02/14  23:00:08  jgmorris
 * Turned on some code that prints out something if an unaligned
 * exception is raised -- in fact, it dumps a whole lot of info.
 * This is good in that it will tell folks when they're doing this
 * "bad" thing.
 * 
 * Revision 1.7  93/07/21  02:46:53  nickh
 * Rearranged a lot of code, and added code to spot unaligned accesses.
 * We raise SysError(-1,"Unaligned") in that case.
 * 
 * Revision 1.6  1993/04/26  18:36:37  nickh
 * Added right incantation to get Mach GDB to accept the exception which we
 * hand off when a breakpoint occurs.
 *
 * Revision 1.5  93/04/15  16:57:49  nickh
 * Whoops.
 * 
 * Revision 1.4  93/04/15  16:27:23  nickh
 * Try to account for GDB breakpoints.
 * 
 * Revision 1.3  93/04/12  15:13:56  nickh
 * MACHINEID now lives in cstruct.c, not here.
 * 
 * Revision 1.2  93/03/26  16:36:59  nickh
 * Upgraded to SML/NJ 0.93. The main change is that GC is not called
 * through a trap, but directly, so the old ghandle code which used to go
 * in here is redundant.
 * 
 * Revision 1.1  93/03/25  17:11:08  nickh
 * SML/Mach 0.75 version.
 * 
 *
 */

#include "ml_mach.h"
#include "exc.h"
/*
#include "ml_types.h"
*/
#include <mach/exception.h>
#include <signal.h> /* for BRK_DIVZERO and BRK_OVERFLOW */
#include <stdio.h>

/* exception handler */

mach_port_t     new_exc_port;
mach_port_t     old_exc_port;


extern int         request_fault[];/*, div_e0[], overflow_e0[];*/
/*extern ml_state_t find_proc();*/

#ifdef MACH_EXN_DEBUG
void printd(s,a,b,c,d,e,f,g)
     char *s;
{
  fprintf(DebugF,"Mach Exception Handler: ");
  fprintf(DebugF,s,a,b,c,d,e,f,g);
}
#else MACH_EXN_DEBUG
void printd(s,a,b,c,d,e,f,g)
     char *s;
{
}
#endif

void printalways(s,a,b,c,d,e,f,g)
     char *s;
{
  fprintf(DebugF,"Mach Exception Handler: ");
  fprintf(DebugF,s,a,b,c,d,e,f,g);
}

#define BRK_CODE 0
#define BRK(n) (((n)<<16)+0xd)  

void report_unknown_exn (thread, state, msp, exn, code, subcode)
     mach_port_t thread;
     int         exn,code,subcode;
     ml_state_t *msp;
     struct mips_thread_state state;
{
  kern_return_t r;

  if (exn == EXC_BREAKPOINT 
     /* && code == BRK_CODE && subcode == BRK(5) */ 
      ) {
    fprintf(DebugF,"GDB breakpoint\n");
    return;
  }
  fprintf(DebugF,"[unknown exn 0x%x, code 0x%x, subcode 0x%x]\n",
	  exn,code,subcode);
  fprintf(DebugF,"[pc = 0x%x, passing to Ux server]\n",state.pc);
  if (msp->ml_inMLFlag) {
    fprintf(DebugF,"in ML, pc = 0x%x\n",state.r1);
  } else {
    fprintf(DebugF,"not in ML\n");
  }
  Die ("dying ...\n");
}

extern int syserror_id0[];

#if 0
static struct {int tag;
	       char name[10];
	     } unaligned_name = {MAKE_DESC(9,TAG_string),"Unaligned"};

static struct {int tag;
	       ml_val_t err;
	       ml_val_t str;
	     } unaligned_arg = {MAKE_DESC(2,TAG_record),INT_CtoML(-1),
				  PTR_CtoML(unaligned_name.name)};

static struct {int tag;
	       ml_val_t exn;
	       ml_val_t arg;
	     } unaligned = {MAKE_DESC(2,TAG_record), PTR_CtoML(syserror_id0+1),
				      PTR_CtoML(&unaligned_arg.err)};
#endif

kern_return_t catch_exception_raise(exception_port, thread, task,
				    exception, code, subcode)
     mach_port_t thread;
     mach_port_t task;
     int         exception;
     int         code;
     int         subcode;
{
  kern_return_t r;
/*
  MLstate_ptr msp = find_proc(0);
*/
  ml_state_t *msp = VProcStates[0];

  ML_STRING(unaligned_name,"Unaligned");

  struct mips_thread_state state;
  int state_count = MIPS_THREAD_STATE_COUNT;

  ml_val_t unaligned, unaligned_arg;

  CHECK(r,thread_get_state(thread, MIPS_THREAD_STATE,
			   (thread_state_t)(&state),&state_count));

  CHECK(r,thread_suspend(thread)); 
  CHECK(r,thread_abort(thread));  /* abort any system calls */
  printd("catch_exception_raise\n");

  r = KERN_SUCCESS;
/*  
  REC_ALLOC2(msp,unaligned_arg,INT_CtoML(-1),PTR_CtoML(unaligned_name.s));
  REC_ALLOC2(msp,unaligned,PTR_CtoML(syserror_id0+1),
	                   PTR_CtoML(&(unaligned_arg+1)));
*/
  if (msp->ml_inMLFlag) {
      /* Integer divide does not raise an exception in MIPS, so the NJ
	 code generator explicitly puts in a Break instruction 0x5000d,
	 which gets to us as a breakpoint: */
    if (exception == EXC_BREAKPOINT && code == BRK_CODE && subcode == BRK(5)) {
      printd("divide-by-zero\n");
      msp->ml_faultExn = DivExn;
    } else if (exception == EXC_ARITHMETIC) {
      if (code == BRK_OVERFLOW) {
	printd("overflow\n");
	msp->ml_faultExn = OverflowExn;
      } else if (code == EXC_MIPS_FLT_OVERFLOW) {
	printd("floating-point overflow\n");
	msp->ml_faultExn = DivExn;
      } else if (code == EXC_MIPS_FLT_DIVIDE0 || code == EXC_MIPS_FLT_INVALID)
	{
	  printd("floating-point divide-by-zero\n");
	  msp->ml_faultExn = DivExn;
	} else {
	r = KERN_FAILURE;
      }
    } else if (exception == EXC_BAD_INSTRUCTION && code == EXC_MIPS_RESADDR) {
      fflush(stdout);
      fflush(stderr);
      printalways("unaligned access\n");
      printalways("pc = 0x%x\n",state.pc);
      /*
      printalways("offending instruction: 0x%x\n",*((unsigned int *)state.pc));
      */
      printalways("reg[1] = 0x%x\n",state.r1);
      printalways("reg[2] = 0x%x\n",state.r2);
      printalways("reg[3] = 0x%x\n",state.r3);
      printalways("reg[4] = 0x%x\n",state.r4);
      printalways("reg[5] = 0x%x\n",state.r5);
      printalways("reg[6] = 0x%x\n",state.r6);
      printalways("reg[7] = 0x%x\n",state.r7);
      printalways("reg[8] = 0x%x\n",state.r8);
      printalways("reg[9] = 0x%x\n",state.r9);
      printalways("reg[10] = 0x%x\n",state.r10);
      printalways("reg[11] = 0x%x\n",state.r11);
      printalways("reg[12] = 0x%x\n",state.r12);
      printalways("reg[13] = 0x%x\n",state.r13);
      printalways("reg[14] = 0x%x\n",state.r14);
      printalways("reg[15] = 0x%x\n",state.r15);
      printalways("reg[16] = 0x%x\n",state.r16);
      printalways("reg[17] = 0x%x\n",state.r17);
      printalways("reg[18] = 0x%x\n",state.r18);
      printalways("reg[19] = 0x%x\n",state.r19);
      printalways("reg[20] = 0x%x\n",state.r20);
      printalways("reg[21] = 0x%x\n",state.r21);
      printalways("reg[22] = 0x%x\n",state.r22);
      printalways("reg[23] = 0x%x\n",state.r23);
      printalways("reg[24] = 0x%x\n",state.r24);
      printalways("reg[25] = 0x%x\n",state.r25);
      printalways("reg[26] = 0x%x\n",state.r26);
      printalways("reg[27] = 0x%x\n",state.r27);
      printalways("reg[28] = 0x%x\n",state.r28);
      printalways("reg[29] = 0x%x\n",state.r29);
      printalways("reg[30] = 0x%x\n",state.r30);
      printalways("reg[31] = 0x%x\n",state.r31);
      fflush(stderr);
        Syserror((char*)"Unaligned");
/*      msp->ml_faultExn = PTR_CtoML(&(unaligned+1));*/
    } else {
      r = KERN_FAILURE;
    }
  } else {
    r = KERN_FAILURE;
  }

  if (r == KERN_SUCCESS) {
    state.pc = (int)request_fault;
    CHECK(r,thread_set_state(thread, MIPS_THREAD_STATE,
			     (thread_state_t)&state,state_count));
  } else {
    report_unknown_exn (thread,state,msp,exception,code,subcode);
  }
  return r;
}

void *mach_exc_handler_thread (not_used)
     void *not_used;
{
  exc_request   req;
  kern_return_t r;

  cthread_wire ();
  while(TRUE) { /* loop forever */
    /* wait for an exception message */
    CHECK(r,mach_msg ((mach_msg_header_t*)&req, MACH_RCV_MSG, 0,
		      sizeof(exc_request), new_exc_port,
		      MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL));
    /* see if we can deal with the exception */
    printd("<exn = 0x%x, code = 0x%x, sub = 0x%x>\n",req.exception,
	   req.code,req.subcode);
    if (catch_exception_raise(new_exc_port, req.thread, req.task, 
			      req.exception, req.code, req.subcode) ==
	KERN_SUCCESS) {
      /* if so, resume the thread -- this assumes that the exception
       * handler called thread_suspend followed by thread_abort(), so 
       * no reply message is required.
       */
      CHECK(r,thread_resume(req.thread));
      printd("<resuming>\n");
    } else {
      /* if we don't know how to deal with the exception, we just
       * forward the message to the old exception port -- this keeps
       * us in good standing with a debugger or any other attached
       * service.
       */
      req.Head.msgh_bits = MACH_MSGH_BITS_COMPLEX |
                           MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND,
					  MACH_MSG_TYPE_MOVE_SEND_ONCE);
      req.Head.msgh_local_port = req.Head.msgh_remote_port;
      req.Head.msgh_remote_port = old_exc_port;
      printd("<forwarding>\n");
      CHECK(r, mach_msg ((mach_msg_header_t*)&req, MACH_SEND_MSG, 
			 sizeof(exc_request), 0, MACH_PORT_NULL,
			 MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL));
      CHECK(r,thread_resume(req.thread));
    }
  } /* end while */
}  

void mach_exc_init () 
{
  kern_return_t r;
  extern void set_fsr();          /* see MIPS.prim.s */
  mach_port_t self = mach_task_self();

  CHECK(r,mach_port_allocate(self, MACH_PORT_RIGHT_RECEIVE,
			   &new_exc_port));
  CHECK(r,mach_port_insert_right(self, new_exc_port, new_exc_port,
			       MACH_MSG_TYPE_MAKE_SEND));
  CHECK(r,thread_get_exception_port(mach_thread_self(), &old_exc_port));
  if (old_exc_port == MACH_PORT_NULL) {
    CHECK(r,task_get_exception_port(self, &old_exc_port));
  }
  CHECK(r,thread_set_exception_port(mach_thread_self(), new_exc_port));
  cthread_detach(cthread_fork(mach_exc_handler_thread,0));
  set_fsr(); /* enable floating-point exceptions */
}


