/* cfun-list.h
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 *
 * This file lists the directory library of C functions that are callable by ML.
 */

#ifndef CLIB_NAME
#define CLIB_NAME	"FoxNet"
#define CLIB_VERSION	"1.0"
#define CLIB_DATE	"Jan 1995"
#endif

#if defined(OPSYS_OSF1) || defined(OPSYS_ULTRIX)

  CFUNC("pfopen",        ml_pfopen,        "string * int -> int")
  CFUNC("pfget_address", ml_pfget_address, "int -> bytearray")
  CFUNC("pfset_filter",  ml_pfset_filter,  "int * bytearray -> unit")
  CFUNC("select",        ml_select,
        "int * int list * int list * int list * (int * int) option -> int")
  CFUNC("writev",        ml_writev,	   "??? -> ???")

  CFUNC("poll",        ml_poll,        "int * int -> bool")
  CFUNC("openpty",     ml_openpty,     "termios * (int * int) -> int * int")
  CFUNC("setsid",      ml_setsid,      "int -> unit")
  CFUNC("get_winsize", ml_get_winsize, "unit -> winsize")
  CFUNC("set_winsize", ml_set_winsize, "int * winsize -> unit")

#elif defined(OPSYS_NETBSD)

  CFUNC("bpfopen",	  ml_bpfopen,        "string -> int")
  CFUNC("bpfget_address", ml_bpfget_address, "int -> bytearray")
  CFUNC("bpfset_filter",  ml_bpfset_filter,  "int * bytearray -> unit")
  CFUNC("bpfnread",       ml_bpfnread     ,  "int -> int")
  CFUNC("select",        ml_select,
        "int * int list * int list * int list * (int * int) option -> int")

#elif defined(OPSYS_MACH)

  CFUNC("mach_msg", ml_mach_msg,  
        "bytearray * int ref * int * int * word32 * int * word32 -> bytearray")
  CFUNC("task_by_pid", ml_task_by_pid,  "word32 -> word32")
  CFUNC("task_self", ml_task_self, "unit -> port")
  CFUNC("port_insert_right",ml_port_insert_right, 
        "port * port * port * int -> unit")
  CFUNC("port_allocate",ml_port_allocate, "port * int -> port")
  /*
  CFUNC("mach_msg_handoff", ml_mach_msg_handoff,
        "'a io_arg -> ('a io_arg) list")
  CFUNC("mach_io_results", ml_mach_io_results, "bool -> 'a io_arg list")
  */
#else
#The foxnet C library does not support this operating system
#endif
