#ifdef OPSYS_OSF1

#include "ml-osdep.h"
#include "ml-unixdep.h"
#include INCLUDE_FCNTL_H
#include "ml-base.h"
#include "ml-values.h"
#include "ml-state.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "ml-globals.h"
#include <sys/socket.h>
#include <sys/time.h>	/* for timeval struct in pfilt.h */
#include <sys/file.h>
#include <sys/errno.h>
#include <net/if.h>
#include <net/pfilt.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <stdio.h>

#define IOVEC_COUNT 16

ml_val_t ml_writev(ml_state_t *msp, ml_val_t arg)
{
  int fileno = REC_SELINT(arg, 0);
  ml_val_t iolist = REC_SEL(arg, 1);
  struct iovec IOVector[IOVEC_COUNT];
  int IOVectorCount;
  int result;

  { /* Check to see if there is enough room in the array. */
    ml_val_t probe;

    probe = iolist;
    IOVectorCount = 0;
    while( !LIST_isNull( probe ) ) {
      IOVectorCount += 1;
      probe = LIST_tl( probe );
    }
    if ( IOVectorCount >= IOVEC_COUNT || IOVectorCount >= UIO_MAXIOV ) {
      perror("writev: TOO MANY IOVEC's");
      return RaiseSysError (msp, NIL(char *));
    }
  }

  { /* Move the iorecords into the iovec array */
    int i;
    ml_val_t probe = iolist;
    for ( i = 0; i < IOVectorCount; i++ ) {
      ml_val_t current = LIST_hd( probe );

      IOVector[i].iov_base = REC_SELPTR( char, current, 0 ) +REC_SELINT( current, 1 );
      IOVector[i].iov_len = REC_SELINT( current, 2 );

      probe = LIST_tl( probe );
    }
  }
  
  result = writev( fileno, IOVector, IOVectorCount );

  return INT_CtoML( result );
}

ml_val_t ml_hello(ml_state_t *msp, ml_val_t arg)
{
  printf( "Hello herb.\n" );
  return ML_unit;
}

#endif











