/*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	Functions to interface with the OSF1 packetfilter pseudo-device



		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	iii.	RCS Log
	1.	includes and extern declarations
	2.	ml_pfopen
	3.	ml_pfget_address
	4.	ml_pfset_filter
	5.	ml_select

		iii.	RCS Log

$Log: header.c,v $

*/

/*
	1.	includes and extern declarations
 */
#ifdef OPSYS_OSF1

#include "ml-osdep.h"
#include "ml-unixdep.h"
#include INCLUDE_FCNTL_H
#include "ml-base.h"
#include "ml-values.h"
#include "ml-state.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "ml-globals.h"
#include <sys/socket.h>
#include <sys/time.h>	/* for timeval struct in pfilt.h */
#include <sys/file.h>
#include <sys/errno.h>
#include <net/if.h>
#include <net/pfilt.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>

extern int errno;

/*
	2.	ml_pfopen
		string * int -> int
 */

ml_val_t ml_pfopen (ml_state_t *msp, ml_val_t arg)
{
    char	*interface = REC_SELPTR(char, arg, 0);
    u_short	bits = REC_SELINT(arg, 1);
    char	devname[20];
    int		i, fd;
    u_int	maxwaiting=32;	/* packet filter queue length */

    /* find an available packetfilter */
    for (i = 0; i < 256; i++)
      {
	sprintf (devname, "/dev/pf/pfilt%d", i);
	if ( (fd = open(devname, O_RDWR, 0)) < 0 )
	  {
	    if (errno = EBUSY) continue;
	    else
	      {
		perror ("pfopen: open");
		return RaiseSysError (msp, NIL(char *));
	      }
	  }
	if (interface && (interface[0] != 0) &&
	    ioctl(fd, EIOCSETIF, interface) < 0)
	  {
	    close(fd);
	    perror ("pfopen: EIOCSETIF");
	    return RaiseSysError (msp, NIL(char *));
	  }
	if (ioctl(fd, EIOCMBIS, &bits)<0)
	  {
	    close(fd);
	    perror ("pfopen: EIOCMBIS");
	    return RaiseSysError (msp, NIL(char *));
	  }
	if (ioctl(fd, EIOCMBIC, ((bits = ~bits & 0x7F), &bits)))
	  {
	    close(fd);
	    perror ("pfopen: EIOCMBIC");
	    return RaiseSysError (msp, NIL(char *));
	  }
	if (ioctl(fd, EIOCSETW, &maxwaiting))
	  {
	    close(fd);
	    perror ("pfopen: EIOCSETW");
	    return RaiseSysError (msp, NIL(char *));
	  }
	return INT_CtoML (fd);
      }
    return RaiseSysError (msp, NIL(char *));
}

/*
	3.	ml_pfget_address
		int -> bytearray
 */

ml_val_t ml_pfget_address (ml_state_t *msp, ml_val_t arg)
{
    int			pf = INT_MLtoC(arg);
    ml_val_t		result;
    struct endevp	p;

    if (ioctl(pf, EIOCDEVP, &p) < 0)
      return RaiseSysError (msp, NIL(char *));

    result = ML_AllocBytearray (msp, 6);
    ((char*)result)[0] = p.end_addr[0];
    ((char*)result)[1] = p.end_addr[1];
    ((char*)result)[2] = p.end_addr[2];
    ((char*)result)[3] = p.end_addr[3];
    ((char*)result)[4] = p.end_addr[4];
    ((char*)result)[5] = p.end_addr[5];

    return result;
}

/*
	4.	ml_pfset_filter
		int * bytearray -> unit
 */

ml_val_t ml_pfset_filter (ml_state_t *msp, ml_val_t arg)
{
    int			pf		= REC_SELINT(arg, 0);
    char		*filter		= REC_SELPTR(char, arg, 1);
    struct endevp	p;

    if (ioctl(pf, EIOCSETF, filter))
      return RaiseSysError (msp, NIL(char *));

    return ML_false;
}

/*
	5.	ml_select
		int * int list * int list * int list * (int * int) option
		-> int
		The last parameter indicates how long to wait
		before returning: if the option is NONE, then don't return
		until the FDs are ready for I/O, otherwise use the
		two ints as the time in seconds and microseconds.
 */

ml_val_t ml_select (ml_state_t *msp, ml_val_t arg)
{
    int			nfds		= REC_SELINT(arg, 0);
    ml_val_t		read_fds	= REC_SEL(arg, 1);
    ml_val_t		write_fds	= REC_SEL(arg, 2);
    ml_val_t		except_fds	= REC_SEL(arg, 3);
    ml_val_t		time_spec	= REC_SEL(arg, 4);
/*
    int			*time_sec	= REC_SELPTR(int, arg, 5);
    int			*time_usec	= REC_SELPTR(int, arg, 6);
*/
    ml_val_t		result;
    struct timeval	timeout;
    int			select_value;
    fd_set		rd, wr, ex;

    FD_ZERO (&rd);
    while (read_fds != ML_nil) {
      FD_SET ((REC_SELINT ((ml_val_t *)read_fds, 0)), &rd);
      read_fds = REC_SEL ((ml_val_t *)read_fds, 1);
    }
    FD_ZERO (&wr);
    while (write_fds != ML_nil) {
      FD_SET ((REC_SELINT ((ml_val_t *)write_fds, 0)), &wr);
      write_fds = REC_SEL ((ml_val_t *)write_fds, 1);
    }
    FD_ZERO (&ex);
    while (except_fds != ML_nil) {
      FD_SET ((REC_SELINT ((ml_val_t *)except_fds, 0)), &ex);
      except_fds = REC_SEL ((ml_val_t *)except_fds, 1);
    }
/*
    printf ("first word of bitsets is 0x%x, 0x%x, 0x%x\n",
	    rd.fds_bits[0], wr.fds_bits[0], ex.fds_bits[0]);
*/

    if (time_spec != ML_nil) {
      ml_val_t * time_pair = REC_SELPTR(ml_val_t, time_spec, 0);
      int time_sec  = REC_SELINT(time_pair, 0);
      int time_usec = REC_SELINT(time_pair, 1);
/*
      printf ("time_spec is 0x%x, time_pair is 0x%x, *time_pair is 0x%x\n",
	      (int) time_spec, (int) time_pair, *(int *)time_pair);
      printf ("time_spec is 0x%x, ML_nil is 0x%x, time is %d.%d\n",
	      time_spec, ML_nil, time_sec, time_usec);
*/
      timeout.tv_sec = time_sec;
      timeout.tv_usec = time_usec;
      result = select (nfds, &rd, &wr, &ex, &timeout);
    }
    else {
/*
      printf ("time_spec is %x, ML_nil is %x\n", time_spec, ML_nil);
*/
      result = select (nfds, &rd, &wr, &ex, NULL);
    }

    return INT_CtoML (result);
}

#endif /* OPSYS_OSF1 */
