structure Parse = 
struct
  structure BurgLrVals = BurgLrValsFun(structure Token = LrParser.Token)
  structure BurgLex    = BurgLexFun(structure Tokens = BurgLrVals.Tokens)
  structure BurgParser = Join(structure ParserData = BurgLrVals.ParserData
			      structure Lex 	   = BurgLex
			      structure LrParser   = LrParser)

  fun parse stream = 
    let
      val lexer = BurgParser.makeLexer(fn n => input(stream,n))
      fun error(msg,i:int,_) = 
	    output(std_out, "Error: line " ^ makestring i ^ ", " ^ msg ^ "\n")
    in
	 BurgParser.parse(30,lexer,error,()) 
	    before
	        BurgLex.UserDeclarations.resetState()
    end

  fun reset () =
    BurgLex.UserDeclarations.resetState()
    
end

