(* main.sml
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 *)

structure Main =
  struct

    fun main (cmdName, argv) = let
	  fun help () = (
		output (std_err, "usage: mlburg [<filename>.burg]\n");
		OS.Process.failure)
          in
	    case argv
	     of [] => (
		  BurgEmit.emit (std_in, (fn () => std_out));
		  OS.Process.success)
	      | ("-h"::_) => help ()
	      | ("-help"::_) => help ()
	      | files => let
		  fun findname file = let
		        val {base, ext} = OS.Path.splitBaseExt file
		        in
		          case ext
		           of (SOME("brg" | "burg")) =>
			        OS.Path.joinBaseExt{base=base, ext=SOME "sml"}
		            | _ => file ^ ".sml"
		          (* end case *)
		        end
		  val names = map (fn n => (n,findname n)) files
		  fun emit (inname, outname) = (let
			val s_in = open_in inname
			in
			  BurgEmit.emit (s_in, (fn () => (open_out outname)))
			end) 
			  handle err => (output (std_err, exnMessage err^"\n");
					 raise err)
		  in
		    app emit names;
		    OS.Process.success
		  end
	  end

  (*
   * This is the function to call in an interactive session.
   * Takes a filename (something.burg) as argument, and produces something.sml
   *)
    fun doit s = main ("", [s])

  (* create a stand-alone executable *)
    fun export name = exportFn (name, main)

  end;

