(*
 * sys/sysenv.sml:
 *   CM's access to base (pervasive) and interactive environment
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor SysEnvFun (Compiler: COMPILER): SYS_ENV = struct

    structure Compiler = Compiler
    structure Env = Compiler.Environment
    structure Sym = Compiler.Symbol

    val getBaseEnv = #get Env.pervasiveEnvRef

    val getStaticBaseEnv = Env.staticPart o getBaseEnv

    fun addToInteractiveEnv delta = let
	val base = # get Env.topLevelEnvRef ()
	val new = Env.concatEnv (delta, base)
    in
        #set Env.topLevelEnvRef new
    end

end
