(*
 * srctypes/yaccsource.sml: dealing with input for ml-yacc
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor YaccSourceFun (structure Control: CONTROL
		       val processor: string): TOOL_SOURCE =
struct

    exception ToolError of string

    fun runyacc name = let
	val cmd = concat [processor, " ", AbsPath.elab name]
	val _ = Control.vsay ("[" ^ cmd ^ "]\n")
    in
	if (OS.Process.system cmd) = OS.Process.success then ()
	else raise ToolError cmd
    end

    (*
     * We do not make an effort to preserve the old .sig- or .sml-file
     * if it doesn't change.  First of all this isn't going to hurt us too
     * much, because the rest of the cutoff-recompilation system will catch
     * this fact in a much more general and reliable fashion than running diff
     * could do it.  Furthermore, we would have a problem with file
     * modification times: if we don't update a target file, then the
     * next time around we *again* will find an out-of-date target.
     *)
    fun update name = let
	val smlfile = AbsPath.extendExt { path = name, ext = "sml", sep = "." }
	val sigfile = AbsPath.extendExt { path = name, ext = "sig", sep = "." }
	val sourcetime = AbsPath.modTime name
    in
	(if  AbsPath.exists smlfile andalso
	     AbsPath.exists sigfile andalso
	     Time.< (sourcetime, AbsPath.modTime smlfile) andalso
	     Time.< (sourcetime, AbsPath.modTime sigfile)
	 then ()
	 else runyacc name);
        ([sigfile, smlfile], [])
    end

end
