(*
 * srctypes/source.sml:
 *   Dealing with different types of sources.
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor SourceFun (structure SmlSource: SML_SOURCE
		   structure YaccSource: TOOL_SOURCE
		   structure LexSource: TOOL_SOURCE
		   structure BurgSource: TOOL_SOURCE
		   structure RcsSource: TOOL_SOURCE): SOURCE = struct

    structure SmlSource = SmlSource

    datatype t = S of { name: AbsPath.t, tool: string }

    datatype expansion = E of {
			       sml: SmlSource.t list,
			       other: (AbsPath.t * string) list
			      }

    exception ToolNotImplemented of string

    fun gen (name, tool) = S { name = name, tool = tool }

    fun name (S { name, ... }) = name

    fun expand classify (S { name, tool }) = let

	fun runtool (ds, update) = let
	    val d = concat [ds, ": ", AbsPath.elab name]
	    fun desc () = d
	    fun g n = SmlSource.get (n, SOME desc)
	    fun c (n, NONE) = (n, classify (AbsPath.spec n))
	      | c (n, SOME t) = (n, t)
	    val (smlfiles, other) = update name
	in
	    E { sml = map g smlfiles, other = map c other }
	end

	fun toolcompile "sml" = E {
				   sml = [SmlSource.get (name, NONE)],
				   other = []
				  }
	  | toolcompile "mlyacc" = runtool ("Yacc", YaccSource.update)
	  | toolcompile "mllex" = runtool ("Lex", LexSource.update)
	  | toolcompile "mlburg" = runtool ("Burg", BurgSource.update)
	  | toolcompile "rcs" = runtool ("Rcs", RcsSource.update)
	  | toolcompile tool = raise ToolNotImplemented tool
    in
	toolcompile tool
    end

end
