(*
 * srctypes/burgsource.sml: dealing with ml-burg input
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor BurgSourceFun (structure Control: CONTROL
		       val processor: string): TOOL_SOURCE =
struct

    exception ToolError of string

    fun runburg name = let
	val cmd = concat [processor, " ", AbsPath.elab name]
	val _ = Control.vsay ("[" ^ cmd ^ "]\n")
    in
	if (OS.Process.system cmd) = OS.Process.success then ()
	else raise ToolError cmd
    end

    (*
     * We do not make an effort to preserve the old .sig- or .sml-file
     * if it doesn't change.  First of all this isn't going to hurt us too
     * much, because the rest of the cutoff-recompilation system will catch
     * this fact in a much more general and reliable fashion than running diff
     * could do it.  Furthermore, we would have a problem with file
     * modification times: if we don't update a target file, then the
     * next time around we *again* will find an out-of-date target.
     *)
    fun update path = let
	val { base, ext } = AbsPath.splitBaseExt path
	val { dir, file = base } = AbsPath.splitDirFile base
	val extra = "sml"
	val sep = "."
	val ext =
	    case ext of
		NONE => SOME extra
	      | SOME "burg" => SOME extra
	      | SOME e => SOME (concat [e, sep, extra])
	val smlbase = AbsPath.joinDirFile { dir = dir, file = base }
	val smlpath = AbsPath.joinBaseExt { base = smlbase, ext = ext }
	val sourcetime = AbsPath.modTime path
    in
	(if  AbsPath.exists smlpath andalso
	     Time.< (sourcetime, AbsPath.modTime smlpath)
	 then ()
	 else runburg path);
        ([smlpath], [])
    end

end
