(*
 * driver/control.sml: Controlling levels of verbosity, etc.
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
structure Controls = struct
    val verbose = ref true
    val debug   = ref false
    val keep_going = ref false
    val show_exports = ref false
end

functor ControlFun (Compiler: COMPILER): CONTROL = struct

    structure P = Compiler.Control.Print

    (*
     * By not having the controls within this functor we make sure that
     * they exist only once and are shared among all instances of CM.
     *)

    val control = let
	val sequential = Futures.sequential ()
	fun c r = let
	    fun access NONE = !r
	      | access (SOME n) = (!r) before (r := n)
	in
	    sequential access
	end
    in
	c
    end

    val verbose = control Controls.verbose
    val debug = control Controls.debug
    val keep_going = control Controls.keep_going
    val show_exports = control Controls.show_exports

    val say = let
	val sequential = Futures.sequential ()
	fun say s = (P.say s; P.flush ())
    in
	sequential say
    end

    fun csay r s = if !r then say s else ()
    val vsay = csay Controls.verbose
    val dsay = csay Controls.debug

end
