(*
 * cm/export.sml: exporting CM's heap image
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor ExportFun (structure Compiler: COMPILER
		   val slists:(string * char * (string list -> unit)) list
		   val bools: (string * (bool option -> bool)) list
		   val strings: (string * string ref) list): EXPORT = struct

    structure Compiler = Compiler
    structure Sym = Compiler.Symbol
    structure Env = Compiler.Environment

    val CMSymbol = "CM"
    val batchSymbol = "CMB"
    val retargetSymbol = "CMR"

    val expose =
	[Sym.strSymbol CMSymbol,
	 Sym.strSymbol batchSymbol,
	 Sym.strSymbol retargetSymbol]

    fun filter env0 = let
	val residue = Env.filterEnv (#get Env.topLevelEnvRef (), expose)
	val new = Env.layerEnv (residue, env0)
    in
	#set Env.topLevelEnvRef new
    end

    fun setslist (var, c, setter) =
	case Getenv.getsplitpath c var of
	    NONE => ()
	  | SOME p => setter p

    fun setbool (var, s) =
	case Getenv.getenv var of
	    SOME "true" => ignore (s (SOME true))
	  | SOME "false" => ignore (s (SOME false))
	  | _ => ()

    fun setstring (var, r) =
	case Getenv.getenv var of
	    SOME s => r := s
	  | _ => ()

    fun dump (label, imagefile) = let
	val _ = exportML imagefile
    in
	app setslist slists;
	app setbool bools;
	app setstring strings;
	print (concat [Compiler.banner, " [", label, "]\n"])
    end

    fun export (label, imagefile, NONE) = dump (label, imagefile)
      | export (label, imagefile, SOME env0) = (filter env0;
						dump (label, imagefile))

end
