;      -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-
;==============================================================================
;     File:  sgml-tag-rules.lisp
;	By:  Willy Walker	<wkw@pitt.edu>
;     Path:  ../cmt/catalyst/amt-ana/english/interpreter-rules/<release-vs>
;  Started:  in prehistory
; Modified:  03 December 1996	by <garof>
;
; Comments:  Contains interpreter rules and functions for handling SGML tags.
;	     SGML tag mapping is fairly simple since their structure is well
;	     defined.
;
; Modified:  12 April 1995
;	By:  Nicholas Brownlow	<ndb@clarit.com>
;  Reasons:  Nicholas was the official "Interpreter" maintainer until then.
;
; Modified:  19 November 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  To garof-ify this file, and to add version control markers to it.
;
; Modified:  03 December 1996
;	By:  Joseph Giampapa	<garof@cs.cmu.edu>
;  Reasons:  Removed references to "ir_vers_ctrl.lisp".
;
; Modified:  <date>
;	By:  <name>		<full e-mail>
;  Reasons:  
;
;==============================================================================


;..............................................................................
;			Center for Machine Translation
;			  Carnegie Mellon University
;
;			   Copyright (c) 1993 - 1996
;	       Carnegie Mellon University.  All Rights Reserved.
;..............................................................................


;..............................................................................
;			      Package Statements
;..............................................................................
(in-package :user)


;..............................................................................
;			  Attempts at Version Control
;..............................................................................

;------------------------------------------------------------------------------
; For use by the maintainer's personal program.
;------------------------------------------------------------------------------
(defconstant *SGML-TAG-RULES-VS* '5.0Analyzer)



;..............................................................................
;			SGML tag root ==> head mapping
;
; All SGML tags get mapped to *S- frames.  All SGML tag sequences get mapped to
; *BS- frames.
;
; In the FS, the ROOT is the tag name.  We build a hash table mapping tag roots
; onto tag concepts.  To avoid listing all the tags beforehand, we build this
; table on the fly.
;..............................................................................


;------------------------------------------------------------------------------
; 19-Nov-96-garof:
; Used by "Get-SGML-Head", stores *[B]S-<SGML tag> indexed by <SGML tag>.
;------------------------------------------------------------------------------
(defvar *SGML-Head-Table* (make-hash-table :size 120 :test #'eq)
  "Used by \"Get-SGML-Head\", stores *[B]S-<SGML tag> indexed by <SGML tag>.")


;------------------------------------------------------------------------------
; 19-Nov-96-garof:
; Do nothing if "root" exists in the *SGML-Head-Table*.  If not, add it and its
; *S- or *BS- symbolic form.
; *S- corresponds to SGML tags.
; *BS- corresponds to SGML tag sequences.
;------------------------------------------------------------------------------
(defun Get-SGML-Head (root prefix)
  "Do nothing if \"root\" exists in the *SGML-Head-Table*.  If not, add its
\"prefix\"-\"root\" symbolic form to the table, indexed by \"root\".
Prefix is usually:
    *S- corresponds to SGML tags.
    *BS- corresponds to SGML tag sequences."
  (or (gethash root *SGML-Head-Table*)
      (setf (gethash root *SGML-Head-Table*)
	    (intern (format nil "~A-~A" prefix root)))))



;---eof sgml-tag-rules.lisp---
