;;;-----------------------------------------------------------------------;
;;;  -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-
;;;-----------------------------------------------------------------------;
;;;
;;; Last Modified         8-Jun-92, 11:11
;;;
;;;         File: dmk-entry-maker.lisp
;;; File created: ;;;  5-Jun-92 by amf: 
;;;      Package: USER
;;;       Author: Alex Franz [amf@cs.cmu.edu]
;;;   
;;; File Description: make DMK entries from ("root" CAT) list
;;;
;;;     See also: 
;;; 
;;;
;;; 
;;;-----------------------------------------------------------------------;
;;;
;;; Change Log:
;;; -----------
;;;  5-Jun-92 by amf: created
;;;
;;;
;;;-----------------------------------------------------------------------;



;;;-----------------------------------------------------------------------;
;;; Documentation:                                                        ;
;;;-----------------------------------------------------------------------;


;;;-----------------------------------------------------------------------;
;;; Package Statements:                                                   ;
;;;-----------------------------------------------------------------------;

(in-package 'user)
;;; (use-package 'meister)

;;;-----------------------------------------------------------------------;
;;; Structures etc:                                                       ;
;;;-----------------------------------------------------------------------;


;;;-----------------------------------------------------------------------;
;;; Global Variables:                                                     ;
;;;-----------------------------------------------------------------------;



;;;-----------------------------------------------------------------------;
;;; Macros:                                                               ;
;;;-----------------------------------------------------------------------;

(defmacro dofile (args . forms)

 "Analogous to DOLIST: (dofile (<var> <filename> <returnform>)
                         <bodyform>*)
  <var> is set to each form in the file & <bodyform>* is evaluated."

  `(let (,(first args))
     (with-open-file (infile ,(second args) :direction :input)
       (loop 
         (setq ,(first args) (read infile nil infile))
         (if (eq ,(first args) infile) (return ,(third args)))
         ,@forms))))


;;;-----------------------------------------------------------------------;
;;; Functions:                                                            ;
;;;-----------------------------------------------------------------------;

(defun make-test-dmk-old ()
  (make-dmk-entries
   "/afs/cs/project/cmt-12/catalyst/amt-beta-system/english/input/words.lisp"
   "/afs/cs/project/cmt-12/catalyst/amt-beta-system/english/dmk/hydraulics-test-ie.dmk"  ))

(defun make-test-dmk-2 ()
  (make-dmk-entries
   "/afs/cs/project/cmt-12/catalyst/amt-beta-system/english/input/linda-words.lisp"
   "/afs/cs/project/cmt-12/catalyst/amt-beta-system/english/dmk/linda-hydraulics-test-ie.dmk"  ))


(defun make-dmk-entries (infile outfile)
  (with-open-file (outstream outfile :direction :output
			     :if-exists :supersede)
    (dofile (entry infile)
	    (let ((word (first entry))
		  (cat (second entry))
		  dmk-entry)
	      
	      (case cat
		(N
		 (setq dmk-entry
		       `((:ROOT ,word)
			 (:POS N)
			 (:CONCEPT ,(intern (format nil "*O-~A" (string-upcase word))))
			 (:MORPH (:PLURAL +) (:GENSG +) (:GENPL +))
			 (:SYN-FEATURES (COMP XCOMP) (COUNT + - ))
			 (:COMMENT "This entry was automatically generated by amf."))))
		(V
		 (setq dmk-entry
		       `((:ROOT ,word)
			 (:POS V)
			 (:CONCEPT ,(intern (format nil "*A-~A" (string-upcase word))))
			 (:MORPH (:PRESENT3SG +) (:PRESPART +) (:PAST +) (:PASTPART +))
			 (:SYN-FEATURES (COMP XCOMP) (VALENCY TRANS INTRANS))
			 (:COMMENT "This entry was automatically generated by amf."))))
		(ADJ
		 (setq dmk-entry
		       `((:ROOT ,word)
			 (:POS ADJ)
			 (:CONCEPT ,(intern (format nil "*P-~A" (string-upcase word))))
			 (:MORPH (:COMP +) (:SUPER +))
			 (:SYN-FEATURES (COMP XCOMP))
			 (:COMMENT "This entry was automatically generated by amf."))))
		(ADV
		 (setq dmk-entry
		       `((:ROOT ,word)
			 (:POS ADV)
			 (:CONCEPT ,(intern (format nil "*P-~A" (string-upcase word))))
			 (:MORPH (:COMP +) (:SUPER +))
			 (:SYN-FEATURES (COMP XCOMP))
			 (:COMMENT "This entry was automatically generated by amf."))))
		(OTHERWISE
		 (setq dmk-entry
		       `((:ROOT ,word)
			 (:POS ,cat)
			 (:COMMENT "This entry was automatically generated by amf.")))))
	      (format outstream "~%~%(~S" (car dmk-entry))
	      (dolist (sublis (cdr dmk-entry))
		(format outstream "~% ~S" sublis))
	      (format outstream ")")))))

	      
		
		    
