;;; Grammar callouts
;;;-----------------


(in-package 'user)


;;; returns the f-structure for the number num

;;; Example: (check-if-number '|1|):
;;;          ((NUMBER SG) 
;;;           (INTEGER "1") 
;;;           (SEM *C-DECIMAL-NUMBER) 
;;;           (CAT NUMBER))

;;;          (check-if-number '|1/2|):
;;;          ((CAT NUMBER) 
;;;           (SEM *C-FRACTION) 
;;;           (FRACTION +) 
;;;           (NUMBER (*OR* SG PL)) 
;;;           (NUMERATOR ((INTEGER "1") 
;;;                       (SEM *C-DECIMAL-NUMBER))) 
;;;           (DENOMINATOR ((INTEGER "2") 
;;;                         (SEM *C-DECIMAL-NUMBER))))

;;;          (check-if-number '|1.2|):
;;;          ((CAT NUMBER)
;;;           (NUMBER PL)
;;;           (SEM *C-DECIMAL-NUMBER)
;;;           (INTEGER "1")
;;;           (DECIMAL "2"))

(defun check-if-number (num)
  (let ((val (read-from-string (symbol-name num))))
    (cond ((integerp val)
	   (let ((out '((sem *c-decimal-number) (cat number))))
	     (if (= 1 val)
		 (progn 
		   (push '(integer "1") out)
		   (push '(number sg) out))
	       (progn
		 (push `(integer ,(format nil "~a" val)) out)
		 (push '(number pl) out)))))
	  ((ratiop val)
	   `((cat number) 
	     (sem *C-FRACTION) 
	     (fraction +)
	     (number (*OR* sg pl))
	     (numerator ((integer ,(format nil "~a" (numerator val)))
			 (sem *c-decimal-number)))
	     (denominator ((integer ,(format nil "~a" (denominator val)))
			   (sem *c-decimal-number)))))
	  ((floatp val)
	   (let* ((out '((sem *c-decimal-number) (cat number) 
			 (number pl)))
		  (str (format nil "~a" val))
		  (dot (position #\. str)))
	     (push `(integer ,(substring str 0 (- dot 1))) out)
	     (push `(decimal ,(substring str (+ 1 dot))) out))))))

(defun no-initial-adjuncts (list)
  (cond ((null list) t)
        ((eq '*multiple* (first list))
         (notany #'(lambda (x) (eq 'initial (second (assoc 'position x))))
                 (rest list)))
        (t (not (eq 'initial (second (assoc 'position list)))))))

(defun no-final-adjuncts (list)
  (cond ((eq '*multiple* (first list))
	 (if (notany #'(lambda (x) (eq 'final (second (assoc 'position x))))
		     (rest list))
	     list
	   '()))
	((eq '*or* (first list))
	 (let* ((out (remove nil (mapcar #'no-final-adjuncts (rest list))))
		(l (length out)))
	   (cond ((eq l 0) nil)
		 ((eq l 1) (first out))
		 (t `(*or* ,@out)))))
        (t (if (not (eq 'final (second (assoc 'position list))))
	       list
	     '()))))

(defun no-same-adjuncts (root list)
  (cond ((eq '*multiple* (first list))
	 (if (notany #'(lambda (x) (equal root (second (assoc 'root x))))
		     (rest list))
	     list
	   '()))
	((eq '*or* (first list))
	 (let* ((out (remove nil (mapcar #'no-same-adjuncts root (rest list))))
		(l (length out)))
	   (cond ((eq l 0) nil)
		 ((eq l 1) (first out))
		 (t `(*or* ,@out)))))
        (t (if (not (equal root (second (assoc 'root list))))
	       list
	     '()))))

(defun no-time-adjuncts (list)
  (cond ((null list) t)
        ((eq '*multiple* (first list))
         (notany #'(lambda (x) (eq '+ (second (assoc 'time x))))
                 (rest list)))
        (t (not (eq '+ (second (assoc 'time list)))))))


(defun process-single-valency (valency)
  (case valency
	(subject+object '((valency subject+object)
			  (object ((cat (*or* n number))))))
	(subject+indobject+object '((valencey subject+indobject+object)
				    (object ((cat (*or* n number))))
				    (indobject ((cat n)))))
	(subject+object+object2 '((valency subject+object+object2)
				  (object ((cat (*or* n number))))
				  (object2 ((cat (*or n number))))))
	(subject+object+oblique '((valency subject+object+oblique)
				  (object ((cat (*or* n number))))
				  (oblique ((cat p)))))
	(subject+object+predicate '((valency subject+object+predicate)
				    (object ((cat (*or* n number))))
				    (predicate ((cat (*or* adj adv))))))
	(subject+object+compl '((valency subject+object+compl)
				(compl ((cat v)))
				(object ((cat (*or* n number))))))
	(subject+object+oblique+oblique2 '((valency subject+object+oblique+oblique2)
					   (object ((cat (*or* n number))))
					   (oblique ((cat p)))
					   (oblique2 ((cat p)))))
	(subject+oblique '((valency subject+oblique)
			   (oblique ((cat p)))))
	(subject+oblique+compl '((valency subject+oblique+compl)
				 (oblique ((cat p)))
				 (compl ((cat v)))))
	(subject+predicate '((valency subject+predicate)
			     (predicate ((cat (*or* adv adj))))))
	(subject+oblique+predicate '((valency subject+oblique+predicate)
				     (oblique ((cat p)))
				     (predicate ((cat *or* adv adj)))))
	(subject+compl '((valency subject+compl)
			 (compl ((cat v)))))))

(defun process-valency (valency)
  (if (listp valency)
      `(*OR* ,@(mapcar #'process-single-valency (rest valency)))
    (process-single-valency valency)))
	
	