(in-package :user)

(setf (working-directory) 
      "/afs/cs/project/cmt-50/xchart/1.1/code/release")

(load "pseudo-unify.lisp")

(defvar *unify-tests*)

(setq *unify-tests* 
      '(
	(a a)

	(a b)

	((*or* a b)
	 a)

	((*or* a b)
	 b)

	((*or* a b)
	 c)

	((*or* a b)
	 (*or* b c))

	((*or* a b)
	 (*multiple* b c))

	((*multiple* a b)
	 (*multiple* b c))

	((*multiple* (*or* a b) c)
	 (*multiple* b c))

	(((a b))
	 ((b c)))

	(((a (*or* y z)))
	 ((b c)(a y)))

	(((a (*multiple* y z)))
	 ((b c)(a y)))

	(((a (*multiple* y z)))
	 ((b c)(a (*multiple* z y))))

	(((a (*multiple* y z)))
	 ((b c)(a (*multiple* y z))))

	(((a (*multiple* y z)))
	 ((a (*multiple* y z))))

	(((a (*or* y z)))
	 ((a (*or* y z))))
))

(defun run-unify-tests ()
  (dolist (test *unify-tests* nil)
	  (format t "~%A: ~s~%B: ~s~%UNIFY: ~s~%" 
		  (first test) (second test) (apply #'unify test))))

(run-unify-tests)

