(in-package 'user)

;;----------------------------------------------------------------------
;; XCHART 1.0
;;
;; File: STRUCTURES.LISP
;;
;; Last Update: 14-Oct-96 by EHN
;;
;; Copyright (c) 1996, Carnegie Mellon University, All Rights Reserved.

;;----------------------------------------------------------------------
;; RULE
;;
;; Structure used to store grammar rules. 
;;
;; LEVEL: an integer used to implement a partial order on rule firing (1 - n)
;; LHS: a non-terminal symbol
;; RHS: a list of non-terminal or lexical category symbols
;; UNIFY: lambda expression or function pointer
;; STRATEGY: (optional) symbol denoting :dfs :bfs

(defstruct rule level lhs rhs unify strategy)

;;----------------------------------------------------------------------
;; ENTRY 
;;
;; Structure used to hold agenda/chart entries. 
;;
;; START: the starting position in the input
;; END: the ending position in the input,
;; CATEGORY: the lexical or non-terminal category
;; CHILDREN: the list of child node ids (for non-terminals only)
;; LEXEME: input symbol (lexical categories only)
;; ID: the unique integer identifier for each entry

(defstruct (entry (:print-function print-entry))
  start end category children lexeme fs id)

(defun entry-print (s stream depth)
  (declare (ignore depth))
  (prin1 (list (entry-start s) (entry-end s) (entry-category s)
	       (or (entry-lexeme s)(entry-children s)) (entry-id s))
	 stream))

;;----------------------------------------------------------------------
;; ARC
;;
;; Structure used to store active arcs. 
;;
;; START: the starting position in the input
;; END: the ending position in the input
;; INDEX: the offset (0-based) into the set of RHS symbols, equivalent
;;        to the position of Allen's circle mark
;; LHS: the LHS of the original rule
;; RHS: the RHS of the original rule
;; CHILDREN: a list of node ids (integers)
;; UNIFY: lambda expression or function pointer
;; STRATEGY: (optional) symbol stating the strategy (:bfs or :dfs)

(defstruct arc start end index lhs rhs children unify strategy)

;;----------------------------------------------------------------------