(in-package 'user)


;;; 
;;; Patches for XCHART
;;;

(defvar *parse-fs*)

(defvar *default-searchmode* 'dfs)

(defvar *default-quitmode* nil)

(defvar *grammar*)

(defvar *grammar-1*)

(defvar *children* (make-hash-table))

(defvar *packing*)

(setf *packing* nil)

(defvar *packing-remove-equal*)

(setf *packing-remove-equal* t)

(defvar *boundaries*)

(defvar *boundary-levels* (make-hash-table))

(defvar *ignore-boundaries*)

(setf *ignore-boundaries* t)

;(setf *boundaries* (make-hash-table))

(defvar *boundaries-present*)

(defvar *zerovec*)

(defvar *final-position*)

(defvar *not-to-be-compacted*)

(setf *not-to-be-compacted* '(<term>))

(defvar *token-position*)

(defvar *trace-arcs*)

(defstruct (entry (:print-function print-entry))
  start end category children lexeme fs id priority)

(defun print-entry (s stream depth)
  (declare (ignore depth))
  (prin1 (list (entry-start s) (entry-end s) (entry-category s)
	       (or (entry-lexeme s)(entry-children s)) (entry-id s) 
	       (entry-priority s))
	 stream))

(defun compare-entry-priority (entry1 entry2)
  (< (entry-priority entry1) (entry-priority entry2)))

(defstruct arc start end index lhs rhs children unify strategy priority)


;;; - added time measurement
;;; - changed the fs-slot used to identify the category: cat is used by
;;;   the grammar, nont is used by the parser;
;;; - grammar rules are stored in a hash table;
;;; - arcs are stored in a hash table;
;;; - defined a list of categories which are not acceptable as the category 
;;;   of the result constituent


;;----------------------------------------------------------------------
;;
;; the parser is not allowed to quit if the found constituent's category is
;; in the *stop-list*
;;


(defvar *stop-list*)
(setf *stop-list* '(<term> <phrase> <word> <n1> <n2> <n> <v> <v1> <v2> <adj>))
(defvar *top-list*)
(setf *top-list* '(<top>))

(defvar *cut-off*)

(defvar *max-hash*)
(setf *max-hash* (make-hash-table))

(defvar *max-priority*)

(defvar *chart-clean*)

(defvar *rule-levels* nil)

(defvar *current-level*)

(defvar *chart-num*)

(defvar *position*)

(defvar *operations*)

(defvar *node-counter*)

(defvar *start-time*)

(defvar *parse-count*)

(defvar *arcs*)

(defvar *chart*)

(defvar *agenda*)


(defvar *input*)




;; parse-init

(defun parse-init (input)

  (setf *input* input)
  (setf *position* 1)
  (setf *operations* 0)
  (setf *node-counter* 0)
  (setf *start-time* (get-internal-real-time))
  (setf *parse-count* 0)
  (setf *arcs* (make-hash-table :test #'equal))
  (setf *chart* nil)
  (setf *agenda* nil)
  (setf *final-position* (1+ (length *input*)))
  (setf *boundaries* (make-array *final-position* :element-type 'bit :initial-element 0))
  (setf *zerovec* (make-array *final-position* :element-type 'bit :initial-element 0))
  (setf *boundaries-present* nil)
  (clrhash *boundary-levels*)
  (clrhash *children*)
  (setf *current-level* 0)
  (setf *chart-num* 0)
  (setf *chart-clean* nil)
  (setf *token-position* 0)
  (setf *cut-off* 0)
  (setf *chart* nil)

)
  
;;----------------------------------------------------------------------
;; PARSE
;;
;; The top-level parser call.
;;
;; INPUT: a list of input symbols, which must be in *LEXICON*
;; GRAMMAR: a list of rule structures, such as *GRAMMAR*
;; SEARCHMODE: One of 'dfs (depth-first-search), 'bfs (breadth-first-search)
;; QUITMODE: if non-NIL, causes parser to quit as soon as it finds the
;;   first chart entry that covers the whole input.

(defun parse (input &key
		    (search *default-searchmode*)
		    (quit *default-quitmode*)
		    (level 999))
  (parse-init input)
  (loop
   (if (and 
	(null *agenda*)
	(null-agenda search level))
       (return))
; the agenda can be null here when the level was increased!!!
   (if (and (not (null *agenda*))
	    (non-null-agenda search quit))
       (return)))
  (format t "~&Finished in ~a sec." 
	  (/ (- (get-internal-real-time) *start-time*) 1000000.0))
  'DONE)

;;----------------------------------------------------------------------


(defun non-null-agenda (search quit)
  (let ((done nil) item start end constituent time-spent)
    (when *trace-arcs*
	  (dump-arcs *arcs*))
    (setq item (pop *agenda*))
    (setf start (entry-start item)
	  end (entry-end item)
	  constituent (entry-category item))
    
    ;; As soon as we've popped off the next item in the agenda, check
    ;; to see if it's a final node; quit if we're supposed to, before
    ;; performing any additional operations, but make sure we put the
    ;; item onto the chart before we quit.
    (cond ((and (= start 1)
		(= end *final-position*))
	   (cond ((and quit
		       (not (member constituent *stop-list*))
		       (equal (char (symbol-name constituent) 0) #\<)
		       (equal (char (symbol-name constituent)
				    (- (length (symbol-name constituent)) 1))
			      #\>))
		  (setq time-spent (- (get-internal-real-time) *start-time*))
		  (chart-trace "~% ~20a ** Covers the input, quitting [~a operations, ~D time used]" 
			       item *operations* (/ time-spent 1000000.0))
		  (push item *chart*)
		  (setf (gethash (entry-id item) *children*) item)
		  (setf *chart-clean* nil)
		  (setq done 't))
		 (t
		  (push item *chart*)
		  (setf (gethash (entry-id item) *children*) item)
		  (setf *chart-clean* nil)
		  (chart-trace "~% ~20a ** Covers the input, continuing...[~a operations]" 
			       item *operations*)
		  (process-all-rules item search)
		  (process-all-arcs item search)
		  )))
	  ((and (member constituent *top-list*)
		(= start 1))
	   (format nil "setting cut-off")
	   (setf *cut-off* end))
	  (t 
	   (process-all-rules item search)	      
	   (process-all-arcs item search)
	    nil))
    done))


;;;----------------------------------------------

(defun process-all-arcs (item search)
  (let (arc-continues arc-ends (start (entry-start item))
		      (constituent (entry-category item)))
    (setq arc-continues (arcs-continued-by start constituent))
    (chart-trace "~% ~20a Arcs continued-by: ~a" item (length arc-continues))
    (dolist (arc arc-continues)
	    (process-continued-arc arc item search))
    (setq arc-ends (arcs-completed-by start constituent))
    (chart-trace "~% ~20a Arcs completed-by: ~a" item (length arc-ends))
    (dolist (arc arc-ends)
	    (process-completed-arc arc item search))))

;;;----------------------------------------------

(defun process-all-rules (item search)
  (let (rule-starts rule-ends (constituent (entry-category item)))
    (setq rule-starts (rules-started-by constituent *current-level*))
    (chart-trace "~% ~20a Rules started-by: ~a at level ~a" item (length rule-starts) *current-level*)
    (dolist (rule rule-starts)
	    (process-started-rule rule item search))
    (setq rule-ends (rules-completed-by constituent *current-level*))
    (chart-trace "~% ~20a Rules completed-by: ~a at level ~a" item (length rule-ends) *current-level*)
    (dolist (rule rule-ends)
	    (process-completed-rule rule item search))
    (incf *operations*)
    ;; Always push processed entries onto the front of the chart.
    (push item *chart*)
    (setf (gethash (entry-id item) *children*) item)))

;;;-----------------------------------------------

(defun null-agenda (search level)
  (let ((done nil) time-spent word entry)
    (cond ((and (or (null *input*) 
		    (boundary *token-position*))
		(or (< *max-priority* *current-level*)
		    (> *current-level* level)))
	   (incf *chart-num*)
	   (cond ((null *input*) 
		  (setq time-spent (- (get-internal-real-time) *start-time*))
		  (format t "~% ~D sec time used~%" (/ time-spent 1000000.0))
		  (setq done 't))
		 ('t (setf *chart* nil)
		     (setf *agenda* nil)
		     (clrhash *arcs*)
		     (incf *token-position*)
		     (incf *position*)
		     (setf *current-level* 0))))
	  ((and (or (null *input*) 
		    (boundary *token-position*))
		(<= *current-level* level)
		(<= *current-level* *max-priority*))		  
	   (block gcl-loop
		  (loop 
		   (chart-trace "~&increasing level: ~a" (1+ *current-level*))
		   (incf *current-level*)
		   (when (or (member *current-level* *rule-levels*)
			     (> *current-level* level)
			     (> *current-level* *max-priority*))
			 #+lucid(loop-finish)
			 #+gcl(return 'gcl-loop))))
	   (if (or (> *current-level* level)
		   (> *current-level* *max-priority*))
	       (setf *agenda* '())
	     (progn 
	       (clrhash *arcs*)		     
	       (cond ((not *chart-clean*)
		      (chart-trace "~&compacting chart: ~a" *current-level*)
		      (chart-trace "~&chart before: ~a" *chart*)
		      (setf *agenda* (compact-chart *chart*))
		      (chart-trace "~&agenda after: ~a" *agenda*)
		      (setf *chart-clean* t)
		      (print-chart (format nil "chart~a" *chart-num*))
		      (incf *chart-num*))
		     ('t (setf *agenda* (reverse *chart*))))
	       (setf *chart* '())))
	   )
	  ((not (null *input*))
	   (chart-trace "~% ~20a Reading from input ~a" 'EMPTY *input*)
	   (incf *position*)
	   (incf *token-position*)
	   (setq word (pop *input*))
	   (push (make-entry 
		  :start (1- *position*)
		  :end   *position*
		  :id    (incf *node-counter*)
		  :category word
		  :lexeme word
		  :priority 0) *chart*)
	   (setf *chart-clean* nil)
	   (let ((readings (lookup-word word)))
	     (if (eq (length readings) 1)
		 (setq entry (make-entry 
			      :start    (1- *position*) 
			      :end      *position*
			      :category '<word>
			      :id   (incf *node-counter*)
			      :lexeme   word
			      :fs (first readings)
			      :priority 0
			      ))
	       (setq entry (make-entry 
			    :start    (1- *position*) 
			    :end      *position*
			    :category '<word>
			    :id   (incf *node-counter*)
			    :lexeme   word
			    :fs `(*OR* ,@readings)
			    :priority 0
			    )))
	     (incf *operations*)
	     (if (eq search 'dfs)
		 (push entry *agenda*)
	       (setq *agenda* (nconc *agenda* (list entry)))))))
    done))


;;;-----------------------------------------------

(defun process-completed-rule (rule item search)
  (let* (; (child-fs nil)
	 entry
	 (nodefs (entry-fs item))
	 (start (entry-start item))
	 (end (entry-end item))
	 (nodeid (entry-id item))
	 (last-fs nodefs)
	 (fs (funcall (rule-unify rule) last-fs)))
    (setq entry (make-entry
		 :start start
		 :end end
		 :category (rule-lhs rule) 
		 :id (incf *node-counter*) 
		 :children (list nodeid)
		 :fs fs
		 :priority (rule-level rule)))
    (cond (fs
	   (chart-trace "~% ~20a Completes rule ~a -> ~a from ~a to ~a" 
			item (rule-lhs rule) (insert-index 1 (rule-rhs rule)) start end)
	   (chart-trace "~% ~20a Entering ~a from ~a to ~a [agenda ~a] at level ~a" 
			item (rule-lhs rule) start end
			(if (eq search 'dfs) "top" "bottom")
			*current-level*)
	   (incf *operations*)
	   (if (or (eq (rule-strategy rule) :dfs)
		   (and (not (rule-strategy rule)) (eq search 'dfs)))
	       (push entry *agenda*)
	     (setq *agenda* (nconc *agenda* (list entry)))))
					;		      (stable-sort *agenda* #'compare-entry-priority))
	  (t 
	   (chart-trace "~% ~20a Completes rule ~a -> ~a from ~a to ~a **UNIFY FAILED**" 
			item (rule-lhs rule) (insert-index 1 (rule-rhs rule)) start end)))))
  
;;;-----------------------------------------------

(defun process-started-rule (rule item search)
  (let (new-arc (end (entry-end item))
		(start (entry-start item))
		(nodeid (entry-id item)))
    (when (and (<= (length (rule-rhs rule))
		   (1+ (- *final-position* end)))
	       (no-boundary end
			    (- (+ end
				  (length (rule-rhs rule))) 
			       2)
			    *current-level*))
	  (progn 
	    (setq new-arc (make-arc 
			   :start start
			   :end end
			   :index 1 
			   :lhs (rule-lhs rule) 
			   :rhs (rule-rhs rule) 
			   :children (list nodeid)
			   :unify (rule-unify rule)
			   :strategy (rule-strategy rule)
			   :priority (rule-level rule)
			   ))
	    (chart-trace "~% ~20a Starts rule ~a -> ~a from ~a to ~a" 
			 item (rule-lhs rule) (insert-index 1 (rule-rhs rule)) start end)
	    (incf *operations*)
	    (let* ((key `(,(nth (arc-index new-arc) (arc-rhs new-arc))))
		   (out (gethash key *arcs*)))
	      (if (eq search 'dfs)
		  (setf (gethash key *arcs*)
			(push new-arc out))
		(setf (gethash key *arcs*) 
		      (nconc out (list new-arc)))))))))

;;;-----------------------------------------------
  
(defun process-completed-arc (arc item search)
  (let* (entry (nodefs (entry-fs item))
	       (end (entry-end item))
	       (nodeid (entry-id item))
	       (child-fs 
		(mapcar #'(lambda (x)
			    (entry-fs (gethash x *children*)))
			(arc-children arc)))
	       (last-fs nodefs)
	       (fs (apply (arc-unify arc)
			  (append child-fs (list last-fs)))))
    (cond ((not (or (eq '*fail* fs) (null fs)))
	   (setq entry (make-entry 
			:start (arc-start arc) 
			:end end
			:priority (arc-priority arc)
			:category 
			(let ((lhs (arc-lhs arc)) wpos)
			  (when (eq *wildcard* lhs)
				(setq wpos (position *wildcard* (arc-rhs arc)))
				(setq lhs (entry-category (gethash (nth wpos (arc-children arc)) *children*))))
			  lhs)
			:id (incf *node-counter*)
			:children (append (arc-children arc) 
					  (list nodeid))
			:fs fs))
	   (chart-trace "~% ~20a Completes arc ~a -> ~a from ~a to ~a"
			item (arc-lhs arc) 
			(insert-index (arc-index arc) (arc-rhs arc))
			(arc-start arc) (arc-end arc))
	   (chart-trace "~% ~20a Entering ~a from ~a to ~a [agenda ~a] at level ~a" 
			item (arc-lhs arc) (arc-start arc) end
			(if (eq search 'dfs) "top" "bottom") *current-level*)
	   (incf *operations*)
	   (if (or (eq (arc-strategy arc) :dfs)
		   (and (not (arc-strategy arc))(eq search 'dfs)))
	       (push entry *agenda*)
	     (setq *agenda* (nconc *agenda* (list entry)))))
					;		    (stable-sort *agenda* #'compare-entry-priority))
	  (t (chart-trace "~% ~20a Completes arc ~a -> ~a from ~a to ~a **~a FAILED**"
			  item (arc-lhs arc)
			  (insert-index (arc-index arc) (arc-rhs arc))
			  (arc-start arc) (arc-end arc) (arc-unify arc)
			  )))))

;;;-----------------------------------------------


(defun process-continued-arc (arc item search)  
  (let* ((nodeid (entry-id item))
	 (new-arc (make-arc
		   :start (arc-start arc) 
		   :end (entry-end item) ;; 11-Oct-96 by EHN (1+ (arc-end arc)) 
		   :lhs (arc-lhs arc) 
		   :rhs (arc-rhs arc)
		   :index (1+ (arc-index arc))
		   :children (append (arc-children arc)
				     (list nodeid))
		   :unify (arc-unify arc)
		   :strategy (arc-strategy arc)
		   :priority (arc-priority arc)
		   )))
    (chart-trace "~% ~20a Continues arc ~a -> ~a from ~a to ~a"
		 item (arc-lhs arc) 
		 (insert-index (1+ (arc-index arc)) (arc-rhs arc)) 
		 (arc-start arc) (arc-end arc))
    (incf *operations*)
    (let* ((key `(,(nth (arc-index new-arc) (arc-rhs new-arc))))
	   (out (gethash key *arcs*)))
      (if (or (eq (arc-strategy arc) :dfs)
	      (and (not (arc-strategy arc)) (eq search 'dfs)))
	  (setf (gethash key *arcs*) 
		(push new-arc out))
	(setf (gethash key *arcs*)
	      (nconc out (list new-arc)))))))

(defun compgra (x)
  (setf *max-priority* 0)
  (let ((fullname (concatenate 'string x ".gra"))
	(outfile (concatenate 'string x ".lisp"))
	(*print-pretty* nil)
	(count 0)
	fn fnbody rule level strategy)
    (with-open-file (out outfile :direction :output :if-exists :supersede)
;		    (format out "(DEFVAR *GRAMMAR-LIST*)~%(SETQ *GRAMMAR-LIST* NIL)~%(DEFVAR *GRAMMAR*)~%(SETQ *GRAMMAR* (make-hash-table :test #'equal))~%(clrhash *GRAMMAR*)~%(DEFVAR *GRAMMAR-1*)~%(SETQ *GRAMMAR-1* (make-hash-table :test #'equal))~%(clrhash *GRAMMAR-1*)~%")
		    (format out "(DEFVAR *GRAMMAR-LIST*)~%(SETQ *GRAMMAR-LIST* NIL)~%(SETQ *GRAMMAR* (make-hash-table :test #'equal))~%(clrhash *GRAMMAR*)~%(SETQ *GRAMMAR-1* (make-hash-table :test #'equal))~%(clrhash *GRAMMAR-1*)~%")
		    (with-open-file (in fullname :direction :input)
				    (loop
				     (setq rule (read in nil in))
				     (when (eq rule in)
					   (return))
				     (incf count)
				     (setq fn (intern (format nil "GRAMMARF-~a" count)))
				     (setq fnbody
					   (compile-augmentation (length (fourth rule))
								 (fifth rule)))
				     (setf (first fnbody) fn)
				     (setf fnbody (cons 'defun fnbody))
				     (format out "~s~%" fnbody)
				     (cond ((listp (first rule))
					    (let ((levstr (first rule)))
					      (cond ((listp (first levstr))
						     (setq level 
							   (first levstr))
						     (setq strategy 
							   (second levstr)))
						    (t (setq level levstr)))))
					   (t (setq level (first rule))))
				     (unless (listp level)
					     (setq level (list level)))
				     (dolist (nextlevel level)
					     (if (> nextlevel *max-priority*)
						 (setq *max-priority* nextlevel))
					     (if (not (member nextlevel 
							      *rule-levels*))
						 (push nextlevel *rule-levels*))
					     (format out "(SETQ *GRAMMAR-LIST* (NCONC *GRAMMAR-LIST* (LIST (MAKE-RULE :STRATEGY ~s :LEVEL ~s :LHS '~s :RHS '~s :UNIFY '~a))))~%"
						     strategy nextlevel (second rule) (fourth rule) fn)
				     )))
		    (format out "(mapc #'(lambda (item) 
	    (let ((rhs (first (rule-rhs item)))
                  (level (rule-level item)))
                 (if (eq (length (rule-rhs item)) 1)
	             (let ((out (gethash `(,rhs ,level) *GRAMMAR-1*)))
		          (setf (gethash `(,rhs ,level) *GRAMMAR-1*)
		          (NCONC out (list item))))
	             (let ((out (gethash `(,rhs ,level) *GRAMMAR*)))
		          (setf (gethash `(,rhs ,level) *GRAMMAR*)
		          (NCONC out (list item)))))))
	*GRAMMAR-LIST*)"))))


;;----------------------------------------------------------------------
;; RULES-STARTED-BY
;;
;; Function which returns a list of the grammar rules which are
;; started by the given constituent.

(defun rules-started-by (constituent highest-level)
  (let* ((wild (gethash `(*wildcard* ,highest-level) *GRAMMAR*))
	 (rest (gethash `(,constituent ,highest-level) *GRAMMAR*))
	 (all (nconc wild rest)))
    (remove-if-not #'(lambda (rule)
		       (and
			;; Level is low enough
;			(<= (rule-level rule) highest-level)
;			(eq (rule-level rule) highest-level)
			;; There are other elements in the RHS to be found
			(rest (rule-rhs rule))))
		   all)))


(defun rules-completed-by (constituent highest-level)
  (let* ((wild (gethash `(*wildcard* ,highest-level) *GRAMMAR-1*))
	 (rest (gethash `(,constituent ,highest-level) *GRAMMAR-1*))
	 (all (nconc wild rest)))
    (remove-if-not #'(lambda (rule)
		       (and
			;; Level is low enough
;			(<= (rule-level rule) highest-level)
;			(eq (rule-level rule) highest-level)
			;; There are no other elements in the RHS to find
			(null (rest (rule-rhs rule)))))
		   all)))




;;----------------------------------------------------------------------
;; ARCS-CONTINUED-BY
;;
;; Function which returns a list of the active arcs ending at END
;; which are continued by the given constituent.

(defun arcs-continued-by (end constituent)
  (let* ((wild (gethash `(,*wildcard*) *arcs*))
	 (rest (gethash `(,constituent) *arcs*))
	 (all (nconc wild rest)))
    (remove-if-not #'(lambda (arc)
			;; There are more symbols on the arc RHS (so
			;; we're not completing the arc yet)
			(and
;			 (>= end (arc-end arc))
			 (= end (arc-end arc))
			 (>= (arc-start arc) *cut-off*)
			 (nthcdr (1+ (arc-index arc)) (arc-rhs arc))))
		   all)))

;;----------------------------------------------------------------------
;; ARCS-COMPLETED-BY
;;
;; Function which returns a list of the active arcs ending at END
;; which are continued by the given constituent.

(defun arcs-completed-by (end constituent)
  (let* ((wild (gethash `(*wildcard*) *arcs*))
	 (rest (gethash `(,constituent) *arcs*))
	 (all (nconc wild rest)))
    (remove-if-not #'(lambda (arc)
		       (and
;			(>= end (arc-end arc))
			(= end (arc-end arc))
			(>= (arc-start arc) *cut-off*)
			(null (nthcdr (1+ (arc-index arc)) (arc-rhs arc)))))
		   all)))


(defun dump-arc (arcs) 
  (format t "No implementation for dumping arcs in this version!!"))




;;;
;;;   DMK lookup for xchart
;;; 

;;; the following definition replaces the one that comes with xchart;
;;; it uses the DMK instead of the toy lexicon

;(defun lookup-word (word)
;  (let ((num (check-if-number word)))
;    (if num `((,@num (nont <word>)))
;      (let ((dmk-output (parse-eng-word (string-downcase 
;					 (symbol-name word)))))
;	(if dmk-output
;	    (if (eq '*OR* (first dmk-output))
;		(mapcar #'(lambda (fs) 
;			    (let ((boundary (assoc 'boundary fs)))
;			      (if boundary
;				  (set-boundary (second boundary)
;						*token-position*)))
;			    `(,@fs (token ,*token-position*) (nont <word>))) (rest dmk-output))
;	      `((,@dmk-output (token ,*token-position*) (nont <word>))))
;	  (if (not (member word '(*PERIOD* *COMMA* *SEMICOLON* *DASH*))) 
;	      `(((token ,*token-position*) (nont <word>) 
;		 (sem *PN-IN-ROOT)
;		 (cat pn) (root ,(symbol-name word))))))))))


(defun lookup-word (word)
  (let ((num (check-if-number word)))
    (cond (num 
	   `((,@num (nont <word>))))
	  ((eq (first (explode-string (symbol-name word))) '*)
	   (let ((dmk-output (parse-eng-word (string-downcase
					      (symbol-name word)))))
	     (if dmk-output 
		 (if (eq '*OR* (first dmk-output))
		     (mapcar #'(lambda (fs) 
				 (let ((boundary (assoc 'boundary fs)))
				   (if boundary
				       (set-boundary (second boundary)
						     *token-position*))
				   `(,@fs (token ,*token-position*) (nont <word>)))) (rest dmk-output))
		   (let ((boundary (assoc 'boundary dmk-output)))
		     (if boundary
			 (set-boundary (second boundary)
				       *token-position*))
		     `((,@dmk-output (token ,*token-position*) (nont <word>)))))
	     `(((token ,*token-position*) (nont ,word))))))
	  (t 
	   (let ((dmk-output (parse-eng-word (string-downcase 
					      (symbol-name word)))))
	     (if dmk-output
		 (if (eq '*OR* (first dmk-output))
		     (mapcar #'(lambda (fs) 
				 (let ((boundary (assoc 'boundary fs)))
				   (if boundary
				       (set-boundary (second boundary)
						     *token-position*))
				   `(,@fs (token ,*token-position*) (nont <word>)))) (rest dmk-output))
		   (let ((boundary (assoc 'boundary dmk-output)))
		     (if boundary
			 (set-boundary (second boundary)
				       *token-position*))
		     `((,@dmk-output (token ,*token-position*) (nont <word>)))))
	       `(((token ,*token-position*) (nont <unknown>)))))))))
	    
	
;;; p1 tokenizes and parses a string

(defun p1 (string  &key
		    (search *default-searchmode*)
		    (quit *default-quitmode*)
		    (level 999))
   (parse (butlast (first (first (tokenize string))))
	  :search search :quit quit :level level))


;;; shows the f-structure associated with a node

(defun node (num)
  (dolist (el *chart*)
	  (when (= (entry-id el) 
		    num) 
		(progn (pns (entry-fs el))
		       (return)))))


(defun node-val (num)
  (dolist (el *chart*)
	  (when (= (entry-id el) 
		   num) 
		(return (entry-fs el)))))


;;; prints chart to file

(defun print-chart (file)
  (with-open-file (stream file :direction :output)
		  (dolist (el (sort-chart-by-id *chart*))
		    (print el stream))))



(defun parse-fs (final-position chart)
  (let ((parses (remove-if-not #'(lambda (x)
				   (and (not (member (entry-category x)
						     *stop-list*))
					(= 1 (entry-start x))
					(= final-position (entry-end x))))
			       chart))
	(count 0))
    (setq *parse-fs* nil)
    (dolist (fs parses (terpri))
      (format t "~%FS[~a,~a]:~%" (incf count) (entry-category fs))
      (pns (entry-fs fs))
      (setq *parse-fs* (nconc *parse-fs* (list (entry-fs fs))))
      (terpri))))


(defun compact-chart (chart)
  (let ((result1 nil)
	(result nil))
    (clrhash *max-hash*)
    (dolist (elem chart)
	    (let ((cat (entry-category elem))
		  max-list)
	      (setf max-list (gethash cat *max-hash*))
	      (block bla
		     (dolist (max max-list)
			     (cond ((and (= (entry-start max) (entry-start elem))
					 (= (entry-end max) (entry-end elem))
					 *packing*)
				    (let ((old-fs (entry-fs max))
					  (new-fs (entry-fs elem)))
				      (cond 
				       ((and *packing-remove-equal*
					     (tree-compare old-fs new-fs))
					(return-from bla))
				       ((eq '*OR* (first old-fs))
					(cond ((eq '*OR* (first new-fs))
					       (setf (entry-fs max)
						     `(*OR* ,@(rest old-fs)
							    ,@(rest new-fs))))
					      (t (setf (entry-fs max)
						       `(*OR* ,@(rest old-fs)
							      ,new-fs)))))
				       (t (cond ((eq '*OR* (first new-fs))
						 (setf (entry-fs max)
						       `(*OR* ,old-fs
							      ,@(rest new-fs))))
						(t (setf (entry-fs max)
							 `(*OR* ,old-fs
								,new-fs)))))))
				    (return-from bla))
				   ((or 
				     (and (< (entry-start max) (entry-start elem))
					  (<= (entry-end elem) (entry-end max)))
				     (and (<= (entry-start max) (entry-start elem))
					  (< (entry-end elem) (entry-end max))))
				    (return-from bla))))
		     (push elem max-list)
		     (push elem result1)
		     (setf (gethash cat *max-hash*) max-list))))
    (clrhash *max-hash*)
    (dolist (elem result1)
	    (let ((cat (entry-category elem))
		  max-list)
	      (setf max-list (gethash cat *max-hash*))
	      (block bla1
		     (dolist (max max-list)
			     (cond ((and (= (entry-start max) (entry-start elem))
					 (= (entry-end max) (entry-end elem))
					 *packing*)
				    (let ((old-fs (entry-fs max))
					  (new-fs (entry-fs elem)))
				      (cond 
				       ((and *packing-remove-equal*
					     (tree-compare old-fs new-fs))
					(return-from bla1))
				       ((eq '*OR* (first old-fs))
					(cond ((eq '*OR* (first new-fs))
					       (setf (entry-fs max)
						     `(*OR* ,@(rest old-fs)
							    ,@(rest new-fs))))
					      (t (setf (entry-fs max)
						       `(*OR* ,@(rest old-fs)
							      ,new-fs)))))
				       (t (cond ((eq '*OR* (first new-fs))
						 (setf (entry-fs max)
						       `(*OR* ,old-fs
							      ,@(rest new-fs))))
						(t (setf (entry-fs max)
							 `(*OR* ,old-fs
								,new-fs)))))))
				    (return-from bla1))
				   ((or 
				     (and (< (entry-start max) (entry-start elem))
					  (<= (entry-end elem) (entry-end max)))
				     (and (<= (entry-start max) (entry-start elem))
					  (< (entry-end elem) (entry-end max))))
				    (return-from bla1))))
		     (push elem max-list)
		     (push elem result)
		     (setf (gethash cat *max-hash*) max-list))))
    (reverse result)))

;(defun compact-chart (chart)
;  (let ((result nil))
;    (clrhash *max-hash*)
;    (dolist (elem chart)
;	    (let ((cat (entry-category elem))
;		  max-list)
;	      (setf max-list (gethash cat *max-hash*))
;	      (block bla
;		     (dolist (max max-list)
;			     (if (or 
;				  (and (< (entry-start max) (entry-start elem))
;				       (<= (entry-end elem) (entry-end max)))
;				  (and (<= (entry-start max) (entry-start elem))
;				       (< (entry-end elem) (entry-end max))))
;				 (return-from bla)))
;		     (push elem max-list)
;		     (push elem result)
;		     (setf (gethash cat *max-hash*) max-list))))
;    result))

(defun sort-chart-by-id (chart)
  (setf chart (stable-sort chart #'compare-entry-id)))
			     
(defun compare-entry-id (e1 e2)
  (< (entry-id e1) (entry-id e2)))


(defun compact-print-chart (file)
  (setq *chart* (compact-chart *chart*))
  (print-chart file))


(defvar *FINAL-CATEGORIES*)

(setq *FINAL-CATEGORIES* '(<OUTPUT> <NP> <VP> <CL> <COMPL> <PP> <ADJP> <ADVP> <REL> <COORD> <CONJ>))

(defun filter-chart (chart set)
  (remove-if-not #'(lambda (x) 
		     (and (equal (char (symbol-name 
					(entry-category x)) 0) #\<)
			 (member (entry-category x) set))) chart))


(defun final-print-chart (file)
  (setq *chart* (filter-chart (compact-chart *chart*) *final-categories*))
  (print-chart file))

(defun no-boundary (current-position end boundary-level)
  (if *ignore-boundaries*
      't
    (if *boundaries-present*       
	(let ((boundvec (make-array *final-position* :initial-element 0 
				    :element-type 'bit)))
	  (dotimes (i (- end current-position))
		   (setf (sbit boundvec (+ current-position i)) 1))
	  (if (equal *zerovec* (bit-and boundvec *boundaries*))
	      't
	    (progn 
	      (block loop1
	      (loop
	       (when (> current-position end)
		     #+lucid(loop-finish)
                     #+gcl(return loop1))
	       (when (>= boundary-level 
			 (gethash current-position *boundary-levels* 1000000))
		     #+lucid(loop-finish)
                     #+gcl(return loop1))
	       (incf current-position))
	      )
	      (if (> current-position end)
		  't
		nil))))
      't)))


(defun set-boundary (boundary-level position)
  (unless *ignore-boundaries*
	  (progn 
	    (setf *boundaries-present* t)
	    (setf (gethash position *boundary-levels*) boundary-level)
	    (setf (sbit *boundaries* position) 1))))


(defun boundary (position)
  (if *ignore-boundaries*
      nil
    (if *boundaries-present* 
	(progn
	  (if (eq (sbit *boundaries* position) 1)
	      't
	    nil))
      nil)))



(defun get-gap-from-entry (entry)
  (get-gap-from-fs (entry-fs entry)))
    

(defun get-gap-from-fs (fs)
  (let ((out (cond ((eq (first fs) '*OR*)
		    (mapcar #'get-gap-from-fs (rest fs)))
		   (t (second (assoc 'gap fs))))))
    (cond ((listp out)
	   (remove-if #'(lambda (x) (or (eq 'null x) (null x))) out))
	  (t out))))


(defun get-cover (chart)
  (let* ((filtered (filter-chart chart *final-categories*))
	 (clauses (filter-chart filtered '(<cl>))))
    (remove-if-not #'(lambda (x) (let ((gap (get-gap-from-fs (entry-fs x))))
				   (or (null gap) 
				       (eq gap 'NULL))))
		   (compact-chart clauses))))


(defun get-final-cover (chart)
  (let* ((filtered (filter-chart chart *final-categories*))
	 (output (filter-chart filtered '(<output>)))
	 final)
    (dolist (elem output)
	    ;(push (break-up-ors (node-val (entry-id elem))) final))
	    (push (kill-ors (node-val (entry-id elem))) final))
    final))

(defun print-entry-list (list)
  (dolist (elem list)
	  (let ((fs (entry-fs elem)))
	    (if fs 
		(pns fs)))))
    
(defun print-fs-list (list)
  (dolist (elem list)
	  (pns elem)))

(defun ppar (sentence &key (print 't))
  (p1 sentence :level 120 :quit nil)
  (setf output (reverse (get-final-cover (compact-chart *chart*))))
  (if print (print-fs-list output)
    output))



(defun kill-ors (fs)
  (cond ((not (listp fs)) fs)
	((equal (first fs) '*OR*)
	 (kill-ors (second fs)))
	((equal (first fs) '*NOT*)
	 fs)
	((equal (first fs) '*MULTIPLE*)
	 `(*MULTIPLE* ,(mapcar #'kill-ors (rest fs))))
	(t (let (out)
	     (dolist (vp fs)
		     (push `(,(first vp) ,(kill-ors (second vp))) out))
	     out))))
	    