
;;; Load file for XCHART with DMK
;;; not optimized for gcl

#+gcl(system:chdir "/usr0/local/alp/XCHART")

#+gcl(load "loader.lisp")

(format nil "DONE")

#+gcl(system:chdir "/usr0/local/alp/XCHART")

(format t "~%****************************************************")
(format t "~%*                                                  *")
(format t "~%*               Loading patches                    *")
(format t "~%* grammar rules and arcs will be stored in hashes  *")
(format t "~%*     arcs cannot be dumped in this version!       *")
(format t "~%                                                   *")
(format t "~%****************************************************")

#+gcl(load "patches6.o")

#+gcl(load "callouts.o")

(compgra "grammar3/gram02")

(load "grammar3/gram02")

#+gcl(load "gcl-patch.lisp")

(load "/usr0/local/alp/xchart/lcflex/Code/load-kant-stuff.gcl.lisp")

(load "grammar3/argclass-hierarchy.lisp")

(setf *dmk-directory* *dmk-path*)
(make-syn-lex-from-dmk-dir)

;;(new-dmk "ASIA")

(ctrace 2)

(defun new-grammar (gram)
  (compgra gram)
  (compile-file gram)
  (load gram))

(defun mymap (x) (first (map-semantic-map (list x))))

(defun list-to-ir (x) (mapcar #'mymap x))


(defun run-all-sentences (tofile)
  (let ((num 1))
    (with-open-file (out tofile :direction :output :if-exists :supersede)
		    (dolist (sent *all-sentences*)
			    (format out "~&((:NUMBER ~a) (:INPUT ~S) ~& (:IR ~& " num sent)
			    (format t "~&~a: ~a" num sent)
			    (pns (list-to-ir (ppar sent :print nil)) :stream out)
                            (format out "))")
			    (incf num))
		    )))


;; set some things

(setf *packing* t)
(setq *interpreter-return-partial-irs* t)