/***************************************************************************
 * Copyright (C) 1991,1992 by Wei Sun (william@cs.anu.edu.au)
 * All Rights Reserved
 * Version 2.02
 *
 * File:gbpage.c
 *
 * DISTRIBUTION:
 *      This program is NOT in public domain.  
 *      It can be freely distributed for non-commercial purposes only,
 *      and THERE IS NO WARRANTY FOR THIS PROGRAM.
 ****************************************************************************/

#include "gb2ps.h"

init_page()
{
/* define margins, line space and character space*/
	_LM=72;
	_RM=500;
	_TM=760;
	_BM=72;
	_FI=0;
	V=_TM; H=_LM;
	charcount=0; CFP=0;
	cfont=CHFONT[0].fp;
	font_height=CHFONT[0].height;
	font_width=CHFONT[0].width;
	page[0].offset=0;
	page[0].chfont=CFP;
	page[0].font_height=font_height;
	page[0].font_width=font_width;
	page[0]._LM=_LM;
	page[0]._RM=_RM;
	page[0]._TM=_TM;
	page[0]._BM=_BM;
	page[0]._FI=_FI;
	page[0].lineNo=0;
	page[1]=page[0];
}


begin_page()
{

	if (!Analyse_flag) {
		if (pagecounter==page_end_print) return;

/*		printf("Page:%d\n",pagecounter);*/
		printf(" %d",pagecounter); fflush(stdout);

		fprintf(out,"%%%%Page: %d\n",pagecounter);
		fprintf(out,"/Courier findfont [%.2f 0 0 %.2f 0 0] makefont setfont\n",0.837*font_width,1.5*font_height);
  		fprintf(out,"/H {moveto gsave currentpoint translate %d %d scale 24 24 true [24 0 0 -24 0 24]}def\n",font_width,font_height);
		fprintf(out,"save\n");
		if (setgray!=0) 
			fprintf(out,"%.2f setgray\n",(float)setgray/100.0);

	}

	if (*stheader) {
		if (!Analyse_flag) {
			fprintf(out,"/tempdict 100 dict\ntempdict begin\n");
			fprintf(out,"/Courier findfont [%.2f 0 0 %.2f 0 0] makefont setfont\n",8.37,15.0);
  			fprintf(out,"/H {moveto gsave currentpoint translate 10 10 scale 24 24 true [24 0 0 -24 0 24]}def\n");
			fprintf(out,"end\n");
		}
		V=_TM+24; H=_LM;
		putString(stheader);
		ASCshow();
	}

		V=_TM-line_h[linecounter];	charcount=0;
}

end_page ()
{
	if (pagecounter) {
		ASCshow();
		if (!Analyse_flag) {
			fprintf(out,"/Courier findfont [%.2f 0 0 %.2f 0 0] makefont setfont\n",8.37,15.0);
  			fprintf(out,"/H {moveto gsave currentpoint translate 10 10 scale 24 24 true [24 0 0 -24 0 24]}def\n");
		}
		if (*stfooter) {
			H=_LM; V=48;
			putString(stfooter);
			ASCshow();
		}
		if (!Analyse_flag) {
		  	if (pageno_flag) {
				fprintf(out,"%d %d M (%d) S\n", 
					300,_BM-24,pagecounter);
			}
		  	fprintf(out,"endpage\n");
		}
	}
	pagecounter++;
}

ps_header ()
{
  fprintf(out,"%%!PS-Adobe-1.0\n");
  fprintf(out,"%%%%Creator: W. SUN, ANU\n");
  fprintf(out,"/endpage {showpage restore} def\n");
  fprintf(out,"/G /grestore load def\n");
  fprintf(out,"/I /imagemask load def\n");
  fprintf(out,"/M /moveto load def\n");
  fprintf(out,"/S /show load def\n");
  DefCHdict();
  fprintf(out,"%%%%EndProlog\n");
}

ps_end()
{
	fprintf(out,"%%%%Trailer\n");
}


