/******************************************************************************
 * Copyright (C) 1991,1992 by Wei Sun (william@cs.anu.edu.au)
 * All Rights Reserved
 * Version 2.02
 *
 * File: 
 *	GB2PS.C
 *
 * SYNOPSIS:
 * 	 gb2ps [-h] [-c font][-y year][-m month][-i issue][-b page_no]
 *	       [-e page_no][-p][-t] input_file [output_file]
 *		
 * DESCRIPTION:
 * 	GB2PS converts the HANZI GB code article into PostScript printable
 * 	files that can be printed on PostScript printers.
 *	
 *	OPTIONS:
 *	-h		Help, print the usage of GB2PS
 *	-y year
 *	-m month
 *	-i issue	These peramaters are used in generating the cover
 *			page file, they will be passed to the coverpage
 *			PS file directly.
 *	-t		don't generate cover page.
 *	-f		allow page formating.
 *	-p		don't generate page number.
 *	-b page_no	begin generating PS file from page page_no.
 *	-e page_no	end generating PS file at page page_no.

 * ENVIRONMENT VARIABLES:
 *	CFONT:		Chinese characters font file.
 *	COVERPAGE:	Cover page PS file.
 *
 * DISTRIBUTION:
 *	This program and the font file are NOT in public domain.  
 *	All the files can be freely distributed for non-commercial purposes 
 * 	only, and THERE IS NO WARRANTY FOR THIS PROGRAM.
 *
 * AUTHOR:
 * 	The author can be reached by E-mail: william@cs.anu.edu.au
 *	or mail at:
 *
 *	   Wei Sun
 *	   Department of Computer Science
 *	   The Australian National University
 *	   Canberra, ACT 2601
 *	   Australia
 *****************************************************************************/

#include <string.h>
#include <stdlib.h>
#include "gb2ps.h"


int _LM,_RM,_TM,_BM,_FI;

char 	stheader[100],stfooter[100];
int	pageno_flag=TRUE;
int	endpage_flag=FALSE;
int	pagecounter=1;
int	page_begin_print=1,page_end_print= -1;
float	linespace=3.0;
float	charspace=0.07;

struct CHfont	CHFONT[6];
int	CFP=0;
char	cfont_name[100];
char	filename[100];
long	offset_CH=0;
int 	font_height,font_width;
long	size_of_CH=150;
char	line[500];
int	charcount=0;

char 	styear[5]="1991";
char 	stmonth[3]="5";
char 	stissue[3]="4";
int	coverpage_flag=TRUE;
int	format_flag=FALSE;
int	Analyse_flag=TRUE;

FILE	*in, *out;
FILE	*cfont;
float	H,V;

main (argc,argv)
int	argc;
char	**argv;
{
  int	ch=0,ch1,ch2;
  int	i;

  *stheader= *stfooter=0;
  i=init(argc,argv);

  init_page();
  AnalyseDoc();

  printf("Page(s):");

  if (coverpage_flag) 
  	coverpage();
  else
	ps_header();

  begin_page();
  while (((ch1=readchar())!=EOF)&&(pagecounter!=page_end_print)) {
	if (!ch)
		ch2=readchar();
	else {
		ch2=ch1;
		ch1=ch;
	}
	ch=putChar(ch1,ch2);
  }
    if (pagecounter!=page_end_print) end_page ();
    ps_end();
    fprintf(out,"end\n");
    cleanup(i);
  printf("\n");
}


