/***************************************************************************
 * Copyright (C) 1991,1992 by Wei Sun (william@cs.anu.edu.au)
 * All Rights Reserved
 * Version 2.02
 *
 *File:gbinit.c
 *
 * DISTRIBUTION:
 *      This program is NOT in public domain.  
 *      It can be freely distributed for non-commercial purposes only,
 *      and THERE IS NO WARRANTY FOR THIS PROGRAM.
 ****************************************************************************/

#include "gb2ps.h"
char pathname[50];

int init(arg,arglist)
int arg;
char **arglist;
{
  char** i;
  int k=0;

  *cfont_name=0;
  out = stdout;

  for (i=arglist+1; i<arglist+arg; i++) 
	switch (**i)  {
	case '-':
    		switch (*((*i)+1)) {
		case 'y': 
			strcpy (styear,*(++i));
			break;
		case 'm':
			strcpy(stmonth,*(++i));
			break;
		case 'i':
			strcpy(stissue,*(++i));
			break;
		case 't': 
			coverpage_flag=FALSE;
			break;
		case 'f': 
			format_flag=TRUE;
			break;
		case 'p': 
			pageno_flag=FALSE;
			break;
		case 'b':
			sscanf(*(++i),"%d",&page_begin_print);
			if (page_begin_print<1) page_begin_print=1;
			break;
		case 'e':
			sscanf(*(++i),"%d",&page_end_print);
			if (page_end_print<1) page_end_print= -1;
			else page_end_print+=1;
			break;
    		case 'h':

    		default:
      			printf("gb2ps\t[-h][-y year][-m month][-i issue][-p][-t][-f][-b page_no]\n\t[-e page_no] input_file [output_file]\n\n");
      			exit(0);
		}
		break;
	default:
		switch(k) {
		case 0:
		    if ((strncasecmp(*i,"cm",2)==0)&&(strlen(*i)==10)) {
		    	sprintf(styear,"19%c%c",(*i)[2],(*i)[3]);
		    	sprintf(stmonth,"%d",((*i)[4]-'0')*10+((*i)[5]-'0'));
		    	sprintf(stissue,"%d",1+
				(islower((*i)[6])?((*i)[6]-'a'):((*i)[6]-'A')));
		    }
    		    strcpy(filename,*i); 
		    if ((in=fopen(*i,"r"))==NULL) {
      			printf("Can't open input file -> %s\n",*i);
      			exit (1);
    		    }
    		    k++;
    		    break;
    		case 1: 
    			if ((out=fopen(*i,"w"))==NULL) {
      			  printf("Can't open output file -> %s\n",*i);
      			  exit (1);
    			}
			k++;
			break;
  		}
  	}
  	
  if (k<2) {
      	printf("gb2ps\t[-h][-y year][-m month][-i issue][-p][-t][-f][-b page_no]\n\
\t[-e page_no] input_file [output_file]\n\n");
	if (k<1) 
		printf("Input file name not supplied.\n");
	else
		printf("Output file name not supplied.\n");
	exit (1);
  }

  if (*pathname==0)
  	if (getenv("CFONT")!=NULL)
 		strcpy(pathname,getenv("CFONT"));
	else
    		strcpy (pathname,CFONT);

 strcpy(cfont_name,pathname); strcat(cfont_name,SONGTI); 
 if ((cfont = fopen (cfont_name, "r"))!=NULL) {
	CHFONT[0].fp=cfont;
	strcpy(CHFONT[0].name,"SONG 24");
	CHFONT[0].height=10;
	CHFONT[0].width=10;
  }
  else
    {
      fprintf(stderr,"Cannot open the chinese font file -> %s\n",
	      cfont_name);
      exit (1);
    }

 strcpy(cfont_name,pathname); strcat(cfont_name,KEITI);
 if ((cfont = fopen (cfont_name, "r"))!=NULL) {
	CHFONT[1].fp=cfont;
	strcpy(CHFONT[1].name,"KEI 24");
	CHFONT[1].height=10;
	CHFONT[1].width=10;
  }
  else
    {
      fprintf(stderr,"Warnning: cannot open the chinese font file -> %s, use %s instead.\n",cfont_name,SONGTI);
	CHFONT[1]=CHFONT[0];
  }

 strcpy(cfont_name,pathname); strcat(cfont_name,FANGSONGTI); 
 if ((cfont = fopen (cfont_name, "r"))!=NULL) {
	CHFONT[2].fp=cfont;
	strcpy(CHFONT[2].name,"FANG SONG 24");
	CHFONT[2].height=10;
	CHFONT[2].width=10;
  }
  else
    {
      fprintf(stderr,"Warnning: cannot open the chinese font file -> %s, use %s instead.\n",cfont_name,SONGTI);
	CHFONT[2]=CHFONT[0];
  }

 strcpy(cfont_name,pathname);  strcat(cfont_name,HEITI); 
 if ((cfont = fopen (cfont_name, "r"))!=NULL) {
	CHFONT[3].fp=cfont;
	strcpy(CHFONT[3].name,"HEI 24");
	CHFONT[3].height=10;
	CHFONT[3].width=10;
  }
  else
    {
      fprintf(stderr,"Warnning: cannot open the chinese font file -> %s, use %s instead.\n",cfont_name,SONGTI);
	CHFONT[3]=CHFONT[0];
  }

 strcpy(cfont_name,pathname); strcat(cfont_name,FANTI); 
 if ((cfont = fopen (cfont_name, "r"))!=NULL) {
	CHFONT[4].fp=cfont;
	strcpy(CHFONT[4].name,"FAN 24");
	CHFONT[4].height=10;
	CHFONT[4].width=10;
  }
  else
    {
      fprintf(stderr,"Warnning: cannot open the chinese font file -> %s, use %s instead.\n",cfont_name,SONGTI);
	CHFONT[4]=CHFONT[0];
  }

 strcpy(cfont_name,pathname); strcat(cfont_name,USERDEF); 
 if ((cfont = fopen (cfont_name, "r"))!=NULL) {
	CHFONT[5].fp=cfont;
	strcpy(CHFONT[5].name,"USER 24");
	CHFONT[5].height=10;
	CHFONT[5].width=10;
  }
  else
    {
	CHFONT[5]=CHFONT[0];
  }

  return k;
}


cleanup(i)
int i;
{
  switch(i) { 
  	case 2: fclose(out);
  	case 1: fclose(in);
  }
  cfont=CHFONT[0].fp;
  fclose (CHFONT[0].fp);
  if (cfont!=CHFONT[1].fp) fclose(CHFONT[1].fp);
  if (cfont!=CHFONT[2].fp) fclose(CHFONT[2].fp);
  if (cfont!=CHFONT[3].fp) fclose(CHFONT[3].fp);
  if (cfont!=CHFONT[4].fp) fclose(CHFONT[4].fp);
  if (cfont!=CHFONT[5].fp) fclose(CHFONT[5].fp);
}


