/***************************************************************************
 * Copyright (C) 1991,1992 by Wei Sun (william@cs.anu.edu.au)
 * All Rights Reserved
 * Version 2.02
 *
 * File:gbchar.c
 *
 * DISTRIBUTION:
 *      This program is NOT in public domain.  
 *      It can be freely distributed for non-commercial purposes only,
 *      and THERE IS NO WARRANTY FOR THIS PROGRAM.
 **************************************************************************/
#include "gb2ps.h"

int  	CHcode[8836][6];
int	ascflag=FALSE;
int	CH_mode=FALSE;
int	paraflag=TRUE;
int	newpage_flag=TRUE;
int	file_pointer_flag;
struct	Page 	page[400];
int	linecounter=0;
float	line_h[26400];
int	maxFont_height=0; /* will be set when read commands*/
int	commandcounter=0;
int	rotate_flag=FALSE;
int	setgray=0;

ASCshow() {
	if (ascflag) {
		if (!Analyse_flag) fprintf(out,") S\n");
		ascflag=FALSE;
	}
}

newline ()
{
	charcount=0;  H=_LM; 
	ASCshow();

	if (maxFont_height<font_height) 
			maxFont_height=font_height;

	if (Analyse_flag) { 
		if (newpage_flag) {
			newpage_flag=FALSE;
			V =_TM-_CLP;
		}
		V -= _CLP; 
		line_h[linecounter]=_CLP;
		linecounter++;
		maxFont_height=0;
	}
	else {
		V -= line_h[linecounter];
		linecounter++;
	}
	if (V<_BM) { 
		if (endpage_flag) {
			end_page();
			begin_page();
			newpage_flag=TRUE;
			endpage_flag=FALSE;
		}
		else {
			endpage_flag=TRUE;
/*			printf("==Page %d lines:%d  offset:%d V=%f\n", pagecounter,linecounter,ftell(in)-file_pointer_flag,V);*/
			if (Analyse_flag) {
				page[pagecounter+1].offset=ftell(in)
							-file_pointer_flag;
				page[pagecounter+1].chfont=CFP;
				page[pagecounter+1].font_height=font_height;
				page[pagecounter+1].font_width=font_width;
				page[pagecounter+1]._LM=_LM;
				page[pagecounter+1]._RM=_RM;
				page[pagecounter+1]._TM=_TM;
				page[pagecounter+1]._BM=_BM;
				page[pagecounter+1]._FI=_FI;
				page[pagecounter+1].lineNo=linecounter-1;
			}
		}
	}
}

put_ASC(c)
int c;
{
	if(c==26||c==EOF||c==0) return;

	charcount++;
	if (maxFont_height<font_height) 
			maxFont_height=font_height;

	if (paraflag) {
		H=_LM;
		H+=_FI; paraflag=FALSE;
	}

	if (endpage_flag) {
		end_page();
		begin_page();
		newpage_flag=TRUE;
		endpage_flag=FALSE;
	}


	if (Analyse_flag) {
	  if ((c>=' ') && (!ascflag)) ascflag=TRUE;
	}
	else {
	  if(c>=' ') {
		if (!ascflag) {
			ascflag=TRUE;
			  fprintf(out,"%.0f %.0f M (",H+0.5, V+0.5);
		}
		if ((c<=0x7f)&&(c>=0x20)&&(c!='(')&&(c!=')'))
			fprintf(out,"%c",c);
		else
			fprintf(out,"\\%03o",c);
	  }
	  else fprintf(out," ");
	}

	H+=_ASP;
	if (H>_RM)
		newline ();
}

put_CH(ch1,ch2)
int ch1,ch2;
{
	long addr;
	char st1[10];
	char st2[200];
	charcount+=2;
	ASCshow();

	if (maxFont_height<font_height) 
			maxFont_height=font_height;

	if (paraflag) {
		H=_LM;
		H+=_FI; paraflag=FALSE;
	}

	if (endpage_flag) {
		end_page();
		begin_page();
		newpage_flag=TRUE;
		endpage_flag=FALSE;
	}

	if (Analyse_flag) {
		if ((pagecounter>=page_begin_print) && 
		    (pagecounter!=page_end_print))
			CHcode[(ch1-0xA1)*94+ch2-0xA1][CFP]+=1;
	}
	else 
	  if (ch1!=0xa1||ch2!=0xa1) {
		addr=(ch1-0xA1)*94+ch2-0xA1;
		fprintf(out,"%.0f %.0f ",H+0.5, V+0.5);
		if (CHcode[addr][CFP]>=CHAR_LIMIT) 
			/*QuWei code start from 1*/
			fprintf(out,"C%1d%02d%02d\n",CFP,ch1-0xa0,ch2-0xa0);
		else {
			fseek(cfont,offset_CH+addr*size_of_CH,0);
			fgets(line,size_of_CH,cfont);
			sscanf(line,"%s %s",st1,st2);
			fprintf(out,"H {<%s>} I G\n",st2);
		}
	  }
  	H+=_CSP;
	if (H>_RM)
		newline ();
}

int putChar(ch1,ch2)
int ch1,ch2;
{
      int k,k1;
	file_pointer_flag=1;

      switch (ch1) {
      	case 13: case 26: break; /* for PC format file*/
      	case '\n': paraflag=TRUE; newline(); break;
      	case '\t': k1=8-charcount%8;
		  for (k=0;k<=k1;k++)
			put_ASC(' '); 
		  break;
        case 12: end_page(); break;
        case EOF: return EOF;
        default:
      		if (ch1>=0xA1) {
      			switch (ch2){
      			  case 13:case 26:  /* for PC format file*/
      			  case EOF:
				put_ASC(ch1); return EOF;
			  case '\n':case 0:
      			  	put_ASC(ch1); paraflag=TRUE; newline(); break;
			  case 12:
      			  	put_ASC(ch1); end_page(); break;
      			  default:
	  			if (ch2<0xA1) {
			  		put_ASC(ch1);
					file_pointer_flag=0; 
		  			put_ASC(ch2);
				}
	  			else {
					file_pointer_flag=0; 
					put_CH(ch1,ch2);
				}
			}
			return 0;
      		}
		else put_ASC(ch1);
      }
      return ch2;
}

putString(st)
char* st;
{
	int i,ch,ch1,ch2,len;
	i=0;
	ch=0;
	len=strlen(st);
	while (i<=len) {
		ch1=st[i++];
		if (!ch)
			ch2=st[i++];
		else {
	  		ch2=ch1;
			ch1=ch;
		}
		ch=putChar(ch1,ch2);
	} 
}

/*===========================================================================*/

DefCHdict() {
	long i,j,k=0;
	char st1[10];
	char st2[200];


	for (i=0;i<94*94;i++) 
	   for (j=0;j<6;j++) {
		if (CHcode[i][j]>=CHAR_LIMIT) k++;
	   }

	fprintf(out,"/CHdict %d dict def\nCHdict begin\n",k+400);

	for (i=0;i<94*94;i++) 
	   for (j=0;j<6;j++) {
		if (CHcode[i][j]>=CHAR_LIMIT) {
			fseek(CHFONT[j].fp,offset_CH+i*size_of_CH,0);
			fgets(line,size_of_CH,CHFONT[j].fp); 
			sscanf(line,"%s %s",st1,st2);
			fprintf(out,"/C%1d%s {H {<%s>} I G} def \n",j,st1,st2);
		}
	   }
}


/*AnalyseDoc: analyse the input document.*/

int AnalyseDoc() {
  int	ch=0,ch1,ch2,i,j;

  for (i=0;i<94*94;i++) 
    for (j=0;j<6;j++)
	CHcode[i][j]=0;;

  begin_page();
  while ((ch1=readchar())!=EOF) {
	if (!ch) 
		ch2=readchar();
	else {
		ch2=ch1;
		ch1=ch;
	}
	ch=putChar(ch1,ch2);
  }
  newline();

  if (pagecounter>=page_begin_print) {
	CFP=page[page_begin_print].chfont;
	cfont=CHFONT[CFP].fp;
	_LM=page[page_begin_print]._LM;
	_RM=page[page_begin_print]._RM;
	_TM=page[page_begin_print]._TM;
	_BM=page[page_begin_print]._BM;
	_FI=page[page_begin_print]._FI;
	linecounter=page[page_begin_print].lineNo;
	font_height=page[page_begin_print].font_height;
	font_width=page[page_begin_print].font_width;
	fseek(in,page[page_begin_print].offset,0);
	pagecounter=page_begin_print;
 }
  else  {
	printf("The file %s only has %d Page(s).\n",filename,pagecounter);
	exit(1);
  }
  Analyse_flag=FALSE; H=_LM; paraflag=TRUE;ascflag=FALSE; CH_mode=FALSE;
}

int readchar() {
	int	c;
	int	tmp;
	float	tmp1=0.0;

	c=fgetc(in);
	while (c=='~') {
		tmp=fgetc(in);
		switch (tmp) {
		  case '{':	CH_mode=TRUE;  break;
		  case '}':	CH_mode=FALSE; break;
		  case '~':	break;
		  case '\n':	break;
		  default:	ungetc(tmp,in);
		}
		if (tmp=='~') 
			break;
		else 
			c=fgetc(in);
	}

	if (CH_mode)
		if (((c&0x7f)>=0x21)&&((c&0x7f)<=0x7e))
			return c|0x80;
		else {
			CH_mode=FALSE;
			return c;
		}
			
	if (!format_flag) return c;

	if (c=='<') {
	    ASCshow();
	    commandcounter=ftell(in);
	    while ((c!='>') && (c!=EOF)){
		c=fgetc(in);
		if (c=='<') break;
		switch (c) {
		  case '<':case EOF: break;
		  case 'L':
			fscanf(in,"%d",&tmp);
			if (tmp>0) linespace=tmp;
			break;
		  case 'C':
			fscanf(in,"%f",&tmp1);
			if (tmp1>0) charspace=tmp1;
			break;
		  case 'B':
			fscanf(in,"%f",&tmp1);
			V=-tmp1;
			break;
		  case 'm':
			fscanf(in,"%f",&tmp1);
			if (tmp1>0) H=tmp1;
			fscanf(in,"%f",&tmp1);
			if (tmp1>0) V=tmp1;
			break;
		  case 'M':
			switch (c=fgetc(in)) {
		  	  case 'L':
				fscanf(in,"%d",&tmp);
				if (tmp>0) _LM=tmp;
				if (H<tmp) H=(float)tmp;
				break;
		  	  case 'R':
				fscanf(in,"%d",&tmp);
				if (tmp>0) _RM=572-tmp;
				break;
		  	  case 'T':
				fscanf(in,"%d",&tmp);
				if (tmp>0) _TM=832-tmp;
				break;
		  	  case 'B':
				fscanf(in,"%d",&tmp);
				if (tmp>0) _BM=tmp;
				break;
		  	  case 'I':
				fscanf(in,"%d",&tmp);
				_FI=tmp;
				break;
			}
			break;

		  case 'F':
			switch (c=fgetc(in)) {
			  case 'S':case 's': 
				CFP=0; cfont=CHFONT[CFP].fp; break;
			  case 'K':case 'k': 
				CFP=1; cfont=CHFONT[CFP].fp; break;
			  case 'F':case 'f': 
				CFP=2; cfont=CHFONT[CFP].fp; break;
			  case 'H':case 'h': 
				CFP=3; cfont=CHFONT[CFP].fp; break;
			  case 'G':case 'g': 
				CFP=4; cfont=CHFONT[CFP].fp; break;
			  case 'U':case 'u': 
				CFP=5; cfont=CHFONT[CFP].fp; break;
		  	  case 'Z':case 'z':
				fscanf(in,"%d",&tmp);
				if (tmp>0) font_width=tmp;
				fscanf(in,"%d",&tmp);
				if (tmp>0) font_height=tmp;
				if (!Analyse_flag) {
					fprintf(out,"/Courier findfont [%.2f 0 0 %.2f 0 0] makefont setfont\n",0.837*font_width,1.5*font_height);
  					fprintf(out,"/H {moveto gsave currentpoint translate %d %d scale 24 24 true [24 0 0 -24 0 24]}def\n",font_width,font_height);
				}
				break;
		  	  case 'R':case'r':
				fscanf(in,"%d",&tmp);
				if (!Analyse_flag) {
				  if (tmp==0) {
					fprintf(out,"/Courier findfont [%.2f 0 0 %.2f 0 0] makefont setfont\n",0.837*font_width,1.5*font_height);

  					fprintf(out,"/H {moveto gsave currentpoint translate %d %d scale 24 24 true [24 0 0 -24 0 24]}def\n",font_width,font_height);
				  }
				  else {
  					fprintf(out,"/H {moveto gsave currentpoint translate %d %d scale 24 24 true [24 0 0 -24 0 24] %d rotate}def\n",font_width,font_height,tmp);
				  }
				}
				break;
		  	  case 'O':case 'o':
				tmp=font_width;
				font_width=font_height;
				font_height=tmp;
				rotate_flag=(!rotate_flag);
				if (rotate_flag==FALSE) {
					H-=font_height;
  					if (!Analyse_flag) 
						fprintf(out,"/H {moveto gsave currentpoint translate %d %d scale 24 24 true [24 0 0 -24 0 24]}def\n",font_width,font_height);
				}
				else  {
					H+=font_width;
  					if (!Analyse_flag)
						fprintf(out,"/H {moveto gsave currentpoint translate %d %d scale 24 24 true [24 0 0 -24 0 24] 90 rotate}def\n",font_width,font_height);
				}
				break;
			}
			break;

		  case 'G':
			fscanf(in,"%d",&tmp);
			if ((tmp>=0)&&(!Analyse_flag)) {
				setgray=tmp;
				fprintf(out,"%.2f setgray\n",(float)tmp/100.0);
			}
			break;
		}
	    }
	}
	if (c=='>') c=fgetc(in);
	return c;
}
