/******************************************************************************
 * Copyright (C) 1991 by Wei Sun (william@anucsd.anu.edu.au)
 * All Rights Reserved
 * Version 1.06
 *
 * File: 
 *	COVER.C
 *
 * DESCRIPTION:
 *
 *	Cover page generator.
 *
 * DISTRIBUTION:
 *	This program is NOT in public domain.  
 *	It can be freely distributed for non-commercial purposes only,
 *	and THERE IS NO WARRANTY FOR THIS PROGRAM.
 *
 *****************************************************************************/
#include "gb2ps.h"
#include <string.h>
#include <stdlib.h>

char coverPS[50];
#ifndef COVERPAGE
#define COVERPAGE "cover.ps"
#endif

coverpage() 
{
	int	tmp;
	FILE* cover;
	tmp=pagecounter;
	pagecounter=0;
	if (getenv("COVERPAGE")!=NULL)
		strcpy(coverPS,getenv("COVERPAGE"));
	else
		strcpy(coverPS,COVERPAGE);

	if ((cover=fopen(coverPS,"r"))==NULL) {
		printf("Can't open cover page file -> %s\n",coverPS);
		exit (1);
	}
	ps_header();
	fprintf(out,"%%%%Page: 0\nsave\n");
	fprintf(out,"/Courier findfont [%.2f 0 0 %.2f 0 0] makefont setfont\n",8.37,15.0);
  	fprintf(out,"/H {moveto gsave currentpoint translate 10 10 scale 24 24 true [24 0 0 -24 0 24]}def\n");
	fprintf(out,"/year (%s) def\n",styear);
	fprintf(out,"/month (%s) def\n",stmonth);
	fprintf(out,"/issue (%s) def\n",stissue);
	while (fgets(line,500,cover)!=NULL) {
		fprintf(out,"%s",line);
	}
	fclose(cover);
	end_page();
	pagecounter=tmp;
}
