#!/atm/release/fore/bin/sntclsh

##################################################################################
# This TCL script sets updates the CDB so that all paths and channels conform to
# the new UPC traffic management parameters.
#
# To conform all policeAction and sust entries are removed.  
# Finally, all default values are removed to save CDB space.
##################################################################################


##################################################################################
# updateCdbThroughPvcs: updates PVC in CDB to use 3.3 format
##################################################################################
proc updateCdbThroughPvcs { list } {
    global c
    set output 1
    set prevname {}
    foreach pvc $list {
	set name  [lindex $pvc 0]
	set type  [lindex $pvc 1]
	set value [lindex $pvc 2]
	set start [expr [string last / $name] + 1]
	if { $start > 0 } {
	    set str [string range $name $start end]
	} else {
	    set str {}
	}
	if { $type == "DIRECTORY" && $str != "qos_new" } {
	    if { $output == 0 } {
		set result [catch {c rm $prevname}]
		if { $result == 1 } {
		    puts "pvc2upc: Could not remove $prevname"
		}
	    }
	    set output 0
	    set prevname $name
	} elseif { $type == "OCTETSTRING" && $str == "qos" } {
	    set result [catch {set qos [c readOldQos $name]}]
	    if { $result == 1 } {
		puts "pvc2upc: Could not read old style qos $name"
		continue
	    }

	    set result [catch {c rm $name}]
	    if { $result == 1 } {
		puts "pvc2upc: Could not remove $name"
		continue
	    }

	    set qos_new "_new"
	    set result [catch {c mkdir "$name$qos_new"}]
	    if { $result == 1 } {
		puts "pvc2upc: Could not make $name$qos_new directory"
		continue
	    }

	    set qos_new "_new/"
	    foreach q $qos {
		set var [lindex $q 0]
		set typ [lindex $q 1]
		set val [lindex $q 2]
		if { $val != "0" && $val != "-1" && \
			$var != "policeAction" && $var != "sust" } {
		    set result [catch {c set "$name$qos_new$var" $typ $val}]
		    if { $result == 1 } {
			puts "pvc2upc: Could not write new style qos entry $name$qos_new$var"
			break
		    }
		}
	    }
	} elseif { $type == "BOOLEAN" } {
	    set output 1
	} elseif { $type == "INTEGER" } {
	    if { $value == "-1" || $value == "0" || \
		    $str == "policeAction" || $str == "sust" } {
		set result [catch {c rm $name}]
		if { $result == 1 } {
		    puts "pvc2upc: Could not remove $name"
		}
	    }
	}
    }
    if { $output == 0 } {
	set result [catch {c rm $prevname}]
	if { $result == 1 } {
	    puts "pvc2upc: Could not remove $prevname"
	}
    }
}


##################################################################################
# updateCdbTermPvcs: updates PVC in CDB to use 3.3 format
##################################################################################
proc updateCdbTermPvcs { list } {
    global c
    foreach pvc $list {
	set name  [lindex $pvc 0]
	set type  [lindex $pvc 1]
	set value [lindex $pvc 2]
	set start [expr [string last / $name] + 1]
	if { $start > 0 } {
	    set str [string range $name $start end]
	} else {
	    set str {}
	}
	set start [expr [string last . $name] + 1]
	if { $start > 0 } {
	    set str2 [string range $name $start end]
	} else {
	    set str2 {}
	}
	if { $type == "OCTETSTRING" && $str2 == "qos" } {
	    set result [catch {set qos [c readOldQos $name]}]
	    if { $result == 1 } {
		puts "pvc2upc: Could not read old style qos $name"
		continue
	    }

	    set result [catch {c rm $name}]
	    if { $result == 1 } {
		puts "pvc2upc: Could not remove $name"
		continue
	    }

	    set qos_new "_new"
	    set result [catch {c mkdir "$name$qos_new"}]
	    if { $result == 1 } {
		puts "pvc2upc: Could not make $name$qos_new directory"
		continue
	    }

	    set qos_new "_new/"
	    foreach q $qos {
		set var [lindex $q 0]
		set typ [lindex $q 1]
		set val [lindex $q 2]
		if { $val != "0" && $val != "-1" && \
			$var != "policeAction" && $var != "sust" } {
		    set result [catch {c set "$name$qos_new$var" $typ $val}]
		    if { $result == 1 } {
			puts "pvc2upc: Could not write new style qos entry $name$qos_new$var"
			break
		    }
		}
	    }
	} elseif { $type == "INTEGER" } {
	    if { $value == "-1" || $value == "0" || \
		    $str == "policeAction" || $str == "sust" } {
		set result [catch {c rm $name}]
		if { $result == 1 } {
		    puts "pvc2upc: Could not remove $name"
		}
	    }
	}
    }
}


proc UpdateNecessary { pvcs } {

    foreach pvc $pvcs {
	set name  [lindex $pvc 0]
	set type  [lindex $pvc 1]
	set value [lindex $pvc 2]
	if { $type == "INTEGER" && $value == "-1" } {
	    return 1
	} elseif { $type == "OCTETSTRING" } {
	    return 1
	}
    }

    return 0
}


##################################################################################
# Open CDB
##################################################################################
set filename /atm/etc/cdb.conf
set result [catch {cdb open c $filename}]
if { $result == 1 } {
    puts "pvc2upc: ERROR: Could not open CDB, \"$filename\""
    exit
}


##################################################################################
# Update CDB pvc and pvp directories
##################################################################################
c cd /software/pvc
set pvcs [c get]
if { [UpdateNecessary $pvcs] == 1 } {
    updateCdbThroughPvcs $pvcs
}

c cd /software/pvp/through
set pvps [c get]
if { [UpdateNecessary $pvps] == 1 } {
    updateCdbThroughPvcs $pvps
}

c cd /software/pvp/term
set terms [c get]
if { [UpdateNecessary $terms] == 1 } {
    updateCdbTermPvcs $terms
}

c cd /software/pvp/orig
set origs [c get]
if { [UpdateNecessary $origs] == 1 } {
    updateCdbTermPvcs $origs
}

c close
