#!/atm/release/fore/bin/perl
#
# @(#)$Id: chngpass.pl,v 1.1 1994/11/17 17:34:06 kamran Exp $ FSI
#
# passwd -- package to change password on machines with read-only root filesys.
#

package passwd;

$passfile = '/atm/etc/passwd';
$ptmpfile = '/atm/etc/ptmp';

sub passwd  {
	local($user) = @_;
	local(@pass) = &getfile;
	local(@pline) = grep(/^$user:/, @pass);

	#
	# no passwords read, or $user not found
	#
	if($#pass == -1 || $#pline != 0) {
		print "I cannot change the password for $user\n";
		return -1;
	}
	#
	# lock file exist and less than 12 hours old?
	#
	if(-f $ptmpfile && -M $ptmpfile < 0.5) {
		print "The password file is busy, try again later\n";
		return -1;
	}

	($me, $opass, $uid) = split(/:/, $pline[0]);
	print "\nChanging password for $me.\n";
	if(length($opass)) {
		$try = &prompt_noecho("Old password: ");
		$osalt = substr($opass, 0, 2);
		if(crypt($try, $osalt) ne $opass) {
			print "Sorry.\n";
			return -1;
		}
		$delta = 0;
	} else {
		$delta = 13;
	}
	do {
		print "Please use a longer password.\n" if $attempts++;
		$npass1 = &prompt_noecho("New password: ");
		$accept = (length($npass1) >= 6);
	} while(!$accept && $attempts < 3);
#	if($attempts >= 3) {
#		print "Sorry.";
#		return -1;
#	}

	$npass2 = &prompt_noecho("Retype new password: ");
	if($npass1 ne $npass2) {
		print "Mismatch - password unchanged.\n";
		return -1;
	}
	$nsalt = &newsalt($me);

	$ncrypt = crypt($npass1, $nsalt);

	if(grep(s:^$me\:$opass\::$me\:$ncrypt\::, @pass) != 1) {
		print "Error changing password - password unchanged.\n";
		return -1;
	}
	&putfile(@pass);
	
	if(((-s $passfile) + $delta) != -s $ptmpfile) {
		print "Error changing password - password unchanged.\n";
		unlink($ptmpfile);
		return -1;
	}
	if(rename($ptmpfile, $passfile) != 1) {
		print "Error installing new password: $! - password unchanged.\n";
		unlink($ptmpfile);
		return -1;
	}

	print "\npassword changed.\n";
	return 0;
}

#
# delete_user - removes the named user from the passwd file
#
sub delete_user {
	local($user) = @_;
	local(@pass) = &getfile;
	local(@pline) = grep(!/^$user:/, @pass);

	#
	# no passwords read, or $user not found
	#
	if($#pass == -1 || $#pline != $#pass-1) {
		print "I cannot delete the password entry for $user\n";
		return -1;
	}

	if(&putfile(@pline) != 0 || rename($ptmpfile, $passfile) != 1) {
		print "Error installing password file: $! - password unchanged.\n";
		unlink($ptmpfile);
		return -1;
	}
	print "\nuser $user deleted from password file\n";
	return 0;
}


sub newsalt {
	local($user) = @_;
	local(@saltset, $now, $pert1, $pert2, $week, $nsalt);
	# Encrypt using salt that's fairly random but encodes weeks
	# since 1970, mod 64.

	# (We perturb the week using the first two chars of $me so
	# that if everyone changes their password the same week we
	# still get more than 64 possible salts.)

	@saltset = ('a' .. 'z', 'A' .. 'Z', '0' .. '9', '.', '/');
	$now = time;
	($pert1, $pert2) = unpack("C2", $me);
	$week = $now / (60*60*24*7) + $pert1 + $pert2;
	$nsalt = $saltset[$week % 64] .  $saltset[$now % 64];
	return $nsalt;
}
	
sub getfile {
	local(@pass);
	unless(open(PASS, "$passfile")) {
		warn "cannot read $passfile\n";
		return ();
	}
	@pass = <PASS>;
	close(PASS);
	return @pass;
}

sub putfile {
	$omask = umask(022);
	unless(open(PTMP, ">$ptmpfile")) {
		warn "cannot write $ptmpfile\n";
		return -1;
	}
	umask($omask);
	foreach (@_) {
		print PTMP;
	}
	close(PTMP);
	return 0;
}

sub prompt_noecho {
	local($reply);
	print $_[0];
	system 'stty', '-echo';
	chop($reply = <STDIN>);
	system 'stty', 'echo';
	print "\n";
	return $reply;
}

if ($#ARGV >= 0) {
    if ($#ARGV == 0) {
        exit( &passwd($ARGV[0]) );
    } elsif ($#ARGV == 1 && $ARGV[1] =~ "deleteuser") {
        exit( &delete_user($ARGV[0]) );
    } else {
        print "Invalid argument\n";
    }
}

exit(1);


