#!/atm/release/fore/bin/sntclsh
#
# AMI - ATM Management Interface
# Copyright (c) 1994, 1995 FORE Systems, Inc.
# All Rights Reserved
#
# @(#)$Id: ami.tcl,v 1.673 1995/06/28 03:00:40 bhargava Exp $ FSI
#

############################################################
#
# showVersionInfo: display version information
#
proc showVersionInfo {} {
    global g_version
    puts "\nATM Management Interface v$g_version"
    puts "Copyright (c) 1994, 1995 FORE Systems, Inc."
    puts "All Rights Reserved\n"
}


proc setDebug {} {
    global g_debug
    if { $g_debug == "on" } {
        set g_debug "off" 
    } else {
        set g_debug "on"
    }
    puts "Debugging is $g_debug"
}



proc DEBUGSTR { str } {
    global g_debug
    if { $g_debug == "on" } {
        puts "DEBUG: $str"
    }
}


proc EMSG { str } {
    puts "\n?ERROR: $str"
}

proc ERROR { str } {
    error "$str"
}


proc convertUserConst { const const_list } {
    set index -1
    set count -1
    set const [string tolower $const]
    foreach item $const_list {
        incr count
        if { [string tolower $item] == $const } {
            set index $count
            break
        }
    }
    if { $index < 0 } { return $const }
    return [lindex $const_list [expr $index + 1]]
}


proc convertMibConst { const const_list } {
    set index [lsearch $const_list $const]
    if { $index < 0 } { return $const }
    return [lindex $const_list [expr $index - 1]]
}



############################################################
#
# setGlobals: set the global variables for this module
#
#

proc setGlobals {} {
    global g_version
    global g_curhost g_switch_type g_prompt g_shortmenus g_fullmenus
    global g_expanded_cmd g_unique_cmds g_ambig_cmds g_cmd_matchcount
    global g_generalinfo g_debug
    global g_scrambling g_descrambling
    global g_e3Loopback g_e3Timing g_e3LineType g_e1LineTypeFraming
    global g_e1Loopback g_e1Timing g_e1LineType g_e1LineLength
    global g_ds3Loopback g_ds3Timing g_ds3LineType g_ds3LineTypeFraming
    global g_ds1Loopback g_ds1Timing g_ds1LineType g_ds1LineTypeFraming \
            g_ds1LineLength
    global g_j2LineLength g_j2Loopback g_j2Timing
    global g_sonetLoopback g_sonetTiming g_sonetLineType g_sonetLineTypeFraming 
    global g_taxiLoopback g_taxiPortModels
    global g_e3StatVars g_ds3StatVars g_sonetStatVars g_j2StatVars 
    global g_ds1StatVars g_e1StatVars
    global g_ipStats g_udpStats g_tcpStats g_snmpStats g_icmpStats g_ifStats
    global g_term_rows g_term_row_offset g_line_count
    global g_sessions g_months
    global g_rs232PortList
    global g_cmd_table g_shmemXACPT
    global g_peerlist

    set g_version 1.2

    set g_peerlist {}
    set g_term_row_offset 2
    set g_term_rows [expr 24 - $g_term_row_offset]
    set g_line_count 0

    set g_sessions(1) {}
    set g_sessions(2) {}
    set g_sessions(3) {}
    set g_sessions(4) {}

    set g_months { Xmas Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec }
    set g_rs232PortList { A 1 B 2 C 3 D 4 }

    set g_shmemXACPT { enabled assertXACPT normal clearXACPT }
    
    set g_e3Loopback { none e3NoLoop cell e3CellLoop \
            diag e3DiagLoop payload e3PayloadLoop \
            line e3LineLoop other e3OtherLoop }

    set g_scrambling { on scrambling off noScrambling }
    set g_descrambling { on descrambling off noDescrambling }
    
    set g_e3Timing { network rxTiming internal localTiming }
    set g_e3LineType { hcs e3Framed plcp e3Plcp }

    set g_ds3Loopback { none ds3NoLoop cell ds3CellLoop \
            diag ds3DiagLoop payload ds3PayloadLoop \
            line ds3LineLoop other ds3OtherLoop }

    set g_ds3Timing { network rxTiming internal localTiming }
    set g_ds3LineType { cbit ds3CbitParity cchannel ds3ClearChannel }
    set g_ds3LineTypeFraming { hcs ds3Hcs plcp ds3Plcp }

    set g_ds1Loopback { none ds1NoLoop line ds1LineLoop \
            diag ds1DiagLoop payload ds1PayloadLoop }
    set g_ds1Timing { network rxTiming internal localTiming }
    set g_ds1LineType { other ds1Other ESF ds1ESF D4 ds1D4 } 
    set g_ds1LineTypeFraming { other other hcs ds1Hcs plcp ds1Plcp }
    set g_ds1LineLength { Lt110 ds1LineLt110 110-220 ds1Line110-220 \
            220-330 e1Line220-330 330-440 e1Line330-440 \
            440-550 ds1Line440-550 550-660 ds1Line550-660 \
            Gt655 ds1LineGt655 }

    set g_e1Loopback { none e1NoLoop line e1LineLoop \
            diag e1DiagLoop payload e1PayloadLoop }
    set g_e1Timing { network rxTiming internal localTiming }
    set g_e1LineType { other e1Other NoCRC e1NoCRC \
            CRC e1CRC MF e1MF CRCMF e1CRCMF }
    set g_e1LineTypeFraming { other other hcs e1Hcs plcp e1Plcp }
    set g_e1LineLength { Lt110 e1LineLt110 110-220 e1Line110-220 \
            220-330 e1Line220-330 330-440 e1Line330-440 \
            440-550 e1Line440-550 550-660 e1Line550-660 \
            G703-75 e1LineG703-75 G703-120 e1LineG703-120 }

    set g_j2LineLength { short j2ShortLine long j2LongLine}
    set g_j2Loopback { none j2NoLoop line j2LineLoop diag j2DiagLoop }
    set g_j2Timing { network rxTiming internal localTiming }

    set g_sonetLoopback { none sonetNoLoop diag sonetDiagLoop line sonetLineLoop}
    set g_sonetTiming { network rxTiming internal localTiming }
    set g_sonetLineType { SMLR sonetOther SMSR sonetSingleModeShortRange \
            SMIR sonetSingleModeMediumRange MM sonetMultiMode \
            UTP sonetUTP coax sonetCoax }
    set g_sonetLineTypeFraming { sonet atmSONET sdh atmSDH }

    set g_taxiLoopback { none noLoopback diag loopback }
    
    set g_e3StatVars { \
            framing { -e3FramingBoard -e3FramingModule -e3FramingPort } \
            plcp { -e3PlcpBoard -e3PlcpModule -e3PlcpPort } \
            atm { -e3AtmBoard -e3AtmModule -e3AtmPort } }

    set g_ds3StatVars { \
            framing { -ds3FramingBoard -ds3FramingModule -ds3FramingPort } \
            plcp { -ds3PlcpBoard -ds3PlcpModule -ds3PlcpPort } \
            atm { -ds3AtmBoard -ds3AtmModule -ds3AtmPort } }

    set g_ds1StatVars { \
            framing { -ds1FramingBoard -ds1FramingModule -ds1FramingPort } \
            plcp { -ds1PlcpBoard -ds1PlcpModule -ds1PlcpPort } \
            atm { -ds1AtmBoard -ds1AtmModule -ds1AtmPort } }
    
    set g_e1StatVars { \
            framing { -e1FramingBoard -e1FramingModule -e1FramingPort } \
            plcp { -e1PlcpBoard -e1PlcpModule -e1PlcpPort } \
            atm { -e1AtmBoard -e1AtmModule -e1AtmPort } }
    
    set g_j2StatVars { \
	    error { -j2ErrorBoard -j2ErrorModule -j2ErrorPort } \
            atm { -j2AtmBoard -j2AtmModule -j2AtmPort } }

    set g_sonetStatVars { \
            section { -sonetSectionBoard -sonetSectionModule -sonetSectionPort } \
            line { -sonetLineBoard -sonetLineModule -sonetLinePort } \
            path { -sonetPathBoard -sonetPathModule -sonetPathPort } \
            atm { -sonetAtmBoard -sonetAtmModule -sonetAtmPort } }

    set g_taxiPortModels { model-4B5B-100 model-4B5B-140 model-6port-4B5B-100 \
        model-TAXI-100 model-TAXI-140 model-6port-TAXI-100 }

    set g_ipStats { \
            -ipInReceives -ipInHdrErrors -ipInAddrErrors -ipForwDatagrams \
            -ipInUnknownProtos -ipInDiscards -ipInDelivers -ipOutRequests \
            -ipOutDiscards -ipOutNoRoutes -ipReasmReqds -ipReasmOKs \
            -ipReasmFails -ipFragOKs -ipFragFails -ipFragCreates }

    set g_icmpStats {}

    set g_tcpStats { -tcpActiveOpens -tcpPassiveOpens -tcpAttemptFails \
            -tcpEstabResets -tcpCurrEstab -tcpInSegs -tcpOutSegs \
            -tcpRetransSegs }

    set g_udpStats { -udpInDatagrams -udpNoPorts -udpInErrors -udpOutDatagrams}

    set g_snmpStats {}


    set g_ifStats { -ifInOctets -ifInUcastPkts -ifInNUcastPkts -ifInDiscards \
            -ifInErrors -ifInUnknownProtos -ifOutOctets -ifOutUcastPkts \
            -ifOutNUcastPkts -ifOutDiscards -ifOutErrors -ifOutQLen }
    
    set g_prompt {}
    set g_curhost {}
    set g_switch_type {}
    set g_expanded_cmd {}
    set g_unique_cmds {}
    set g_ambig_cmds {}

    set g_debug off

    set g_generalinfo \
        "General commands:\n \
        '?' to get list of commands at the current level\n \
        'up' to go up one menu level\n \
        'top' to go to the root menu\n \
        'exit' to leave AMI\n"

    # The menu tree structure is:
    #
    # { submenu-name "description" { menu } { menu } ... }
    #
    # The menu leaf node format is:
    #
    # { command-name @ "description" "arg-list" "parse-specs" "implementor" }
    # 
    # To hide a submenu, set submenu help message to "&"
    # To hide a command, set "@" to "@&"
    #

    set g_shortmenus { root "root menu"
        { about @ "Display program information" "" "" "about" }
        { exit @ "Exit AMI" "" "" "set g_exit 1" }
        { help @ "Display help for each command" 
            "[<subject>]" "[%s]" "describeCommands $g_menu $g_prompt %1" 
        }
        { history @ "Display command history" "" "" "puts [history]" }
        { open @ "Open a connection" "<switch> [<community>]" 
                 "%s [%s]" "set g_curhost [ openSession %1 %2 ]" 
        }
        { ping @ "Ping a host or switch" "<IP-address>" "%s" 
        	"puts \"\[ping %1\]\"" 
        }
        { redo @ "Repeat a history command" "[<command-number>]" "[%d]"
            "history event %1"
        }
        { rows @ "Get/set number of rows" 
            "[<rows>]" "[%d]" "terminalRows %1"
        }
        { top @ "Go to the root menu" "" "" "set g_prompt {}" }
        { up @ "Go up 1 menu level" "" "" "upOneLevel" }
    }

    set g_fullmenus { root "root menu"
        { about @ "Display program information" "" "" "about" }
        { close @ "Close this connection" "" "" 
                  "set g_curhost [ closeSession $g_curhost ]" 
        }

        { configuration "System configuration submenu" 
            { alarms "Alarm configuration submenu"
        	{ show @ "Display alarm configuration"
        	  "" "" "configureAlarmShow"
    		}
                { enable @ "enable an alarm" "(major | minor) <alarm type>"
                  "major|minor %s" "configureAlarmSet %1 %2 enabled"
                }
                { disable @ "disable an alarm" "(major | minor) <alarm type>"
                  "major|minor %s" "configureAlarmSet %1 %2 disabled"
                }
            }
            { atmarp "ATM ARP configuration submenu" 
                { arpserver "ATM ARP server submenu"
                    { show @ "Display ATM ARP server address"
            		"[<interface>]" "[%s]" "atmarpserverShow %1"
                    }
                    { set @ "Set ATM ARP server address"
            		"<NSAPaddress> [<interface>]" 
            		"%s [%s]" "atmarpserverSet %1 %2"
                    }
                }
                { delete @ "Delete an ARP entry" 
                    "<host>" "%s" "atmarpDeleteAny %1" 
                }
                { flush @ "Flush the ATM ARP cache" "" "" "atmarpFlush" }
                { getnsap @ "Get my NSAP address" "[<interface>]"
                    "[%s]" "atmarpMynsap %1"
                }
                { mapnsap @ "Set NSAP to IP address mapping"
                    "<host> <NSAPaddress> [<interface>]"
                    "%s %s [%s]" "atmarpMapnsap_ip %1 %2 %3"
                }
                { newclassicalip @ "Create a new classical IP PVC ARP entry"
                    "<host> <vpi> <vci> [<interface>]" "%s %d %d [%s]" 
                    "atmarpNewClassical %1 %2 %3 %4"
                }
                { newforeip @ "Create a FORE IP PVC ARP entry"
                    "<host> <vpi> <vci> (4 | 5) [<interface>]" 
                    "%s %d %d 4|5 [%s]" 
                    "atmarpNewPVC %1 %2 %3 %4 %5" 
                }
                { show @ "Show ATM ARP entries" "" "" "atmarpShow" }
            }
            { board "Board configuration submenu"
                { cdvt @ "Set board CDV tolerance" "<board> <cdvt>" 
                    "%d %d" 
                    "setCDVTOrPolicing swboard \[switchBoardNumber %1 \] -swBoardCDV %2" 
                }
                { policing @ "Set board policing action" 
                        "<board> (tag | drop)" "%d tag|drop" 
                        "setCDVTOrPolicing swboard \[switchBoardNumber %1 \] -swBoardPolicingAction %2" 
                }
                { prefix @ "Set the default NSAP prefix" "<board> <prefix>"
                        "%d %s" "setDefaultPrefix swboard \[switchBoardNumber %1 \] -swBoardNsapPrefix %2"
                }
                     
                { show @ "Display board configuration" 
                        "[<board>]" "[%d]" "configureBoardShow %1" 
                }
                { topology @ "Display board routing table" 
                        "[<board>]" "[%d]" "configureBoardTopology %1" 
                }
            }
            { ip "IP configuraion submenu" 
                { address @ "Set ip address for interface" 
                    "<interface> <address>" "%s %s" "configureIpAddress %1 %2" 
                }
                { admin @ "Force the interface up/down" 
                    "<interface> (up | down)" "%s up|down" 
                                        "configureIpAdmin %1 %2" 
                }
                { broadcast @ "Set broadcast address for interface" 
                    "<interface> (0 | 1)" "%s 0|1" 
                        "configureIpBroadcast %1 %2" 
                }
                { forwarding @ "Set ip forwarding" "(on | off)" 
                    "on|off" "configureIpForwarding %1" 
                }
                { mask @ "Set subnet mask for interface" 
                    "<interface> <mask>" "%s %s" "configureIpMask %1 %2" 
                }
                { route "IP routing configuration submenu"
                    { new @ "Create a new route" 
                         "(default | <destination-ipaddress>) <gateway> [<metric>]" 
                         "%s %s [%d]" "configureIpRouteAdd %1 %2 %3" 
                    }
                    { delete @ "delete a route" 
                         "(default | <destination-ipaddress>) <gateway>" 
                         "%s %s" "configureIpRouteDelete %1 %2" 
                    }
                    { show @ "Display routing infomation" 
                         "" "" "configureIpRouteShow" 
                    }
                }
                { show @ "Display ip configuration" 
                    "[<interface>]" "[%s]" "configureIpShow %1" 
                }
            }
            { module "Network module configuration submenu" 
                { show @ "Display network module configuration"
                    "[<module>]" "[%s]" "configureModuleShow %1" 
	        }
                { timing "Network module timing configuration submenu"
                    { show @ "Display network module timing configuration"
                        "[<module>]" "[%s]" "configureNetmodTimingShow %1"
		    }
                    { internalclock @ "Configure module timing source"
                        "<module> (export | import)"
                        "%s export|import"
                        "configureNetmodTimingInternalClock %1 %2"
		    }
                    { exportclock @ "Configure module exported timing source"
                        "<module> (primary | secondary) (<module-port#> | crystal)"
                        "%s primary|secondary %s"
                        "configureNetmodTimingExportClock %1 %2 %3"
		    }
                    { importclock @ "Configure module imported timing source"
                        "<module> (primary | secondary) (A | B | C | D)"
                        "%s primary|secondary %s"
                        "configureNetmodTimingImportClock %1 %2 %3"
		    }
		}
                { traffic "Network module traffic management submenu"
                    { epd @ "Set value for AAL5 packet drop" 
                        "<module> <number of cells>" "%s %d" 
                        "configureShmemPacketdrop %1 %2"
                    }
                    { models @ "Display predefined memory models" 
                        "" "" "configureShmemModels" 
                    }
                    { setmodel @ "Set the memory model for this module" 
                        "<module> <model>" "%s %d" 
                        "configureShmemSetModel %1 %2"
                    }
                    { show @ "Display shared memory module configuration"
                	"[<module>]" "[%s]" "configureShmemShow %1"
            	    }
                    { fifoblock @ "Set FIFO blocking when queues are full"
                        "<module> (normal | enabled)" "%s normal|enabled"
                        "configureShmemXACPT %1 [convertUserConst %2 $g_shmemXACPT]"
                    }
                }
            }

            { nsap "Configure NSAP static routes and prefixes"
                { route "Manage NSAP static routes"
                    { delete @ "Remove an NSAP static route" "<NSAP> <mask> <port> <vpi>"
                        "%s %d %s %d" "configureNsapAddressDelete %1 %2 %3 %4"
                    }
                    { new @ "create an NSAP static route" 
                        "<NSAP> <mask> <port> <vpi> [-cost <cost>] [-cbr_cap <cbr_cap>] [-vbr_cap <vbr_cap>] [abr] [epd]"
                        "%s %d %s %d [-cost %d] [-cbr_cap %d] [-vbr_cap %d]  [%s] [%s]" 
                           "configureNsapAddressAdd %1 %2 %3 %4 %5 %6 %7 %8 %9"
                    }
                    { show @ "Display NSAP static route table" "[<NSAP> [<mask>]]"
                        "[%s] [%d]" "configureNsapAddressShow %1 %2"
                    }
                }
                { prefix "Configure NSAP prefixes" 
                    { delete @ "Delete an NSAP prefix" "<port> <vpi> <prefix>"
                        "%s %d %s" "configureNsapPrefixDelete %1 %2 %3"
                    }
                    { new @ "Create an NSAP prefix" "<port> <vpi> <prefix>"
                        "%s %d %s" "configureNsapPrefixAdd %1 %2 %3"
                    }
                    { show @ "Display NSAP prefixes" "[<port> [<vpi> [<prefix>]]]"
                        "[%s] [%d] [%s]" "configureNsapPrefixShow %1 %2 %3"
                    }
                }
            }
            { port "Port configuration submenu"
                { e1 "E1 module configuration submenu"
                    { emptycells @ "Set idle/unassigned cells" 
                        "<port> (idle | unassigned)" "%s idle|unassigned" 
                        "configureHardwarePort e1 %1 -e1IdleUnassignedCells %2"
                    }
                    { length @ "Set line length"
                        "<port> (Lt110 | 110-220 | 220-330 | 330-440 | 440-550 | 550-660 | G703-75 | G703-120)"
                        "%s Lt110|110-220|220-330|330-440|440-550|550-660|G703-75|G703-120"
                        "configureHardwarePort e1 %1 -e1LineLength [convertUserConst %2 $g_e1LineLength]"
                    }
                    { loopback @ "Set loopback" 
                        "<port> (line | payload | diag | none)"
                        "%s line|payload|diag|none"
                        "configureHardwarePort e1 %1 -e1LoopbackConfig [convertUserConst %2 $g_e1Loopback]" 

                    }
                    { mode @ "Set operating mode" 
                        "<port> (plcp | hcs)" "%s plcp|hcs" 
                        "configureHardwarePort e1 %1 -e1LineTypeFraming [convertUserConst %2 $g_e1LineTypeFraming]" 
                    }
                    { show @ "Display E1 configuration" 
                        "[<port>]" "[%s]" "configurePortE1Show %1" 
                    }
                    { timing @ "Set timing" 
                        "<port> (network | internal)" 
                        "%s network|internal"
                        "configureHardwarePort e1 %1 -e1TxClockSource [convertUserConst %2 $g_e1Timing]" 
                    }
                }
                { e3 "E3 module configuration submenu"
                    { emptycells @ "Set idle/unassigned cells" 
                        "<port> (idle | unassigned)" "%s idle|unassigned" 
                        "configureHardwarePort e3 %1 -e3IdleUnassignedCells %2"
                    }
                    { loopback @ "Set loopback" 
                        "<port> (cell | payload | diag | line | none)"
                        "%s cell|payload|diag|line|none"
                        "configureHardwarePort e3 %1 -e3LoopbackConfig [convertUserConst %2 $g_e3Loopback]" 
                    }
                    { mode @ "Set operating mode" 
                        "<port> (plcp | hcs)" "%s plcp|hcs" 
                        "configureHardwarePort e3 %1 -e3LineType [convertUserConst %2 $g_e3LineType]" 
                    }
                    { scrambling @ "Set scrambling" 
                        "<port> (on | off)" "%s on|off" 
                        "configureHardwarePortScrambling e3 %1 %2"
                    }
                    { show @ "Display E3 configuration" 
                        "[<port>]" "[%s]" "configurePortE3Show %1" 
                    }
                    { timing @ "Set timing" 
                        "<port> (network | internal)"
                        "%s network|internal" 
                        "configureHardwarePort e3 %1 -e3TxClockSource [convertUserConst %2 $g_e3Timing]" 
                    }
                }
                { ds1 "DS1 module configuration submenu"
                    { emptycells @ "Set idle/unassigned cells" 
                        "<port> (idle | unassigned)" "%s idle|unassigned)" 
                        "configureHardwarePort ds1 %1 -ds1IdleUnassignedCells %2"
                    }
                    { length @ "Set line length"
                        "<port> (Lt110 | 110-220 | 220-330 | 330-440 | 440-550 | 550-660 | Gt655)"
                        "%s Lt110|110-220|220-330|330-440|440-550|550-660|Gt655"
                        "configureHardwarePort ds1 %1 -ds1LineLength [convertUserConst %2 $g_ds1LineLength]"
                    }
                    { loopback @ "Set loopback" 
                        "<port> (line | payload | diag | none)"
                        "%s line|payload|diag|none"
                        "configureHardwarePort ds1 %1 -ds1LoopbackConfig [convertUserConst %2 $g_ds1Loopback]" 

                    }
                    { mode @ "Set operating mode" 
                        "<port> (plcp | hcs)" "%s plcp|hcs" 
                        "configureHardwarePort ds1 %1 -ds1LineTypeFraming [convertUserConst %2 $g_ds1LineTypeFraming]" 
                    }
                    { show @ "Display DS1 configuration" 
                        "[<port>]" "[%s]" "configurePortDS1Show %1" 
                    }
                    { timing @ "Set timing" 
                        "<port> (network | internal)"
                        "%s network|internal"
                        "configureHardwarePort ds1 %1 -ds1TxClockSource [convertUserConst %2 $g_ds1Timing]" 
                    }
                }
                { ds3 "DS3 module configuration submenu"
                    { emptycells @ "Set idle/unassigned cells" 
                        "<port> (idle | unassigned)" "%s idle|unassigned" 
                        "configureHardwarePort ds3 %1 -ds3IdleUnassignedCells %2"
                    }
                    { framing @ "Set framing" 
                        "<port> (cchannel | cbit)"
                        "%s cchannel|cbit"
                        "configureHardwarePort ds3 %1 -ds3LineType [convertUserConst %2 $g_ds3LineType]" 
                    }
                    { loopback @ "Set loopback" 
                        "<port> (cell | payload | diag | line | none)" 
                        "%s cell|payload|diag|line|none"
                        "configureHardwarePort ds3 %1 -ds3LoopbackConfig [convertUserConst %2 $g_ds3Loopback]" 

                    }
                    { mode @ "Set operating mode"
                        "<port> (plcp | hcs)" "%s plcp|hcs"
                        "configureHardwarePort ds3 %1 -ds3LineTypeFraming [convertUserConst %2 $g_ds3LineTypeFraming]" 
                    }
                    { scrambling @ "Set scrambling"
                        "<port> (on | off)" "%s on|off" 
                        "configureHardwarePortScrambling ds3 %1 %2"
                    }
                    { show @ "Display DS3 configuration" 
                        "[<port>]" "[%s]" "configurePortDS3Show %1" 
                    }
                    { timing @ "Set timing" 
                        "<port> (network | internal)"
                        "%s network|internal"
                        "configureHardwarePort ds3 %1 -ds3TxClockSource [convertUserConst %2 $g_ds3Timing]" 
                    }
                }
                { j2 "J2 module configuration submenu"
                    { line @ "Set line length" 
                        "<port> (short | long)"
                        "%s short|long"
                        "configureHardwarePort j2 %1 -j2LineLength [convertUserConst %2 $g_j2LineLength]" 

                    }
                    { loopback @ "Set loopback" 
                        "<port> (line | diag | none)"
                        "%s line|diag|none"
                        "configureHardwarePort j2 %1 -j2LoopbackConfig [convertUserConst %2 $g_j2Loopback]" 

                    }
                    { show @ "Display J2 configuration" 
                        "[<port>]" "[%s]" "configurePortJ2Show %1" 
                    }
                    { timing @ "Set timing" 
                        "<port> (network | internal)"
                        "%s network|internal"
                        "configureHardwarePort j2 %1 -j2TxClockSource [convertUserConst %2 $g_j2Timing]" 
                    }
                }
                { sonet "SONET module configuration submenu" 
                    { emptycells @ "Set idle/unassigned cells" 
                        "<port> (idle | unassigned)" "%s idle|unassigned" 
                        "configureHardwarePort sonet %1 -sonetIdleUnassignedCells %2"
                    }
                    { loopback @ "Set loopback" 
                        "<port> (line | diag | none)" "%s line|diag|none"
                        "configureHardwarePort sonet %1 -sonetLoopbackConfig [convertUserConst %2 $g_sonetLoopback]"
                    }
                    { mode @ "Set SONET mode"
                        "<port> (sonet | sdh)" "%s sonet|sdh" 
                        "configureHardwarePort sonet %1 -sonetFramingStandardOper [convertUserConst %2 $g_sonetLineTypeFraming]"
                    }
                    { show @ "Display SONET configuration" 
                        "[<port>]" "[%s]" "configurePortSONETShow %1" 
                    }
                    { timing @ "Set timing"
                        "<port> (network | internal)" 
                        "%s network|internal" 
                        "configureHardwarePort sonet %1 -sonetTxClockSource [convertUserConst %2 $g_sonetTiming]" 
                    }
                }
                { show @ "Display port configuration" 
                        "[<port>]" "[%s]" "configurePortShow %1" 
                }
                { taxi "TAXI module configuration submenu"
                    { loopback @ "Set loopback" 
                        "<port> (diag | none)" "%s diag|none"
                        "configureHardwarePort TAXI %1 -hwPortTAXILoopback [convertUserConst %2 $g_taxiLoopback]"
                    }
                    { show @ "Display TAXI configuration" 
                        "[<port>]" "[%s]" "configurePortTaxiShow %1" 
                    }
                }
                { traffic "Port level traffic management submenu"
                    { cdv @ "Set maximum CDV for CBR or VBR traffic"
                        "<port> (CBR | VBR) <CDV in microseconds>" 
                        "%s CBR|VBR %d" "configureShmemCDV %1 %2 %3"
                    }
                    { efci @ "Set EFCI threshold for ABR traffic"
                        "<port> (on | off) <threshold>" "%s on|off %d" 
                        "configureShmemEFCI %1 %2 %3"
                    }
                    { qsize @ "Set queue size for ABR and UBR traffic"
                        "<port> <number of cells>" "%s %d" 
                        "configureShmemQsize %1 %2"
                    }
                    { show @ "Display port traffic configuration"
                        "[<port>]" "[%s]" "configurePortTrafficShow %1"
                    }
                }
            }
            { rs232 "Serial port configuration submenu"
                { show @ "Display serial port configuration" 
                    "[(A | B)]" "[A|B]" "configRs232Show %1" 
        	}
                { speed @ "Set port speed" "(A | B) <speed>" 
                    "A|B %d" "configRs232Speed %1 %2" 
                }
            }
            { snmp "SNMP configuration submenu"
                { community @ "Set SNMP read/write communities" 
                    "(read | write) <community>" "read|write %s" 
                    "$g_curhost setcommunity %1 %2" 
                }
                { trap "Trap configuration submenu"
                        { delete @ "Remove a trap entry" 
                                "<trap>" "%d" "configureSnmpTrapDelete %1" 
                        }
                        { new @ "Create a trap entry" 
                                "<ipaddress>" "%s" "$g_curhost trap add %1" 
                        }
                        { show @ "Display trap configuration" 
                                 "" "" "configureSnmpTrapShow" 
                        }
                }
            }
            { spans "SPANS signalling configuration submenu"
                { delete @ "Remove SPANS signalling path" 
                    "<port> <vpi>" "%s %d" "configureSpansDelete %1 %2" 
                }
                { new @ "Create SPANS signalling path" 
                    "<port> <vpi> [-sig <vci>] [-cls <vci>] [-aal (4 | 5)] \n\t[-cdvt <cdvt>] [(tag | drop)]"
                    "%s %d [-sig %d] [-cls %d] [-aal %s] [-cdvt %d] [tag|drop]" 
                    "configureSpansNew %1 %2 %3 %4 %5 %6 %7" 
                }
                { show @ "Display SPANS signalling information" 
                    "[<port> [<vpi>]]" "[%s] [%s]" 
                    "configureSpansShow %1 %2" 
                }
            }
            { spvc "Smart PVC submenu"
                { delete @ "Remove a SPVC" 
		    "<Local SPVC ID> [source | destination | bidirectional] or\n\t<port> <vpi> <vci> <dest-session> <dest-port> <dest-vpi> <dest-vci> \\\n\t[(source | destination | bidirectional)]"
		    "%s [%d] [%d] [%s] [%s] [%d] [%d] [source|destination|bidirectional]" "configureSpvcDelete %1 %2 %3 %4 %5 %6 %7 %8" 
                }
                { new @ "Create a new SPVC" 
		    "<port> <vpi> <vci> <dest-session> <dest-port> <dest-vpi> <dest-vci> \\\n\t[-peak <Kb/sec>] [(source | destination | bidirectional)]" 
               "%s %d %d %s %s %d %d [-peak %d] [source|destination|bidirectional]" "configureSpvcNew %1 %2 %3 %4 %5 %6 %7 %8 %9" 
		}
                { show @ "Display SPVC configuration" 
		    "" "" "configureSpvcShow" 
		}
            }
            { switch "General switch configuration submenu"
                { cdvt @ "Set switch CDV tolerance" 
                        "<cdvt>" "%d" "setCDVTOrPolicing switch 0 -switchCDV %1" 
                } 
                { name @ "Set name for this switch" "<name>" "%s" 
                    "$g_curhost system set -sysName %1"
                }
                { policing @ "Set switch policing action" "(tag | drop)" 
                   "tag|drop" "setCDVTOrPolicing switch 0 -switchPolicingAction %1" 
                }
                { prefix @ "Set switch NSAP prefix" "<prefix>" "%s"
                     "setDefaultPrefix switch 0 -switchNsapPrefix %1" 
                }
                { show @ "Display switch configuration" "" "" 
                                        "configureSwitchShow" 
                }
            }
            { uni30 "UNI 3.0 signalling configuration submenu"
                { delete @ "Remove UNI 3.0 signalling path" 
                        "<port> <vpi>" "%s %d" "configureQ2931Delete %1 %2" 
                }
                { new @ "Create UNI 3.0 signalling path" 
                        "<port> <vpi> [-sig <vci>] [-aal (4 | 5)] \n\t[(user | network)] [-ilmi (up | down)] [(publicUNI | auto | IISP)]" 
                        "%s %d [-sig %d] [-aal %s] [user|network] [-ilmi up|down] [publicUNI|auto|iisp]" "configureQ2931New %1 %2 %3 %4 %5 %6 %7"
                }
                { show @ "Display UNI 3.0 signalling configuration" 
                        "[<port> [<vpi>]]" "[%s] [%d]" 
                                "configureQ2931Show %1 %2" 
                }
            }
            { vcc "Virtual channel configuration submenu" 
                { delete @ "Remove a virtual channel connection" 
                    "<iport> <ivpi> <ivci> <oport> <ovpi> <ovci>" 
                    "%s %d %d %s %d %d" "configureVccDelete %1 %2 %3 %4 %5 %6" 
                }
                { modify @ "Modify existing virtual channel parameters"
                    "<port> <vpi> <vci> -peak <peak>"
                    "%s %d %d -peak %d" "configureVccModify %1 %2 %3 %4"
                }
                { new @ "Create a new virtual channel connection" 
                    "<iport> <ivpi> <ivci> <oport> <ovpi> <ovci> [-peak <peak>]\n\t[-cdvt <cdvt>]" 
                    "%s %d %d %s %d %d [-peak %d] [-sustained %d] [-burst %d] [-cdvt %d]" 
                    "configureVccNew %1 %2 %3 %4 %5 %6 %7 %8 %9 %10" 
                }
                { show @ "Display channel information" 
                    "[<port> [<vpi> [<vci>]]]" "[%s] [%d] [%d]" 
                    "configureVccShow %1 %2 %3"
                }
            }
            { vpc "Virtual path configuration submenu"
                { delete @ "Remove a virtual path connection"
                    "<port> <vpi> (<port> <vpi> | term | orig)" 
                    "%s %d [%s] [%d] [term|orig]" 
                    "configureVpcDelete %1 %2 %3 %4 %5" 
                }
                { modify @ "Modify existing virtual path parameters"
                    "<port> <vpi> (term | orig) -peak <peak>"
                    "%s %d term|orig -peak %d" "configureVpcModify %1 %2 %3 %4"
                }
                { new @ "Create a virtual path connection"
                    "<port> <vpi> (<oport> <ovpi> | term | orig) [-peak <peak>] \n\t[-maxvci <maxvci>]" 
                    "%s %d [%s] [%d] [-maxvci %d] [-peak %d] [-sustained %d] [-burst %d] [term|orig]" 
                    "configureVpcNew %1 %2 %3 %4 %5 %6 %7 %8 %9" 
                }
                { show @ "Display path information" 
                    "[<port> [<vpi>]]" "[%s] [%d]" "configureVpcShow %1 %2" 
                }
            }
        }

        { exit @ "Exit AMI" "" "" "set g_exit 1" }
        { help @ "Display help for each command" 
            "[<subject>]" "[%s]" "describeCommands $g_menu $g_prompt %1" 
        }
        { history @ "Display command history" "" "" "puts [history]" }
        { open @ "Open a connection" "<switch> [<community>]" 
                 "%s [%s]" "set g_curhost [ openSession %1 %2 ]" 
        }

        { operation "Switch operation submenu"
            { cdb "CDB Administration submenu"
                { backup @ "Backup the configuration database" 
                        "[<host>:]<full path to backup file>" 
                        "%s" "operBackupCDB %1" 
                }
                { init @ "Initialize the CDB" "" "" "operCDBInit" }
                { reset @ "Reset the configuration database" 
                    "" "" "operResetCDB" 
                }
                { restore @ "Restore the configuration database" 
                    "[<host>:]<full path to backup file>" 
                    "%s" "operRestoreCDB %1" 
                }
            }
            { environment "Switch environment information"
                { cpu @ "Display CPU information"
            	  "" "" "operEnvironmentCPU"
	        }
		{ fabric "Fabric submenu"
  		    { show @ "Show environmental status for all fabrics"
	                "" "" "operEnvironmentFabricShow"
	            }
		    { temperature @ "Set fabric alarm/trap temperature thresholds"
		        "<reset threshold> <trip threshold>"
		        "%d %d" "operEnvironmentFabricTempThresholds %1 %2"
		    }
		}
                { fans @ "Display fan banks information"
            	  "" "" "operEnvironmentFans"
	        }
                { power @ "Display power supply information"
            	  "" "" "operEnvironmentPower"
	        }
                { temperature @ "Display temperature sensors information"
            	  "" "" "operEnvironmentTemperature"
	        }
            }
            { panic "Panic acknowledgement"
                { clear @ "Clear the panic flag without viewing the dump"
                        "" "" "operPanicClear"
                }
                { show @ "Display the panic dump without clearing the flag"
                        "" "" "operPanicShow"
                }
                { dump @ "Upload panic info to a host and clear the panic flag"
                    "<host>:<full path to backup file>" 
                    "%s" "operPanicDump %1" 
                }
            }
            { trace &
                { dump @ "Dump trace to a file"
                      "<log> <host>:<full path to file>" 
                      "%s %s" "operTraceDump %1 %2" 
                }
                { show @ "Show state of logs and groups" "" 
                         "" "operTraceShow" }
                { size @ "Set size of log" 
                       "<log name> <new size>"
                       "%s %d" "operTraceSize %1 %2"
                }
                { enable @ "Enable logging for a group" 
                           "<group name>" 
                           "%s" "operTraceEnable %1 1" 
                }
                { disable @ "Disable logging for a group" 
                           "<group name>" 
                           "%s" "operTraceEnable %1 0" 
                }
            }
            { date @ "Get/set system date & time" 
                "[<mm>/<dd>/<yyyy> <hh>:<mm>:<ss>> [(+|-)<hh>:<mm>]]" 
                "[%s] [%s] [%s]" "operDateSet %1 %2 %3"
            }
            { flash "Flash file system submenu"
                { copy @ "Copy a file" "<from> <to>" "%s %s" 
                    "operFlashCopy %1 %2" }
                { delete @ "Delete a file" "<file>" "%s" "operFlashDelete %1" }
                { dir @ "Display directory listing" "[<file>]" "[%s]" 
                    "operFlashDir %1" }
                { free @ "Show amount of free space" "" "" "operFlashFree" }
                { get @ "Get a file from remote host" 
                    "<host>:<remotefile> <localfile>" 
                    "%s %s" "operFlashGet %1 %2" 
                }
                { init @ "Format the flash file system" "" "" 
                    "operFlashFormat" }
                { put @ "Put a file on the remote host" 
                    "<localfile> <host>:<remotefile>" "%s %s" 
                    "operFlashPut %1 %2" 
                }
                { rename @ "Rename a file" "<from> <to>" "%s %s" 
                    "operFlashRename %1 %2" }
            }
            { halt @ "Halt the switch" "" "" "operHaltSwitch" }
            { log "System log submenu"
                { clear @ "Clear the message log" "" "" "operLogClear" }
                { show @ "Display log information" 
                    "[(INFO | NOTICE | WARNING | ERROR)] [mmdd[hhmm]]" 
                    "[INFO|NOTICE|WARNING|ERROR] [%s]" "operLogShow %1 %2" 
                }
            }
            { password @ "Change administrative password" 
                "" "" "operPassword" 
            }
            { rpc "RPC access level menu"
            	{ show @ "Show the RPC access level"
                    "" "[NULLARGUMENT1]" "rpcAccess %1"
	        }
                { set @ "Set the RPC access level"
                    "[(read | write | none)]" "read|write|none" "rpcAccess %1"
                }
            }
            { test @ "Test switch board" "<board-number>" "%d" "operBoardTest %1" }
            { upgrade @ "Upgrade the switch software" 
            	"<remotehost>:<full path to remotefile>" 
                "%s" "operUpgrade %1" 
            }
	    { version @ "Show/set the version of the switch software"
                "[<new-version>]" "[%s]" "operVersion %1"
	    }
            { reboot @ "Reboot the switch" "" "[%s]" "operRebootSwitch %1" }
        }

        { ping @ "Ping a host or switch" "<IP-address>" "%s" 
        	"puts \"\[ping %1\]\"" 
        }
        { redo @ "Repeat a history command" "[<command-number>]" "[%d]"
            "history event %1"
        }
        { rows @ "Get/set number of rows" 
            "[<rows>]" "[%d]" "terminalRows %1"
        }

        { statistics "Switch statistics submenu" 
            { aal0 @ "Display AAL0 layer statistics" 
                "[<interface>]" "[%s]" "getAtmStats aal0 %1"
    	    }
            { aal4 @ "Display AAL4 layer statistics" 
                "[<interface>]" "[%s]" "getAtmStats aal4 %1"
    	    }
            { aal5 @ "Display AAL5 layer statistics" 
                "[<interface>]" "[%s]" "getAtmStats aal5 %1"
    	    }
            { atm @ "Display ATM layer statistics" 
                "[<interface>]" "[%s]" "getAtmStats atm %1"
    	    }
            { board @ "Display switch board statistics" 
                "[<board>]" "[%d]" "getBoardStats %1" 
	    }
            { ctlport @ "Display control port statistics" 
                "[<interface>]" "[%s]" "getAtmStats physical %1"
    	    }
            { ds1 @ "Display DS1 port statistics" 
                "[<port>]" "[%s]" "getHardPortStats %1 ds1 $g_ds1StatVars" 
            }
            { ds3 @ "Display DS3 port statistics" 
                "[<port>]" "[%s]" "getHardPortStats %1 ds3 $g_ds3StatVars" 
            }
            { e3 @ "Display E3 port statistics" 
                "[<port>]" "[%s]" "getHardPortStats %1 e3 $g_e3StatVars" 
            }
            { e1 @ "Display E1 port statistics" 
                "[<port>]" "[%s]" "getHardPortStats %1 e1 $g_e1StatVars" 
            }
            { j2 @ "Display J2 port statistics" 
                "[<port>]" "[%s]" "getHardPortStats %1 j2 $g_j2StatVars" 
            }
            { icmp @ "Display ICMP statistics" "" "" 
                "getGeneralStats icmp $g_icmpStats" 
            }
            { interface @ "Display interface statistics" 
                "[<interface>]" "[%s]" "getIfStats %1 $g_ifStats" 
            }
            { ip @ "Display IP statistics" "" ""
                "getGeneralStats ip $g_ipStats"
            }
            { module @ "Display network module statistics" "[<module>]"
                "[%s]" "getNetmodStats %1"
            }
            { sonet @ "Display SONET port statistics" 
                "[<port>]" "[%s]" "getHardPortStats %1 sonet $g_sonetStatVars" 
            }
            { port @ "Display general port counters" 
                "[<port>]" "[%s]" "getPortStats %1"
            }
            { uni30 @ "Display UNI 3.0 signalling statistics" 
                "[<port> [<vpi>]]" "[%s] [%d]" 
                "getSoftPortStats q2931 %1 %2" 
            }
            { spans @ "Display SPANS signalling statistics" 
                "[<port> [<vpi>]]" "[%s] [%d]" 
                "getSoftPortStats sigstat %1 %2" 
            }
            { tcp @ "Display TCP statistics" "" "" 
                "getGeneralStats tcp $g_tcpStats" 
            }
            { udp @ "Display UDP statistics" "" "" 
                "getGeneralStats udp $g_udpStats" 
            }
            { vcc @ "Display virtual channel statistics" 
                "[<port> [<vpi> [<vci>]]]" "[%s] [%d] [%d]" 
                "getVccStats %1 %2 %3"
            }
            { vpc @ "Display virtual path statistics"
                "[<port> [<vpi>]]" "[%s] [%d]" "getVpcStats %1 %2" 
            }
        }

        { top @ "Go to the root menu" "" "" "set g_prompt {}" }
        { up @ "Go up 1 menu level" "" "" "upOneLevel" }

    }

    set g_hiddenmenus {
        { ".." @& "" "" "" "upOneLevel" } 
        { "!!" @& "" "[<command-number>]" "[%d]" "history event %1" } 
        { "quit" @& "" "" "" "set g_exit 1" } 
        { "debug" @& "" "" "" "setDebug" } 
        { "printmenus" @& "" "" "" "printMenuTree $g_fullmenus {}" } 
        { "echo" @& "" "" "" "set g_echo 1" } 
        { "tcl" @& "" "" "" "enterTCL" } 
        { "4444" @& "" "" "" "shipASX" } 
    }

    foreach item $g_hiddenmenus {
        lappend g_shortmenus $item
        lappend g_fullmenus  $item
    }
}


proc isHiddenCommand { type } {
    if { $type == "&" || $type == "@&" } {
        return 1
    }
    return 0
}

proc isCommand { type } {
    if { $type == "@" || $type == "@&" } {
        return 1
    }
    return 0
}

proc isSubmenu { type } {
    if { ![isCommand $type] } {
        return 1
    }
    return 0
}


proc initAMIputs {} {
    global g_term_rows g_line_count

    set g_line_count $g_term_rows
}


proc AMIpause {} {
    global g_term_rows g_line_count

    if { $g_term_rows > 0 } {
        puts -nonewline "\nPress return for more, q to quit: "
        gets stdin answer
        initAMIputs
        if { $answer == "q" || $answer == "Q" } { error "" }
        puts {}
    }
}


proc AMIputs { data } {
    global g_term_rows g_line_count

    if { $g_term_rows > 0 } {
        if { $g_line_count <= 0 } { AMIpause }
    }

    set newline [string first "\n" $data]
    if { $newline >= 0 } {
        AMIputs "[string range $data 0 [expr $newline - 1]]"
        AMIputs "[string range $data [expr $newline + 1] end]"
        return
    }

    incr g_line_count -1

    if { [string length $data] > 80 } {
        puts "[string range $data 0 79]"
        AMIputs "[string range $data 80 end]"
    } else {
        puts "$data"
    }
}



############################################################
#
# sparcSwitch: return TRUE if this is a sparc switch
#
proc sparcSwitch {} {
    global g_curhost g_switch_type

    if { [compiledWSCP] } {
        # 
        # if WSCP is compiled in this version, then we must be running
        # on a cheetah processor
        return 0
    }

    if { [lsearch { asx100 asx200 asx200bxa } $g_switch_type] >= 0 } {
        #
        # old generation switches
        #
        return 1
    }

    if { $g_curhost == "localhost" } {
        #
        # This is none of the above, since it is running on localhost
        # then must be an sparc switch with a dead switch control software
        # unless this machine's name is really "localhost"
        #
        return 1
    }

    return 0
}


############################################################
#
# runningOnSwitch: check to see if we are running on switch
#
proc runningOnSwitch {} {
    global g_curhost
    if { $g_curhost == "localhost"} { return 1 }

    puts "\nThis command is only available on the local switch"
    return 0
}


############################################################
#
# yesorno: get yes or no from user
#
#
proc yesorno { prompt default } {
    while { 1 } { 
        puts -nonewline "\n$prompt \[$default\]? "

        if { [gets stdin answer] < 0 } { return 0 }
        if { $answer == ""  } { set answer $default }
        if { $answer == "y" } { return 1 }
        if { $answer == "n" } { return 0 }
    }
    return 0
}



############################################################
#
# scanUinqueCommands: cache the unique commands for faster lookup
#
#
proc scanUniqueCommands { menutree flag fullcmd } {
    global g_unique_cmds g_unique_fullcmd g_ambig_cmds

    if { $flag == "init" } { 
        set g_unique_cmds {}
        set g_unique_fullcmd {}
    }

    set menutree [lrange $menutree 2 end]

    foreach menu $menutree {
        set cmd [lindex $menu 0]
        set cmdindex [lsearch $g_unique_cmds $cmd] 
        if { $cmdindex >= 0 } {
            set cmdindex [expr $cmdindex + 1]
            set count [expr [lindex $g_unique_cmds $cmdindex] + 1]
            set g_unique_cmds \
                    [lreplace $g_unique_cmds $cmdindex $cmdindex $count]
        } else {
            set g_unique_cmds [concat $g_unique_cmds $cmd 1]
            set g_unique_fullcmd \
                    [lappend g_unique_fullcmd [concat $fullcmd]]
        }

        #
        # This is commented so we only scan the top level menu, not submenus
        #
#       if { [lindex $menu 1] != "@" } { 
#           scanUniqueCommands $menu "loop" [concat $fullcmd $cmd]
#       }
    }

    if { $flag != "init" } { return }

    set cmdindex [expr [llength $g_unique_cmds] - 1]
    set unique_cmds {}
    set ambig_cmds {}
    while { $cmdindex > 0 } {
        if { [lindex $g_unique_cmds $cmdindex] == 1 } {
            set unique_cmds [concat \
                    $unique_cmds [lindex $g_unique_cmds [expr $cmdindex - 1]]]
            set unique_cmds [lappend unique_cmds \
                    [lindex $g_unique_fullcmd [expr $cmdindex / 2]]]
        } else {
            set g_ambig_cmds [concat \
                    $g_ambig_cmds [lindex $g_unique_cmds [expr $cmdindex - 1]]]
        }
        set cmdindex [expr $cmdindex - 2]
    }

    set g_unique_cmds $unique_cmds
}

############################################################
#
# getMenuPosition: return the sublist this command tree is pointing to
#
#       menutree - is the protion of menu tree to search
#       cmd      - is the command list to serach for
#
#       This function returns the list conatining this command
#       or an empty list if the command is not found
#
#
proc getMenuPosition { menutree cmd } {
    foreach thiscmd $cmd {
        set thiscmd [string tolower $thiscmd]
        set found 0
        set menutree [lrange $menutree 2 end]
        foreach thismenu $menutree {
            if { [lindex $thismenu 0] == $thiscmd } {
                set found 1
                break
            }
        }
        if { $found == 0 } {
            return {}
        }
        set menutree $thismenu
    }
    return $menutree
}



############################################################
# 
# listCommands: list the commands for the given tree
#
#       menutree - is the protion of the tree in the current context
#       cmd      - is the user command to display the help for
#
#
proc listCommands { menutree cmd } {
    set menutree [lrange [getMenuPosition $menutree $cmd] 2 end]

    set per_line 4
    foreach thiscmd $menutree {
        set cmd_name [lindex $thiscmd 0]
        set cmd_type [lindex $thiscmd 1]
        if { [isHiddenCommand $cmd_type] } { continue }
        if { [isSubmenu $cmd_type] } {
            set cmd_name "$cmd_name>"
        }
        puts -nonewline "[format "  %-15s" $cmd_name]"
        incr per_line -1
        if { $per_line <= 0 } {
            puts {}
            set per_line 4
        }
    }

    if { $per_line > 0 && $per_line < 4 } { puts {} }
}




############################################################
# 
# describeCommands: list the commands with their description 
#                   for the given tree
#
#       menutree - is the protion of the tree in the current context
#       cmd      - is the user command to display the help for
#       subcmd   - specific subcommand
#
#
proc describeCommands { menutree cmd subcmd } {
    global g_generalinfo g_cmd_table

    initAMIputs

    if { $subcmd == {} } {
        AMIputs "\n$g_generalinfo\n"
    }

    set menutree [getMenuPosition $menutree $cmd]

    if { $subcmd != {} } {
        set newtree [getMenuPosition $menutree $subcmd]
        if { $newtree != {} && [isSubmenu [lindex $newtree 1]] } { 
            set menutree $newtree 
            set cmd "$cmd $subcmd"
            set subcmd {}
            AMIputs {}
        }
    }

    set menutree [lrange $menutree 2 end]

    foreach thiscmd $menutree {
        set cmd_name [lindex $thiscmd 0]
        if { $subcmd != {} && $subcmd != $cmd_name } { continue }
        set cmd_type [lindex $thiscmd 1]
        if { [isHiddenCommand $cmd_type] } { continue }
        set thiscmd $g_cmd_table([makeIndex "$cmd $cmd_name"])
        if { [isSubmenu $cmd_type] } {
            set cmd_name "$cmd_name>"
            set description [lindex $thiscmd 1]
        } else {
            set description [lindex $thiscmd 2]
        }
        AMIputs "[format "  %-15s \t - %s" $cmd_name $description]"
        if { $subcmd != {} } { return }
    }
    if { $subcmd != {} } {
        EMSG "Invalid or ambiguous command"
    }
}



############################################################
#
# argumentHelp: display arguemnet format
#
# cmdlist - the command list to display help for
#
proc argumentHelp cmdlist {
    puts "usage: [lindex $cmdlist 0] [lindex $cmdlist 3]"
}



############################################################
#
# parseCommand: parse the given command with respect the current
#            position in the menu structure and return the
#            sublist associated with this command or return
#            an empty list if invalid command
#
#       menutree - is the protion of menu tree to search
#       curpos   - is the current position of the user within this menu tree
#       cmd      - is the users command
#
#
proc parseCommand { menutree curpos cmd } {
    global g_expanded_cmd g_cmd_matchcount
    set g_cmd_matchcount 0
    set menutree [getMenuPosition $menutree $curpos]
#   set foundcount 0
    set cmdpos 0
    foreach thiscmd $cmd {
        DEBUGSTR "parsing $thiscmd"
        if { $thiscmd == "?" } { break }
        set thiscmd [string tolower $thiscmd]
        if { [isCommand [lindex $menutree 1]] } { break }
        set menutree [lrange $menutree 2 end]
        set found 0
        set foundcount 0
        # match exactly the command against the menu
        foreach thismenu $menutree {
            if { [lindex $thismenu 0] == $thiscmd } {
                set found 1
                incr foundcount 1
                break
            }
        }
        if { $found == 0 } {
            DEBUGSTR "$thiscmd not found, try partial match"
            # try partial matching
            set matchcount 0
            set matchmenu {}
            foreach thismenu $menutree {
                if { [string match ${thiscmd}* [lindex $thismenu 0]] } {
                    incr matchcount 1
                    set matchmenu $thismenu
                }
            }
            DEBUGSTR "partial match count = $matchcount"
            if { $matchcount != 1 } {
                if { $foundcount <= 0 } {
                    set g_cmd_matchcount $matchcount
                    return {}
                }
#               if { [llength $cmd] <= [expr [lsearch $cmd $thiscmd] + 1] } {
#                   if { [lindex $thismenu 1] != "@" } {
#                       return {}
#                   }
#               }
                break
            }
            set thismenu $matchmenu
        }
        set cmd [lreplace $cmd $cmdpos $cmdpos [lindex $thismenu 0]]
        set menutree $thismenu
        incr cmdpos 1
    }

    set g_expanded_cmd $cmd
    return $menutree
}


proc isDelimeter { c } {

    if { $c == "\[" || $c == "\]" || \
	 $c == "("  || $c == ")"  || \
	 $c == "|"  || $c == " "  || \
	 $c == {} } {
	return 1
    } else {
	return 0
    }
}


proc exactMatch { arg list } {

    set start [string first $arg $list]
    if { $start < 0 } {
	return 0
    }
   
    set before [string index $list [expr $start - 1]]
    set after  [string index $list [expr $start + [string length $arg]]]

    if { [isDelimeter $before] && [isDelimeter $after] } {
	return 1
    } else {
	return 0
    }
}


############################################################
#
# parseArguments: parse the argument list for this command
#                    and execute the command
#
# cmdlist - is the menu for this command
# arglist - is the arguments that the user entered
#
proc parseArguments { cmdlist arglist } {

    if { [llength [lindex $cmdlist 5]] <= 0 } {
        EMSG "This command is not implemented yet."
        return {}
    }

    if { [llength [lindex $cmdlist 4]] <= 0 } {
        #
        # No arguments needed
        #
        if { [llength $arglist] > 0 } {
            EMSG "Too many arguments specified"
            return {}
        }
        return [lindex $cmdlist 5]
    }

    set arg_spec [lindex $cmdlist 4]
    set parsed {}

    while { [llength $arg_spec] > 0 } {
        set optional 0
        set next_spec [lindex $arg_spec 0]

        if { [string index $next_spec 0] == "%" } {
            set arg_spec [lrange $arg_spec 1 end]
        } elseif { [string index $next_spec 0] == "-" } {
            set next_spec [lrange $arg_spec 0 1]
            set arg_spec [lrange $arg_spec 2 end ]
        } elseif { [string index $next_spec 0] == "\[" } {
            set arg_spec [lrange $arg_spec 1 end]
            set optional 1
            while { [string index $next_spec \
                        [expr [string length $next_spec] - 1]] != "\]" } {
                if { $arg_spec == {} } {
                    EMSG "Internal error, incomplete format specifier!"
                    return {}
                }
                set next_spec [concat $next_spec [lindex $arg_spec 0]]
                set arg_spec [lrange $arg_spec 1 end]
            }
            set next_spec [string range $next_spec 1 end]
            set next_spec [string range $next_spec 0 \
                                [expr [string length $next_spec] - 2]]
        } else {
            set arg_spec [lrange $arg_spec 1 end]
        }
        DEBUGSTR "next format specifier is '$next_spec'"

        if { $optional } {
            if { [llength $arglist] <= 0 } {
                break
            }
        } elseif { [llength $arglist] < [llength $next_spec] } {
            EMSG "Insufficient number of arguments"
            argumentHelp $cmdlist
            return {}
        }

        #
        # find a match for this format
        #

        set nargs [llength $next_spec]
        set argtype [string index $next_spec 0]
        set foundarg 0
	DEBUGSTR "nargs = $nargs argtype = $argtype"
        if { $argtype == "%" } {
            set nextarg [lindex $arglist 0]
            if { $optional && [exactMatch $nextarg $arg_spec] } {
                #
                # if optional and the text of this argument matches another
                # optional field, then skip, this field
                #
                DEBUGSTR "skipping optional parameter"
            } else {
                set arglist [lrange $arglist 1 end]
                set foundarg [scan $nextarg $next_spec arg_value]
            }
        } elseif { $argtype == "-" && \
                    [string index [lindex $next_spec 1] 0] == "%" } {
            set argindex [lsearch $arglist [lindex $next_spec 0]]
            if { $argindex >= 0 } {
                set nextarg [lrange $arglist $argindex [expr $argindex + 1]]
                set arglist [concat \
                                [lrange $arglist 0 [expr $argindex - 1]] \
                                [lrange $arglist [expr $argindex + 2] end]]
                set foundarg [scan $nextarg $next_spec arg_value]
            }
        } else {
            if { $argtype == "-" } {
                set arg_index [lsearch $arglist [lindex $next_spec 0]]
                if { $arg_index >= 0 } {
                    set foundarg [regexp -nocase -- \
                        [lindex $next_spec 1] \
                        [lindex $arglist [expr $arg_index + 1]] arg_value]
                } else {
                    set foundarg 0
                }
            } else {
                set foundarg [regexp -nocase -- \
                        $next_spec $arglist arg_value]
            }
            if { $foundarg } {
                if { $argtype == "-" } {
                    set argindex [lsearch $arglist [lindex $next_spec 0]]
                } else {
                    set argindex [lsearch $arglist [lindex $arg_value 0]]
                }
                set arglist [concat \
                        [lrange $arglist 0 [expr $argindex - 1]] \
                        [lrange $arglist [expr $argindex + $nargs] end]]
            }
        }

        if { $foundarg || $optional } {
            if { $foundarg } { 
                set parsed [concat $parsed $arg_value] 
                DEBUGSTR "arg_value is $arg_value"
            } else {
                set parsed [concat $parsed "\[\]"]
            }        
        } else {
            EMSG "Invalid argument format"
            argumentHelp $cmdlist
            return {}
        }
    }

    if { [llength $arglist] > 0 } {
        #
        # unparsed arguments?
        #
        EMSG "Invalid argument '[lindex $arglist 0]'"
        return {}
    }

    set command {}

    foreach cmditem [lindex $cmdlist 5] {
        while { [regexp -- {%[0-9]+} $cmditem matched] == 1} {
            regsub $matched $cmditem \
                [lindex $parsed [expr \
                    [string range $matched 1 end] - 1]] cmditem
        }
        if { $cmditem != {} && $cmditem != "\[\]" } {
            set command [concat $command $cmditem]
        } else {
            set command "$command \"\""
        }
    }

    return $command
}



############################################################
#
# removeMenu: remove this menu from the given menu tree
# amenu: the menu to be removed
# menutree: the menu structure to remove from
# curmenu: the current submenu for this menu tree
# returns the new and imporved menutree
#
proc removeMenu { amenu menutree curmenu } {
    global g_debug
    if { $curmenu == "" } {
        DEBUGSTR "removeMenu: removing $amenu"
    }

    set newtree [lrange $menutree 0 1]

    foreach menu [lrange $menutree 2 end] {
        set submenu_title [concat $curmenu [lindex $menu 0]]
        set removed 0
        foreach tmenu [lindex $amenu 1] {
            DEBUGSTR "is $submenu_title == [concat [lindex $amenu 0] $tmenu]"
            if { $submenu_title == [concat [lindex $amenu 0] $tmenu] } {
                DEBUGSTR "removeMenu: removed $amenu"
                set removed 1
                break
            }
        }
        if { $removed } { continue }
        if { [isSubmenu [lindex $menu 1]] } {
            if { $submenu_title == [lrange [lindex $amenu 0] \
                    0 [expr [llength $submenu_title] - 1]]} {
                DEBUGSTR "$submenu_title == [lindex $amenu 0]"
                set menu [removeMenu $amenu $menu $submenu_title]
            }
        }
        lappend newtree $menu
    }

    return $newtree
}



############################################################
#
# removeSessionsFromMenus: remove the last 4 sessions from menus
#
#
proc removeSessionsFromMenus {} {
    global g_fullmenus g_sessions

    DEBUGSTR "removing dynamic menus"

    set newmenus {}
    set menus $g_fullmenus

    foreach menu $menus {
        for { set i 1 } { $i <= 4 } { incr i } {
            if { [lindex $menu 0] == [lindex $g_sessions($i) 0] && \
                    [isCommand [lindex $menu 1]] } {
                DEBUGSTR "removing $menu"
                break
            }
        }
        if { $i > 4 } {
            set newmenus [lappend newmenus $menu]
        }
    }

    set g_fullmenus $newmenus
}



############################################################
#
# addSessionsToMenus: update the last 4 sessions in the menus
#
#
proc addSessionsToMenus {} {
    global g_fullmenus g_sessions g_cmd_table

    DEBUGSTR "adding dynamic menus"

    set index 0

    for { set i 1 } { $i <= 4 } { incr i } {
        set sessname [lindex $g_sessions($i) 0]
        if { $sessname == {} } { continue }
        DEBUGSTR "adding session-$i $sessname"
        set sessmenu [format \
                "%s @ \"Switch to session %s\" \"\" \"\" \"setSession %s\"" \
                $sessname $sessname $sessname]

        set g_fullmenus [lappend g_fullmenus $sessmenu]
        set g_cmd_table([makeIndex $sessname]) $sessmenu
    }
}



############################################################
#
# setSession: set current session
#
#
proc setSession { session } {
    global g_curhost g_sessions g_prompt g_switch_type g_peerlist

    if { $g_curhost == $session } { return }

    set g_peerlist {}

    removeSessionsFromMenus

    set sessprompt {}

    for { set i 1 } { $i <= 4 } { incr i } {
        if { $session == [lindex $g_sessions($i) 0] } {
            set sessprompt [lrange $g_sessions($i) 1 end]
            break
        }
    }

    if { $i > 4 } { set i 1 }

    set g_sessions($i) "$g_curhost $g_prompt"

    addSessionsToMenus

    set g_curhost $session
    set g_prompt $sessprompt
    set g_switch_type [getSwitchType $g_curhost]
}



############################################################
#
# timeString: convert to time string
#
proc timeString { time } {
    set time [expr $time / 100]
    set days [expr $time / ( 24 * 60 * 60)]
    set time [expr $time - $days * 24 * 60 * 60]
    set hours [expr $time / (60 * 60)]
    set time [expr $time - $hours * 60 * 60]
    set mins [expr $time / 60]
    return "[format "%dd:%02d:%02d" $days $hours $mins]"
}

############################################################
#
# niceTimeString: convert to time string
#
proc niceTimeString { time } {
    set time [expr $time / 100]
    set days [expr $time / ( 24 * 60 * 60)]
    set time [expr $time - $days * 24 * 60 * 60]
    set hours [expr $time / (60 * 60)]
    set time [expr $time - $hours * 60 * 60]
    set mins [expr $time / 60]
    return "[format "%d days %02d:%02d" $days $hours $mins]"
}

############################################################
#
# cellsToMbs: convert cells to mbs
#
#
proc cellsToMbs { cells } {
    if { $cells == "N/A" } { return $cells }
    set bits [expr $cells * 53 * 8]
    return [megaUnits $bits]
}


############################################################
#
# nsapRemPeriod: remove all the periods from an NSAP address
# 
#
proc nsapRemPeriod { nsap } {
    regsub -nocase ^0x $nsap "" nsap
    regsub -all {\.} $nsap "" nsap
    
    return $nsap
}


############################################################
#
# cellsToKbs: convert cells to Kbs
#
#
proc cellsToKbs { cells } {
    if { $cells == -1    } { return ""    }
    if { $cells == "N/A" } { return $cells }
    if { $cells == 0     } { return 0      }
    set bits [expr $cells * 53 * 8 / 1000 + 1]
    return $bits
}


############################################################
#
# KbsToCells: convert Kbs to Cells
#
#
proc KbsToCells { kbps } {
    if { $kbps == "N/A" } { return $kbps }
    if { $kbps == 0 }     { return 0     }
    set cells [expr $kbps * 1000 / 53 / 8]
    return $cells
}


############################################################
#
# ConvertCapVal: convert capability value
#
#
proc convertCapVal { cells } {
    if { $cells == ~0 } { return "INF" }
    return [cellsToMbs $cells]
}


############################################################
#
# megaUnits: convert to mega something
#            round it to a maximum of 3 decimal points
#
proc megaUnits { val } {
    if { [catch { set val [expr $val / 100.0] } result ] } {
        return "N/A"
    }
    set val [expr round($val) / 10000.0]
    return $val
}


############################################################
#
# getItemValue: get the value for an item in a list that has
#               the format {name value name value ...}
#
#
proc getItemValue { list item } {
    set index [lsearch $list $item]
    if { $index < 0 } {
        DEBUGSTR "getItemValue: $item not found"
        return "N/A";
    }
    return [lindex $list [expr $index + 1]]
}



############################################################
#
# about: display about AMI
#
proc about {} {
    showVersionInfo
    puts "  AMI uses SNMP to manage FORE Systems' ATM switches."
    puts "  AMI is platform independent and runs on hosts and FORE ATM switches."
    puts "  When AMI is executed on a host, you must first use the OPEN command"
    puts "  to specify the switch to manage.  If AMI is started on the switch,"
    puts "  it immediately opens a connection to the local switch."
  
}



############################################################
#
# getSwitchType: get the switch type for the specified session
#
#
proc getSwitchType { session } {
    if { [catch { set switch_type \
            [$session switch get -switchType] } result] == 0 } {
        return $switch_type
    }
    if {$result == "SNMP: the requested object does not exist"} {
	puts "\nWARNING: Pre 3.0.1 switch.  Some AMI commands will not work."
    } else {
	puts "\nWARNING: Unable to get switch-type:"
	puts "$result\nTrying to get adapter-type...\n"
    }

    if { [catch { set adapters [$session asx adapter list] } result] != 0 } {
        set adapters {}
    }

    if { $adapters != {} } {
        set adapter_type [$session asx adapter get \
                [lindex $adapters 0] -adapterType]
        if { $adapter_type == "type-ASX-100" } {
            set adapter_type "asx100"
        } else {
            set adapter_type "asx200"
        }
    } else {
        set adapter_type {}
    }

    if { $adapter_type == {} } {
        if { $session == "localhost" } {
            EMSG "Could not contact switch '$session'."
        } else {
            ERROR "Could not contact switch '$session'."
        }
    }
    return $adapter_type
}



############################################################
#
# addToSessions: add this session to session list
#
proc addToSessions { session prompt } {
    global g_sessions

    for { set i 4 } { $i > 1 } { incr i -1 } {
        set g_sessions($i) $g_sessions([expr $i - 1])
    }
    set g_sessions(1) "$session $prompt"
}


############################################################
#
# removeFromSessions: remove this session from session list
#
proc removeFromSessions { session } {
    global g_sessions

    for { set i 1 } { $i <= 4 } { incr i } {
        if { [lindex $g_sessions($i) 0] == $session } { break }
    }
    for { } { $i < 4 } { incr i } {
        set g_sessions($i) $g_sessions([expr $i + 1])
    }
    set g_sessions(4) {}
}


############################################################
#
# openSession: open a session to the host, return session handle
#
#
proc openSession { host community } {
    global g_curhost g_switch_type g_sessions g_prompt g_peerlist

    set g_peerlist {}

    set realhost $host

    if { $host == "localhost" } { set host "127.0.0.1" }

    if { [regexp {[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+} $host] == 0 } {
        if { [gethostbyname $host] == {} } { 
            EMSG "Can not resolve the address for '$host'" 
            return $g_curhost
        }
    }

    if { $g_sessions(4) != {} } {
        EMSG "Too many open sessions.  Please close one."
        return $g_curhost
    }

    if { $community == {} } { set community "public" }

    puts "\nOpening a session for \"$realhost\", please wait..."

    if { $host == "127.0.0.1" } {
        set session "localhost"
    } else {
        set session $host
    }

    set id 0

    addToSessions $g_curhost $g_prompt

    for { set i 1 } { $i <= 4 } { incr i } {
        if { $session == [lindex $g_sessions($i) 0] } {
            if { $id == 0 } { incr id }
        } elseif { [regexp -nocase -- "($session):(\[1-4\])" \
                [lindex $g_sessions($i) 0] match m1 m2] } {
            if { $id <= $m2 } { set id [expr $m2 + 1] }
        }
    }

    removeFromSessions $g_curhost

    if { $id > 0 } { set session "$session\:$id" }

    eval [concat snmp open $session $host $community]

    set g_switch_type [getSwitchType $session]

    if { $g_switch_type != {} } {
        puts "\nConnected to \"$realhost\" \($g_switch_type\)."
    }

    if { $g_curhost != {} } {
        removeSessionsFromMenus
        addToSessions $g_curhost $g_prompt
        addSessionsToMenus
    }

    set g_prompt {}
    return $session
}


############################################################
#
# closeSession: close the specified session
#
#
proc closeSession { session } {
    global g_prompt g_curhost g_sessions g_switch_type g_peerlist
    $session close
    set g_prompt {}
    set g_peerlist {}

    removeSessionsFromMenus
    set g_curhost [lindex $g_sessions(1) 0]
    set g_prompt [lrange $g_sessions(1) 1 end]
    removeFromSessions [lindex $g_sessions(1) 0]
    addSessionsToMenus

    if { $g_curhost != {} } { 
        set g_switch_type [getSwitchType $g_curhost]
        return $g_curhost 
    }
    return {}
}


############################################################
#
# queryList: evaluate the expression and return a list
#
#
proc queryList { expression } {
    set result [eval $expression]
    if { [string index $result 0] == "-" || \
            [scan [string index $result 0] "%d" temp] == 1 } {
        set result [list $result]
    }
    return $result
}


############################################################
#
# niceHardwareVersion: convert version number to string
#
proc niceHardwareVersion { version } {
    set verstr [format "%d.%d" \
            [expr $version / 0x10000] [expr ($version / 0x100) % 0x100]]
    return $verstr
}


############################################################
#
# setCDVTOrPolicing: set the value for CDVT or policing
#
proc setCDVTOrPolicing { table index variable value } {
    global g_curhost g_switch_type

    if { $g_switch_type == "asx100" } {
        EMSG "This option is not supported on ASX-100 switches"
        return
    }

    $g_curhost $table set $index $variable $value
}

############################################################
#
# set
#
proc setDefaultPrefix { table index variable value } {
    global g_curhost

    $g_curhost $table set $index $variable $value

    AMIputs "[format "\nThis change will become effective on restart of switch control software"]"

    if { $g_curhost != "localhost" } {
        return
    }

    operRebootSwitch "scs"
    
}


############################################################
#
# configureSwitchShow: show switch configuration
#
#
proc configureSwitchShow {} {
    global g_curhost g_switch_type
    set name [$g_curhost system get -sysName]
    set vars [$g_curhost switch get \
            -uptime -hardwareVersion -softwareVersion \
            -atmAddress -maxPaths -maxChannels -switchNsapPrefix] 

    set morevars {}
    
    if { $g_switch_type != "asx100" } {
        catch { set morevars [$g_curhost switch get \
                -switchCDV -switchPolicingAction] } result
    }
    set vars [concat $vars $morevars]

    set switch_type $g_switch_type

    if { [catch { set switchtype \
            [$g_curhost switch get -switchType] } result] != 0 } {
        set switch_type $g_switch_type
    }

    if { $switch_type == {} } { set switch_type "Unknown" }

    initAMIputs
    puts "\nSwitch '$name', Type $switch_type, up [niceTimeString [getItemValue $vars -uptime]]"

    puts -nonewline "[format "Hardware version %s" \
            [niceHardwareVersion [getItemValue $vars -hardwareVersion]]]"

    set version [getItemValue $vars -softwareVersion]
    if { [catch { set version \
            [$g_curhost switch get -softwareVersionText] } result] == 0 } { 
        set version [join $version]
    } else {
        set version "[format  "%d.%d.%d" [expr $version / 0x10000]\
                [expr ($version / 0x100) % 0x100] [expr $version % 0x100]]"
    }

    AMIputs "[format ", Software version %s\n" $version]"

    AMIputs "[format "Maximum Virtual Path Connections\t%d" \
            [getItemValue $vars -maxPaths]]"
    AMIputs "[format "Maximum Virtual Channels\t\t%d" \
            [getItemValue $vars -maxChannels]]"
    AMIputs "[format "CDVT\t\t\t\t\t%s" [getItemValue $vars -switchCDV]]"
    AMIputs "[format "Policing\t\t\t\t%s" \
            [getItemValue $vars -switchPolicingAction]]"
    AMIputs "[format "NSAP Prefix\t\t\t\t%s" \
            [getItemValue $vars -switchNsapPrefix]]"
    AMIputs "[format "SPANS address\t\t\t\t%s" \
            [getItemValue $vars -atmAddress]]"

}



############################################################
#
# userBoardNumber: convert board number to user space
#
#
proc userBoardNumber { hwboard } {
    global g_switch_type

    if { $g_switch_type != "asx100" } {
        incr hwboard
    }

    return $hwboard
}



############################################################
#
# switchBoardNumber: convert user board number to switch space
#
#
proc switchBoardNumber { userboard } {
    global g_switch_type

    if { $g_switch_type != "asx100" } { incr userboard -1 }

    if { $userboard < 0 } { ERROR "Invalid switch board number" }

    return $userboard
}



############################################################
#
# boardModel: get board model description
#
#
proc getBoardModel { model } {
    switch $model {
        3857 { return "asx100" }
        3858 { return "asx200" }
    }
    return $model
}


############################################################
#
# configureBoardShow: show board configuration
#
#
#
proc configureBoardShow { board } {
    global g_curhost g_switch_type

    if { $board != {} } { set board [switchBoardNumber $board] }

    set vars [queryList [concat $g_curhost board get $board]]

    if { $vars == {} } {
        puts "\nNo board information is available"
        return
    }

    set swvars {}

    if { $g_switch_type != "asx100" } {
        catch { set swvars [queryList \
                [concat $g_curhost swboard get $board]] } result
    } else {
        catch { set swvars [queryList \
                [concat $g_curhost swboard get $board -swBoardNsapPrefix]] } result
    }
    
    set swvars_sav $swvars

    initAMIputs
    AMIputs "\nBoard Version Model     S/N    NMs VPIerrors VCIerrors Policing CDVT"

    foreach var $vars {
        set swvar [lindex $swvars 0]
        set swvars [lrange $swvars 1 end]

        AMIputs "[format "%-5s %-7s %-9s %-6s %-3s %9s %9s %-8s %s \n" \
                [userBoardNumber [getItemValue $var -boardIndex]] \
                [niceHardwareVersion [getItemValue $var -boardVersion]] \
                [getBoardModel [getItemValue $var -boardModel]] \
                [getItemValue $var -boardSerialNumber] \
                [getItemValue $var -numberOfModules] \
                [getItemValue $var -vpiLookupErrors] \
                [getItemValue $var -vciLookupErrors] \
                [getItemValue $swvar -swBoardPolicingAction] \
                [getItemValue $swvar -swBoardCDV]]"

    }
    
    foreach swvar $swvars_sav {
        AMIputs "[format "Default NSAP Prefix for board %d is %s" \
                [userBoardNumber [getItemValue $swvar -swBoardIndex]] \
                [getItemValue $swvar -swBoardNsapPrefix]]"                
    }
}


############################################################
#
# operBoardTest: test switch board
#
#
proc operBoardTest { board } {
    global g_switch_type errorCode
    if { ![runningOnSwitch] } { return }

    puts "\n                ***** WARNING *****\n"
    puts "Testing the switch requires physically disconnecting all"
    puts "of its ATM connections thus disrupting all traffic passing"
    puts "through this switch.  The switch will also be rebooted"
    puts "after testing is completed."

    if { [yesorno "Test switch board $board" "n"] } {
        set nanny [open "| ps ax | grep nanny | head -1" r]
        if { [gets $nanny pid] > 0 } {
            catch { exec kill "-TERM" [lindex $pid 0] } result
        }
        close $nanny
        set switch_type $g_switch_type
        if { ![sparcSwitch] } {
            puts "\nSelect switch type\n\t1) asx100\n\t2) asx200"
            puts -nonewline "\nSwitch type: "
            gets stdin type
            switch $type {
                1 { set switch_type "asx100" }
                2 { set switch_type "asx200" }
                default {
                    puts "Invalid switch type"
                    return
                }
            }
        }
        if { $switch_type == "asx200" } { incr board -1 }
        set device [format "asx%d" $board]
        exec ifconfig $device down
        exec ctlptshut $device
        if { $switch_type == "asx100" } {
            switch $board {
                0 { set vmebase 15 }
                1 { set vmebase 16 }
                2 { set vmebase 17 }
                3 { set vmebase 18 }
            }
        } else {
            switch $board {
                0 { set vmebase 14 }
                1 { set vmebase 18 }
                2 { set vmebase 1C }
                3 { set vmebase 20 }
            }
        }
        if { [catch { exec asxtest -b $vmebase > /dev/tty} result] } {
            puts "$errorCode"
            puts "\nThe switch diagnostic failed.  Please contact"
            puts "FORE Systems' Technical Support.\n\n"
            puts "\nI will not restart the switch controller."
            return
        }
        puts "\nTest passed."
        puts "Switch is operational, you may now reconnect attachments."
        puts -nonewline "\nPress return to reboot the switch: "
        gets stdin cr
        exec /etc/reboot
     }
}


############################################################
#
# configureBoardTopology: show routing table
#
#
proc configureBoardTopology { board } {
    global g_curhost

    if { $board != {} } { set board [switchBoardNumber $board] }

    set vars [queryList [concat $g_curhost topology get $board]]

    if { $vars == {} } {
        puts "\nNo topology information is available"
        return
    }

    initAMIputs
    AMIputs "\nBoard Source             Destination          Capacity   Age"

    foreach var $vars {
        AMIputs "[format "%-5s %-18s %-18s %10s %5s" \
                [userBoardNumber [getItemValue $var -swBoardLinkIndex]] \
                [getItemValue $var -swBoardLinkSrc] \
                [getItemValue $var -swBoardLinkDest] \
                [getItemValue $var -swBoardLinkCapacity] \
                [getItemValue $var -swBoardLinkAge]]"
    }
}



############################################################
#
# userModulePortNumber: convert module port number to user space
#
#
proc userModulePortNumber { port } {
    global g_switch_type

    if { $g_switch_type != "asx100" } {
        incr port
    }

    return $port
}



############################################################
#
# switchModulePortNumber: convert user module port number to switch space
#
#
proc switchModulePortNumber { userport } {
    global g_switch_type

    if { $g_switch_type != "asx100" } { incr userport -1 }

    if { $userport < 0 } { ERROR "Invalid module port number" }

    return $userport
}



############################################################
#
# switchModuleNumber: convert user space module id to number
#
# 
proc switchModuleNumber { module } {
    switch $module {
        "a" -
        "A" { return 0 }
        "b" -
        "B" { return 1 }
        "c" -
        "C" { return 2 }
        "d" -
        "D" { return 3 }
    }
    ERROR "Invalid network module identifier"
}



############################################################
#
# userModuleNumber: convert switch module id to user space 
#
# 
proc userModuleNumber { module } {
    switch $module {
        0 { return "A" }
        1 { return "B" }
        2 { return "C" }
        3 { return "D" }
    }
    ERROR "Invalid network module identifier"
}



############################################################
#
# switchBoardModule: convert board module spec to switch board and module
#
proc switchBoardModule { bn } {
    if { $bn == {} } { return {} }

    set b {}
    set n {}

    if { ![regexp -nocase -- {^([0-9])([A-Z])$} $bn mc b n] && \
            ![regexp -nocase -- {^([0-9])$} $bn mc b] && \
            ![regexp -nocase -- {^([A-Z])$} $bn mc n] } {
        ERROR "Invalid module specification"
    }

    if { $b != {} } {
        set b [switchBoardNumber $b]
    } else {
        set b 0
    }

    if { $n != {} } {
        set n [switchModuleNumber $n]
    }

    return "$b $n"
}



############################################################
#
# configureModuleShow: show module information
#
#
proc configureModuleShow { board_module } {
    global g_curhost

    set vars [queryList [concat $g_curhost module get \
            [switchBoardModule $board_module]]]

    if { $vars == {} } {
        puts "\nNo module information is available"
        return
    }

    initAMIputs
    AMIputs "\nModule  Speed  Ports  Uptime    Type"

    foreach var $vars {
        AMIputs "[format "%s%-5s %6s  %5s  %-9s %s" \
                [userBoardNumber [getItemValue $var -moduleBoard]] \
                [userModuleNumber [getItemValue $var -moduleNumber]] \
                [megaUnits [getItemValue $var -moduleSpeed]] \
                [getItemValue $var -moduleNumberOfPorts] \
                [timeString [getItemValue $var -moduleUptime]] \
                [getItemValue $var -moduleName]]"
    }
}



############################################################
#
# configureNetmodTimingShow: display netmod timing info
#
proc configureNetmodTimingShow { board_module } {
    global g_curhost

    set vars [queryList [concat $g_curhost ndt get \
            [switchBoardModule $board_module]]]

    if { $vars == {} } {
        puts "\nNo netmod timing information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%24s %29s" Import Export]"
    AMIputs "[format "%-7s %-9s %-9s %-9s %-9s %-9s %-9s %s" \
            Module Internal Primary Secondary Current Primary Secondary Current]"

    foreach var $vars {
	set board [userBoardNumber [getItemValue $var -ntBoard]]
        set module [format "%s%s"  $board \
                [userModuleNumber [getItemValue $var -ntModule]]]

	set internal [getItemValue $var -ntGlobalClock]
	set internal [string range $internal 0 5]

        set priimport [format "%s%s" $board \
		[string index [getItemValue $var -ntPrimaryImportClock] 6]]
        set secimport [format "%s%s" $board \
		[string index [getItemValue $var -ntSecondaryImportClock] 6]]
        set importstate [getItemValue $var -ntImportClockOperStatus]
	if { $importstate == "netmodExportClock" } {
	    set importstate $module
	} else {
	    set importstate [string range $importstate 0 \
		    [expr [string first Cl $importstate] - 1]]
	}
	if { $priimport == $board } { 
	    set priimport "N/A" 
	    set secimport "N/A" 
	    set importstate "N/A" 
	}

        set priexport [getItemValue $var -ntPrimaryExportClock]
        switch $priexport {
            "primaryRecoveredClock" { set priexport [format "%s%s" \
                    $module [userModulePortNumber \
                    [getItemValue $var -ntPrimaryRecoveredClock]]] }
            "crystalClock" {set priexport "crystal" }
        }
        set secexport [getItemValue $var -ntSecondaryExportClock]
        switch $secexport {
            "secondaryRecoveredClock" { set secexport [format "%s%s" \
                    $module [userModulePortNumber \
                    [getItemValue $var -ntSecondaryRecoveredClock]]] }
            "crystalClock" {set secexport "crystal" }
        }
        set exportstate [getItemValue $var -ntExportClockOperStatus]
	set exportstate [string range $exportstate 0 \
		[expr [string first Cl $exportstate] - 1]]


	AMIputs "[format "%-7s %-9s %-9s %-9s %-9s %-9s %-9s %s" \
                $module $internal \
		$priimport $secimport $importstate \
		$priexport $secexport $exportstate]"
    }
}



############################################################
#
# configureNetmodTimingPort: set netmod timing port source
#
proc configureNetmodTimingPort { board_module which port } {
    global g_curhost

    switch $which {
        "primary" { set which "-ntPrimaryRecoveredClock" }
        "secondary" { set which "-ntSecondaryRecoveredClock" }
    }

    set b_n [switchBoardModule $board_module] 

    eval [concat $g_curhost ndt set $b_n \
            $which [switchModulePortNumber $port]]
}



############################################################
#
# configureNetmodTimingModule: set netmod timing module source
#
proc configureNetmodTimingModule { board_module which module } {
    global g_curhost

    switch $which {
        "primary" { set which "-ntPrimaryImportClock" }
        "secondary" { set which "-ntSecondaryImportClock" }
    }

    switch $module {
        "a" { set module 1 }
        "b" { set module 2 }
        "c" { set module 3 }
        "d" { set module 4 }
    }

    set b_n [switchBoardModule $board_module] 

    eval [concat $g_curhost ndt set $b_n $which $module]
}



############################################################
#
# configureNetmodTimingClock: set netmod timing clock source
#
proc configureNetmodTimingClock { board_module which clksrc } {
    global g_curhost

    switch $which {
        "primary" { set which "-ntPrimaryExportClock" }
        "secondary" { set which "-ntSecondaryExportClock" }
    }

    switch $clksrc {
        "recovered" { set clksrc 1 }
        "crystal" { set clksrc 2 }
    }

    eval [concat $g_curhost ndt set \
            [switchBoardModule $board_module] $which $clksrc]
}


############################################################
#
# configureNetmodTimingInternalClock: set netmod timing source
#
proc configureNetmodTimingInternalClock { board_module source } {
    global g_curhost

    switch $source {
        "export" { set source 1 }
        "import" { set source 2 }
    }

    set b_n [switchBoardModule $board_module] 

    eval [concat $g_curhost ndt set $b_n "-ntGlobalClock" $source]
}


############################################################
#
# configureNetmodTimingExportClock: set netmod timing source
#
proc configureNetmodTimingExportClock { board_module which source } {
    global g_curhost
    if { [string tolower $source] == "crystal" } {
        configureNetmodTimingClock $board_module $which "crystal"
    } else {
        if { [string length $source] != 1 || [scan $source "%d" port] != 1 } {
            EMSG "Invalid port number or module name within this module."
            return
        }

	configureNetmodTimingPort  $board_module $which $port
	configureNetmodTimingClock $board_module $which "recovered"
    }
}


############################################################
#
# configureNetmodTimingImportClock: set netmod exported timing source
#
proc configureNetmodTimingImportClock { board_module which source } {
    global g_curhost
    if { [string length $source] != 1 || [scan $source "%s" module] != 1 } {
	EMSG "Invalid port number within this module."
	return
    }

    configureNetmodTimingModule  $board_module $which [string tolower $module]
}


############################################################
#
# configureShmemShow: display shared memory netmod information
#
proc configureShmemShow { module } {
    global g_curhost g_shmemXACPT

    if { $module != {} } { set module [switchBoardModule $module] }

    set vars [queryList [concat $g_curhost shmem netmod get $module]]

    if { $vars == {} } {
        puts "\nNo shared memory module information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n %-6s %-5s %-8s %-6s %-9s %6s %6s %6s %6s %-6s" \
            Module Model Unicasts Mcasts McastOuts Cells Shared Used EPD FIFOblock]"

    foreach var $vars {
        AMIputs "[format " %s%-5s %5s %8s %6s %9s %6s %6s %6s %6s %-6s" \
                [userBoardNumber [getItemValue $var -nshmemBoard]] \
                [userModuleNumber [getItemValue $var -nshmemModule]] \
                [getItemValue $var -nshmemConfRow] \
                [getItemValue $var -nshmemCurrentUcastConnections] \
                [getItemValue $var -nshmemCurrentMcastConnections] \
                [getItemValue $var -nshmemCurrentVpiVciLists] \
                [getItemValue $var -nshmemCurrentCellsBuffers] \
                [getItemValue $var -nshmemConfSharedMemory] \
                [getItemValue $var -nshmemCurrentSharedMemory] \
                [getItemValue $var -nshmemConfAal5PacketDrop] \
                [convertMibConst \
                [getItemValue $var -nshmemAssertXACPT] $g_shmemXACPT]]"
    }
}



############################################################
#
# configurePortTrafficShow: display traffic configuration
#
proc configurePortTrafficShow { port } {
    global g_curhost

    if { $port != {} } { set port [$g_curhost convert bnpstrtobnp $port] }

    set vars [queryList [concat $g_curhost shmem portconf get $port]]

    if { $vars == {} } {
        puts "\nNo port traffic configuration information available"
        return
    }

    initAMIputs

    AMIputs "\nPort configuration:"

    AMIputs "[format "\n %-4s %10s %10s %10s %12s %12s" \
            Port CBR-CDV VBR-CDV ABR-Qsize ABR-EFCI-ON ABR-EFCI-OFF]"

    foreach var $vars {
        AMIputs "[format " %-4s %10s %10s %10s %12s %12s" \
                [$g_curhost convert bnptobnpstr \
                [getItemValue $var -pshmemConfBoard] \
                [getItemValue $var -pshmemConfModule] \
                [getItemValue $var -pshmemConfPort]] \
                [getItemValue $var -pshmemMaxCDVforCBR] \
                [getItemValue $var -pshmemMaxCDVforVBR] \
                [getItemValue $var -pshmemQsizeforABR] \
                [getItemValue $var -pshmemEfciOnABR] \
                [getItemValue $var -pshmemEfciOffABR]]"
    }

    AMIputs "\nPort priority queues:"

    set vars [queryList [concat $g_curhost shmem portstate get $port]]

    if { $vars == {} } {
        puts "\nNo port priority queue traffic information available"
        return
    }

    AMIputs "[format "\n %-4s %-8s %-9s %-9s %-7s" \
            "" "" CLP Qsize Qsize]"
    AMIputs "[format " %-4s %-8s %-9s %-9s %-7s %12s %10s" \
            Port Priority Threshold Dedicated Current TxCells LostCells]"

    foreach var $vars {
        set pri [getItemValue $var -pshmemPriority]
        if { [string range $pri 0 8] == "priority-" } {
            set pri [string range $pri 9 end]
        }
        AMIputs "[format " %-4s %-8s %9s %9s %7s %12s %10s" \
                [$g_curhost convert bnptobnpstr \
                [getItemValue $var -pshmemBoard] \
                [getItemValue $var -pshmemModule] \
                [getItemValue $var -pshmemPort]] \
                $pri \
                [getItemValue $var -pshmemClpThreshold] \
                [getItemValue $var -pshmemDedicatedQsize] \
                [getItemValue $var -pshmemCurrentQsize] \
                [getItemValue $var -pshmemTxCells] \
                [getItemValue $var -pshmemLostCells]]"
    }
}



############################################################
#
# configureShmemModels: display shared memory models
#
proc configureShmemModels {} {
    global g_curhost

    set vars [queryList [concat $g_curhost shmem model get]]

    if { $vars == {} } {
        puts "\nNo shared memory model information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n %-5s %-8s %8s %-9s %8s  %s" \
            Model Unicasts Mcasts McastOuts Cells Name]"

    foreach var $vars {
        AMIputs "[format " %-5s %8s %8s %9s %8s  %s" \
                [getItemValue $var -shmemConfIndex] \
                [getItemValue $var -shmemUcastConnections] \
                [getItemValue $var -shmemMcastConnections] \
                [getItemValue $var -shmemVpiVciLists] \
                [getItemValue $var -shmemCellsBuffers] \
                [getItemValue $var -shmemConfName]]"
    }
}


############################################################
#
# configureShmemSetModel: Set model for a given module
#
# NOTE: This requires the switch software to be restarted
#
proc configureShmemSetModel { module model } {
    global g_curhost

    initAMIputs
    AMIputs "\nChanging the configured model on a shared memory"
    AMIputs "network module will take effect after restarting"
    AMIputs "the switch software."

    if { [yesorno "Set memory model to $model" "y"] } {
        eval [concat $g_curhost shmem netmod set \
                [switchBoardModule $module] -nshmemConfRow $model]
        # request to restart switch software
        operRestartSwitch
    }
}


############################################################
#
# configureShmemPacketdrop: Set packetdrop level for this port
#
proc configureShmemPacketdrop { module threshold } {
    global g_curhost

    eval [concat $g_curhost shmem netmod set \
        [switchBoardModule $module] -nshmemConfAal5PacketDrop $threshold]
}


############################################################
#
# configureShmemXACPT: Set XACPT bit for this netmod
#
proc configureShmemXACPT { module xacpt } {
    global g_curhost

    eval [concat $g_curhost shmem netmod set \
        [switchBoardModule $module] -nshmemAssertXACPT $xacpt]
}


############################################################
#
# configureShmemCDV: Set cdvt for this port
#
# NOTE: This requires the switch software to be restarted
#
proc configureShmemCDV { port CBRorVBR cdvt } {
    global g_curhost

    initAMIputs
    AMIputs "\nChanging the configured CDV on a shared memory"
    AMIputs "network module will take effect after restarting"
    AMIputs "the switch software."

    if { [yesorno "Set the CDV value to $cdvt" "y"] } {
        set CBRorVBR [string toupper $CBRorVBR]
        switch $CBRorVBR {
            "CBR" { set CBRorVBR "-pshmemMaxCDVforCBR" }
            "VBR" { set CBRorVBR "-pshmemMaxCDVforVBR" }
        }

        eval [concat $g_curhost shmem portconf set \
                [$g_curhost convert bnpstrtobnp $port] $CBRorVBR $cdvt]

        # request to restart switch software
        operRestartSwitch
    }
}


############################################################
#
# configureShmemQsize: Set queue size for this port
#
# NOTE: This requires the switch software to be restarted
#
proc configureShmemQsize { port qsize } {
    global g_curhost

    initAMIputs
    AMIputs "\nChanging the configured queue size on a shared memory"
    AMIputs "network module will take effect after restarting"
    AMIputs "the switch software."

    if { [yesorno "Set the queue size to $qsize" "y"] } {
        eval [concat $g_curhost shmem portconf set \
              [$g_curhost convert bnpstrtobnp $port] -pshmemQsizeforABR $qsize]

        # request to restart switch software
        operRestartSwitch
    }
}


############################################################
#
# configureShmemEFCI: Set EFCI for this port
#
proc configureShmemEFCI { port ONorOFF val } {
    global g_curhost

    set ONorOFF [string toupper $ONorOFF]
    switch $ONorOFF {
        "ON"  { set ONorOFF "-pshmemEfciOnABR" }
        "OFF" { set ONorOFF "-pshmemEfciOffABR" }
    }

    eval [concat $g_curhost shmem portconf set \
            [$g_curhost convert bnpstrtobnp $port] $ONorOFF $val] 
}


############################################################
#
# portToBNPstr: convert port number to BNP string
# 
proc portToBNPstr { port } {
    global g_curhost

    if { $port != {} } {
        if { [catch { set port \
                [$g_curhost convert porttobnpstr $port] } result] } {
            return "?"
        }
    }
    return $port
}



############################################################
#
# configurePortShow: show port information
#
#
proc configurePortShow { bnp } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    set vars [queryList [concat $g_curhost port get $port]]

    if { $vars == {} } {
        puts "\nNo port information is available"
        return
    }

    set atmaddress {}

    initAMIputs
    AMIputs "\nPort Carrier   Mb/s iVPs iVCs    iBW  iCells oVPs oVCs    oBw  oCells Model"

    foreach var $vars {
        set rxCells [getItemValue $var -portReceivedCells]
        set txCells [getItemValue $var -portTransmittedCells]
        if { $rxCells > 1000000 } { set rxCells "[megaUnits $rxCells]M" }
        if { $txCells > 1000000 } { set txCells "[megaUnits $txCells]M" }

        set bnp [portToBNPstr [getItemValue $var -portNumber]]

        set b [getItemValue $var -portHwBoard]
        set n [getItemValue $var -portHwModule]
        set p [getItemValue $var -portHwNumber]

        set model [$g_curhost hwport get $b $n $p -hwPortModel]
        if { [string range $model 0 5] == "model-" } {
            set model [string range $model 6 end]
        }
        if { [string range $model 0 5] == "6port-" } {
            set model "[string range $model 6 end]-6"
        }

        if { [string match ?CTL $bnp] == 0} {
            set portspeed [megaUnits [$g_curhost module get \
                    [getItemValue $var -portHwBoard] \
                    [getItemValue $var -portHwModule] -moduleSpeed]]
        } else {
            set portspeed 80.0
        }

        set pathvcs [$g_curhost path get \
                [getItemValue $var -portNumber] -pathNumChannels]

        set numInChannels 0
        foreach path $pathvcs {
            set numInChannels [expr \
                    $numInChannels + [getItemValue $path -pathNumChannels]]
        }

        set pathvcs [$g_curhost opath get \
                [getItemValue $var -portNumber] -opathNumChannels]

        set numOutChannels 0
        foreach path $pathvcs {
            set numOutChannels [expr \
                    $numOutChannels + [getItemValue $path -opathNumChannels]]
        }

        AMIputs \
          "[format "%-4s %-7s %6s %4s %4s %6s %7s %4s %4s %6s %7s %s" \
            $bnp \
            [getCarrierState $b $n $p] \
            $portspeed \
            [getItemValue $var -portNumPathsIn] \
            $numInChannels \
            [cellsToMbs [getItemValue $var -portAllocBandwidthIn]] \
            $rxCells \
            [getItemValue $var -portNumPathsOut] \
            $numOutChannels \
            [cellsToMbs [getItemValue $var -portAllocBandwidthOut]] \
            $txCells \
            $model]"
    }
}



############################################################
#
# getCarrierState: get carrier state for this port
#
#
proc getCarrierState { b n p } {
    global g_curhost
    set carrier [$g_curhost hwport get $b $n $p -hwPortCarrier]
    if { $carrier == "carrier" } {
        set carrier "yes"
    } else {
        set carrier "no"
    }

    return $carrier
}



############################################################
#
# configureHardwarePort: set someting on a hardware port
#
#
proc configureHardwarePort { type bnp var val } {
    global g_curhost 
    set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
    set b [lindex $b_n_p 0]
    set n [lindex $b_n_p 1]
    set p [lindex $b_n_p 2]

    switch $type {
        e1	{ $g_curhost e1 conf set $b $n $p $var $val }
        e3	{ $g_curhost e3 conf set $b $n $p $var $val }
        ds1	{ $g_curhost ds1 conf set $b $n $p $var $val }
        ds3	{ $g_curhost ds3 conf set $b $n $p $var $val }
	j2      { $g_curhost j2 conf set $b $n $p $var $val }
        sonet	{ $g_curhost sonet conf set $b $n $p $var $val }
        TAXI	{ $g_curhost hwport set $b $n $p $var $val }
    }
}



############################################################
#
# configureHardwarePortScrambling: set scrambling on a hardware port
#
#
proc configureHardwarePortScrambling { type bnp val } {
    global g_curhost 
    global g_scrambling g_descrambling

    set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
    set b [lindex $b_n_p 0]
    set n [lindex $b_n_p 1]
    set p [lindex $b_n_p 2]

    switch $type {
        e3 {
            $g_curhost e3 conf set $b $n $p \
                    -e3TxScrambling [convertUserConst $val $g_scrambling]
            $g_curhost e3 conf set $b $n $p \
                    -e3RxScrambling [convertUserConst $val $g_descrambling]
        }
        ds3 { 
            $g_curhost ds3 conf set $b $n $p \
                    -ds3TxScrambling [convertUserConst $val $g_scrambling]
            $g_curhost ds3 conf set $b $n $p \
                    -ds3RxScrambling [convertUserConst $val $g_descrambling]
        }
        sonet {
            $g_curhost sonet conf set $b $n $p \
                    -sonetTxScrambling [convertUserConst $val $g_scrambling]
            $g_curhost sonet conf set $b $n $p \
                    -sonetRxScrambling [convertUserConst $val $g_descrambling]
        }
    }
}


############################################################
#
# hexValue: convert integer to hex
#
proc hexValue { intval } {
    if { [scan $intval "%d" hexval] == 1 } { 
        set hexval [format "0x%x" $intval]
    } else {
        set hexval "N/A" 
    }
    return $hexval
}



############################################################
#
# configurePortE3Show: show E3 port information
#
#
proc configurePortE3Show { bnp } {
    global g_curhost g_e3Loopback g_scrambling g_e3Timing g_e3LineType
    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }
    set vars [queryList [concat $g_curhost e3 conf get $b $n $p]]

    if { $vars == {} } {
        puts "\nNo E3 port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-7s %-6s %-4s %-8s %-12s %-10s %s" \
            Port Carrier Status Mode Loopback ClockSource Scrambling IdleCells]"

    foreach var $vars {
        set b [getItemValue $var -e3ConfBoard]
        set n [getItemValue $var -e3ConfModule]
        set p [getItemValue $var -e3ConfPort]
        AMIputs "[format "%-4s %-7s %-6s %-4s %-8s %-12s %-10s %s" \
                [$g_curhost convert bnptobnpstr $b $n $p] \
                [getCarrierState $b $n $p] \
                [hexValue [getItemValue $var -e3LineStatus]] \
                [convertMibConst \
                [getItemValue $var -e3LineType] $g_e3LineType] \
                [convertMibConst \
                [getItemValue $var -e3LoopbackConfig] $g_e3Loopback] \
                [convertMibConst \
                [getItemValue $var -e3TxClockSource] $g_e3Timing] \
                [convertMibConst \
                [getItemValue $var -e3TxScrambling] $g_scrambling] \
                [getItemValue $var -e3IdleUnassignedCells]]"
    }
}



############################################################
#
# configurePortE1Show: show E1 port information
#
#
proc configurePortE1Show { bnp } {
    global g_curhost g_e1Loopback g_e1Timing g_e1LineType g_e1LineLength
    global g_e1LineTypeFraming

    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }
    set vars [queryList [concat $g_curhost e1 conf get $b $n $p]]

    if { $vars == {} } {
        puts "\nNo E1 port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-7s %-7s %-5s %-8s %-8s %-12s %-10s %s" \
            Port Carrier Status Mode LineType Loopback ClockSource LineLength IdleCells]"

    foreach var $vars {
        set b [getItemValue $var -e1ConfBoard]
        set n [getItemValue $var -e1ConfModule]
        set p [getItemValue $var -e1ConfPort]
        AMIputs "[format "%-4s %-7s %-7s %-5s %-8s %-8s %-12s %-10s %s" \
                [$g_curhost convert bnptobnpstr $b $n $p]\
                [getCarrierState $b $n $p] \
                [hexValue [getItemValue $var -e1LineStatus]] \
                [convertMibConst \
                [getItemValue $var -e1LineTypeFraming] $g_e1LineTypeFraming] \
                [convertMibConst \
                [getItemValue $var -e1LineType] $g_e1LineType] \
                [convertMibConst \
                [getItemValue $var -e1LoopbackConfig] $g_e1Loopback] \
                [convertMibConst \
                [getItemValue $var -e1TxClockSource] $g_e1Timing] \
                [convertMibConst \
                [getItemValue $var -e1LineLength] $g_e1LineLength] \
                [getItemValue $var -e1IdleUnassignedCells]]"
    }
}




############################################################
#
# configurePortDS1Show: show DS1 port information
#
#
proc configurePortDS1Show { bnp } {
    global g_curhost g_ds1Loopback g_ds1Timing g_ds1LineType g_ds1LineLength
    global g_ds1LineTypeFraming

    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }
    set vars [queryList [concat $g_curhost ds1 conf get $b $n $p]]

    if { $vars == {} } {
        puts "\nNo DS1 port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-7s %-6s %-5s %-8s %-8s %-12s %-10s %s" \
            Port Carrier Status Mode Framing Loopback ClockSource LineLength IdleCells]"

    foreach var $vars {
        set b [getItemValue $var -ds1ConfBoard]
        set n [getItemValue $var -ds1ConfModule]
        set p [getItemValue $var -ds1ConfPort]
        AMIputs "[format "%-4s %-7s %-6s %-5s %-8s %-8s %-12s %-10s %s" \
                [$g_curhost convert bnptobnpstr $b $n $p]\
                [getCarrierState $b $n $p] \
                [hexValue [getItemValue $var -ds1LineStatus]] \
                [convertMibConst \
                [getItemValue $var -ds1LineTypeFraming] $g_ds1LineTypeFraming]\
                [convertMibConst \
                [getItemValue $var -ds1LineType] $g_ds1LineType] \
                [convertMibConst \
                [getItemValue $var -ds1LoopbackConfig] $g_ds1Loopback] \
                [convertMibConst \
                [getItemValue $var -ds1TxClockSource] $g_ds1Timing] \
                [convertMibConst \
                [getItemValue $var -ds1LineLength] $g_ds1LineLength] \
                [getItemValue $var -ds1IdleUnassignedCells]]"
    }
}




############################################################
#
# configurePortDS3Show: show DS3 port information
#
#
proc configurePortDS3Show { bnp } {
    global g_curhost g_ds3Loopback g_ds3Timing g_ds3LineType
    global g_ds3LineTypeFraming g_scrambling
    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }
    set vars [queryList [concat $g_curhost ds3 conf get $b $n $p]]

    if { $vars == {} } {
        puts "\nNo DS3 port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-7s %-6s %-4s %-8s %-8s %-12s %-10s %s" \
            Port Carrier Status Mode Framing Loopback ClockSource Scrambling IdleCells]"

    foreach var $vars {
        set b [getItemValue $var -ds3ConfBoard]
        set n [getItemValue $var -ds3ConfModule]
        set p [getItemValue $var -ds3ConfPort]
        AMIputs "[format "%-4s %-7s %-6s %-4s %-8s %-8s %-12s %-10s %s" \
                [$g_curhost convert bnptobnpstr $b $n $p]\
                [getCarrierState $b $n $p] \
                [hexValue [getItemValue $var -ds3LineStatus]] \
                [convertMibConst \
                [getItemValue $var -ds3LineTypeFraming] $g_ds3LineTypeFraming]\
                [convertMibConst \
                [getItemValue $var -ds3LineType] $g_ds3LineType] \
                [convertMibConst \
                [getItemValue $var -ds3LoopbackConfig] $g_ds3Loopback] \
                [convertMibConst \
                [getItemValue $var -ds3TxClockSource] $g_ds3Timing] \
                [convertMibConst \
                [getItemValue $var -ds3TxScrambling] $g_scrambling] \
                [getItemValue $var -ds3IdleUnassignedCells]]"
    }
}




############################################################
#
# configurePortJ2Show: show J2 port information
#
#
proc configurePortJ2Show { bnp } {
    global g_curhost g_j2LineLength g_j2Loopback g_j2Timing g_j2LineType
    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }
    set vars [queryList [concat $g_curhost j2 conf get $b $n $p]]

    if { $vars == {} } {
        puts "\nNo J2 port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-12s %-12s %-12s" \
            Port LineLength Loopback ClockSource]"

    foreach var $vars {
        AMIputs "[format "%-4s %-12s %-12s %-12s" \
                [$g_curhost convert bnptobnpstr \
                    [getItemValue $var -j2ConfBoard] \
                    [getItemValue $var -j2ConfModule] \
                    [getItemValue $var -j2ConfPort]] \
                [convertMibConst \
                [getItemValue $var -j2LineLength] $g_j2LineLength] \
                [convertMibConst \
                [getItemValue $var -j2LoopbackConfig] $g_j2Loopback] \
                [convertMibConst \
                [getItemValue $var -j2TxClockSource] $g_j2Timing]]"
    }
}




############################################################
#
# configurePortSONETShow: show SONET port information
#
#
proc configurePortSONETShow { bnp } {
    global g_curhost g_sonetLoopback g_scrambling g_sonetTiming g_sonetLineType
    global g_sonetLineTypeFraming
    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }
    set vars [queryList [concat $g_curhost sonet conf get $b $n $p]]

    if { $vars == {} } {
        puts "\nNo SONET port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-6s %-7s %-6s %-4s %-5s %-8s %-12s %-7s %s" \
           Port Width Carrier Status Line Mode Loopback ClockSource Scramb. IdleCells]"

    foreach var $vars {
        set b [getItemValue $var -sonetConfBoard]
        set n [getItemValue $var -sonetConfModule]
        set p [getItemValue $var -sonetConfPort]
        AMIputs "[format "%-4s %-6s %-7s %-6s %-4s %-5s %-8s %-12s %-7s %s" \
                [$g_curhost convert bnptobnpstr $b $n $p] \
                [getItemValue $var -sonetPathWidth] \
                [getCarrierState $b $n $p] \
                [hexValue [getItemValue $var -sonetLineStatus]] \
                [convertMibConst \
                [getItemValue $var -sonetLineType] $g_sonetLineType] \
                [convertMibConst [getItemValue \
                $var -sonetFramingStandardOper] $g_sonetLineTypeFraming] \
                [convertMibConst \
                [getItemValue $var -sonetLoopbackConfig] $g_sonetLoopback] \
                [convertMibConst \
                [getItemValue $var -sonetTxClockSource] $g_sonetTiming] \
                [convertMibConst \
                [getItemValue $var -sonetTxScrambling] $g_scrambling] \
                [getItemValue $var -sonetIdleUnassignedCells]]"
    }
}



############################################################
#
# configurePortTaxiShow: show TAXI port information
#
#
proc configurePortTaxiShow { bnp } {
    global g_curhost g_taxiLoopback g_taxiPortModels
    set b {}
    set n {}
    set p {}
    if { $bnp != {} } {
        set b_n_p [$g_curhost convert bnpstrtobnp $bnp]
        set b [lindex $b_n_p 0]
        set n [lindex $b_n_p 1]
        set p [lindex $b_n_p 2]
    }

    set hwvars [queryList [concat $g_curhost hwport get $b $n $p]]
    set vars {}

    foreach var $hwvars {
        set portModel [getItemValue $var -hwPortModel]
        if { [lsearch $g_taxiPortModels $portModel] >= 0 } {
            lappend vars $var
        }
    }

    if { $vars == {} } {
        puts "\nNo TAXI port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s %-10s %-10s %-5s %-7s %-10s %s" \
            Port Carrier State Obuf Version Loopback Model]"

    foreach var $vars {
        set b [getItemValue $var -hwPortBoard]
        set n [getItemValue $var -hwPortModule]
        set p [getItemValue $var -hwPortNumber]
        set version [getItemValue $var -hwPortVersion]
        if { [string first "generation-" $version] >= 0 } {
            set version [string range $version 11 end]
        }
        AMIputs "[format "%-4s %-10s %-10s %-5s %-7s %-10s %s" \
                [portToBNPstr [getItemValue $var -hwPortGlobalIndex]] \
                [getCarrierState $b $n $p] \
                [getItemValue $var -hwPortOperStatus] \
                [getItemValue $var -hwPortBufferSize] \
                $version \
                [convertMibConst \
                  [getItemValue $var -hwPortTAXILoopback] $g_taxiLoopback] \
                [$g_curhost module get \
                    [getItemValue $var -hwPortBoard] \
                    [getItemValue $var -hwPortModule] -moduleName]]"
    }
}




############################################################
#
# configureVpcShow: show virtual paths
#
proc configureVpcShow { bnp vpi } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    if { [catch { set indexlist [queryList \
            [concat $g_curhost path list $port $vpi]] } result] != 0 } {
        set indexlist {}
    }

    set totalpaths [llength $indexlist]

    initAMIputs
    AMIputs "\n Input      Output"
    AMIputs "[format " %-4s %4s  %-4s %4s  %6s %-9s %-6s %6s %10s %s" \
            Port VPI Port VPI Mb/s Uptime NumVCs BW Cells Protocol]"

    foreach index $indexlist {
        if { [catch { set var \
                [eval [concat $g_curhost path get $index]] } result] } {
            continue
        }
        if { $var == {} } { continue }
        set cells [getItemValue $var -pathCells]
        if { $cells > 1000000 } { set cells "[megaUnits $cells]M" }
        if { [getItemValue $var -pathStatus] != "valid" } { 
            set status "*" 
        } else {
            set status ""
        }
        AMIputs "[format "%1s%-4s %4s  terminate  %6s %-9s %6s %6s %10s %s" \
                $status [portToBNPstr [getItemValue $var -pathPort]] \
                [getItemValue $var -pathVPI] \
                [cellsToMbs [getItemValue $var -pathMaxBandwidth]] \
                [timeString [getItemValue $var -pathUptime]] \
                [getItemValue $var -pathNumChannels] \
                [cellsToMbs [getItemValue $var -pathAllocBandwidth]] \
                $cells \
                [getItemValue $var -pathSigProtocol]]"
    }

    if { [catch { set indexlist [queryList \
            [concat $g_curhost opath list $port $vpi]] } result] != 0 } {
        set indexlist {}
    }

    set totalpaths [expr $totalpaths + [llength $indexlist]]

    foreach index $indexlist {
        if { [catch { set var \
                [eval [concat $g_curhost opath get $index]] } result] } {
            continue
        }
        if { $var == {} } { continue }
        set cells [getItemValue $var -opathCells]
        if { $cells > 1000000 } { set cells "[megaUnits $cells]M" }
        if { [getItemValue $var -opathStatus] != "valid" } { 
            set status "*" 
        } else {
            set status ""
        }
        AMIputs "[format "%1soriginate  %-4s %4s  %6s %-9s %6s %6s %10s %s" \
                $status [portToBNPstr [getItemValue $var -opathPort]] \
                [getItemValue $var -opathVPI] \
                [cellsToMbs [getItemValue $var -opathMaxBandwidth]] \
                [timeString [getItemValue $var -opathUptime]] \
                [getItemValue $var -opathNumChannels] \
                [cellsToMbs [getItemValue $var -opathAllocBandwidth]] \
                $cells \
                [getItemValue $var -opathSigProtocol]]"
    }


    if { [catch { set indexlist [queryList \
            [concat $g_curhost pathroute list $port $vpi]] } result] != 0 } {
        set indexlist {}
    }

    set totalpaths [expr $totalpaths + [llength $indexlist]]

    foreach index $indexlist {
        if { [catch { set var \
                [eval [concat $g_curhost pathroute get $index]] } result] } {
            continue
        }
        if { $var == {} } { continue }
        set cells [getItemValue $var -pathrCells]
        if { $cells > 1000000 } { set cells "[megaUnits $cells]M" }
        if { [getItemValue $var -pathrStatus] != "valid" } { 
            set status "*" 
        } else {
            set status ""
        }
        AMIputs "[format "%1s%-4s %-4s  %-4s %4s  %6s %-9s %6s %6s %10s %s" \
                $status [portToBNPstr [getItemValue $var -pathrInputPort]] \
                [getItemValue $var -pathrInputVPI] \
                [portToBNPstr [getItemValue $var -pathrOutputPort]] \
                [getItemValue $var -pathrOutputVPI] \
                [cellsToMbs [getItemValue $var -pathrMaxBandwidth]] \
                [timeString [getItemValue $var -pathrUptime]] \
                "N/A" \
                [cellsToMbs [getItemValue $var -pathrAllocBandwidth]] \
                $cells \
                [getItemValue $var -pathrSigProtocol]]"
    }

    if { $totalpaths <= 0 } {
        puts "\nNo virtual path information is available"
        return
    }
}



############################################################
#
# configureVpcModify: modify path parameters
#
#
proc configureVpcModify { bnp vpi type peak } {
    global g_curhost
    set port [$g_curhost convert bnpstrtoport $bnp]

    set peak [expr (($peak * 1000) / 8 / 53)]

    switch $type {
        "term" { $g_curhost path set $port $vpi -pathAllocBandwidth $peak }
        "orig" { $g_curhost opath set $port $vpi -opathAllocBandwidth $peak }
    }
}


############################################################
#
# configureVpcNew: create a virtual path
#
proc configureVpcNew { ibnp ivpi obnp ovpi maxvcs peak sustained burst type } {
    global g_curhost
    set iport [$g_curhost convert bnpstrtoport $ibnp]
    if { $peak != {} } { set peak "-bw $peak" }
    if { $type != {} } {
        if { $obnp != {} } {
            EMSG "Output port conflicts with $type"
            return {}
        }
        if { $maxvcs != {} } { set maxvcs "-maxvci $maxvcs" }
        set otherside {}
        switch $type {
            term { eval [concat \
                    $g_curhost path create $iport $ivpi $peak $maxvcs] 
                   catch { set otherside \
                        [$g_curhost opath list $iport $ivpi] } result
                   if { $otherside != {} } { return }
                   set otherside "orig"
            }
            orig { eval [concat \
                    $g_curhost opath create $iport $ivpi $peak $maxvcs] 
                   catch { set otherside \
                        [$g_curhost path list $iport $ivpi] } result
                   if { $otherside != {} } { return }
                   set otherside "term"
            }
        }
        set prompt [format \
                "Would you like to create the %sinating side also" $otherside]
        if { ![yesorno $prompt "y"] } {
            return
        }
        switch $otherside {
            term { eval [concat \
                    $g_curhost path create $iport $ivpi $peak $maxvcs] 
            }
            orig { eval [concat \
                    $g_curhost opath create $iport $ivpi $peak $maxvcs] 
            }
        }
    } else {
        if { $obnp == {} || $ovpi == {} } {
            EMSG "Output BNP and VPI or term/orig option must be specified"
            return {}
        }
        set oport [$g_curhost convert bnpstrtoport $obnp]
        eval [concat $g_curhost \
                pathroute create $iport $ivpi $oport $ovpi $peak]
    }
}



############################################################
#
# configureVpcDelete: delete a virtual path
#
proc configureVpcDelete { ibnp ivpi obnp ovpi type } {
    global g_curhost
    set iport [$g_curhost convert bnpstrtoport $ibnp]

    if { $type != {} } {
        if { $obnp != {} } {
            EMSG "Output port conflicts with $type"
            return {}
        }
        set otherside {}
        switch $type {
            term { 
                eval [concat $g_curhost path remove $iport $ivpi] 
                catch { set otherside \
                        [$g_curhost opath list $iport $ivpi] } result
                set otype "orig"
            }
            orig { 
                eval [concat $g_curhost opath remove $iport $ivpi]
                catch { set otherside \
                        [$g_curhost path list $iport $ivpi] } result
                set otype "term"
            }
        }
        if { $otherside != {} } {
            set prompt [format \
                    "Would you like to delete the %sinating side also" $otype]
            if { ![yesorno $prompt "y"] } { 
                return
            }
            switch $otype {
                term { eval [concat $g_curhost path remove $iport $ivpi] }
                orig { eval [concat $g_curhost opath remove $iport $ivpi] }
            }
        }
    } else {
        if { $obnp == {} || $ovpi == {} } {
            EMSG "Output BNP and VPI or term/orig option must be specified"
            return {}
        }
        set oport [$g_curhost convert bnpstrtoport $obnp]
        eval [concat $g_curhost pathroute remove $iport $ivpi $oport $ovpi]
    }
}



############################################################
#
# configureVccShow: show virtual channels
#
proc configureVccShow { bnp vpi vci } {
    global g_curhost g_switch_type
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    set indexlist [queryList [concat $g_curhost channel list $port $vpi $vci]]

    if { $indexlist == {} } {
        puts "\nNo virtual channel information is available"
        return
    }

    initAMIputs
    AMIputs "\n Input        Output"
    AMIputs "[format " %-4s %3s %3s %-4s %3s %3s %-8s %6s %7s %8s %-8s %s" \
            Port VPI VCI Port VPI VCI Uptime BW Cells CDVT Policing Protocol]"

    foreach index $indexlist {
        if { [catch { set var \
                [eval [concat $g_curhost channel get $index]] } result] } {
            continue
        }
        if { $var == {} } { continue }
        set cells [getItemValue $var -chanCells]
        if { $cells > 1000000 } { set cells "[megaUnits $cells]M" }

        if { $g_switch_type == "asx100" } {
            set 200vars {}
        } else {
            set 200vars "-chanCDV [getItemValue $var -chanCDV] \
                    -chanPolicingAction \
                    [getItemValue $var -chanPolicingAction]"
        }

        catch { set ovars \
                [queryList [concat $g_curhost chanroute get $index]] } result

        foreach ovar $ovars {
            if { [getItemValue $var -chanStatus] != "valid" || \
                    [getItemValue $ovar -chanrStatus] != "valid" } { 
                set status "*" 
            } else {
                set status ""
            }
	    if { [getItemValue $var -chanSigProtocol] == "q2931" } {
		set protocol "uni30"
	    } else {
		set protocol [getItemValue $var -chanSigProtocol]
	    }
            AMIputs "[format \
                    "%1s%-4s %3s %3s %-4s %3s %3s %-8s %6s %7s %8s %-8s %s" \
                    $status [portToBNPstr [getItemValue $var -chanPort]] \
                    [getItemValue $var -chanVPI] \
                    [getItemValue $var -chanVCI] \
                    [portToBNPstr [getItemValue $ovar -chanrOutputPort]] \
                    [getItemValue $ovar -chanrOutputVPI] \
                    [getItemValue $ovar -chanrOutputVCI] \
                    [timeString [getItemValue $var -chanUptime]] \
                    [cellsToMbs [getItemValue $var -chanAllocBandwidth]] \
                    $cells \
                    [getItemValue $200vars -chanCDV] \
                    [getItemValue $200vars -chanPolicingAction] \
		    $protocol]"
        }
    }
}



############################################################
#
# configureVccModify: modify channel parameters
#
#
proc configureVccModify { bnp vpi vci peak } {
    global g_curhost
    set port [$g_curhost convert bnpstrtoport $bnp]

    set peak [expr (($peak * 1000) / 8 / 53)]

    $g_curhost channel set $port $vpi $vci -chanAllocBandwidth $peak
}



############################################################
#
# configureVccNew: create a virtual channel
#
proc configureVccNew { ibnp ivpi ivci obnp ovpi ovci \
                  peak sustained burst cdvt } {
    global g_curhost g_switch_type
    set iport [$g_curhost convert bnpstrtoport $ibnp]
    set oport [$g_curhost convert bnpstrtoport $obnp]

    if { $peak != {} } { set peak "-bw $peak" }
    if { $cdvt != {} } {
        if { $g_switch_type == "asx100" } {
            puts "\nCDVT is not supported on ASX-100s"
            return
        }
    }
    if { $cdvt != {} } { set cdvt "-cdvt $cdvt" }

    eval [concat $g_curhost channel create \
            $iport $ivpi $ivci $oport $ovpi $ovci $peak $cdvt]
}



############################################################
#
# configureVccDelete: delete a virtual channel
#
proc configureVccDelete { ibnp ivpi ivci obnp ovpi ovci } {
    global g_curhost
    set iport [$g_curhost convert bnpstrtoport $ibnp]
    set oport [$g_curhost convert bnpstrtoport $obnp]

    eval [concat $g_curhost channel remove \
            $iport $ivpi $ivci $oport $ovpi $ovci]
}



############################################################
#
# SPVC support functions
#

proc fixSpvcAddr { addr } {
    if { [string range $addr 0 5] != "000000" } {
        set addr [format "00000000%s" [string range $addr 0 7]]
    } else {
        set addr [format "00000000%s" [string range $addr 8 15]]
    }
    return $addr
}

proc spvcAddrToSession { peerlist addr } {
    set index [lsearch $peerlist $addr]
    if { $index > 0 } {
        return [lindex $peerlist [expr $index - 1]]
    }
    return $addr
}


proc getSpvcSrcInfo { srcid } {
    global g_curhost g_peerlist
    set spvc [$g_curhost spvcsrc get $srcid]
    set destid [getItemValue $spvc -spvcSrcDestSpvcId]
    set destsw [fixSpvcAddr [getItemValue $spvc -spvcSrcDestSwitchAddr]]
    set destsession [spvcAddrToSession $g_peerlist $destsw]
    set destport "N/A"
    set destVPI "N/A"
    set destVCI "N/A"
    set destBNP "N/A"
    if { $destsession != $destsw } {
        if {![catch { set destinfo [$destsession spvcdest get $destid] } rc]} {
            set destport [getItemValue $destinfo -spvcDestOutPort]
            set destBNP [$destsession convert porttobnpstr $destport]
            set destVPI  [getItemValue $destinfo -spvcDestOutVPI]
            set destVCI  [getItemValue $destinfo -spvcDestOutVCI]
        }
    }
    set spvc [concat $spvc \
            "-spvcDestSession $destsession" \
            "-spvcDestOutPort $destport" \
            "-spvcDestOutBNP $destBNP" \
            "-spvcDestOutVPI $destVPI" \
            "-spvcDestOutVCI $destVCI"]

    return $spvc
}

proc getSpvcDestInfo { destid } {
    global g_curhost global g_peerlist
    set spvc [$g_curhost spvcdest get $destid]
    set srcid [getItemValue $spvc -spvcDestSrcSpvcId]
    set srcsw [fixSpvcAddr [getItemValue $spvc -spvcDestSrcSwitchAddr]]
    set srcsession [spvcAddrToSession $g_peerlist $srcsw]
    set srcport "N/A"
    set srcVPI "N/A"
    set srcVCI "N/A"
    set srcBNP "N/A"
    if { $srcsession != $srcsw } {
        if {![catch { set srcinfo [$srcsession spvcsrc get $srcid] } rc]} {
            set srcport [getItemValue $srcinfo -spvcSrcInPort]
            set srcBNP [$srcsession convert porttobnpstr $srcport]
            set srcVPI  [getItemValue $srcinfo -spvcSrcInVPI]
            set srcVCI  [getItemValue $srcinfo -spvcSrcInVCI]
        }
    }
    set spvc [concat $spvc \
            "-spvcSrcSession $srcsession" \
            "-spvcSrcInPort $srcport" \
            "-spvcSrcInBNP $srcBNP" \
            "-spvcSrcInVPI $srcVPI" \
            "-spvcSrcInVCI $srcVCI"]

    return $spvc
}


proc bidirectionalSpvc { src dest } {
    set destsession [getItemValue $src -spvcDestSession]
    if { $destsession == [fixSpvcAddr \
            [getItemValue $src -spvcSrcDestSwitchAddr]] } { return 0 }
    set srcsession [getItemValue $dest -spvcSrcSession]
    if { $srcsession == [fixSpvcAddr \
            [getItemValue $dest -spvcDestSrcSwitchAddr]] } { return 0 }
    if { $destsession != $srcsession } { return 0 }

    if { [getItemValue $src -spvcDestOutPort] == "N/A" } { return 0 }
    if { [getItemValue $dest -spvcSrcInPort] == "N/A" } { return 0 }
    if { [getItemValue $src -spvcSrcInPort] != \
            [getItemValue $dest -spvcDestOutPort] } { return 0 }
    if { [getItemValue $src -spvcDestOutPort] != \
            [getItemValue $dest -spvcSrcInPort] } { return 0 }

    if { [getItemValue $src -spvcSrcInVPI] != \
            [getItemValue $dest -spvcDestOutVPI] } { return 0 }
    if { [getItemValue $src -spvcDestOutVPI] != \
            [getItemValue $dest -spvcSrcInVPI] } { return 0 }

    if { [getItemValue $src -spvcSrcInVCI] != \
            [getItemValue $dest -spvcDestOutVCI] } { return 0 }
    if { [getItemValue $src -spvcDestOutVCI] != \
            [getItemValue $dest -spvcSrcInVCI] } { return 0 }

    return 1
}

proc createPeerList {} {
    global g_curhost g_sessions g_peerlist

    if { $g_peerlist != {} } { return }

    for { set i 1 } { $i <= 4 } { incr i } {
        if { $g_sessions($i) != {} } {
            set session [lindex $g_sessions($i) 0]
            if { [catch { set swaddr [$session \
                    switch get 0 -atmAddress] } result] } {
                EMSG "Unable to get ATM address for $session"
                continue
            }
            set swaddr [fixSpvcAddr $swaddr]
            set g_peerlist [concat $g_peerlist "$session $swaddr"]
        }
    }
}


############################################################
#
# configureSpvcShow: display SPVC information
#
proc configureSpvcShow {} {
    global g_curhost
    set spvcsrclist [$g_curhost spvcsrc list]
    set spvcdestlist [$g_curhost spvcdest list]

    if { $spvcsrclist == {} && $spvcdestlist == {} } {
        puts "\nNo SPVC information is available"
        return
    }

    createPeerList

    initAMIputs
    AMIputs "\n Local                                    Remote"
    AMIputs "[format " %-5s %-4s %3s %3s %6s %-14s %-5s %-4s %3s %3s %s" \
            ID Port VPI VCI BW Direction ID Port VPI VCI Switch]"

    set destspvcs {}
    set skipdestids {}
    foreach destid $spvcdestlist {
        # scan all destination first to match up bidirectional SPVCs
        set destspvcs [lappend destspvcs [getSpvcDestInfo $destid]]
    }

    foreach srcid $spvcsrclist {
        set spvc [getSpvcSrcInfo $srcid]
        set direction "source"
        foreach destspvc $destspvcs {
            if { [bidirectionalSpvc $spvc $destspvc] } {
                set direction "bidirectional"
                set skipdestids [concat $skipdestids \
                        [getItemValue $destspvc -spvcDestSpvcId]]
                break
            }
        }
        AMIputs "[format " %-5s %-4s %3s %3s %6s %-14s %-5s %-4s %3s %3s %s"\
                $srcid \
                [portToBNPstr [getItemValue $spvc -spvcSrcInPort]] \
                [getItemValue $spvc -spvcSrcInVPI] \
                [getItemValue $spvc -spvcSrcInVCI] \
                [cellsToMbs [getItemValue $spvc -spvcSrcAllocBandwidth]] \
                $direction \
                [getItemValue $spvc -spvcSrcDestSpvcId] \
                [getItemValue $spvc -spvcDestOutBNP] \
                [getItemValue $spvc -spvcDestOutVPI] \
                [getItemValue $spvc -spvcDestOutVCI] \
                [getItemValue $spvc -spvcDestSession]]"
    }

    foreach spvc $destspvcs {
        set destid [getItemValue $spvc -spvcDestSpvcId]
        if { [lsearch $skipdestids $destid] >= 0 } { continue }
        AMIputs "[format " %-5s %-4s %3s %3s %6s %-14s %-5s %-4s %3s %3s %s"\
                $destid \
                [portToBNPstr [getItemValue $spvc -spvcDestOutPort]] \
                [getItemValue $spvc -spvcDestOutVPI] \
                [getItemValue $spvc -spvcDestOutVCI] \
                [cellsToMbs [getItemValue $spvc -spvcDestAllocBandwidth]] \
                destination \
                [getItemValue $spvc -spvcDestSrcSpvcId] \
                [getItemValue $spvc -spvcSrcInBNP] \
                [getItemValue $spvc -spvcSrcInVPI] \
                [getItemValue $spvc -spvcSrcInVCI] \
                [getItemValue $spvc -spvcSrcSession]]"
    }
}


############################################################
#
# configureSpvcNew: Create an SPVC
#
proc configureSpvcNew { port vpi vci dest destport destvpi destvci peak dir } {
    global g_curhost g_peerlist

    createPeerList

    if { [lsearch $g_peerlist $dest] < 0 } {
        EMSG "The destination session '$dest' is invalid"
        return
    }

    if { $peak != {} } { set peak "-peak $peak" }
    if { $dir == {} } { set dir "bidirectional" }
    set port [$g_curhost convert bnpstrtoport $port]
    set destport [$dest convert bnpstrtoport $destport]
    switch $dir {
        "source" {
            eval [concat $g_curhost spvc create $port $vpi $vci \
                    $dest $destport $destvpi $destvci $peak]
        }
        "destination" {
            eval [concat $dest spvc create $destport $destvpi $destvci \
                    $g_curhost $port $vpi $vci $peak]
        }
        "bidirectional" {
            eval [concat $g_curhost spvc create $port $vpi $vci \
                    $dest $destport $destvpi $destvci $peak]
            eval [concat $dest spvc create $destport $destvpi $destvci \
                    $g_curhost $port $vpi $vci $peak]
        }
    }
}


############################################################
#
# configureSpvcDelete: Remove an SPVC
#
proc configureSpvcDelete { port vpi vci dest destport destvpi destvci dir } {
    global g_curhost g_peerlist

    createPeerList

    if { $dest != {} } {
        if { [lsearch $g_peerlist $dest] < 0 } {
            EMSG "The destination session '$dest' is invalid"
            return
        }
    }

    if { $dir == {} } { set dir "bidirectional" }

    if { $vpi == {} } {
        switch $dir {
            "source" { 
                set spvc [getSpvcSrcInfo $port]
                set dest [getItemValue $spvc -spvcDestSession]
                $g_curhost spvcsrc set $port -spvcSrcEntryStatus invalid 
                if { [getItemValue $spvc -spvcSrcDestSwitchAddr] != $dest } {
		    set destid [getItemValue $spvc -spvcSrcDestSpvcId]
		    if { ![catch { $dest spvcdest get $destid \
			    -spvcDestEntryStatus } ck] } { 
			$dest spvcdest set $destid -spvcDestEntryStatus invalid
		    }
                }
                return
            }
            "destination" { 
                set spvc [getSpvcDestInfo $port]
                set dest [getItemValue $spvc -spvcSrcSession] 
                $g_curhost spvcdest set $port -spvcDestEntryStatus invalid 
                if { [getItemValue $spvc -spvcDestSrcSwitchAddr] != $dest } {
		    set srcid [getItemValue $spvc -spvcDestSrcSpvcId]
		    if { ![catch { $dest spvcsrc get $srcid \
			    -spvcSrcEntryStatus } ck] } {
			$dest spvcsrc set $srcid -spvcSrcEntryStatus invalid
		    }
		}
                return
            }
            "bidirectional" {
                set spvc [getSpvcSrcInfo $port]
                if { [getItemValue $spvc -spvcSrcDestSwitchAddr] == \
                        [getItemValue $spvc -spvcDestSession] } {
                    EMSG "Can not find an open session for this SPVC"
                    return
                } else {
                    set port [getItemValue $spvc -spvcSrcInPort]
                    set vpi [getItemValue $spvc -spvcSrcInVPI]
                    set vci [getItemValue $spvc -spvcSrcInVCI]
                    set dest [getItemValue $spvc -spvcDestSession]
                    set destport [getItemValue $spvc -spvcDestOutPort]
                    set destvpi [getItemValue $spvc -spvcDestOutVPI]
                    set destvci [getItemValue $spvc -spvcDestOutVCI]
                }
            }
        }
    } else {
        set port [$g_curhost convert bnpstrtoport $port] 
        set destport [$dest convert bnpstrtoport $destport] 
    }

    switch $dir {
        "source" {
            $g_curhost spvc remove $port $vpi $vci \
                    $dest $destport $destvpi $destvci
        }
        "destination" {
            $dest spvc remove $destport $destvpi $destvci \
                    $g_curhost $port $vpi $vci
        }
        "bidirectional" {
            $g_curhost spvc remove $port $vpi $vci \
                    $dest $destport $destvpi $destvci
            $dest spvc remove $destport $destvpi $destvci \
                    $g_curhost $port $vpi $vci
        }
    }
}



############################################################
#
# configureIpShow: show IP configuration
#
#
proc configureIpShow { iface } {
    global g_curhost;
    set iplist [$g_curhost ipaddr get]
    set iflist [$g_curhost if get -ifDescr -ifOperStatus]

    if { $iplist == {} || $iflist == {} } {
        puts "\nNo IP information is available"
        return
    }

    if { $iface != {} } {
        foreach if $iflist {
            if { [getItemValue $if -ifDescr] == $iface } { break }
        }
        if { [getItemValue $if -ifDescr] != $iface } { 
            EMSG "Interface \"$iface\" does not exist"
            return
        }
    }

    initAMIputs
    AMIputs "\ninterface  state\taddress\t\tnetmask\t\tbroadcast"

    foreach if $iflist {
        set ifdescr [getItemValue $if -ifDescr]
        set ifindex [getItemValue $if -ifIndex]
        if { $iface != {} && $iface != $ifdescr } { continue }

        puts -nonewline \
                "$ifdescr\t   [getItemValue $if -ifOperStatus]\t\t"

        foreach ip $iplist {
            set ifnum [getItemValue $ip -ipAdEntIfIndex]
            if { $ifnum != $ifindex } { continue }

            set addr [getItemValue $ip -ipAdEntAddr]
            puts -nonewline "[format "%-15s " $addr]"
            set mask [getItemValue $ip -ipAdEntNetMask]
            puts -nonewline "[format "%-15s " $mask]"

            regexp -- {^([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)$} \
                    $addr match a1 a2 a3 a4
            regexp -- {^([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)$} \
                    $mask match m1 m2 m3 m4

            if { [getItemValue $ip -ipAdEntBcastAddr] == 1 } {
                puts -nonewline "[format "%d.%d.%d.%d" \
                        [expr ($a1 & $m1) | (255 & ~$m1)] \
                        [expr ($a2 & $m2) | (255 & ~$m2)] \
                        [expr ($a3 & $m3) | (255 & ~$m3)] \
                        [expr ($a4 & $m4) | (255 & ~$m4)]]"
            } else {
                puts -nonewline "[format "%d.%d.%d.%d" [expr $a1 & $m1] \
                        [expr $a2 & $m2] [expr $a3 & $m3] [expr $a4 & $m4]]"
            }
            break
        }
        AMIputs {}
    }

    AMIputs "\nIP Forwarding State: [$g_curhost ip get -ipForwarding]"
}



############################################################
#
# getInterfaceNumber: get interface number from its name
#
#
proc getInterfaceNumber { ifname } {
    global g_curhost
    set iflist [$g_curhost if get -ifDescr]
    foreach ifitem $iflist {
        if { [getItemValue $ifitem -ifDescr] == $ifname } {
            return [getItemValue $ifitem -ifIndex]
        }
    }
    return 0
}



############################################################
#
# getInterfaceAddress: get interface ip address
#
#
proc getInterfaceAddress { ifname } {
    global g_curhost
    set ifnum [getInterfaceNumber $ifname]
    if { $ifnum > 0 } {
        set iplist [$g_curhost ipaddr get -ipAdEntIfIndex]
        foreach ip $iplist {
            if { [getItemValue $ip -ipAdEntIfIndex] == $ifnum } {
                return [getItemValue $ip -ipAdEntAddr]
            }
        }
    }
    return {}
}    



############################################################
#
# configureIpAdmin: force the interface up/down
#
#
proc configureIpAdmin { ifce state } {
    global g_curhost
    set ifnum [getInterfaceNumber $ifce]
    if { $ifnum <= 0 } {
        EMSG "No such interface"
        return
    }
    $g_curhost if set $ifnum -ifAdminStatus $state
}



############################################################
#
# configureIpAddress: Set address for this interface
#
#
proc configureIpAddress { ifce address } {
    global g_curhost
    set ifnum [getInterfaceNumber $ifce]
    if { $ifnum <= 0 } {
        EMSG "No such interface"
        return
    }
    $g_curhost ipaddr set $address -ipAdEntIfIndex $ifnum
}



############################################################
#
# configureIpMask: Set network mask for this interface
#
#
proc configureIpMask { ifce mask } {
    global g_curhost
    set ipaddress [getInterfaceAddress $ifce]
    if { [llength $ipaddress] > 0 } {
        $g_curhost ipaddr set $ipaddress -ipAdEntNetMask $mask
        return
    }
    return "Interface not found"
}



############################################################
#
# configureIpBroadcast: Set broadcast address for this interface
#
#
proc configureIpBroadcast { ifce bcast } {
    global g_curhost
    set ipaddress [getInterfaceAddress $ifce]
    if { [llength $ipaddress] > 0 } {
        $g_curhost ipaddr set $ipaddress -ipAdEntBcastAddr $bcast
        return
    }
    return "Interface not found"
}



############################################################
#
# configureIpRouteShow: show IP routing table
#
#
proc configureIpRouteShow {} {
    global g_curhost
    set rtlist [$g_curhost iproute get \
            -ipRouteDest -ipRouteIfIndex -ipRouteNextHop -ipRouteMetric1]

    if { $rtlist == {} } {
        puts "\nNo routing information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-20s %-20s %-15s %-15s" \
            Destination Gateway Metric Interface]"
    foreach rt $rtlist {
        set dest [getItemValue $rt -ipRouteDest]
        if { $dest == "0.0.0.0" } { set dest "default" }
        AMIputs "[format "%-20s %-20s %-15s %-15s" $dest \
                [getItemValue $rt -ipRouteNextHop] \
                [getItemValue $rt -ipRouteMetric1] \
                [$g_curhost if get [getItemValue $rt -ipRouteIfIndex] -ifDescr]]"
    }
}



############################################################
#
# configureIpForwarding: set ip forwarding
#
#
proc configureIpForwarding { state } {
    global g_curhost
    if { $state == "on" } {
        set state "forwarding"
    } else {
        set state "not-forwarding"
    }
    $g_curhost ip set -ipForwarding $state
}


############################################################
#
# configureIpRouteAdd: Add a route
#
#
proc configureIpRouteAdd { dest gate metric } {
    global g_curhost
    if { $dest == "default" } {
        set dest "0.0.0.0"
    }
    $g_curhost iproute set $dest -ipRouteNextHop $gate
    # assume indirect
    set route_type 4 
    if { $metric != {} } { 
        if { $metric == 0 } {
            # set to direct
            set route_type 3 
        }
    }
    $g_curhost iproute set $dest -ipRouteType $route_type
}


############################################################
#
# configureIpRouteDelete: remote a route
#
#
proc configureIpRouteDelete { dest gate } {
    global g_curhost
    if { $dest == "default" } {
        set dest "0.0.0.0"
    }
    $g_curhost iproute set $dest -ipRouteType 2
}



############################################################
#
# configureSnmpTrapShow: list trap destinations
#
#
proc configureSnmpTrapShow {} {
    global g_curhost
    set traps [$g_curhost trap list]

    if { $traps == {} } {
        puts "\nNo trap information is available"
        return
    }

    initAMIputs
    AMIputs "\nTrap\tDestination"

    set i 0

    foreach trap $traps {
        incr i
        AMIputs "$i\t$trap"
    }
}


############################################################
#
# configureSnmpTrapDelete: delete trap destinations
#
#
proc configureSnmpTrapDelete { trap } {
    global g_curhost
    set traps [$g_curhost trap list]

    incr trap -1

    if { [lindex $traps $trap] == {} } {
        EMSG "Trap number $trap does not exist"
    } else {
        $g_curhost trap remove [lindex $traps $trap]
    }
}



############################################################
#
# configureSpansShow: show SPANS information
#
#
proc configureSpansShow { bnp vpi } {
    global g_curhost g_switch_type
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    set vars [queryList [concat $g_curhost sigpath get $port $vpi]]

    if { $vars == {} } {
        puts "\nNo SPANS signalling information is available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-4s %5s %5s %5s %7s %-5s %9s %-8s %-4s %-15s" \
            Port VPI Sig Cls AAL State CDVT Policing Type RemoteAddress]"

    foreach var $vars {
        set aaltype [getItemValue $var -sigPathAALType]
        switch $aaltype {
            "type34" { set aaltype 4 }
            "type5" { set aaltype 5 }
        }
        set remote_addr [getItemValue $var -sigPathRemoteIpAddress]
        if { $remote_addr == "255.255.255.255" } { 
            set remote_addr {} 
#       } else {
#           set remote_name [gethostbyaddr $remote_addr]
#           if { $remote_name != {} } { set remote_addr $remote_name }
        }
        if { [getItemValue $var -sigPathEntryStatus] != "valid" } {
            set status "*"
        } else {
            set status ""
        }
        if { $g_switch_type != "asx100" } {
            set 200vars "-sigPathCDV [getItemValue $var -sigPathCDV] \
                    -sigPathPolicingAction \
                    [getItemValue $var -sigPathPolicingAction]"
        } else {
            set 200vars {}
        }
        AMIputs "[format "%1s%-4s %5s %5s %5s %7s %-5s %9s %-8s %-4s %-15s" \
                $status [portToBNPstr [getItemValue $var -sigPathPort]] \
                [getItemValue $var -sigPathVPI] \
                [getItemValue $var -sigPathVCI] \
                [getItemValue $var -sigPathClsVCI] \
                $aaltype \
                [getItemValue $var -sigPathOperStatus] \
                [getItemValue $200vars -sigPathCDV] \
                [getItemValue $200vars -sigPathPolicingAction] \
                [getItemValue $var -sigPathType] \
                $remote_addr]"
    }
}



############################################################
#
# configureSpansNew: create a SPANS sigpath
#
#
proc configureSpansNew { bnp vpi sig cls aal cdvt policing } {
    global g_curhost g_switch_type
    set port [$g_curhost convert bnpstrtoport $bnp]
    if { $sig != {} } { set sig "-sig $sig" }
    if { $cls != {} } { set cls "-cls $cls" }
    if { $aal != {} } { 
        switch $aal {
            "4" { set aal "-aal type34" }
            "5" { set aal "-aal type5" }
            default { set aal "-aal $aal" }
        }
    }
    if { $cdvt != {} || $policing != {} } {
        if { $g_switch_type == "asx100" } {
            puts "\nCDVT and Policing is not supported on ASX-100s"
            return
        }
    }
    if { $cdvt != {} } { set cdvt "-cdvt $cdvt" }
    if { $policing != {} } { set policing "-policing $policing" }
    eval [concat $g_curhost \
            spans create $port $vpi $sig $cls $aal $cdvt $policing]
}


############################################################
#
# configureSpansDelete: delete a SPANS sigpath
#
#
proc configureSpansDelete { bnp vpi } {
    global g_curhost
    set port [$g_curhost convert bnpstrtoport $bnp]

    $g_curhost spans remove $port $vpi
}




############################################################
#
# configureQ2931New: create q2913 sigpath
#
#
proc configureQ2931New { bnp vpi sig aal uni ilmi ref } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp ] }
    if { $sig != {} } { set sig "-sig $sig" }
    if { $aal != {} } { 
        switch $aal {
            "4" { set aal "-aal type34" }
            "5" { set aal "-aal type5" }
            default { set aal "-aal $aal" }
        }
    }
    if { $uni != {} } { set uni "-uni $uni" }
    if { $ilmi != {} } { set ilmi "-ilmi $ilmi" }
    if { $ref != {} } { set ref "-ref $ref" }

    eval [concat $g_curhost q2931 create $port $vpi $sig $aal $uni $ilmi $ref]
}


############################################################
#
# configureQ2931Delete: remove a q2931 sigpath
#
proc configureQ2931Delete { bnp vpi } {
    global g_curhost
    set port {}
    if { $bnp != {} } {
        set port [$g_curhost convert bnpstrtoport $bnp ]
    }
    eval [concat $g_curhost q2931 remove $port $vpi]
}


############################################################
#
# configureQ2931Show: show q2931 sigpaths
#
proc configureQ2931Show { bnp vpi } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp ] }

    set data [queryList [concat $g_curhost q2931 admin get $port $vpi]]

    if { $data == {} } {
        puts "\nNo UNI 3.0 signalling information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n %-4s %5s %5s %5s %-5s %-6s %-8s %-10s %s" \
            Port VPI Sig AAL State ILMI UNIside ConfigType OperType]"

    foreach item $data {
        set aaltype [getItemValue $item -q2931AdminAALType]
        switch $aaltype {
            "type34" { set aaltype 4 }
            "type5" { set aaltype 5 }
        }
        if { [getItemValue $item -q2931AdminEntryStatus] != "valid" } {
            set status "*"
        } else {
            set status ""
        }
        AMIputs "[format "%1s%-4s %5s %5s %5s %-5s %-6s %-8s %-10s %s" \
                $status [portToBNPstr [getItemValue $item -q2931AdminPort]] \
                [getItemValue $item -q2931AdminVPI] \
                [getItemValue $item -q2931AdminVCI] \
                $aaltype \
                [getItemValue $item -q2931OperStatus] \
                [getItemValue $item -q2931ILMIOperStatus] \
                [getItemValue $item -q2931AdminUNISide] \
                [getItemValue $item -q2931AdminConfigType] \
                [getItemValue $item -q2931AdminOperType]]"
    }
}



############################################################
#
# configureNsapPrefixAdd: create an NSAP prefix
#
# explicitly disallows nsap prefix entries for the control port
#
proc configureNsapPrefixAdd { bnp vpi nsap } {
    global g_curhost
    set port {}
    if { [regexp -nocase -- "ctl" $bnp] == 1 } {
        AMIputs "[format "NSAP Prefix cannot be changed for the control port"]"
        return {}
    }

    if { $bnp != {} } {
        set port [$g_curhost convert bnpstrtoport $bnp]
    }
    eval [concat $g_curhost nsapfx create $port $vpi $nsap]
}



############################################################
#
# configureNsapPrefixDelete: delete an NSAP prefix
#
proc configureNsapPrefixDelete { bnp vpi nsap } {
    global g_curhost
    set port {}
    if { $bnp != {} } {
        set port [$g_curhost convert bnpstrtoport $bnp]
    }
    eval [concat $g_curhost nsapfx remove $port $vpi $nsap]
}


############################################################
#
# configureNsapPrefixShow: show NSAP prefix table
#
proc configureNsapPrefixShow { bnp vpi nsap } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }
    set data [queryList [concat $g_curhost nsapfx get $port $vpi $nsap]]

    if { $data == {} } {
        puts "\nNo user configured NSAP prefix information is available"
        return
    }

    initAMIputs

    AMIputs "\n Port\t   VPI NSAP-Prefix"

    foreach item $data {
        if { [getItemValue $item -nsapNetworkPrefixStatus] != "valid" } {
            set status "*"
        } else {
            set status ""
        }
        AMIputs "[format "%1s%s\t%6s %s" \
                $status \
                [portToBNPstr [getItemValue $item -nsapNetworkPrefixPort]] \
                [getItemValue $item -nsapNetworkPrefixVPI] \
                [getItemValue $item -nsapNetworkPrefixValue]]"
    }
}



############################################################
#
# configureNsapAddressAdd: create an NSAP address
#
proc configureNsapAddressAdd { nsap mask bnp vpi cost cbr_cap vbr_cap abr epd} {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }
    if { $cost != {} } {set cost [concat -cost $cost] }
    if { $cbr_cap != {} } {set cbr_cap [concat -cbr_cap $cbr_cap] }
    if { $vbr_cap != {} } {set vbr_cap [concat -vbr_cap $vbr_cap] }

    eval [concat $g_curhost nsap create $nsap $mask $port $vpi $cost $cbr_cap $vbr_cap $abr $epd]
}


############################################################
#
# configureNsapAddressDelete: delete an NSAP address
#
proc configureNsapAddressDelete { nsap mask bnp vpi } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }
    eval [concat $g_curhost nsap remove $nsap $mask $port $vpi]
}



############################################################
#
# configureNsapAddressShow: display Nsap Address table
#
proc configureNsapAddressShow { nsap mask } {
    global g_curhost
    set data [queryList [concat $g_curhost nsap get $nsap $mask]]

    if { $data == {} } {
        puts "\nNo NSAP static route information is available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-40s %-4s %-4s %-3s %-4s %-5s %-5s %-5s" \
            NSAP-address Mask Port VPI Cost CBR VBR FLAGS]"
    AMIputs "[format " %+63s   %-3s" Mbs Mbs]"

    foreach item $data {
        if { [getItemValue $item -nsapStaticRouteStatus] != "valid" } {
            set status "*"
        } else {
            set status ""
        }
        if { [getItemValue $item -nsapStaticRouteAbrSupport] == "supported" } {
            set abr "A"
        }  else {
            set abr ""
        }
        if { [getItemValue $item -nsapStaticRouteEpdSupport] == "supported" } {
            set epd "E"
        } else {
            set epd ""
        }

        AMIputs "[format "%1s%-40s %-4s %-4s %-3s %-4s %-5s %-5s %-5s" \
                $status [nsapRemPeriod [getItemValue $item -nsapStaticRouteAddress]] \
                [getItemValue $item -nsapStaticRouteMask] \
                [portToBNPstr [getItemValue $item -nsapStaticRoutePort]] \
                [getItemValue $item -nsapStaticRouteVPI] \
                [getItemValue $item -nsapStaticRouteCost] \
                [convertCapVal [getItemValue $item -nsapStaticRouteMaxCbrCap]] \
                [convertCapVal [getItemValue $item -nsapStaticRouteMaxVbrCap]] \
                "$abr$epd"]"

    }
}



############################################################
#
# getVpcStats: show virtual path statistics
#
proc getVpcStats { bnp vpi } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    if { [catch { set indexlist [queryList \
            [concat $g_curhost path list $port $vpi]] } result] != 0 } {
        set indexlist {}
    }

    set totalpaths [llength $indexlist]

    initAMIputs

    AMIputs "\nInput      Output"
    AMIputs "[format "%-4s %4s  %-4s %4s  %15s %15s" \
            Port VPI Port VPI Cells RejectedCells]"

    foreach index $indexlist {
        set var [eval [concat $g_curhost path get $index \
                -pathPort -pathVPI -pathCells -pathRejectedCells]]
        if { $var == {} } { continue }
        AMIputs "[format "%-4s %4s  %-9s  %15s %15s" \
                [portToBNPstr [getItemValue $var -pathPort]] \
                [getItemValue $var -pathVPI] \
                terminate \
                [getItemValue $var -pathCells] \
                [getItemValue $var -pathRejectedCells]]"
    }

    if { [catch { set indexlist [queryList \
            [concat $g_curhost opath list $port $vpi]] } result] != 0 } {
        set indexlist {}
    }

    set totalpaths [expr $totalpaths + [llength $indexlist]]

    foreach index $indexlist {
        set var [eval [concat $g_curhost opath get $index \
                -opathPort -opathVPI -opathCells -opathRejectedCells]]
        if { $var == {} } { continue }
        AMIputs "[format "%-9s  %-4s %4s  %15s %15s" \
                originate \
                [portToBNPstr [getItemValue $var -opathPort]] \
                [getItemValue $var -opathVPI] \
                [getItemValue $var -opathCells] \
                [getItemValue $var -opathRejectedCells]]"
    }

    if { [catch { set indexlist [queryList \
            [concat $g_curhost pathroute list $port $vpi]] } result] != 0 } {
        set indexlist {}
    }

    set totalpaths [expr $totalpaths + [llength $indexlist]]

    foreach index $indexlist {
        set var [eval [concat $g_curhost pathroute get $index \
                -pathrInputPort -pathrInputVPI -pathrOutputPort \
                -pathrOutputVPI -pathrCells -pathrRejectedCells]]
        if { $var == {} } { continue }
        AMIputs "[format "%-4s %4s  %-4s %4s  %15s %15s" \
                [portToBNPstr [getItemValue $var -pathrInputPort]] \
                [getItemValue $var -pathrInputVPI] \
                [portToBNPstr [getItemValue $var -pathrOutputPort]] \
                [getItemValue $var -pathrOutputVPI] \
                [getItemValue $var -pathrCells] \
                [getItemValue $var -pathrRejectedCells]]"
    }

    if { $totalpaths == {} } {
        puts "\nNo virtual path statistics are available"
        return
    }
}



############################################################
#
# getVccStats: show virtual channels statistics
#
proc getVccStats { bnp vpi vci } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    set indexlist [queryList [concat $g_curhost channel list $port $vpi $vci]]

    if { $indexlist == {} } {
        puts "\nNo virtual channel statistics are available"
        return
    }

    initAMIputs

    AMIputs "\nInput          Output"
    AMIputs "[format "%-4s %4s %4s %-4s %4s %4s %15s %15s" \
            Port VPI VCI Port VPI VCI Cells RejectedCells]"

    foreach index $indexlist {
        set var [eval [concat $g_curhost channel get $index]]
        if { $var == {} } { continue }
        set cells [getItemValue $var -chanCells]
        if { $cells > 1000000 } { set cells "[megaUnits $cells]M" }

        set ovars [queryList [concat $g_curhost chanroute get $index]]

        foreach ovar $ovars {
            AMIputs "[format \
                    "%-4s %4s %4s %-4s %4s %4s %15s %15s" \
                    [portToBNPstr [getItemValue $var -chanPort]] \
                    [getItemValue $var -chanVPI] \
                    [getItemValue $var -chanVCI] \
                    [portToBNPstr [getItemValue $ovar -chanrOutputPort]] \
                    [getItemValue $ovar -chanrOutputVPI] \
                    [getItemValue $ovar -chanrOutputVCI] \
                    [getItemValue $var -chanCells] \
                    [getItemValue $var -chanRejectedCells]]"
        }
    }
}



############################################################
#
# getAtmStats: show ATM driver layer statistics
#
#
proc getAtmStats { layer ifc } {
    global g_curhost

    set ifindex {}
    if { $ifc != {} } {
        set iflist [$g_curhost if get -ifIndex -ifDescr]
        foreach if $iflist {
            if { [getItemValue $if -ifDescr] == $ifc } {
                set ifindex [getItemValue $if -ifIndex]
                break
            }
        }
        if { $ifindex == {} } {
            EMSG "Invalid interface name"
            return
        }
    }

    set iflist [eval [concat $g_curhost asx $layer list $ifindex]]

    if { $iflist == {} } {
        puts "\nNo $layer layer statistics are available"
        return
    }

    initAMIputs
    switch $layer {
        "aal0" { AMIputs "[format "\n%-15s %15s %15s %15s" \
                Interface XmtCell RcvCell CellDsc]" } 
        "aal4" { AMIputs "[format \
                "\n%-6s %8s %8s %8s %8s %8s %8s %8s %8s" \
                Intfce  XmtCell RcvCell XmtPDU RcvPDU CRCErr \
                SARErr CSErr CellDsc]" }
        "aal5" { AMIputs "[format \
                "\n%-6s %8s %8s %8s %8s %8s %8s %8s %8s" \
                Intfce XmtCell RcvCell XmtPDU RcvPDU CRCErrs CSErrs \
                CellDsc PDUDsc]" }
        "atm"  { AMIputs "[format "\n%-9s %10s %10s %10s %10s %10s %10s" \
                Interface XmtCell RcvCell VPI-OOR VPI-Noc VCI-OOR VCI-Noc]" }
        "physical" { AMIputs "[format "\n%-15s %15s %15s" \
                Interface Framing-Errors CRC-Errors]" }
    }

    foreach ifindex $iflist {
        set stats [eval [concat $g_curhost asx $layer get $ifindex]]
        set ifname [$g_curhost if get $ifindex -ifDescr]

        switch $layer {
            "aal0" { AMIputs "[format "%-15s %15s %15s %15s" \
                    $ifname \
                    [getItemValue $stats -aal0TransmittedCells] \
                    [getItemValue $stats -aal0ReceivedCells] \
                    [getItemValue $stats -aal0CellsDiscards]]" }
            
            "aal4" { AMIputs "[format \
                    "%-6s %8s %8s %8s %8s %8s %8s %8s %8s" \
                    $ifname \
                    [getItemValue $stats -aal4TransmittedCells] \
                    [getItemValue $stats -aal4ReceivedCells] \
                    [getItemValue $stats -aal4TransmittedPDUs] \
                    [getItemValue $stats -aal4ReceivedPDUs] \
                    [getItemValue $stats -aal4PayloadCRCErrors] \
                    [getItemValue $stats -aal4SARProtocolErrors] \
                    [getItemValue $stats -aal4CSProtocolErrors] \
                    [getItemValue $stats -aal4CellsDiscards]]" }

            "aal5" { AMIputs "[format \
                    "%-6s %8s %8s %8s %8s %8s %8s %8s %8s" \
                    $ifname \
                    [getItemValue $stats -aal5TransmittedCells] \
                    [getItemValue $stats -aal5ReceivedCells] \
                    [getItemValue $stats -aal5TransmittedPDUs] \
                    [getItemValue $stats -aal5ReceivedPDUs] \
                    [getItemValue $stats -aal5CRCErrors] \
                    [getItemValue $stats -aal5CSProtocolErrors] \
                    [getItemValue $stats -aal5CellsDiscards] \
                    [getItemValue $stats -aal5PDUsDiscards]]" }

            "atm"  { AMIputs "[format "%-9s %10s %10s %10s %10s %10s %10s" \
                    $ifname \
                    [getItemValue $stats -atmTransmittedCells] \
                    [getItemValue $stats -atmReceivedCells] \
                    [getItemValue $stats -atmOutOfRangeVPIs] \
                    [getItemValue $stats -atmUnconnectedVPIs] \
                    [getItemValue $stats -atmOutOfRangeVCIs] \
                    [getItemValue $stats -atmUnconnectedVCIs]]" }

            "physical" { AMIputs "[format "%-15s %15s %15s" \
                    $ifname \
                    [getItemValue $stats -phyLayerFramingErrors] \
                    [getItemValue $stats -phyLayerHeaderCRCErrors]]" }

        }
    }
}


############################################################
#
# getBoardStats: show board statictics
#
proc getBoardStats { board } {
    global g_curhost
    if { $board != {} } { set board [switchBoardNumber $board] }

    set stats [queryList [concat $g_curhost board get $board \
            -boardIndex -vpiLookupErrors -vciLookupErrors]]

    if { $stats == {} } {
        puts "\nNo board statistics are available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-5s   %20s   %20s" \
            Board VPI-Lookup-Errors VCI-Lookup-Errors]"

    foreach stat $stats {
        AMIputs "[format "%-5d   %20s   %20s" \
                [userBoardNumber [getItemValue $stat -boardIndex]] \
                [getItemValue $stat -vpiLookupErrors] \
                [getItemValue $stat -vciLookupErrors]]"
    }
}



############################################################
#
# getNetmodStats: show module statistics
#
#
proc getNetmodStats { board_module } {
    global g_curhost

    set vars [queryList [concat $g_curhost obuf get \
            [switchBoardModule $board_module]]]

    if { $vars == {} } {
        puts "\nNo module statistics are available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-6s %-15s %-7s %8s %8s %8s" \
            Module Buffer-type Status Size QLength Overflows]"

    foreach var $vars {
        AMIputs "[format "%s%-5s %-15s %-7s %8s %8s %8s" \
                [userBoardNumber [getItemValue $var -obufBoard]] \
                [userModuleNumber [getItemValue $var -obufNumber]] \
                [getItemValue $var -obufType] \
                [getItemValue $var -obufOperStatus] \
                [getItemValue $var -obufBufferSize] \
                [getItemValue $var -obufQueueLength] \
                [getItemValue $var -obufOverflows]]"
    }
}




############################################################
#
# getPortStats: get general port counters
#
#
proc getPortStats { bnp } {
    global g_curhost
    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }
    set stats [queryList [concat $g_curhost port get $port \
            -portNumber -portHwBoard -portHwModule -portHwNumber \
            -portReceivedCells -portTransmittedCells]]

    if { $stats == {} } {
        puts "\nNo port statistics are available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-4s  %15s  %20s  %15s  %15s" \
            Port Received-Cells Transmitted-Cells \
            Port-Errors Port-Overflows]"

    foreach stat $stats {
        set b [getItemValue $stat -portHwBoard]
        set n [getItemValue $stat -portHwModule]
        set p [getItemValue $stat -portHwNumber]
        AMIputs "[format "%-4s  %15s  %20s  %15s  %15s" \
                [portToBNPstr [getItemValue $stat -portNumber]] \
                [getItemValue $stat -portReceivedCells] \
                [getItemValue $stat -portTransmittedCells] \
                [$g_curhost hwport get $b $n $p -hwPortErrors] \
                [$g_curhost hwport get $b $n $p -hwPortOverflows]]"
    }
}



############################################################
#
# getHardPortStats: display port counter for the given port(s)
#		   type can be {e3, ds1, ds3, j2, sonet}
#		   skiplist is of the form { type list type list ... }
#
proc getHardPortStats { bnp type skiplist } {
    global g_curhost 

    set b_n_p {}
    if { $bnp != {} } { set b_n_p [$g_curhost convert bnpstrtobnp $bnp] }

    set ports [queryList \
            [concat $g_curhost $type [lindex $skiplist 0] list $b_n_p]]

    if { $ports == {} } {
        puts "\nNo $type statistics are available"
        return
    }

    initAMIputs

    foreach port $ports {
        set vars {}
        set skipvars {}
        set tempvars $skiplist
        while { $tempvars != {} } {
            set morevars [eval \
                    [concat $g_curhost $type [lindex $tempvars 0] get $port ]]
            set skipvars [concat $skipvars [lindex $tempvars 1]]
            set vars [concat $vars $morevars]
            set tempvars [lrange $tempvars 2 end]
        }

        AMIputs "[format "\n%s Port %s Counter\t\t    Value\t    Delta" $type \
                [eval [concat $g_curhost convert bnptobnpstr $port]]]"
        AMIputs "------------------------------\t--------------\t--------------"

        while { $vars != {} } {
            set varname [lindex $vars 0]
            if { [lsearch $skipvars $varname] < 0 } {
                set varname [string range $varname 1 end]
                set value [lindex $vars 1]
                set delta [$g_curhost hash find $varname.$port]
                if { $delta != {} } { 
                    set delta [expr $value - $delta]
		    if { $delta < 0 } {
			set delta 0
		    }
                } else {
                    set delta 0
                }
                catch { $g_curhost hash add $varname.$port $value } result
                AMIputs "[format "%-30s %15s %15s" $varname $value $delta]"
            }
            set vars [lrange $vars 2 end]
        }
        if { $bnp == {} } { AMIpause }
    }
}



############################################################
#
# getSoftPortStats: display stats for spans, q2931, or sscop
#
#
proc getSoftPortStats { whichstat bnp vpi } {
    global g_curhost

    set port {}
    if { $bnp != {} } { set port [$g_curhost convert bnpstrtoport $bnp] }

    switch $whichstat {
        "sigstat" { 
            set skipfields "-sigPathStatsPort -sigPathStatsVPI" 
            set subcmd {}
        }
        "q2931" { 
            set skipfields "-q2931StatsPort -q2931StatsVPI"
            set subcmd "stats" 
        }
        "sscop" { 
            set skipfields "-sscopStatsPort -sscopStatsVPI" 
            set subcmd "stats" 
        }
    }

    set stats [queryList \
            [concat $g_curhost $whichstat $subcmd  get $port $vpi]]

    if { $stats == {} } {
        puts "\nNo signalling statistics are available"
        return
    }

    initAMIputs

    foreach stat $stats {
        set bnp [eval [concat portToBNPstr \
                [getItemValue $stat [lindex $skipfields 0]]]]
        AMIputs "[format "\nPort %s Counter\t\t\t   Value\t\tDelta" $bnp]"
        AMIputs "---------------------------------- -------------------- --------------------"

        while { $stat != {} } {
            set field [lindex $stat 0]
            if { [lsearch $skipfields $field] < 0 } {
                set value [lindex $stat 1]
                set varname [string range $field 1 end]
                set delta [$g_curhost hash find $varname.$bnp]
                if { $delta == {} } {
                    set delta 0
                } else {
                    set delta [expr $value - $delta]
                }
                catch { $g_curhost hash add $varname.$bnp $value } result
                AMIputs "[format "%-34s %20s %20s" $varname $value $delta]"
            }
            set stat [lrange $stat 2 end]
        }
        AMIpause
    }
}



############################################################
#
# getGeneralStats: get general statistics on network layers
#
proc getGeneralStats { cmd vars } {
    global g_curhost
    set stats [eval [concat $g_curhost $cmd get $vars]]

    if { $stats == {} } {
        puts "\nNo $cmd statistics are available"
        return
    }

    initAMIputs

    AMIputs "[format "\n%-30s       %-20s %-20s" "$cmd Counter" Value Delta]"
    AMIputs "------------------------------ -------------------- --------------------"

    while { $stats != {} } {
        set value [lindex $stats 1]
        set varname [string range [lindex $stats 0] 1 end]
        set delta [$g_curhost hash find $varname.0]
        if { $delta == {} } {
            set delta 0
        } else {
            set delta [expr $value - $delta]
        }
        catch { $g_curhost hash add $varname.0 $value } result 
        AMIputs "[format "%-30s %20s %20s" $varname $value $delta]"
                
        set stats [lrange $stats 2 end]
    }
}



############################################################
#
# getIfStats: get interface level statistics
#
proc getIfStats { ifc vars } {
    global g_curhost
    set ifindex {}
    if { $ifc != {} } {
        set iflist [$g_curhost if get -ifIndex -ifDescr]
        foreach if $iflist {
            if { [getItemValue $if -ifDescr] == $ifc } {
                set ifindex [getItemValue $if -ifIndex]
                break
            }
        }
        if { $ifindex == {} } {
            EMSG "Invalid interface name"
            return
        }
    }
    set iflist [eval [concat $g_curhost if list $ifindex]]

    if { $iflist == {} } {
        puts "\nNo interface statistics are available"
        return
    }

    initAMIputs

    foreach ifindex $iflist {
        set stats [eval [concat $g_curhost if get $ifindex $vars]]
        AMIputs "[format "\n%-30s       %-20s %-20s" \
                "Interface [$g_curhost if get $ifindex -ifDescr] Counter" \
                Value Delta]"
        AMIputs "------------------------------ -------------------- --------------------"

        while { $stats != {} } {
            set value [lindex $stats 1]
            set varname [string range [lindex $stats 0] 1 end]
            set delta [$g_curhost hash find $varname.$ifindex]
            if { $delta == {} } {
                set delta 0
            } else {
                set delta [expr $value - $delta]
            }
            catch { $g_curhost hash add $varname.$ifindex $value } result
            AMIputs "[format "%-30s %20s %20s" $varname $value $delta]"
            set stats [lrange $stats 2 end]
        }
        AMIpause
    }
}



############################################################
#
# operLogShow: display log file
#
#
proc operLogShow { class startdate } {
    global g_months
    if { ![runningOnSwitch] } { return }

    if { $startdate != {} } {
        if { [string length $startdate] == 4 } { 
            set startdate [format "%4s0000" $startdate]
        }
    }

    set logs [glob -nocomplain /var/adm/messages*]

    initAMIputs

    set linedate {}

    foreach log $logs {
        set logfile [open $log r]
        if { $startdate != {} } {
            set size [file size $log]
            set pos 0
            set lastpos 0
            while { [gets $logfile line] >= 0 } {
                set linedate [format "%02d%02d%2s%2s" \
                        [lsearch $g_months [lindex $line 0]] \
                        [lindex $line 1] \
                        [string range [lindex $line 2] 0 1] \
                        [string range [lindex $line 2] 3 4]]
                if { [string compare $linedate $startdate] >= 0 } { 
                    seek $logfile $lastpos
                    if { $lastpos > 0 } { gets $logfile line }
                    break
                }
                set lastpos $pos
                set pos [expr $pos + ($size - $pos) / 2]
                seek $logfile $pos
                gets $logfile line
            }
        }
        while { [gets $logfile line] >= 0 } {
            if { $class != {} } {
                if { [regexp -nocase -- $class $line] == 0} { continue }
            }
            if { $startdate != {} } {
                set linedate [format "%02d%02d%2s%2s" \
                        [lsearch $g_months [lindex $line 0]] \
                        [lindex $line 1] \
                        [string range [lindex $line 2] 0 1] \
                        [string range [lindex $line 2] 3 4]]
                if { [string compare $linedate $startdate] < 0 } { continue }
            }
            AMIputs "$line"
        }
        close $logfile
    }
}


############################################################
#
# operLogClear: clear the log file
#
#
proc operLogClear {} {
    if { ![runningOnSwitch] } { return }

    if { [yesorno "Are you sure you want to clear the log files" "n"] } {
        set logfiles [glob -nocomplain /var/adm/messages* ]
        foreach log $logfiles { exec /bin/rm -rf $log }
        exec touch /var/adm/messages > /dev/null
        set syslog [open "| ps ax | grep syslogd | head -1" r]
        if { [gets $syslog pid] > 0 } {
            exec kill "-HUP" [lindex $pid 0]
        }
        close $syslog
    }
}



############################################################
#
# operPassword: change adminstrative password
#
#
proc operPassword {} {
    global g_switch_type

    if { ![runningOnSwitch] } { return }

    if { [compiledWSCP] } {
        puts "\nThis switch does not support an administrative password"
    }

    catch { exec /atm/release/fore/bin/perl \
            /atm/release/fore/bin/chngpass.pl asx > /dev/tty } result
}



############################################################
#
# operHaltSwitch: Halt the switch
#
#
proc operHaltSwitch {} {
    if { ![runningOnSwitch] } { return }
    if { [yesorno "Are you sure you want to halt this switch" "n"] } {
        exec halt
    }
}


############################################################
#
# waitForSwitchUp: wait until the switch starts responding again
#
proc waitForSwitchUp {} {
    global g_curhost

    if { [catch { set init [$g_curhost switch get 0 -uptime] } result] } {
        set init 0
    }

    set time $init

    while { [expr $time-$init] < 1000 } {
        catch { set cur_time [$g_curhost switch get 0 -uptime] } result
        if { $cur_time < $time } {
            return
        }
        set time $cur_time
    }

    return
}


############################################################
#
# operRebootSwitch: Reboot the switch
#
#
proc operRebootSwitch { restartasxd } {
    global g_curhost g_switch_type

    if { $restartasxd == "scs" } {
        if { [yesorno \
                "Restart the switch software" "n"] } {
            $g_curhost switch warmstart "scs"
            waitForSwitchUp
        }
        return
    } else {
        if { ![runningOnSwitch] } { return }

        if { [yesorno "Are you sure you want to reboot this switch" "n"] } {
            if { [sparcSwitch] } {
                exec /etc/reboot
            }
            if { [catch { $g_curhost switch warmstart } result ] != 0 } {
                EMSG "Sorry, reboot failed!"
            }
            waitForSwitchUp
        }
    }
}



############################################################
#
# operRestartSwitch: restart switch software
#
#
proc operRestartSwitch {} {
    operRebootSwitch "scs"
}


############################################################
#
# operEnvironmentPower: environment info
#
#
proc operEnvironmentPower {} {
    global g_curhost

    set powerlist [$g_curhost env power get]

    if { $powerlist == {}} {
        puts "\nNo environmental power information available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-12s %-15s %-11s %-11s %-10s %s" \
            PowerSupply Type InputState OutputState S/N Version]"

    foreach power $powerlist {
        AMIputs "[format " %-12s %-15s %-11s %-11s %-10s %s" \
                [getItemValue $power -envPowerSupplyIndex] \
                [getItemValue $power -envPowerSupplyType] \
                [getItemValue $power -envPowerSupplyInputState] \
                [getItemValue $power -envPowerSupplyOutputState] \
                [getItemValue $power -envPowerSupplySerialNumber] \
                [getItemValue $power -envPowerSupplyVersion]]"
    }
}



############################################################
#
# operEnvironmentFans: environment info
#
#
proc operEnvironmentFans {} {
    global g_curhost

    set fanlist [$g_curhost env fans get]

    if { $fanlist == {}} {
        puts "\nNo environmental fan information available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-15s %-15s" FanBank FanBankState]"

    foreach fan $fanlist {
        AMIputs "[format " %-15s %-15s" \
                [getItemValue $fan -envFanBankIndex] \
                [getItemValue $fan -envFanBankState]]"
    }
}


############################################################
#
# operEnvironmentTemperature: environment info
#
#
proc operEnvironmentTemperature {} {
    global g_curhost

    set templist [$g_curhost env temp get]

    if { $templist == {}} {
        puts "\nNo environmental temperature sensor information available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-30s %-15s" TemperatureSensor SensorState]"

    foreach temp $templist {
        AMIputs "[format " %-30s %-15s" \
                [getItemValue $temp -envTempSensorIndex] \
                [getItemValue $temp -envTempSensorState]]"
    }
}


############################################################
#
# operEnvironmentCPU: environment info
#
#
proc operEnvironmentCPU {} {
    global g_curhost

    set cpulist [$g_curhost env cpu get]

    if { $cpulist == {}} {
        puts "\nNo environmental CPU information available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-10s %-10s %-10s" CPU Type State]"

    foreach cpu $cpulist {
        if { [getItemValue $cpu -envCpuSlot] == "0" } {
            set slot "X"
        } else {
            set slot "Y"
        }
        set cpunum "[format "%s%s" \
                [userBoardNumber [getItemValue $cpu -envCpuBoard]] $slot]"

        AMIputs "[format " %-10s %-10s %-10s" \
                $cpunum \
                [getItemValue $cpu -envCpuType] \
                [getItemValue $cpu -envCPUState]]"
    }
}

############################################################
#
# operEnvironmentFabricShow: environment fabric show
#
#
proc operEnvironmentFabricShow {} {
    global g_curhost

    set fabset [$g_curhost env fabric-params get]
    set fabtmp [$g_curhost env fabric-temp get]

    if { $fabset == {}} {
        puts "\nNo environmental fabric information available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-10s %-10s %-10s" Fabric {Deg C} State]"

    foreach fab $fabtmp {
        AMIputs "[format " %-10s %-10s %-10s" \
		[getItemValue $fab -envFabricIndex] \
                [getItemValue $fab -envFabricTemperature] \
                [getItemValue $fab -envFabricTemperatureState]]"
    }

    AMIputs "[format "\n Alarm/trap reset threshold (this fabric): %s degrees C or lower" \
	    [getItemValue $fabset -envFabricAlarmResetTemperature]]"
    AMIputs "[format " Alarm/trap trip threshold (this fabric): %s degrees C or greater" \
	    [getItemValue $fabset -envFabricAlarmTripTemperature]]"

}


############################################################
#
# operEnvironmentFabricTempThresholds: set fabric alarm/trap trip/reset thresholds.
#
#
proc operEnvironmentFabricTempThresholds { reset trip } {
    global g_curhost
    
    eval [concat $g_curhost env fabric-params set -envFabricAlarmTripTemperature $trip]
    eval [concat $g_curhost env fabric-params set -envFabricAlarmResetTemperature $reset]
}

############################################################
#
# configureAlarmShow: display alarm information
#
#
proc configureAlarmShow { } {
    global g_curhost

    set alarms [queryList [concat $g_curhost alarm get]]

    if { $alarms == {} } {
        puts "\nNo alarm information is available"
        return
    }

    initAMIputs

    AMIputs "[format "\n %-30s %-14s %-12s %-12s" \
            AlarmType AlarmStatus MinorAlarm MajorAlarm]"

    foreach alarm $alarms {
        AMIputs "[format " %-30s %-14s %-12s %-12s" \
                [getItemValue $alarm -swAlarmType] \
                [getItemValue $alarm -swAlarmStatus] \
                [getItemValue $alarm -swAlarmMinorCategory] \
                [getItemValue $alarm -swAlarmMajorCategory]]"
    }

    set relays [$g_curhost relay get]

    AMIputs "[format "\n Major alarm relay status: %s" \
            [getItemValue $relays -swAlarmMajorRelayState]]"
    AMIputs "[format " Minor alarm relay status: %s" \
            [getItemValue $relays -swAlarmMinorRelayState]]"
}



############################################################
#
# configureAlarmSet: set alarm configuration
#
#
proc configureAlarmSet { category type val } {
    global g_curhost

    switch $category {
        "minor" { set category "-swAlarmMinorCategory" }
        "major" { set category "-swAlarmMajorCategory" }
    }

    $g_curhost alarm set $type $category $val
}


############################################################
#
# operDateSet: get or set system time
#
#
proc operDateSet { date time offset } {
    global g_curhost g_months
    if { $date == {} } {
        set date [join [eval [concat $g_curhost host get -hrSystemDate]]]
        regexp -- {([0-9]+)\/([0-9]+)\/([0-9]+)} \
                [lindex $date 0] match mm dd yy
        set rest [string first " " $date]
        puts "\n[lindex $g_months $mm] $dd [string range $date $rest end] $yy"
    } else {
        eval [concat $g_curhost host set -hrSystemDate $date $time $offset]
	puts "The new date will take effect on the next reboot"
    }
}


############################################################
#
# operCpuInfo: display cpu informattion
#
#
proc operCpuInfo {} {
    global g_curhost

#    if { $g_curhost == "localhost" } {
#        set serial "unknown"
#        set sparc [exec devinfo -pv | grep idprom]
#        if { [regexp -- {\.........\.....199[0-9]\..(.....)} $sparc m m1] } {
#            scan $m1 "%x" serial
#        }
#        puts "\nSwitch controller serial number: $serial"
#    }

    set cpuinfo [$g_curhost host get]

    if { $cpuinfo == {} } {
        puts "\nNo CPU information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\nCPU uptime: %s" \
            [niceTimeString [getItemValue $cpuinfo -hrSystemUptime]]]"
}


############################################################
#
# rs232PortNumber: convert rs232 port name to number
#
#
proc rs232PortNumber { port } {
    global g_rs232PortList
    if { $port != {} } {
        set port [string toupper $port]
        set port [lindex $g_rs232PortList \
                [expr [lsearch $g_rs232PortList $port] + 1]]
    }
    return $port
}

############################################################
#
# rs232PortName: convert rs232 port number to name
#
#
proc rs232PortName { port } {
    global g_rs232PortList
    if { $port != {} } {
        set port [lindex $g_rs232PortList \
                [expr [lsearch $g_rs232PortList $port] - 1]]
    }
    return $port
}


############################################################
#
# configRs232Show: show rs232 port info
#
#
proc configRs232Show { portname } {
    global g_curhost
    
    set portlist [eval [concat \
            $g_curhost rs232 port list [rs232PortNumber $portname]]]

    if { $portlist == {} } {
        puts "\nNo serial port information is available"
        return
    }

    initAMIputs
    AMIputs "[format "\n%-8s %-8s %8s   %-8s %4s   %-10s %-6s" \
            Port Type Speed Flow Bits Stops Parity]"

    foreach rs232port $portlist {
        set portinfo [$g_curhost rs232 port get $rs232port]
        set asyncinfo [$g_curhost rs232 async get $rs232port]

        AMIputs "[format "%-8s %-8s %8s   %-8s %4s   %-10s %-6s" \
                [rs232PortName $rs232port] \
                [getItemValue $portinfo -rs232PortType] \
                [getItemValue $portinfo -rs232PortInSpeed] \
                [getItemValue $portinfo -rs232PortInFlowType] \
                [getItemValue $asyncinfo -rs232AsyncPortBits] \
                [getItemValue $asyncinfo -rs232AsyncPortStopBits] \
                [getItemValue $asyncinfo -rs232AsyncPortParity]]"
    }
}



############################################################
#
# configRs232Speed: set rs232 port speed
#
#
proc configRs232Speed { portname speed } {
    global g_curhost

    $g_curhost rs232 port set \
            [rs232PortNumber $portname] -rs232PortInSpeed $speed

    if { $g_curhost == "localhost" && [sparcSwitch] } {
        # restart init process to reload /etc/ttytab
        exec kill -HUP 1
    }
}



############################################################
#
# configRs232Bits: set rs232 number of bits
#
#
proc configRs232Bits { portname bits } {
    global g_curhost

    $g_curhost rs232 async set \
            [rs232PortNumber $portname] -rs232AsyncPortBits $bits
}



############################################################
#
# configRs232Stop: set rs232 stop bits
#
#
proc configRs232Stop { portname stop } {
    global g_curhost

    $g_curhost rs232 async set \
            [rs232PortNumber $portname] -rs232AsyncPortStopBits $stop
}



############################################################
#
# configRs232Parity: set rs232 port parity
#
#
proc configRs232Parity { portname parity } {
    global g_curhost

    $g_curhost rs232 async set \
            [rs232PortNumber $portname] -rs232AsyncPortParity $parity
}



############################################################
#
# configRs232Reset: reset rs232 port
#
#
proc configRs232Reset { port } {

    if { [runningOnSwitch] && [sparcSwitch] } {
        # restart init process to reload /etc/ttytab
        exec kill -HUP 1
    }
}



############################################################
#
# restartASXD: restart asxd
#
proc restartASXD { sig } {
    set pid [exec cat /atm/etc/asxd.asx0.pid]

    exec kill -$sig $pid
}




############################################################
#
# ftpFile: ftp a file to from this switch
#
#
proc ftpFile { ftpcmd localfile remfile remhost } {
    if { [ catch { exec ping $remhost 3 } result ] } {
        if { ![yesorno "ping $remhost failed.  Try FTP anyway" "n"] } {
            return 0
        }
    }
    puts -nonewline "\nremote userid: "
    if { [gets stdin userid] < 0 } { return 0 }
    puts -nonewline "remote password: "
    exec stty -echo > /dev/tty

    if { [gets stdin password] < 0 } { 
        exec stty echo >< /dev/tty
        return 0 
    }
    exec stty echo > /dev/tty

    puts {}

    if { $userid == {} || $password == {} } { return 0 }

    set remdir {}
    set slash [string last "/" $remfile]

    if { $slash >= 0 } {
        set remdir [string range $remfile 0 $slash]
        set remfile [string range $remfile [expr $slash + 1] end]
    }

    set f [open /tmp/ftpcmd.[pid] w]
    if { $ftpcmd == "get" } {
        puts $f "user $userid $password\nbin\nhash\ncd $remdir\nget $remfile $localfile"
    } else {
        puts $f "user $userid $password\nbin\nhash\ncd $remdir\nput $localfile $remfile"
    }
    close $f

    set f [open "| /usr/ucb/ftp -vn $remhost < /tmp/ftpcmd.[pid]" r ]

    set status 0

    while { [gets $f line] > 0 } {
        if { [scan $line "%d %s" d s] == 2 } {
            if { $d == 150 } {
                while { [read $f 1] == "#" } { 
                    puts -nonewline "#" 
                    flush stdout
                }
                puts {}
            } elseif { $d == 226 } {
                set status 1
                break
            } elseif { $d == 530 } {
                EMSG "Userid or password is invalid"
                break
            } elseif { $d == 550 } {
                EMSG "The path to the file or filename is invalid"
                break
            }
        }
    }

    close $f

    exec /bin/rm -f /tmp/ftpcmd.[pid]

    if { $status } {
        puts "Transfer successful."
    } else {
        puts "Transfer failed."
    }

    return $status
}


############################################################
#
# operCDBInit: initialize the cdb
#
proc operCDBInit { } {
    global g_curhost g_switch_type

    if { [compiledWSCP] } {
        if { ![runningOnSwitch] } { return }
	$g_curhost cdb init
    }
}

############################################################
#
# operTraceDump: Trace dump to a host
#
proc operTraceDump { log host_file} {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }
    $g_curhost trace dump $log $host_file
}

############################################################
#
# operTraceShow
#
proc operTraceShow { } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }
    $g_curhost trace show
}


############################################################
#
# operTraceSize
#
proc operTraceSize { log size} {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }
    $g_curhost trace logsize $log $size
}

############################################################
#
# operTraceOn
#
proc operTraceEnable { group on} {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }
    $g_curhost trace enable $group $on
}

############################################################
#
# operBackupCDB: backup the CDB
#
proc operBackupCDB { host_file } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }

    set host {}
    set file {}
    set colon [string first ":" $host_file]

    if { $colon > 0 } {
        set host [string range $host_file 0 [expr $colon - 1]]
        set file [string range $host_file [expr $colon + 1] end]
    } else {
        set file $host_file
    }
    if { $file == {} } {
        ERROR "Filename must be specified for CDB backup"
    }

    if { [sparcSwitch] } {
        if { $host != {} } {
            if { [ftpFile put /atm/etc/cdb.conf $file $host] == 0 } {
                return
            }
        } else {
            if { [string index $file 0] != "/" } { set file "/atm/etc/$file" }
            exec cp /atm/etc/cdb.conf $file
        }
    } else {
        $g_curhost cdb backup $host_file
    }

    puts "CDB backup was successful"
}



############################################################
#
# operRestoreCDB: restore the CDB
#
#
proc operRestoreCDB { host_file } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }

    set host {}
    set file {}
    set colon [string first ":" $host_file]

    if { $colon > 0 } {
        set host [string range $host_file 0 [expr $colon - 1]]
        set file [string range $host_file [expr $colon + 1] end]
    } else {
        set file $host_file
    }
    if { $file == {} } {
        ERROR "Filename must be specified for CDB restore"
    }

    puts "\nRestore procedure requires the switch control software to restart"

    if { ![yesorno "Continue with restore" "n"] } { return }

    if { [sparcSwitch] } {
        #
        # should probably stop asxd
        #
        if { $host != {} } {
            if { [ftpFile get /atm/etc/cdb.conf.new $file $host] } {
                restartASXD STOP
                if { [ catch \
                        { exec mv /atm/etc/cdb.conf.new /atm/etc/cdb.conf } \
                        result ] } {
                    puts "$result"
                    restartASXD CONT
                    return
                }
                restartASXD KILL
            } else {
                return
            }
        } else {
            restartASXD STOP
            if { [string index $file 0] != "/" } { set file "/atm/etc/$file" }
            if { [ catch { exec cp $file /atm/etc/cdb.conf } result ] } {
                puts "$result"
                restartASXD CONT
                return
            }
            restartASXD KILL
        }
    } else {
        $g_curhost cdb restore $host_file
    }

    puts "CDB was restored successfully"
}



############################################################
#
# operResetCDB: reset the CDB
#
proc operResetCDB {} {
    global g_curhost

    puts "\n********** W A R N I N G **********\n"
    puts "This operation resets the switch configuration database."
    puts "As a result, the switch control software will be restarted."
    puts "You will lose connectivity with the switch while this"
    puts "operation is progressing."

    if { [yesorno "Are you sure you want to reset the CDB" "n"] } {
        $g_curhost cdb reset

        puts "\nThe switch will restart momentarily."
        waitForSwitchUp
    }
}



############################################################
#
# operPanicClear: clear the panic flag on an ASX200+ switch
#
#
proc operPanicClear { } {
    global g_curhost

    if { ![runningOnSwitch] } { return }
    $g_curhost panic clear
}


############################################################
#
# operPanicShow: Display available information from a panic dump on an ASX200+
#
#
proc operPanicShow { } {
    global g_curhost

    if { ![runningOnSwitch] } { return }
    $g_curhost panic show
}


############################################################
#
# operPanicDump: Upload panic information from an ASX200+ switch to a host
#
proc operPanicDump { host_file } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }

    set host {}
    set file {}
    set colon [string first ":" $host_file]

    if { $colon > 0 } {
        set host [string range $host_file 0 [expr $colon - 1]]
        set file [string range $host_file [expr $colon + 1] end]
    }
    if { $host == {} || $file == {} } {
        ERROR "Invalid argument specification."
    }

    $g_curhost panic dump $host:$file

    # Clear the panic flag since it's now safe to make another dump
    $g_curhost panic clear
}


############################################################
#
# operUpgrade: upgrade the switch using the given file on remote host
#
#
proc operUpgrade { host_file } {
    global g_curhost g_switch_type errorCode

    if { ![runningOnSwitch] } { return }

    set host {}
    set file {}
    set colon [string first ":" $host_file]

    if { $colon > 0 } {
        set host [string range $host_file 0 [expr $colon - 1]]
        set file [string range $host_file [expr $colon + 1] end]
    }
    if { $host == {} || $file == {} } {
        ERROR "Invalid argument specification."
    }

    if { [sparcSwitch] } {
        if { [ftpFile get /tmp/distribution $file $host] } {
            cd /tmp
            puts "Processing the upgrade file..."
            if { [catch \
                  { exec tar xf /tmp/distribution ./fore_upgrade } result ] } {
                EMSG "This is an invalid upgrade file."
                return
            }
            if { [catch { exec ./fore_upgrade > /dev/tty } result ] } {
                EMSG "Error running the upgrade script."
                return
            }
        } else {
            return
        }
    } else {
        $g_curhost flash upgrade $host:$file interactive
    }

    puts "switch upgrade was successful."

    if { [yesorno "Reboot the switch" "y"] } {
        $g_curhost switch warmstart
	waitForSwitchUp
    }
}



############################################################
#
# operVersion: show/set software version
#
proc operVersion { newversion } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] } { return }

    if { [sparcSwitch] } {
        puts "\nThis switch does not support the version command"
	return
    }

    if { $newversion != {} } {
	$g_curhost flash version $newversion

	if { [yesorno "Reboot the switch" "y"] } {
	    $g_curhost switch warmstart
	}
    } else {
	$g_curhost flash version
    }
}




############################################################
#
# terminalRows: set number of rows
#
#
proc terminalRows { rows } {
    global g_term_rows g_term_row_offset
    if { $rows == {} } {
        puts "\nTerminal Rows = [expr $g_term_rows + $g_term_row_offset]"
    } else {
        if { $rows < 0 } { ERROR "Invalid number of rows" }
        if { $rows > 0 && $rows <= $g_term_row_offset } { 
            set rows [expr $g_term_row_offset + 1]
            puts "\nNumber of rows too small.  Rows set to $rows."
        }
        set g_term_rows [expr $rows - $g_term_row_offset]
    }
}


############################################################
#
# compiledWSCP: return 1 if WSCP is compiled
#
proc compiledWSCP {} {
    global g_curhost

    if { [catch { $g_curhost compiled WSCP } result] } {
        return 0
    }
    return 1
}


############################################################
#
# hasFlash: switch has flash
#
proc hasFlash {} {
    if { ![compiledWSCP] } {
        puts "\nNo flash file system available on this switch"
        return 0
    }
    return 1
}

############################################################
#
# operFlashFree: show the amount of free space left in flash
#
proc operFlashFree { } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    $g_curhost flash free
}

############################################################
#
# operFlashCopy: copy flash file
#
proc operFlashCopy { f1 f2 } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    $g_curhost flash copy $f1 $f2
}



############################################################
#
# operFlashDir: get flash directory listing
#
proc operFlashDir { f } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    set dirinfo [eval [concat $g_curhost flash dir $f]]
    
    initAMIputs
    
    foreach dirent $dirinfo { AMIputs "$dirent" }
}



############################################################
#
# operFlashDelete: delete flash file
#
proc operFlashDelete { f } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    $g_curhost flash delete $f
}



############################################################
#
# operFlashFormat: format flash filesystem
#
proc operFlashFormat { } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    puts "\n********** W A R N I N G **********\n"
    puts "If the switch is rebooted for any reason while formatting"
    puts "the flash the configuration of this switch will be destroyed."
    puts "As a result, when the switch control software is restarted."
    puts "you will only be able to connect to the switch using the"
    puts "serial port."

    if { [yesorno "Are you sure you want to format the flash" "n"] } {
        $g_curhost flash format mksysfiles
    }
}



############################################################
#
# operFlashGet: Get remote file into flash
#
proc operFlashGet { rf lf } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    $g_curhost tftp get $rf $lf
}



############################################################
#
# operFlashPut: send local file to remote
#
proc operFlashPut { lf rf } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    $g_curhost tftp put $lf $rf
}



############################################################
#
# operFlashRename: rename flash file
#
proc operFlashRename { f1 f2 } {
    global g_curhost g_switch_type

    if { ![runningOnSwitch] || ![hasFlash] } { return }

    $g_curhost flash rename $f1 $f2
}



############################################################
#
# atmarpShow: display ATM ARP entries
#
#
proc atmarpShow {} {
    global g_curhost

    set arps [$g_curhost atmarp get]
    set nsaps 0
    set pvcs  0

    if { $arps == {} } { return }

    initAMIputs

    foreach arp $arps {
	if { [getItemValue $arp -atmarpNsapAddress] == \
		"0000000000000000000000000000000000000000" } {
	    set pvcs  1
	} else {
	    set nsaps 1
	}
    }

    if { $pvcs == 1 } {

	AMIputs "[format "\n %-16s %-5s %-5s %-5s %-6s %-17s %s" \
		IPaddress If VPI VCI AAL Type Direction]"

	foreach arp $arps {
	    if { [getItemValue $arp -atmarpNsapAddress] == \
		    "0000000000000000000000000000000000000000" } {

		set status [getItemValue $arp -atmarpEntryStatus]
		if { $status != "valid" } {
		    set status "*"
		} else {
		    set status " "
		}
	    
		set ifname [$g_curhost if get \
			[getItemValue $arp -atmarpInterface] -ifDescr]

		AMIputs "[format "%s%-16s %-5s %-5s %-5s %-6s %-17s %s" \
			$status \
			[getItemValue $arp -atmarpIpAddress] \
			$ifname \
			[getItemValue $arp -atmarpVPI] \
			[getItemValue $arp -atmarpVCI] \
			[getItemValue $arp -atmarpAALType] \
			[getItemValue $arp -atmarpConnType] \
			[getItemValue $arp -atmarpConnDirection]]"
	    }
	}
    }

    if { $nsaps == 1 } {

	AMIputs "[format "\n %-16s %-5s %s" \
		IPaddress If "NSAP Address"]"

	foreach arp $arps {
	    if { [getItemValue $arp -atmarpNsapAddress] != \
		    "0000000000000000000000000000000000000000" } {

		set status [getItemValue $arp -atmarpEntryStatus]

		if { $status != "valid" } {
		    set status "*"
		} else {
		    set status " "
		}

		set ifname [$g_curhost if get \
			[getItemValue $arp -atmarpInterface] -ifDescr]

		AMIputs "[format "%s%-16s %-5s %s" \
			$status \
			[getItemValue $arp -atmarpIpAddress] \
			$ifname \
			[getItemValue $arp -atmarpNsapAddress]]"
	    }
	}
    }
}


############################################################
#
# atmarpFlush: flush the ATM ARP cache
#
#
proc atmarpFlush {} {
    global g_curhost

    if { [yesorno "Flush the ATM ARP cache" "n"] } {
        $g_curhost atmarp flush
    }
}


############################################################
#
# atmarpDeleteAny: delete an ARP entry
#
proc atmarpDeleteAny { host } {
    global g_curhost

    $g_curhost atmarp remove $host
}


############################################################
#
# atmarpNewClassical: create a classical IP PVC ARP entry
#
proc atmarpNewClassical { host vpi vci device } {
    global g_curhost

    if { $device == {} } { set device "qaa0" }

    set ifindex [getInterfaceNumber $device]
    $g_curhost atmarp classicalip $host $ifindex $vpi $vci
}


############################################################
#
# atmarpNewPVC: create an outgoing PVC ARP entry
#
proc atmarpNewPVC { host vpi vci aal device } {
    global g_curhost

    if { $device == {} } { set device "asx0" }

    switch $aal {
        "4" { set aal "aal34" }
        "5" { set aal "aal5" }
    }

    set ifindex [getInterfaceNumber $device]
    $g_curhost atmarp foreip $host $ifindex $vpi $vci $aal
}



############################################################
#
# atmarpserverSet: set NSAP address of arp server
#
proc atmarpserverSet { nsap device } {
    global g_curhost

    if { $device == {} } { set device "qaa0" }

    set ifindex [getInterfaceNumber $device]

    puts "\nSetting the ARP server NSAP address for $device"

    $g_curhost arpserver set $ifindex 1 \
            -classicalIpManualConfigArpServerAddr $nsap

    $g_curhost arpserver set $ifindex 1 \
            -classicalIpArpServerConfigType manualConfig

    #
    # For FT 3.0.2 disable this.  Driver automatically enables itself 
    # as arp server if the NSAP address specified is the same as this
    # interface's NSAP address
    # 
    $g_curhost arpserver set $ifindex 1 -classicalIpArpServer disable
}


############################################################
#
# atmarpserverShow: Display address of ARP server
#
proc atmarpserverShow { device } {
    global g_curhost

    if { $device == {} } { set device "qaa0" }

    set ifindex [getInterfaceNumber $device]
    set info [$g_curhost arpserver get $ifindex 1 \
            -classicalIpManualConfigArpServerAddr]

    if {$info == {} } {
        puts "\nNo arpserver information available"
        return
    }

    puts "\n$device ARP server address: $info"

    set info [$g_curhost arpserver get $ifindex 1 -classicalIpArpServer]

    if {$info == {} } {
        puts "\nThis interface is not enabled as arpserver"
        return
    }

    if { $info == "enable" } {
        puts "\n$device is enabled for ARP server service"
    } else {
        puts "\n$device is not enabled for ARP server service"
    }
}



############################################################
#
# atmarpMapnsap_ip: add an nsap to ip mapping
#
proc atmarpMapnsap_ip { host nsap device } {
    global g_curhost

    if { $device == {} } { set device "qaa0" }

    set ifindex [getInterfaceNumber $device]
    $g_curhost atmarp mapnsap $ifindex $nsap $host
}



############################################################
#
# atmarpMynsap: Get my NSAP address
#
proc atmarpMynsap { device } {
    global g_curhost

    if { $device == {} } { set device "qaa0" }

    set ifindex [getInterfaceNumber $device]
    set nsap [$g_curhost mynsap get $ifindex]

    puts "\n$device NSAP address: $nsap"
}



############################################################
#
# rpcAccess: Get or set RPC access level
#
proc rpcAccess { level } {
    global g_switch_type

    if { [compiledWSCP] } {
        EMSG "RPC access can not be changed on this switch."
        return
    }

    if { ![runningOnSwitch] } { return }

    if { $level != {} } {
        switch $level {
            "read"	{ set access "rpcReadOnly" }
            "write"	{ set access "rpcReadWrite" }
            "none"	{ set access "rpcNone" }
        }
        exec echo -n $access > /atm/etc/rpcat
    }

    set access "rpcReadOnly"
    catch { set access [exec cat /atm/etc/rpcat] } result

    switch $access {
        "rpcReadWrite" { set access "Read-Write" }
        "rpcReadOnly"  { set access "Read-Only" }
        "rpcNone"      { set access "None" }
        "default"      { set access "Unknown" }
    }

    puts "\nRPC access level is set to: $access"

    if { $level != {} } {
        puts "\nThe switch must be restarted for this change to take effect."
    }
}


############################################################
#
# printMenuTree: display the menu tree
#
#
proc printMenuTree { menutree tabs} {
    if { $tabs == {} } { 
        initAMIputs
        AMIputs {} 
    }
    set menutree [lrange $menutree 2 end]
    foreach menu $menutree {
        if { [isSubmenu [lindex $menu 1]] } {
            AMIputs "$tabs [lindex $menu 0]"
            set moretabs "$tabs    "
            printMenuTree $menu $moretabs
        } else {
            set args [lindex $menu 3]
            set moretabs ""
            if { [lindex $menu 5] == {} } {
                puts -nonewline "$tabs *[lindex $menu 0]"
            } else {
                puts -nonewline "$tabs [lindex $menu 0]"
            }
            if { [string length $args] > 0 } {
                while { [string length $args] > 0 } {
                    AMIputs "$moretabs  [string range $args 0 60]"
                    set args [string trim [string range $args 61 end]]
                    set moretabs "$tabs    "
                }
            } else {
                AMIputs {}
            }
        }
    }
    AMIputs {}
}



############################################################
#
# shipASX: prepare ASX switch for shipping
#
proc shipASX {} {
    if { [catch { exec /atm/release/fore/bin/perl \
            /atm/release/fore/bin/ship.pl > /dev/tty } result] != 0 } {
        puts "$result"
    }
}


############################################################
#
# enterTCL: enter the TCL interpreter
#
proc enterTCL {} {
    puts "\nType 'exit' to return to AMI\n"
    while { 1 } {
        puts -nonewline "% "
        gets stdin argv
        if { $argv == "exit" } { break }
        catch { eval $argv } result
        if { $result != {} } { puts $result }
    }
}


############################################################
#
# upOneLevel: go up 1 level
#
proc upOneLevel {} {
    global g_prompt

    if { [llength $g_prompt] > 0 } {
        set g_prompt [lrange $g_prompt 0 [expr [llength $g_prompt] - 2]]
    }
}


############################################################
#
# makeIndex: make an index using the command in itemlist
#
proc makeIndex { cmdlist } {
    set index {}
    foreach cmd $cmdlist {
        set index "$index\_$cmd"
    }
    return $index
}



############################################################
#
# mainloop: main loop
#
proc mainloop {} {
    global g_curhost g_prompt g_fullmenus g_shortmenus global g_exit
    global g_ambig_cmds g_unique_cmds g_expanded_menu 
    global g_expanded_cmd g_cmd_matchcount g_menu g_echo g_lasthost 
    global g_cmd_table

    set g_exit 0

    while { 1 } {
        if { $g_exit != 0 } { break }
        if { $g_curhost != $g_lasthost } {
            if { $g_curhost == {} } {
                set g_menu $g_shortmenus
            } else {
                set g_menu $g_fullmenus
            }
            set g_lasthost $g_curhost
        }

        if { $g_curhost != {} } { 
            puts -nonewline "\n$g_curhost::$g_prompt> " 
        } else {
            puts -nonewline "\n$g_prompt> "
        }

        if { [gets stdin argv] < 0 } { break }

        if { $argv == {} } { continue }

        if { [catch { set argv [lrange $argv 0 end] } result] } {
            EMSG "$result"
            continue
        }

        if {[compiledWSCP]} {
            if {$g_curhost == "localhost"} {
                if {[catch {must_wait} result]} {
                    puts "\nThe ami client running on the serial line has"
                    puts "suspended your session. Try again later"
                    break
                }
            }
        }

        if { $g_echo } { puts "$argv" }

        if { [lindex $argv 0] == "#" } { continue }

        if { [string tolower [lindex $argv 0]] == "redo"  && \
                [lindex $argv 1] != "?" } {
            if { [llength $argv] > 1 } {
                catch { set argv [history event [lrange $argv 1 end]] } result
            } else {
                catch { set argv \
                        [history event [expr [history nextid] - 1]] } result
            }
            DEBUGSTR "REDO: $argv"
        }

        history add $argv

        #
        # get a pointer to our command table for this command
        #
        set cmdlist [parseCommand $g_menu $g_prompt $argv]
        set cmdlen [llength $cmdlist]

        set cur_prompt $g_prompt

        if { $cmdlen > 0 && [lsearch $argv [lindex $cmdlist 0]] < 0 } {
            # 
            # abbreviated command, make sure there is no other matches
            #
            DEBUGSTR "abbreviated command, checking against unique commands"
            set cmdindex [lsearch $g_unique_cmds [lindex $argv 0]]
            if { $cmdindex >= 0 } {
                set cmdloc [lindex $g_unique_cmds [expr $cmdindex + 1]]
                set cmdlist [parseCommand $g_menu $cmdloc $argv]
                set cmdlen [llength $cmdlist]
                set g_expanded_cmd [concat $cmdloc $g_expanded_cmd]

                if { $cmdlen > 0 && [isSubmenu [lindex $cmdlist 1]] } {
                    set g_prompt {}
                }
            }
        }

        if { $cmdlen <= 0 && $g_cmd_matchcount <= 0 } {
            #
            # try searching from the top
            #
            DEBUGSTR "Searching menus from the top"
            set cmdlist [parseCommand $g_menu {} $argv]
            set cmdlen [llength $cmdlist]

            if { $cmdlen <= 0 } {
                #
                # try searching unique commands
                #
                DEBUGSTR "Checking against unique commands"
                set cmdindex [lsearch -glob $g_unique_cmds \
                        [string tolower [lindex $argv 0]]*]
                if { $cmdindex >= 0 } {
                    set cmdloc [lindex $g_unique_cmds [expr $cmdindex + 1]]
                    set cmdlist [parseCommand $g_menu $cmdloc $argv]
                    set cmdlen [llength $cmdlist]
                    set g_expanded_cmd [concat $cmdloc $g_expanded_cmd]
                }
            }

            if { $cmdlen > 0 && [isSubmenu [lindex $cmdlist 1]] } {
                set g_prompt {}
            }
        }

        if { $cmdlen > 0 } {
            #
            # process the command
            #
            set argv $g_expanded_cmd
            set arg0 [expr [lsearch $argv [lindex $cmdlist 0]] + 1]

            if { [lindex $argv $arg0] == "?" } {
                if { [isSubmenu [lindex $cmdlist 1]] } {
                    listCommands $g_menu [concat $g_prompt \
                            [lrange $g_expanded_cmd 0 [expr $arg0 - 1]]]
                    set g_prompt $cur_prompt
                    continue
                }
            }
            
            if { [catch { set cmdlist \
                    $g_cmd_table([makeIndex "$g_prompt \
                    [lrange $g_expanded_cmd 0 [expr $arg0 - 1]]"])} result] } {
                if { [catch { set cmdlist \
                        $g_cmd_table([makeIndex "[lrange $g_expanded_cmd 0 \
                        [expr $arg0 - 1]]"]) } result] } {
                    EMSG "Invalid command"
                    continue
                }
            }

            if { [lindex $argv $arg0] == "?" } {
                argumentHelp $cmdlist
                continue
            }

            if { [isCommand [lindex $cmdlist 1]] } {
                if { [catch { set proc [parseArguments $cmdlist \
                        [lrange $argv $arg0 end]] } result] != 0 } {
                    if { $result != {} } { EMSG "$result" }
                    continue
                }
                if { [llength $proc] > 0 } {
                    DEBUGSTR "eval '$proc'"
                    if { [catch { uplevel #0 $proc } result] != 0 } {
                        if { $result != {} } { EMSG "$result" }
                    }
                }
                continue
            }
            if { [llength [lrange $argv $arg0 end]] <= 0 } {
                set g_prompt [concat $g_prompt $argv]
                continue
            }
        }

        if { $g_cmd_matchcount > 0 || [lsearch -glob $g_ambig_cmds \
                [string tolower [lindex $argv 0]]*] >= 0 } {
            EMSG "Ambiguous command"
        } else {
            EMSG "Invalid command"
        }
    }

    return $g_exit
}



############################################################
#
# buildMenuTable: parse the given menu tree and store the
#                commands into an associative array
#
	proc buildMenuTable { menutree prefix } {
    global g_fullmenus g_cmd_table
	    if { $menutree == {} } {
		set newtree { root {} }
		set menutree [lrange $g_fullmenus 2 end]
	    } else {
		set newtree {} 
	    }
 
	    foreach menu $menutree {
		set name "$prefix [lindex $menu 0]"
		if { [isCommand [lindex $menu 1]] } {
		    set g_cmd_table([makeIndex $name]) $menu
		    set newtree [lappend newtree "[lrange $menu 0 1] {} {} {} {}"]
		} else {
		    set g_cmd_table([makeIndex $name]) [lrange $menu 0 1]
		    set subtree [buildMenuTable \
				     [lrange $menu 2 end] "$prefix [lindex $menu 0]"]
		    if { [isHiddenCommand [lindex $menu 1]] } {
			set newtree [lappend newtree "[lindex $menu 0] & $subtree"]
		    } else {
			set newtree [lappend newtree "[lindex $menu 0] {} $subtree"]
		    }
		}
	    }
    return $newtree
	}
 
 
############################################################
#
# main entry to AMI
#
#

set tcl_precision 4

if { $argc > 2 } {
    EMSG "Wrong number of arguments"
    puts "usage: $argv0 \[<hostname> \[<community>\]\]"
    return
}

setGlobals

showVersionInfo

scanUniqueCommands $g_fullmenus "init" ""

puts "\n$g_generalinfo"

#
# list of paltform and connection dependent menus
#
set local_menus { \
        { "operation cdb" { backup restore } } \
        { "operation" { reboot upgrade trace} } \
}

set wscp_local_menus { \
        { "operation cdb" { init } } \
        { "operation" { flash panic version} } \
} 

set asx_local_menus { \
        { "operation" { halt log password rpc test } } \
}

#
# Move the actual commands into an array to speed up parsing
#
set g_fullmenus [buildMenuTable {} {}]

#
# initialize menus and open initial connection (if requested)
#
set g_lasthost {}
set g_menu $g_shortmenus

if { $argc > 0 } {
    if { [catch { eval \
            [concat set g_curhost [openSession \
            [lindex $argv 0] [lindex $argv 1]]] } result] != 0 } {
        puts "$result"
    }
}

#
# now remove any menus that don't apply here
#
if { $g_curhost != "localhost" } {
    set removelist [concat $local_menus $asx_local_menus $wscp_local_menus]
} else {
    if { [compiledWSCP] } {
        set removelist $asx_local_menus
    } else {
        set removelist $wscp_local_menus
    }
}

foreach xmenu $removelist {
    set g_fullmenus [removeMenu $xmenu $g_fullmenus ""]
}


set g_echo 0

ami_C_main
