#include <stdio.h>

#define crash(fmt, args...) do {fprintf(stderr, fmt , ##args);exit(1);} while(0)

void emit (int vc)
{
  static int hilo, value;
  static int addr = 0x1000;

  if (hilo == 0) {
    value = vc;
    hilo = 1;
  }
  else {
    value = (vc<<16) + value;
    printf ("sramwrite 0x%x 0x%x\n", addr, value);
    addr += 4;
    hilo = 0;
  }
}


int main (int argc, char **argv)
{
  int vc, count, burst, slots;

  if (argc != 2)
    crash ("Usage: %s burst\n", argv[0]);
  
  burst = atoi(argv[1]);

  vc = 1;
  count = burst;
  slots = 1024;
  while (slots--) {
    emit (vc);
    if (--count == 0) {
      count = burst;
      if (++vc > 3)
        vc = 1;
    }
  }
}  
  
    

  
