#ifndef _IJET_REG_H_
#define _IJET_REG_H_

#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_jet.h>

public void
reg_AppendVrlistToFreelist (int unit, freelist_t freelistId,
                            vr_t *currentTailp, vr_t *headp);

public void reg_AddVcToDynamicList (int unit, int listNum, vcid_t vcid,
                                    int burstSize);

public uint32 reg_ReadDynamicRegister (int unit, int listNum,
                                       jet_dynamic_regs_t whichReg);

public void reg_WriteDynamicRegister (int unit, int listNum,
                                      jet_dynamic_regs_t whichReg,
                                      uint32 value);

public void
reg_AppendVrThenScheduleStatic (int unit, vcid_t vcid, vr_t *headp,
                                vr_t *currentTailp);
public void
reg_AppendVrThenScheduleDynamic (int unit, int listNum, vcid_t vcid, 
                                 int burstSize, vr_t *headp,
                                 vr_t *currentTailp);

public int reg_ReadStaticBitVector (int unit, int vcid);
public void reg_WriteStaticBitVector (int unit, int vcid, int bit);

public uint32 reg_ReadStaticRegister (int unit,
                                      jet_static_regs_t whichReg);

public void reg_WriteStaticRegister (int unit,
                                     jet_static_regs_t whichReg,
                                     uint32 value);

#endif /* _IJET_REG_H_ */
