int hacknum = 1;
int hackdenom = 1;
int hackvc = 0xfffe;  /* JET_STATIC_SCHEDULE_DYNAMIC */
int manrxlinking = 0;
int mantxlinking = 0;
int txwaithack = 0;

int permit0 = 0;
int d9land = 0xff0000;  /* ...db to enable credit, d9 to not enable credit */

#define CREDIT_VCID        0xbb

/*
 * The initialization routine for the low-level interface module.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/malloc.h>

#include <sys/socket.h>
#include <sys/device.h>
#include <net/if.h>
#include <dev/pci/pcireg.h>
#include <dev/pci/pcivar.h>

#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_jet.h>
#include <dev/pci/jetland/include/ijet_ll.h>
#include <dev/pci/jetland/include/ijet_ll_internals.h>
#include <dev/pci/jetland/include/ijet_sonet.h>
#include <dev/pci/jetland/include/ijet_reg.h>

public void DebugNewline () {}


public ll_error_t PartitionSram (int unit,
                                  uint32 *rxTableOffset, int *numRxVcs,
                                  uint32 *txTableOffset, int *numTxVcs,
                                  uint32 *vrTableOffset, int *numVrs,
                                  uint32 *staticTableOffset,
                                  int *numStaticTableEntries,
                                  uint32 *dynamicTableOffset,
                                  int *numDynamicLists,
                                  int *numDynamicEntriesPerList);

private uint32 RoundUpToPowerOfTwo (uint32 value, uint32 lower, uint32 upper);

public rxTableEntry_t *ll_rxTableBase   [NIJET];
public txTableEntry_t *ll_txTableBase   [NIJET];
public vr_t           *ll_vrBase        [NIJET];
public vr_t           *ll_vrPartition   [NIJET];
public int             ll_rxVcExtraction[NIJET];

public int mummert_timeout = 0;  /* kosak HACK */
public int ijet_firstAppendEver[NIJET][JET_MAX_FREELISTS];

public int ll_bitmasks[]=
{
    0x0,

    0x0001,0x0003,0x0007,0x000f,
    0x001f,0x003f,0x007f,0x00ff,
    0x01ff,0x03ff,0x07ff,0x0fff,
    0x1fff,0x3fff,0x7fff,0xffff,

    0x0001ffff,0x0003ffff,0x0007ffff,0x000fffff,
    0x001fffff,0x003fffff,0x007fffff,0x00ffffff,
    0x01ffffff,0x03ffffff,0x07ffffff,0x0fffffff,
    0x1fffffff,0x3fffffff,0x7fffffff,0xffffffff
};

public bool                 jet_adaptorFound[NIJET] = {FALSE};
public bool                 jet_oc12        [NIJET] = {FALSE};
public caddr_t              jet_sramBase    [NIJET];
public volatile jet_regs_t *jet_asicBase    [NIJET];
public volatile char       *jet_sonetBase   [NIJET];
public uint32               jet_sramSize    [NIJET];
public uint32              *jet_hackFlag    [NIJET];

public uint32               jet_numStaticTableEntries [NIJET];
public staticTableEntry_t  *jet_staticTable [NIJET];

/*
 *
 */

public void jet_Goose(int unit, vm_offset_t sramBase, uint32 sramSize,
		      vm_offset_t asicBase, vm_offset_t sonetBase)
     begin(jet_Goose);
{
  /* FIX:: TODD */
  /* assert(JET_UNIT_VALID(unit)); */
  
  jet_sramBase [unit] = (caddr_t)         sramBase;
  jet_sramSize [unit] =                   sramSize;
  jet_asicBase [unit] = (jet_regs_t *)    asicBase;
  jet_sonetBase[unit] = (volatile char *) sonetBase;
  jet_adaptorFound[unit] = TRUE;

  jet_hackFlag[unit] = &((uint32*)sramBase)[4];
}
end(jet_Goose);



public int
jet_InterruptToMaskStatusRegp (in  int unit, intr_interrupt_t interrupt,
                               out volatile uint32 **maskregpp,
			       out volatile uint32 **statusregpp)
begin (jet_InterruptToMaskStatusRegp);
{
    int index;
    volatile uint32 *maskregp;
    volatile uint32 *statusregp;

    assert (((int) interrupt >= 0) && (interrupt < INTR_NUM_INTERRUPTS));


    if (((int) interrupt >= INTR_MBX_OFFSET) &&
        (interrupt <  INTR_MBX_OFFSET + INTR_NUM_MBX_INTERRUPTS))
    {
        maskregp=   &jet_asicBase[unit]->imr_mbx;
        statusregp= &jet_asicBase[unit]->isr_mbx;

        index= interrupt - INTR_MBX_OFFSET;
    }
    else
    {
        maskregp=   &jet_asicBase[unit]->imr_msc;
        statusregp= &jet_asicBase[unit]->isr_msc;

        index= interrupt - INTR_MSC_OFFSET;
    }

    if (maskregpp)
        *maskregpp= maskregp;

    if (statusregpp)
        *statusregpp= statusregp;

    return index;
}
end (jet_InterruptToMaskStatusRegp);



/* ll_Init -- initialize the hardware and the ll_ module
 *
 * This routine is called when the hardware and the low level interface
 * need to be initialized or reinitialized.
 *
 * jet_Goose needs to have been called first in order to provide us
 * pointers to ASIC registers, etc.
 *
 * Results:
 *
 *    SUCCESS
 */

public ll_error_t ll_Init (int unit,
                           int numRxVcs, int numTxVcs, int numVrs,
                           int numStaticTableEntries,
                           int numDynamicLists, int numDynamicEntriesPerList,
                           int rxVcExtraction,
                           caddr_t ucode, int ucodeSize)
begin (ll_Init);
{
    uint32 rxTableOffset, txTableOffset, vrTableOffset, staticTableOffset;
    uint32 dynamicTableOffset;
    ll_error_t error;

    /* Detect board type */
    jet_SonetDetect(unit);

    if (jet_oc12[unit]) {
	warn ("OC-12 board hackage bogus suck suck suck\n");
	jet_sramSize[unit] = 0x1e0000;
	jet_hackFlag[unit] = &((uint32*) jet_sramBase)[0x68004];
    }

    {
        static jet_reg_cmd_reg_t reg;
        jet_asicBase[unit]->cmd_reg = reg;
    }

    if ((error = intr_Init(unit)) < 0)
        return error;
    if ((error = jet_SramInit (unit)) < 0)
        return error;
    if ((error = jet_LbiInit (unit)) < 0)
        return error;
    if ((error = jet_DownloadUcode (unit, (uint32 *) ucode, (uint32) ucodeSize)) < 0)
        return error;
    if ((error = jet_AsicInit  (unit)) < 0)
        return error;
    if ((error = jet_SonetInit (unit)) < 0)
        return error;
    if ((error = PartitionSram (unit,
                                &rxTableOffset, &numRxVcs,
                                &txTableOffset, &numTxVcs,
                                &vrTableOffset, &numVrs,
                                &staticTableOffset,
                                &numStaticTableEntries,
                                &dynamicTableOffset,
                                &numDynamicLists,
                                &numDynamicEntriesPerList)) < 0)
        return error;
    if ((error = ll_MailboxInit (unit)) < 0)
        return error;
    if ((error = ll_FreelistInit (unit)) < 0)
        return error;
    if ((error = ll_VcInit (unit, rxTableOffset, numRxVcs, txTableOffset,
                            numTxVcs, rxVcExtraction)) < 0)
        return error;
    if ((error = ll_VrInit (unit, vrTableOffset, numVrs)) < 0)
        return error;
    if ((error = ll_StaticSchedulerInit (unit, staticTableOffset,
                                         numStaticTableEntries)) < 0)
        return error;
    if ((error = ll_DynamicSchedulerInit (unit,
                                          txTableOffset, dynamicTableOffset,
                                          numDynamicLists,
                                          numDynamicEntriesPerList)) < 0)
        return error;

    {
        jet_reg_cmd_reg_t reg= jet_asicBase[unit]->cmd_reg;
        reg.enable= TRUE;
        jet_asicBase[unit]->cmd_reg= reg;
    }

    {
        jet_reg_txrx_arb_t reg = jet_asicBase[unit]->txrx_arb;
        reg.rxCount= 0xf;
        reg.txCount= 0xf;
        jet_asicBase[unit]->txrx_arb = reg;
    }

    return SUCCESS;
}
end (ll_Init);

/*
 * this partitions SRAM into the appropriate regions.
 * It may also force input parameters to a specific value
 * (e.g. for alignment purposes)
 */


public ll_error_t PartitionSram (int unit,
                                  uint32 *rxTableOffset, int *numRxVcs,
                                  uint32 *txTableOffset, int *numTxVcs,
                                  uint32 *vrTableOffset, int *numVrs,
                                  uint32 *staticTableOffset,
                                  int *numStaticTableEntries,
                                  uint32 *dynamicTableOffset,
                                  int *numDynamicLists,
                                  int *numDynamicEntriesPerList)
begin (PartitionSram);
{
    bool moveSchTables;
    uint32 nextFree;

#ifdef IJET_VPC_CREDIT
    nextFree = 0x10000;
    moveSchTables = TRUE;
#else
    nextFree = 0x20;  /* locations 0 and 16 are reserved. */
    moveSchTables = FALSE;
#endif


    if (jet_oc12[unit]) {
#ifdef IJET_VPC_CREDIT	
	nextFree = 0x1b0000;
	moveSchTables = TRUE;
#else	
	nextFree = 0x1a0020;
	moveSchTables = FALSE;
#endif
    }

    /* 
     * If nextFree is 0x10000 or 0x1b0000 to accomodate the rate scheduler
     * move the static and dynamic table towards the end of SRAM to preserve
     * some memory space.
     */
    if (!moveSchTables) {
	{
	    uint32 staticTableSize;
	    uint32 bitmask;
	    
	    staticTableSize= 
		*numStaticTableEntries * sizeof (staticTableEntry_t);

	    /* needs dWord alignment */
	    
	    bitmask= ll_bitmasks [ll_Mylog2 (sizeof (uint32))];
	    *staticTableOffset= (nextFree + bitmask) & ~bitmask;
	    
	    if (*staticTableOffset + staticTableSize > jet_sramSize[unit])
		return LL_ERROR_PARTITION_FAILED;
	    
	    warn ("static table: sram address 0x%x, size 0x%x\n",
		  *staticTableOffset, staticTableSize);
	    
	    nextFree= *staticTableOffset + staticTableSize;
	}
 
	{                                                       
	    uint32 dynamicTableSize;                                        
	    uint32 bitmask;                                                 
	    
	    dynamicTableSize= *numDynamicLists * *numDynamicEntriesPerList *
		sizeof (dynamicListEntry_t);                     
	    
	    /* HACK: what alignment?  I guess 1K */                         
	    
	    bitmask= ll_bitmasks [10 + ll_Mylog2 (sizeof (uint32))];        
	    *dynamicTableOffset= (nextFree + bitmask) & ~bitmask;           
	    
	    if (*dynamicTableOffset + dynamicTableSize > jet_sramSize[unit])
		return LL_ERROR_PARTITION_FAILED;                     
	    
	    warn ("dynamic table: sram address 0x%x, size 0x%x\n",         
		  *dynamicTableOffset, dynamicTableSize);      
	    
	    nextFree= *dynamicTableOffset + dynamicTableSize;             
	}           
    }                                             
   
    {
        uint32 txTableSize;
        uint32 bitmask;

        *numTxVcs = RoundUpToPowerOfTwo (*numTxVcs, 1024, 65536);
        if (*numTxVcs == 0)
            return LL_ERROR_PARTITION_FAILED;

	/* the transmit table is "naturally aligned" */

        txTableSize = *numTxVcs * sizeof (txTableEntry_t);
       
        bitmask = txTableSize - 1;
        *txTableOffset= (nextFree + bitmask) & ~bitmask;

        if (*txTableOffset + txTableSize > jet_sramSize[unit])
            return LL_ERROR_PARTITION_FAILED;

        warn ("txTable: sram address 0x%x, size 0x%x\n",
               *txTableOffset, txTableSize);

        nextFree= *txTableOffset + txTableSize;
    }
 
    /*
     * compute start of RxTable
     */

    {
        uint32 rxTableSize;
        uint32 bitmask;

        *numRxVcs = RoundUpToPowerOfTwo (*numRxVcs, 1024, 65536);
        if (*numRxVcs == 0)
            return LL_ERROR_PARTITION_FAILED;

	/* the receive table is "naturally aligned" */

        rxTableSize = *numRxVcs * sizeof (rxTableEntry_t);

        bitmask = rxTableSize - 1;
        *rxTableOffset= (nextFree + bitmask) & ~bitmask;

        if (*rxTableOffset + rxTableSize > jet_sramSize[unit])
            return LL_ERROR_PARTITION_FAILED;

        warn ("rxTable: sram address 0x%x, size 0x%x\n",
               *rxTableOffset, rxTableSize);

        nextFree= *rxTableOffset + rxTableSize;
    }

    if (moveSchTables) {
	{
	    uint32 staticTableSize;
	    uint32 bitmask;
	    
	    staticTableSize= 
		*numStaticTableEntries * sizeof (staticTableEntry_t);
	    
	    /* needs dWord alignment */
	    
	    bitmask= ll_bitmasks [ll_Mylog2 (sizeof (uint32))];
	    *staticTableOffset= (nextFree + bitmask) & ~bitmask;
	    
	    if (*staticTableOffset + staticTableSize > jet_sramSize[unit])
		return LL_ERROR_PARTITION_FAILED;
	    
	    warn ("static table: sram address 0x%x, size 0x%x\n",
		  *staticTableOffset, staticTableSize);
	    
	    nextFree= *staticTableOffset + staticTableSize;
	}
 
	{                                                       
	    uint32 dynamicTableSize;                                        
	    uint32 bitmask;                                                 
	    
	    dynamicTableSize= *numDynamicLists * *numDynamicEntriesPerList *
		sizeof (dynamicListEntry_t);                     
	    
	    /* HACK: what alignment?  I guess 1K */                         
	    
	    bitmask= ll_bitmasks [10 + ll_Mylog2 (sizeof (uint32))];        
	    *dynamicTableOffset= (nextFree + bitmask) & ~bitmask;           
	    
	    if (*dynamicTableOffset + dynamicTableSize > jet_sramSize[unit])
		return LL_ERROR_PARTITION_FAILED;                     
	    
	    warn ("dynamic table: sram address 0x%x, size 0x%x\n",         
		  *dynamicTableOffset, dynamicTableSize);      
	    
	    nextFree= *dynamicTableOffset + dynamicTableSize;             
	}           
    }                               
 
    {
        uint32 vrTableSize;
        uint32 bitmask;

        vrTableSize= *numVrs * sizeof (vr_t);

        bitmask= ll_bitmasks [ll_Mylog2 (sizeof (vr_t))];
        *vrTableOffset= (nextFree + bitmask) & ~bitmask;

        if (*vrTableOffset + vrTableSize > jet_sramSize[unit]) {
	    warn ("Asked for %d VRs, have space for only %d VRs\n", *numVrs,
		  (jet_sramSize[unit] - *vrTableOffset)/sizeof(vr_t));
            return LL_ERROR_PARTITION_FAILED;
	}

        warn ("vr partition: sram address 0x%x, size 0x%x\n",
               *vrTableOffset, vrTableSize);

        nextFree= *vrTableOffset + vrTableSize;
    }

    return SUCCESS;
}
end (PartitionSram);


private uint32 RoundUpToPowerOfTwo (uint32 value, uint32 lower, uint32 upper)
begin (RoundUpToPowerOfTwo);
{
    int i;

    i= 1;
    while (((i < lower) || (i < value)) &&
           (i <= upper))
        i *= 2;

    if (i <= upper)
        return i;
    else
        return -1;

    notreached;
}
end (RoundUpToPowerOfTwo);



internal uint32 ll_Mylog2 (uint32 value)
begin (ll_Mylog2);
{
    int i= 1;
    int retval= 0;

    while (i < value)
    {
        i *= 2;
        retval++;
    }

    return retval;
}
end (ll_Mylog2);



/*------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 * Routines for handling VC's
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------*/

/*
 * tables which answer the question: is a particular (tx, rx) vcid in use?
 */

private bool *rxTableUsed[NIJET];
private bool *txTableUsed[NIJET];
private int numRxVcs[NIJET];
private int numTxVcs[NIJET];

/*
 * table which contains the current tail pointer for each Tx VC
 */

private vr_t **txTailp[NIJET];


/*
 * ll_VcInit -- initialize the VC module
 *
 * Parameters:
 *    rxTableOffset - offset in SRAM of the RxTable
 *    p_numRxVcs    - number of entries in that table
 *    txTableOffset - offset in SRAM of the TxTable
 *    p_numTxVcs    - number of entries in that table
 *    vciVpiMapping - the vcivpi-->vcid mapping
 */

internal ll_error_t ll_VcInit (int unit,
                               uint32 rxTableOffset, uint32 p_numRxVcs,
                               uint32 txTableOffset, uint32 p_numTxVcs,
                               int rxVcExtraction)
begin (ll_VcInit);
{
    assert (sizeof(*jet_sramBase[unit]) == 1);

    ll_rxTableBase[unit]=
        (rxTableEntry_t *) (jet_sramBase[unit] + rxTableOffset);
    ll_txTableBase[unit]=
        (txTableEntry_t *) (jet_sramBase[unit] + txTableOffset);

    numRxVcs[unit]= p_numRxVcs;
    numTxVcs[unit]= p_numTxVcs;
  
    {
      int i;
      uint32 *p;
      debug ("zeroing rxTable\n");

      p= (uint32 *) ll_rxTableBase[unit];
      for (i= 0; i < numRxVcs[unit] * sizeof(rxTableEntry_t) / sizeof(uint32); i++)
	p[i]= 0;

      debug ("zeroing txTable\n");
      p= (uint32 *) ll_txTableBase[unit];
      for (i= 0; i < numTxVcs[unit] * sizeof(txTableEntry_t) / sizeof(uint32); i++)
	p[i]= 0;
    }

    rxTableUsed[unit]= malloc (numRxVcs[unit] * sizeof (*rxTableUsed[unit]),
			       M_DEVBUF, M_WAITOK);
    txTableUsed[unit]= malloc (numTxVcs[unit] * sizeof (*txTableUsed[unit]),
			       M_DEVBUF, M_WAITOK);
    txTailp    [unit]= malloc (numTxVcs[unit] * sizeof (*txTailp[unit]),
			       M_DEVBUF, M_WAITOK);

    assert (rxTableUsed[unit] != NULL);
    assert (txTableUsed[unit] != NULL);
    assert (txTailp    [unit] != NULL);

    {
        int i;

        for (i= 1; i < numRxVcs[unit]; i++)
            rxTableUsed[unit][i] = FALSE;

        for (i= 1; i < numTxVcs[unit]; i++) {
            txTableUsed[unit][i] = FALSE;
            txTailp    [unit][i] = NULL;
        }

        rxTableUsed[unit][0] = txTableUsed[unit][0] = TRUE;
    }
    if (permit0) {
      warn ("WARNING: permitting tx vcid 0 (hack)\n");
      txTableUsed[unit][0] = FALSE;  /* kosak HACK */
    } else
      warn ("not permitting tx vcid 0\n");

    {
        uint32 value=
            rxTableOffset >> (10 + ll_Mylog2 (sizeof (rxTableEntry_t)));

        debug ("rxTableOffset is 0x%x; setting rx_vtba to 0x%x\n",
               rxTableOffset, value);
        
        jet_asicBase[unit]->rx_vtba= value;
    }

    {
        uint32 value=
            txTableOffset >> (10 + ll_Mylog2 (sizeof (txTableEntry_t)));

        debug ("txTableOffset is 0x%x; setting tx_vtba to 0x%x\n",
               txTableOffset, value);

        jet_asicBase[unit]->tx_vtba= value;
    }

    jet_asicBase[unit]->rx_vtba_msk= (~((numRxVcs[unit] >> 10)-1)) & 0x3f;

    {
        jet_reg_cfg_reg_t reg= jet_asicBase[unit]->cfg_reg;

        debug ("setting rxVcExtraction to 0x%x\n", rxVcExtraction);
        reg.rxVcExtraction= rxVcExtraction;
        jet_asicBase[unit]->cfg_reg= reg;
        ll_rxVcExtraction[unit] = rxVcExtraction;
    }

    return SUCCESS;
}
end (ll_VcInit);



internal ll_error_t ll_VcShutdown (int unit)
begin (ll_VcShutdown);
{
    return SUCCESS;
}
end (ll_VcShutdown);



/*
 * ll_OpenRx -- set up a Rx VC Table entry for receiving on a VC
 *
 *
 * Parameters:
 *    cellProcessing -- cell processing type (e.g. AAL5)
 *    mailbox -- mailbox to which this VC will post messages
 *    headerFreelist
 *    dataFreelist   -- freelists from which this VC will get buffers
 *    vpivcip -- pointer to VPI/VCI to use (set your variable to
 *               VCI_DONTCARE if you want this routine to pick one for you)
 *
 * Note on VPI/VCI: This is the "canonical" form of the VPI/VCI:
 * VPI*65536 + VCI
 * This routine will convert that to the "adaptor" form, which varies
 * according to RxVcExtraction.
 *
 * Returns:
 *    VCID of your table entry (>= 0)
 *
 *    otherwise...
 *
 *    LL_ERROR_BAD_VCIVPI -- VCIVPI somehow bad
 *
 *    LL_ERROR_VCID_IN_USE -- the VCI/VPI you selected maps to a vcid already
 *                          in use
 *
 *    LL_ERROR_NO_FREE_VCIDS -- table full
 *
 *
 * Side effects:
 *    If value at *vpivcip was VCI_DONTCARE, it is changed to the VCI/VPI
 *    that the routine picked for you
 *
 */

public vcid_t ll_OpenRx (
    in     int unit, cellProcessing_t cellProcessing, mailbox_t mailbox,
           freelist_t headerFreelist, freelist_t dataFreelist,
    in_out vpivci_t *vpivcip)
begin (ll_OpenRx);
{
  vcid_t vcid;
  static rxTableEntry_t rxEntry; /* initially 0's */

  assert (JET_MAILBOXOK  (mailbox));
  assert (JET_FREELISTOK (headerFreelist));
  assert (JET_FREELISTOK (dataFreelist));

  if (*vpivcip == LL_VCI_DONTCARE) {
    int i;
    
    /*
     * HACK: fix this so it's not linear search
     */
    
    for (i = 0; i < numRxVcs[unit]; i++)
      if (!rxTableUsed[unit][i])
	break;
    
    if (i == numRxVcs[unit])
      return LL_ERROR_NO_FREE_VCIDS;
    
    *vpivcip = i;
    vcid = i;
  }
  else {
    if ((vcid = ll_VpivciToVcid (unit, *vpivcip)) < 0)
      return LL_ERROR_BAD_VCIVPI;
    
    if (rxTableUsed[unit][vcid])
      return LL_ERROR_VCID_IN_USE;
  }
  
  /*
   * Make entry in host memory and then slam it into SRAM
   */

  rxEntry.vrIndex =        0;
  rxEntry.cellProcessing = cellProcessing;
  rxEntry.mailbox =        mailbox;
  rxEntry.firstBuffer =    TRUE;
  rxEntry.freelistA =      headerFreelist;
  rxEntry.freelistB =      dataFreelist;
  rxEntry.crc =            JET_INITIAL_CRC;

  ll_rxTableBase[unit][vcid] = rxEntry;
  rxTableUsed[unit][vcid] = TRUE;

  ll_IncrementMailboxUserCount  (unit, mailbox);
  ll_IncrementFreelistUserCount (unit, headerFreelist);
  ll_IncrementFreelistUserCount (unit, dataFreelist);

#ifdef IJET_VPC_CREDIT
  /* 
   * We only use even numbered VCIDs
   */
  rxTableUsed[unit][vcid+1] = TRUE;
#endif

  return vcid;
}
end (ll_OpenRx);



/*
 * ll_OpenTx -- set up a Tx VC Table entry for sending on a VC
 *
 *
 * Parameters:
 *    cellProcessing -- cell processing type (e.g. AAL5)
 *    mailbox -- mailbox to which this VC will post messages
 *    scheduling -- type of scheduling (static vs dynamic)
 *    vpivci -- the VCI/VPI that gets put in the cell header
 *              (unlike Rx, there is no relationship between this VCI/VPI
 *               and the VCID that gets returned)
 *
 * Returns:
 *    VCID of your table entry (>= 0)
 *
 *    otherwise...
 *
 *    LL_ERROR_BAD_VCIVPI -- VCIVPI somehow bad
 *
 *    LL_ERROR_NO_FREE_VCIDS -- table full
 */

public vcid_t ll_OpenTx (int unit, cellProcessing_t cellProcessing,
                         mailbox_t mailbox, scheduling_t scheduling,
                         vpivci_t vpivci)
begin (ll_OpenTx);
{
  vcid_t vcid, startIndex;
  static txTableEntry_t txEntry;

  assert (JET_MAILBOXOK (mailbox));

  if (!VcivpiOK (vpivci))
    return LL_ERROR_BAD_VCIVPI;

  if (scheduling == SCHEDULE_STATIC)
    startIndex= STATIC_FIRST_VCID;
  else
    startIndex= DYNAMIC_FIRST_VCID;


  vcid = vpivci;
  if (txTableUsed[unit][vcid])
    return LL_ERROR_VCID_IN_USE;


  /*
   * make entry in host memory and then slam it into SRAM
   */

  txEntry.creditValue=     0;
  txEntry.dynamicListMask= 0;
  txEntry.vrIndex=         0;
  txEntry.cellProcessing=  cellProcessing;
  txEntry.mailbox=         mailbox;
  txEntry.crc=             JET_INITIAL_CRC;
  txEntry.vpivci=          vpivci;

  ll_txTableBase[unit][vcid]= txEntry;
  txTableUsed[unit][vcid]= TRUE;
  ll_IncrementMailboxUserCount (unit, mailbox);
#ifdef IJET_VPC_CREDIT
  /*
   * We want to use only even vcids to incorporate the rate scheduler 
   */
  txTableUsed[unit][vcid+1] = TRUE;
#endif
  return vcid;
}
end (ll_OpenTx);

#ifdef IJET_VPC_CREDIT
public vcid_t ll_OpenCreditTx (int unit, cellProcessing_t cellProcessing,
			       mailbox_t mailbox, scheduling_t scheduling,
			       vpivci_t creditVci)
begin ();
{
  vcid_t vcid;
  static txTableEntry_t txEntry;

  assert (JET_MAILBOXOK (mailbox));

  if (!VcivpiOK (vpivci))
    return LL_ERROR_BAD_VCIVPI;


  vcid = CREDIT_VCID;
  if (txTableUsed[unit][vcid])
    return LL_ERROR_VCID_IN_USE;


  /*
   * make entry in host memory and then slam it into SRAM
   */

  txEntry.creditValue=     0;
  txEntry.dynamicListMask= 0;
  txEntry.vrIndex=         0;
  txEntry.cellProcessing=  cellProcessing;
  txEntry.mailbox=         mailbox;
  txEntry.crc=             JET_INITIAL_CRC;
  txEntry.vpivci=          creditVci;

  ll_txTableBase[unit][vcid]= txEntry;
  txTableUsed[unit][vcid]= TRUE;
  ll_IncrementMailboxUserCount (unit, mailbox);
  /*
   * We want to use only even vcids to incorporate the rate scheduler 
   */
  txTableUsed[unit][vcid+1] = TRUE;
  return vcid;
}
end ();
#endif


/*
 * ll_CloseRx -- close Rx
 *
 * Parameters:
 *    vcid -- the VCID to close
 *
 * work needs to be done here
 *
 */

public void ll_CloseRx (int unit, vcid_t vcid)
begin (ll_CloseRx);
{
    static rxTableEntry_t zeroEntry = {0};
    rxTableEntry_t rxEntry;

    assert (vcid < numRxVcs[unit]);
    assert (rxTableUsed[unit][vcid]);

    rxEntry = ll_rxTableBase[unit][vcid];

    ll_DecrementMailboxUserCount  (unit, rxEntry.mailbox);
    ll_DecrementFreelistUserCount (unit, rxEntry.freelistA);
    ll_DecrementFreelistUserCount (unit, rxEntry.freelistB);

    ll_rxTableBase[unit][vcid] = zeroEntry;

    rxTableUsed[unit][vcid]= FALSE;
}
end (ll_CloseRx);



/*
 * ll_CloseTx -- close Tx
 *
 * Parameters:
 *    vcid -- the VCID to close
 *
 * work needs to be done here
 *
 */

public void ll_CloseTx (int unit, vcid_t vcid)
begin (ll_CloseTx);
{
    static txTableEntry_t zeroEntry = {0};
    txTableEntry_t txEntry;

    assert (vcid < numTxVcs[unit]);
    assert (txTableUsed[unit][vcid]);

    txEntry = ll_txTableBase[unit][vcid];

    ll_DecrementMailboxUserCount (unit, txEntry.mailbox);

    ll_txTableBase[unit][vcid] = zeroEntry;

    txTableUsed[unit][vcid]= FALSE;
}
end (ll_CloseTx);



/*
 * ll_ChangeFreelist -- yeah, right
 *
 */

public void ll_ChangeFreelist (int unit, vcid_t vcid,
                               freelist_t headerFreelist,
                               freelist_t dataFreelist)
begin (ll_ChangeFreelist);
{
    assert (FALSE);
}
end (ll_ChangeFreelist);


/*
 * ll_AppendVrThenScheduleStatic
 *
 */

public bool ll_AppendVrThenScheduleStatic (int unit, vcid_t vcid,
                                           vr_t *headp, vr_t *tailp)
begin (ll_AppendVrThenScheduleStatic);
{
    static volatile bool busy;
    vr_t *currentTailp;

    if (busy)
        panic ("AppendVr not reentrant!!!\n");
    busy=TRUE;

    assert (vcid < numTxVcs[unit]);
    assert (txTableUsed[unit][vcid]);

    ifdebug (1) {
        vr_t *vrp = headp;
        debug ("Appending the following chain:\n");
        while (vrp - ll_vrBase[unit] != 0) {  /* while not null vrp */
            int i;
            uint32 *p = (uint32 *) vrp;
            debug ("sram 0x%x:\n", (char*)vrp-(char*)ll_vrBase[unit]);
            for (i=0; i<4; i++)
                debug ("   %x\n", p[i]);
            debug ("\n");
            vrp = ll_vrBase[unit] + vrp->vr.nextIndex;
        }
        debug ("----------------------------------\n");
      }

    currentTailp= txTailp[unit][vcid];
    txTailp[unit][vcid]= tailp;

    if (txwaithack && (ll_txTableBase[unit][vcid].vrIndex != 0)) {
        busy=FALSE;
        return FALSE;
    }

    if (!mantxlinking)
        reg_AppendVrThenScheduleStatic (unit, vcid, headp, currentTailp);
    else {
        if (ll_txTableBase[unit][vcid].vrIndex != 0)
            currentTailp->vr.nextIndex = headp - ll_vrBase[unit];
        else
            ll_txTableBase[unit][vcid].vrIndex = headp-ll_vrBase[unit];
    }
    reg_WriteStaticBitVector (unit, vcid, 1);
    
    busy=FALSE;
    return TRUE;
}
end (ll_AppendVrThenScheduleStatic);


/*
 * ll_AppendVrThenScheduleDynamic
 *
 */

public bool
ll_AppendVrThenScheduleDynamic (int unit, int listNum, vcid_t vcid,
                                int burstSize, vr_t *headp, vr_t *tailp)
begin ();
{
    static volatile bool busy=FALSE;
    vr_t *currentTailp;

    if (busy)
        panic ("AppendVrThenScheduleDynamic not reentrant!\n");
    busy=TRUE;
    
    assert (listNum < 2);
    assert (vcid < numTxVcs[unit]);
    assert (txTableUsed[unit][vcid]);

    currentTailp = txTailp[unit][vcid];
    txTailp[unit][vcid] = tailp;

    if (txwaithack && (ll_txTableBase[unit][vcid].vrIndex != 0)) {
        busy=FALSE;
        return FALSE;
    }

    reg_AppendVrThenScheduleDynamic (unit, listNum, vcid, burstSize,
                                     headp, currentTailp);
    busy=FALSE;
    return TRUE;
}
end ();

/*
 * ll_GetVcidInUseTables
 * This returns the addresses of my ...InUse tables so that the diagnostic
 * routines can access them
 */

public void ll_GetVcidInUseTables (int unit, bool **rxTablep, bool **txTablep)
begin (ll_GetVcidInUseTables);
{
    if (rxTablep)
        *rxTablep= rxTableUsed[unit];
    if (txTablep)
        *txTablep= txTableUsed[unit];
}
end (ll_GetVcidInUseTables);


/*------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 * Routines for handling VR's
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------*/

private int   numVrs     [NIJET];

private vr_t *freelistTailp[NIJET][JET_MAX_FREELISTS];  /* freelist tails */

private ll_error_t AllocateInit     (int unit);
private ll_error_t AllocateShutdown (int unit);
private vr_t      *AllocateSingleVr (int unit);
private void       FreeSingleVR     (int unit, vr_t *vrp);



/*
 * ll_VRInit -- initialize VR routines
 */

internal ll_error_t ll_VrInit (int unit, uint32 vrTableOffset, int p_numVrs)
begin (ll_VrInit);
{
    assert (sizeof (*jet_sramBase[unit]) == 1);  /* don't fuck me up! */

/* NOTE: vrBase is the same as the start of SRAM.  This is so vrp to 
 * vrIndex computations work correctly. */

    ll_vrBase[unit]=      (vr_t *) jet_sramBase[unit];
    ll_vrPartition[unit]= (vr_t *) (jet_sramBase[unit] + vrTableOffset);
    numVrs[unit]= p_numVrs;

    AllocateInit (unit);

    return SUCCESS;
}
end (ll_VrInit);



internal ll_error_t ll_VrShutdown (int unit)
begin (ll_VrShutdown);
{
    AllocateShutdown (unit);

    return SUCCESS;
}
end (ll_VrShutdown);



/*
 * ll_AllocateVRs -- allocate VR's in SRAM
 *
 * Parameters:
 *    count -- how many VR's you want
 *    table -- an array of pointers to VR's
 *
 * Returns:
 *    Number of VR's you got
 *
 * Side Effects:
 *
 *    "table" is modified to point to the VR's allocated for you, one
 *    entry per VR
 *
 */

public int ll_AllocateVrs (int unit, int count, vr_t **table)
begin (ll_AllocateVrs);
{
    int i;
    vr_t *vrp;

    for (i= 0; i < count; i++)
    {
        vrp= AllocateSingleVr (unit);

        if (vrp)
            table[i]= vrp;
        else
            break;
    }

    return i;
}
end (ll_AllocateVrs);




/*
 * ll_FreeVrs -- free VR's
 *
 * Parameters:
 *    count -- how many VR's you want to free
 *    table -- an array of pointers to VR's
 *
 */

public void ll_FreeVrs (int unit, int count, vr_t **table)
begin (ll_FreeVrs);
{
    int i;

    for (i= 0; i < count; i++) {
        FreeSingleVR (unit, table [i]);
    }
}
end (ll_FreeVrs);



/*
 * ll_AppendVrlistToFreelist -- append a list of VR's to a freelist
 *
 * Parameters:
 *    freelist -- the freelist to which to append
 *    headp, tailp -- pointers to the head and tail of the list you're appending
 *
 */

public void
ll_AppendVrlistToFreelist (int unit, freelist_t freelistId, vr_t *headp,
                           vr_t *tailp)
begin (ll_AppendVrlistToFreelist);
{
  static volatile bool busy;
  vr_t *currentTailp;

  if (busy)
    panic ("appendvrlisttofreelist not reentrant!\n");
  busy=TRUE;

  assert (JET_FREELISTOK (freelistId));

  currentTailp = freelistTailp[unit][freelistId];
  freelistTailp[unit][freelistId] = tailp;

  if (ijet_firstAppendEver[unit][freelistId] || !manrxlinking) {
    reg_AppendVrlistToFreelist (unit, freelistId, currentTailp, headp);
    ijet_firstAppendEver[unit][freelistId] = 0;
  }
  else {
    if (currentTailp->vr.nextIndex) {
      warn ("Warning: couldn't slam.  Entering wb mode\n");
      reg_AppendVrlistToFreelist (unit, freelistId, currentTailp, headp);
    }
    else
      currentTailp->vr.nextIndex = headp-ll_vrBase[unit];
  }
  busy=FALSE;
}
end (ll_AppendVrlistToFreelist);



/*
 * Allocation routines:
 *
 * AllocateInit
 * AllocateShutdown
 * AllocateSingleVr
 * FreeSingleVr
 *
 * presently uses super-cheesy "used" array
 */

private bool *vrUsed[NIJET];

private ll_error_t AllocateInit (int unit)
begin (AllocateInit);
{
    int i;
    vrUsed[unit]= malloc (numVrs[unit] * sizeof (*vrUsed[unit]),
			  M_DEVBUF, M_WAITOK);

    for (i= 0; i < numVrs[unit]; i++)
        vrUsed[unit][i]= FALSE;

    return SUCCESS;
}
end (AllocateInit);


private ll_error_t AllocateShutdown (int unit)
begin (AllocateShutdown);
{
    free (vrUsed[unit], M_DEVBUF);
   
    return SUCCESS;
}
end (AllocateShutdown);


private vr_t *AllocateSingleVr (int unit)
/* begin (AllocateSingleVr); */
{
    int i;

    /* HACK: cheesy linear search!  Must die!  Must Die! */

    for (i= 0; i < numVrs[unit]; i++)
        if (!vrUsed[unit][i])
            break;

    if (i == numVrs[unit])
        return NULL;

    vrUsed[unit][i]= TRUE;
    return ll_vrPartition[unit] + i;
}
/* end (AllocateSingleVr); */


private void FreeSingleVR (int unit, vr_t *vrp)
/* begin (FreeSingleVR); */
{
    int index= vrp - ll_vrPartition[unit];

    assert ((index >= 0) && (index < numVrs[unit]));

    vrUsed[unit][index]= FALSE;
}
/* end (FreeSingleVR); */


/*------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 * Routines for handling mailboxes
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------*/

private uint32 mailboxInUse     [NIJET];  /* bit vector */
private int    mailboxUserCount [NIJET][JET_MAX_REAL_MAILBOXES];

/*
 * ll_MailboxInit -- initialize mailbox data structures
 */

internal ll_error_t ll_MailboxInit (int unit)
begin (ll_MailboxInit);
{
    int i;

    for (i= 0; i < JET_MAX_REAL_MAILBOXES; i++)
        mailboxUserCount [unit][i]= 0;

    mailboxInUse[unit]= 0;
   
    return SUCCESS;
}
end (ll_MailboxInit);



/*
 * ll_AllocMailbox -- allocate a mailbox for your exclusive use
 *
 * Parameters:
 *    bufferSwitchHandler --
 *        thread to wake up when a buffer switch event is received
 *        for this mailbox (or NO_THREAD if none)
 *
 *    endOfPDUHandler --
 *        thread to wake up when an end of PDU message is received
 *        for this mailbox (or NO_THREAD if none)
 *
 *    tailp --
 *        pointer to the VR to use as the initial mailbox
 *        (mailboxes always have at least one VR in them)
 *
 * Returns:
 *    mailbox id if successful,
 *    otherwise LL_ERROR_NO_FREE_MAILBOXES
 */

public mailbox_t ll_AllocMailbox (int unit,
                                  ll_handler_t bufferSwitchHandler,
                                  ll_handler_t endOfPDUHandler,
                                  vr_t *tailp)
begin (ll_AllocMailbox);
{
    int i;

    /*
     * find a free mailbox
     */

    for (i=0; i<JET_MAX_REAL_MAILBOXES; i++)
        if (BITMASK_BIT (mailboxInUse[unit], i) == 0)
            break;

    if (i == JET_MAX_REAL_MAILBOXES)
        return LL_ERROR_NO_FREE_MAILBOXES;

    BITMASK_SET1 (mailboxInUse[unit], i);

    if (bufferSwitchHandler != NULL)
    {
        intr_interrupt_t interruptIndex= INTR_COMPUTE_BUFSW_INDEX (i);
        intr_InstallHandler (unit, interruptIndex, bufferSwitchHandler);
    }

    if (endOfPDUHandler != NULL)
    {
        intr_interrupt_t interruptIndex= INTR_COMPUTE_EOPDU_INDEX (i);
        intr_InstallHandler (unit, interruptIndex, endOfPDUHandler);
    }

    {
        tailp->vr.nextIndex= 0;

        jet_asicBase[unit]->mbox[i]= tailp - ll_vrBase[unit];
    }

    return i;
}   
end (ll_AllocMailbox);



/*
 * ll_FreeMailbox -- free a mailbox
 *
 * Parameters:
 *    mailbox -- mailbox id
 */

public void ll_FreeMailbox (int unit, mailbox_t mailbox)
begin (ll_FreeMailbox);
{
    intr_interrupt_t interruptIndex;

    assert (JET_MAILBOXOK (mailbox));
    assert (BITMASK_BIT(mailboxInUse[unit], mailbox));
    assert (mailboxUserCount[unit][mailbox] == 0);

    /*
     * Remove handlers (if any) associated with this id
     */

    interruptIndex= INTR_COMPUTE_BUFSW_INDEX (mailbox);
    intr_RemoveHandler (unit, interruptIndex);

    interruptIndex= INTR_COMPUTE_EOPDU_INDEX (mailbox);
    intr_RemoveHandler (unit, interruptIndex);

    /*
     * Clear the asic mailbox register
     */

    BITMASK_SET0 (mailboxInUse[unit], mailbox);

    jet_asicBase[unit]->mbox[mailbox]= 0;
}
end (ll_FreeMailbox);



/*
 * ll_IncrementMailboxUserCount --
 * ll_DecrementMailboxUserCount --
 *
 *    These routines help keep track of how many VCs are using a mailbox
 *
 * Parameters:
 *    mailbox -- the id of the mailbox
 */

public void ll_IncrementMailboxUserCount (int unit, mailbox_t mailbox)
begin (ll_IncrementMailboxUserCount);
{
    assert (JET_MAILBOXOK (mailbox));
    assert (BITMASK_BIT (mailboxInUse[unit], mailbox));

    debug ("Unit %d: increasing user count of mailbox %d (value was %d)\n",
           unit, (int) mailbox, mailboxUserCount[unit][mailbox]);

    mailboxUserCount[unit][mailbox] ++;
}
end (ll_IncrementMailboxUserCount);


public void ll_DecrementMailboxUserCount (int unit, mailbox_t mailbox)
begin (ll_DecrementMailboxUserCount);
{
    assert (JET_MAILBOXOK (mailbox));
    assert (BITMASK_BIT (mailboxInUse[unit], mailbox));

    debug ("Unit %d: decreasing user count of mailbox %d (value was %d)\n",
           unit, (int) mailbox, mailboxUserCount[unit][mailbox]);

    mailboxUserCount[unit][mailbox] --;
}
end (ll_DecrementMailboxUserCount);


/*
 * ll_GetMailboxInUseVector
 * This returns the address of my MailboxInUse vector so that the diagnostic
 * routines can read/write it
 */

public uint32 *ll_GetMailboxInUseVector (int unit)
begin (ll_GetMailboxInUseVector);
{
    return &mailboxInUse[unit];
}
end (ll_GetMailboxInUseVector);



/*------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 * Routines for handling freelists
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------*/

private uint32 freelistInUse   [NIJET];  /* bitmask */
private int  freelistUserCount [NIJET][JET_MAX_FREELISTS];

private ll_emptyListHandler_t emptyListAction [NIJET][JET_MAX_FREELISTS];

private void InstallEmptyListHandler  (int unit, freelist_t freelist,
                                       ll_emptyListHandler_t handler);
private void RemoveEmptyListHandler   (int unit, freelist_t freelist);
private void FreelistInterruptHandler (int unit);

/*
 * ll_FreelistInit -- initialize freelist data structures
 */

internal ll_error_t ll_FreelistInit (int unit)
begin (ll_FreelistInit);
{
  int i;

  for (i=0; i<JET_MAX_FREELISTS; i++) {
    freelistUserCount   [unit][i] = 0;
    emptyListAction     [unit][i] = NULL;
    ijet_firstAppendEver[unit][i] = TRUE; /* hack hack hack */
  }
  freelistInUse[unit]= 0;
  BITMASK_SET1 (freelistInUse[unit], 0);  /* mark FL 0 as used */

  if (0)  /* HACK: end of FL interrupts are back! */
    intr_InstallHandler (unit, INTR_END_OF_FREELIST,
                         &FreelistInterruptHandler);

  return SUCCESS;
}
end (ll_FreelistInit);



internal ll_error_t ll_FreelistShutdown (int unit)
begin (ll_FreelistShutdown);
{
  intr_RemoveHandler (unit, INTR_END_OF_FREELIST);
  return SUCCESS;
}
end (ll_FreelistShutdown);



/*
 * ll_AllocFreelist -- allocate a freelist for your exclusive use
 *
 * Parameters:
 *    markerHandler --
 *        thread to wake up when a freelist marker is encountered
 *        on this freelist (or THREAD_NONE if none)
 *
 *    emptyListHandler --
 *        thread to wake up when your list runs out of VRs
 *        (or THREAD_NONE if none)
 *
 * Returns:
 *    freelist id if successful,
 *    otherwise LL_ERROR_NO_FREE_FREELISTS
 */

public freelist_t ll_AllocFreelist (int unit,
                                    ll_handler_t markerHandler,
                                    ll_emptyListHandler_t emptyListHandler)
begin (ll_AllocFreelist);
{
    int i;

    /*
     * find a free freelist
     */

    for (i= 0; i < JET_MAX_FREELISTS; i++)
        if (BITMASK_BIT (freelistInUse[unit], i) == 0)
            break;

    if (i == JET_MAX_FREELISTS)
        return LL_ERROR_NO_FREE_FREELISTS;

    BITMASK_SET1 (freelistInUse[unit], i);

    if (markerHandler != NULL) {
        intr_interrupt_t interruptIndex= INTR_COMPUTE_FREELIST_INDEX (i);
        intr_InstallHandler (unit, interruptIndex, markerHandler);
    }

    if (emptyListHandler != NULL)
        InstallEmptyListHandler (unit, i, emptyListHandler);

    return i;
}
end (ll_AllocFreelist);



/*
 * ll_FreeFreelist -- free a freelist
 *
 * Parameters:
 *    freelistId -- freelist id
 */

public void ll_FreeFreelist (int unit, freelist_t freelistId)
begin (ll_FreeFreelist);
{
    intr_interrupt_t interruptIndex;

    assert (JET_FREELISTOK (freelistId));
    assert (BITMASK_BIT (freelistInUse[unit], freelistId));
    assert (freelistUserCount[unit][freelistId] == 0);

    /*
     * Remove handlers (if any) associated with this id
     */

    interruptIndex= INTR_COMPUTE_FREELIST_INDEX (freelistId);
    intr_RemoveHandler (unit, interruptIndex);

    RemoveEmptyListHandler (unit, freelistId);

    BITMASK_SET0 (freelistInUse[unit], freelistId);
    
    /* 
     * Clear the asic freelist register.  Don't know if this is ok, but
     * this is needed for the VPC code.
     */
    jet_asicBase[unit]->freelist[freelistId]= 0;
}
end (ll_FreeFreelist);



/*
 * ll_IncrementFreelistUserCount --
 * ll_DecrementFreelistUserCount --
 *
 *    These routines help keep track of how many VCs are using a freelist
 *
 * Parameters:
 *    freelistId -- the id of the freelist
 */

public void ll_IncrementFreelistUserCount (int unit, freelist_t freelistId)
begin (ll_IncrementFreelistUserCount);
{
    assert (JET_FREELISTOK (freelistId));
    assert (BITMASK_BIT (freelistInUse[unit], freelistId));

    debug ("Unit %d: increasing user count of freelist %d (val was %d)\n",
           unit, (int) freelistId, freelistUserCount[unit][freelistId]);

    freelistUserCount[unit][freelistId] ++;
}
end (ll_IncrementFreelistUserCount);


public void ll_DecrementFreelistUserCount (int unit, freelist_t freelistId)
begin (ll_DecrementFreelistUserCount);
{
    assert (JET_FREELISTOK (freelistId));
    assert (BITMASK_BIT (freelistInUse[unit], freelistId));

    debug ("Unit %d: decreasing user count of freelist %d (val was %d)\n",
           unit, (int) freelistId, freelistUserCount[unit][freelistId]);

    freelistUserCount[unit][freelistId] --;
}
end (ll_DecrementFreelistUserCount);



private void InstallEmptyListHandler (int unit, freelist_t freelistId,
                                      ll_emptyListHandler_t handler)
begin (InstallEmptyListHandler);
{
    assert (JET_FREELISTOK (freelistId));
    assert (BITMASK_BIT (freelistInUse[unit], freelistId));
    assert (emptyListAction[unit][freelistId] == NULL);
    assert (handler != NULL);

    debug ("Adding empty list handler for unit %d, list %d\n",
           unit, freelistId);

    emptyListAction[unit][freelistId]= handler;
}
end (InstallEmptyListHandler);



/*
 * RemoveEmptyListHandler  -- remove a handler for a freelist
 *
 * Parameters:
 *    freelist -- the freelist
 */

private void RemoveEmptyListHandler (int unit, freelist_t freelistId)
begin (RemoveEmptyListHandler);
{
    assert (JET_FREELISTOK (freelistId));
    assert (BITMASK_BIT (freelistInUse[unit], freelistId));

    debug ("Removing empty list handler for unit %d, freelist %d\n",
           unit, freelistId);

    emptyListAction[unit][freelistId]= NULL;
}
end (RemoveEmptyListHandler);



private void FreelistInterruptHandler (int unit)
begin (FreelistInterruptHandler);
{
    int i;

    for (i= 0; i < JET_MAX_FREELISTS; i++) {
        if (jet_asicBase[unit]->freelist[i] != 0)
            continue;
        
        {
            ll_emptyListHandler_t action= emptyListAction[unit][i];
            if (action) {
                debug ("Calling empty freelist handler for freelist %d\n", i);
                (*action) (unit, i);
            }
            else
                debug ("No empty freelist handler for freelist %d\n", i);
        }
    }
}
end (FreelistInterruptHandler);

/*
 * ll_GetFreelistInUseVector
 * This returns the address of my FreeListInUse vector so that the diagnostic
 * routines can read/write it
 */

public uint32 *ll_GetFreelistInUseVector (int unit)
begin (ll_GetFreelistInUseVector);
{
    return &freelistInUse[unit];
}
end (ll_GetFreelistInUseVector);

/*------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 * Routines for dealing with the scheduler
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------*/

internal ll_error_t
ll_StaticSchedulerInit (int unit, uint32 staticTableOffset,
                        int numStaticTableEntries)
begin (ll_StaticSchedulerInit);
{
    /*
     * fill in scheduler table with default values
     */
    
    int i;

    assert (sizeof(*jet_sramBase[unit]) == 1);

    jet_numStaticTableEntries[unit] = numStaticTableEntries;
    jet_staticTable[unit] =
        (staticTableEntry_t *) (jet_sramBase[unit] + staticTableOffset);
    debug ("Hi!!!  static table offset is 0x%x\n", staticTableOffset);

    ll_SetScheduler (unit, hacknum, hackdenom, hackvc, 8);

    for (i=0; i<JET_NUM_STATIC_VCS; i++)
        reg_WriteStaticBitVector (unit, i, 0);

    /*
     * enable scheduler
     */

    {
        static jet_stat_table_limit_t value;

        reg_WriteStaticRegister (unit, JET_STATIC_TABLE_BASEADDR,
                                 staticTableOffset >> 2);

        value.stat_table_size=     (numStaticTableEntries>>1)-1;
        value.bit_vector_en=       1;
        value.stat_sch_en=         1;
        value.cmd_proc_timeout_en= mummert_timeout; /* kosak HACK */
        
        reg_WriteStaticRegister (unit, JET_STATIC_TABLE_LIMIT,
                                 *(uint32 *)&value);
    }

    return SUCCESS;
}
end (ll_StaticSchedulerInit);


#if 0

public ll_error_t ll_SetScheduler (int unit, int numerator, int denominator,
                                   int preferredVc, int numOtherVcs)
begin (ll_SetScheduler);
{
    int othervc = 0;
    int i;

    warn ("KOSAK HACK ON: ignoring your parameters!!!!\n");
    
    for (i=0; i<jet_numStaticTableEntries[unit]; i++) {
        int index = i % denominator;
        if (index < numerator)
            jet_staticTable[unit][i] = JET_STATIC_SCHEDULE_DYNAMIC;
        else
            jet_staticTable[unit][i] = JET_STATIC_SCHEDULE_IDLE;
    }

    return 0;
}
end (ll_SetScheduler);

#else

public ll_error_t ll_SetScheduler (int unit, int numerator, int denominator,
                                   int preferredVc, int numOtherVcs)
begin (ll_SetScheduler);
{
  int othervc;
  int i;
  
  if (permit0)
    othervc = 0;
  else
    othervc = 1;
  
  for (i=0; i<jet_numStaticTableEntries[unit]; i++) {
    int index = i % denominator;
    if (index < numerator)
      jet_staticTable[unit][i] = preferredVc;
    else {
      jet_staticTable[unit][i] = othervc;
      othervc++;
      if ((numerator != 0) && (othervc == preferredVc))
        othervc++;
      
      othervc = othervc % numOtherVcs;
      
      if ((othervc == 0) && !permit0)
        othervc = 1;
    }
  }
  
  return 0;
}
end (ll_SetScheduler);

#endif

#ifdef IJET_VPC_CREDIT
public ll_error_t ll_SetLinkRate (int unit, uint32 linkRate, uint32 lineRate,
				  vcid_t preferredVc)
begin();
{
    int idleVc = 0xffff;        /* Idle slot */
    int i;
    int preferredSlots, idleSlots;
    double fraction, total;

    fraction = (double) linkRate / lineRate;
    total = 0.0;
    preferredSlots = idleSlots = 0;

    for (i = 0; i < jet_numStaticTableEntries[unit]; i++) {
	if (total < 1.0) {
	    jet_staticTable[unit][i] = idleVc;
	    total += fraction;
	    idleSlots++;
	}
	else {
	    jet_staticTable[unit][i] = preferredVc;
	    total -= 1.0;
	    total += fraction;
	    preferredSlots++;
	}
    }  
    warn ("Set Link Rate to %u, preferredSlots = %d, idleSlots = %d\n", 
	  linkRate, preferredSlots, idleSlots);  
}
end();
#endif


private void ResetDynamicList (int unit, int listNum);

internal ll_error_t
ll_DynamicSchedulerInit (int unit, uint32 txTableOffset,
                         uint32 dynamicTableOffset, int numDynamicLists,
                         int numDynamicEntriesPerList)
begin (ll_DynamicSchedulerInit);
{
  int sizelog2;

  /* compute ceil(log(sizeof(numDynamicEntriesPerList))) */
  for (sizelog2=0; (1<<sizelog2)<numDynamicEntriesPerList; sizelog2++)
    ;
    
  /* Dynamic Scheduler Base register */
  reg_WriteDynamicRegister (unit, 0xf, JET_DYNAMIC_GLOBAL_TABLE_BASE,
                            dynamicTableOffset >> 2);

  /* Dyn Sch Table Size/Arbitration Reg */
  reg_WriteDynamicRegister (unit, 0xf, JET_DYNAMIC_GLOBAL_SIZEARB,
                            (sizelog2 << 4) |
                            JET_DYNAMIC_ARBITRATION_DISCIPLINE);

  /* TxVC table base addr register, for dynamic scheduler */
  reg_WriteDynamicRegister (unit, 0x0f, JET_DYNAMIC_GLOBAL_VC_BASE,
                            txTableOffset >> 2);
    
  {
    uint32 readback = (reg_ReadDynamicRegister (unit, 0x0f,
                                               JET_DYNAMIC_GLOBAL_VC_BASE)
		       << 2) & 0x1fffff;

    if (readback != txTableOffset) {
      warn ("Hey!  Writing to dyn registers didn't stick!\n");
      warn ("expected 0x%x got 0x%x\n", txTableOffset, readback);
      return LL_ERROR_DYNAMIC_CHECK_FAILED;
    }
  }
    
  /* Set list priorities: for now hack to 0 */
  reg_WriteDynamicRegister (unit, 0x0f, JET_DYNAMIC_GLOBAL_PRIORITIES, 0);

  /* zero dynamic lists */
  {
    int i;
    uint32 *p= (uint32 *) (jet_sramBase[unit] + dynamicTableOffset);

    for (i=0; i < numDynamicLists * numDynamicEntriesPerList *
           sizeof(dynamicListEntry_t) / sizeof (uint32) ; i++)
      p[i] = 0;
  }

  {
    int listNum;
    for (listNum = 0; listNum < numDynamicLists; listNum++)
      ResetDynamicList (unit, listNum);
  }

  warn("Dynamic Scheduler rules!!\n");
  return SUCCESS;
}
end (ll_DynamicSchedulerInit);


/*
 * Empties a dynamic list, adds the End Of List Marker,
 * sets the contract size, and enables the list
 */

private void ResetDynamicList (int unit, int listNum)
begin (ResetDynamicList);
{
  /* Make sure list is Off */
  reg_WriteDynamicRegister (unit, listNum, JET_DYNAMIC_LIST_BIT_REG,
                            0x00ff0000);
  
  /* Set Head and Tail registers to zero */
  reg_WriteDynamicRegister (unit, listNum, JET_DYNAMIC_LIST_HEAD_PTR, 0);
  reg_WriteDynamicRegister (unit, listNum, JET_DYNAMIC_LIST_TAIL_PTR, 0);
  
  /* Set M_cnt_reload value; magic number 8 */
  reg_WriteDynamicRegister (unit, listNum, JET_DYNAMIC_LIST_MCNT_RELOAD, 8);
  
  /* Add end of list marker to dynamic list */
  reg_AddVcToDynamicList (unit, listNum, JET_DYNAMIC_LIST_END_MARKER, 0);
  
  /* Turn List on by setting LM_enable bit */
 
  reg_WriteDynamicRegister (unit, listNum, JET_DYNAMIC_LIST_BIT_REG, 
			    0x00ff0000); 
}
end (ResetDynamicList);



internal ll_error_t ll_ScheduleShutdown (int unit)
begin (ll_ScheduleShutdown);
{
    return SUCCESS;
}
end (ll_ScheduleShutdown);


/*------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 * some utility routines
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------
 *------------------------------------------------------------------------*/

public int ll_VpivciToVcid (int unit, vpivci_t vpivci)
begin (ll_VpivciToVcid);
{
    int vpi = (vpivci & 0xff0000) >> 16;
    int vci = (vpivci & 0x00ffff);
    vcid_t vcid;
    int shiftAmount = (16 - ll_rxVcExtraction[unit]);

    if (vpivci < 0)
        return LL_ERROR_BAD_VCIVPI;

    vcid = (vpi << shiftAmount) | (vci & ll_bitmasks [shiftAmount]);

    debug ("converting vpivci %d to vcid %d\n", vpivci, vcid);
    return vcid;
}
end (ll_VpivciToVcid);


/*
 * ll_txIdle
 *
 * FIX: make this a macro
 */
public int ll_txBusy(int unit, vcid_t vcid)
     begin(ll_txBusy);
{
  return ll_txTableBase[unit][vcid].vrIndex;
}
end(ll_txBusy);
