#include "glob.h"

void *Malloc (size_t size)
{
  void *retval = malloc (size);
  
  if (!retval)
    crash (.form ("Malloc(%ld) failed.\n", (long)size));
  
  return retval;
}


void *Realloc (void *p, size_t size)
{
  void *retval = realloc (p, size);
  
  if (!retval)
    crash (.form ("Realloc (%p,%ld) failed\n", p, (long)size));

  return retval;
}


void Free (void *p)
{
  free (p);
}
