/* Read some test messages */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <jetmsg.h>

extern int close (int); /* HACK */

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)

#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

char device[] = "/dev/jetmsg0";

void doit (int fd, fd_set *setp)
{
    int retval;
    int i;
    unsigned char buffer[80];

    for (i=0; i<80; i++)
        buffer[i] = 0;
    
    if (FD_ISSET (fd, setp)) {
        int nbytes;
        if ((retval = ioctl (fd, FIONREAD, &nbytes)) < 0)
            crash ("fionread error\n");
        warn ("FIONREAD returned %d\n", nbytes);

        warn ("(fd %d):", fd);
        if ((retval = atm_recv (fd, buffer, sizeof(buffer))) < 0)
            crash ("atm_recv failed, errno %d\n", errno);
        warn ("(bytes %4d):", retval);
        
        warn ("data:[");
        
        for (i=0; i<retval; i++)
             if (buffer[i]>=' ')
                warn ("%c",buffer[i]);
            else
                warn ("(%d)",buffer[i]);
        warn ("]\n");
       
    }
}

int main(int argc, char **argv)
{
    int fd0;
    int error;
    struct timeval *timeout_pointer;  

    if ((fd0 = atm_open(device, O_RDONLY)) < 0)
        crash ("atm_open \"%s\" failed, errno %d!\n", device, errno);
    warn ("Using fd %d\n", fd0);

    if ((error = atm_bind_skip (fd0)) < 0)
        crash ("atm_bind_skip failed, errno %d\n", errno);

    timeout_pointer = 0; 
    for (;;) {
        fd_set set;
        int retval;

        FD_ZERO (&set);
        FD_SET (fd0, &set);
        retval = select (1, &set, NULL, NULL, timeout_pointer);

        if (retval) {
            doit (fd0, &set);
        }
    }
    
    if ((error = atm_close (fd0)) < 0)
        crash ("atm_close failed!\n");
    return 0;
}



