/* this is a test of the ioctl routine */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>


#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int); /* HACK */

int load_ucode (char *fname, uint32 *buffer, int length);

void main(int argc, char **argv)
{
  int fd;
  int buffer [1024];
  int error_length= load_ucode ("ucode.dat", buffer, 1024*4);
  iocopy_req_t iocpr;

  if (error_length < 0) {
    printf ("microcode loading FAILED!  you suck\n");
    exit (1);
  }

  iocpr.user = (char *) buffer;
  iocpr.len = error_length;

  if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
    printf("failed to open device!\n");
    exit(1);
  }

  if (ioctl(fd, IJETIOC_LOAD_UCODE, &iocpr) < 0) {
    printf ("you suck[1]:ioctl failed, errno = %d\n", errno);
    exit(1);
  }

  close(fd);
  exit(0);
}

/*
 * Load microcode into scheduler
 */
int load_ucode (char *fname, uint32 *buffer, int capacity)
{
    FILE    *fp;
    char    data[200], dummy[100];
    int     addr, data1, data2, data3;
    int     length= 0;

    printf ("Loading ucode file\n");

    if ((fp=fopen(fname, "r")) == NULL)
    {
        printf ("Unable to load file \"%s\"\n", fname);
        return -1;
    }
    else
    {
        while (fgets(data, 200, fp) != NULL)
        {
            if (data[0]=='$')
            {
                if (capacity < 3 * sizeof(uint32))
                {
                    printf ("buffer not big enough!\n");
                    return -2;
                }
                sscanf(data, "$%x: %s  %x %x_%x", &addr, dummy, &data3, &data2, &data1);
                *buffer++= addr;
                *buffer++= data2<<16 | (data1&0xFFFF);
                *buffer++= data3&0x0FFF;
                capacity -= 3 * sizeof(uint32);
                length   += 3 * sizeof(uint32);
            }
        }
        fclose(fp);
    }

    printf ("Read ucode file successfully\n");
    return length;
}                              
