#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

#include "../src/vpc/vpc_user.h"

#define crash(fmt,args...) (fprintf(stderr, fmt , ##args),exit(1))

#define PARMCOUNT 9

int main (int argc, char **argv)
{
  int fd;
  int parms[PARMCOUNT];
  int i, error;

  if (argc != PARMCOUNT+1)
    crash ("Usage: %s numUnits numRxdataCells numRxrmCells "
           "numDelayLineCells cellsPerVr "
           "outputPortFullThreshold firstDataVci firstCreditVci "
	   "kenelLoopCount\n",
           argv[0]);

  for (i=0; i<PARMCOUNT; i++)
    parms[i] = atoi(argv[i+1]);

  if ((fd = open ("/dev/vpc", O_RDWR)) < 0)
    crash ("failure opening device, error=%d\n", errno);

  if ((error = ioctl (fd, VPC_IOCTL_GO_DELAY, parms)) < 0)
    crash ("ioctl returned error code %d\n", errno);

  printf ("Looping forever: hit ^C to stop...\n");
  for (;;)
    if ((error = ioctl (fd, VPC_IOCTL_POLL, parms)) < 0)
      crash ("ioctl returned error code %d\n", errno);
  
  return 0;
}
