/* Initialize the uworld routines */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <uworld_user.h>

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)
#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

char device[] = "/dev/uworld0";

int main(int argc, char **argv)
{
  int fd;
  static int p[4];
  int i;

  if (argc < 2)
    crash ("Usage: %s unit [parm0 parm1 parm2]\n", argv[0]);
  
  for (i=0; i<argc-1; i++)
    p[i] = atoi(argv[i+1]);

  printf ("unit is %d, p0 is %d, p1 is %d, p2 is %d\n",
          p[0], p[1], p[2], p[3]);

  if ((fd=open(device, O_RDWR, 0)) < 0)
    crash ("failed to open %s, error=%d!\n", device, errno);

  if ((ioctl (fd, UWORLD_IOCTL_DVR_LINK, p)) < 0)
    crash ("ioctl failed, errno %d\n", errno);

  close(fd);
  return 0;
}
