int megatoast;
unsigned int megalinkrate = 135000000;
int vpcKeepGoing = 1;

#include <sys/types.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/errno.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/syslog.h>
#include <sys/device.h>
#include <sys/malloc.h>
#include <sys/proc.h>

#include <vm/vm.h>
#include <vm/vm_param.h>
#include <vm/vm_extern.h>

#include <net/if.h>
#include <net/if_types.h>
#include <net/if_dl.h>
#include <net/netisr.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>

#include <machine/cpu.h>
#include <machine/pio.h>

#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_ll.h>
#include <dev/pci/jetland/include/ijet_reg.h>
#include <dev/pci/jetland/src/vpc/vpc_user.h>

#undef min
#define min(a,b) ((a)<(b)?(a):(b))


/*------------------------------------------------------------------------*/

extern vm_map_t kernel_map;
extern int hz;

/*------------------------------------------------------------------------*/

#undef debug
#undef DEBUG_PREFIX
#define debug debugr
#define DEBUG_PREFIX "txrate:"

/*------------------------------------------------------------------------
 * my beautiful macros
 *------------------------------------------------------------------------*/

#define VRINDEX(unit,vrp) ((vrp)-ll_vrBase[(unit)])
#define VRP(unit,index) (ll_vrBase[(unit)]+(index))
#if 1
#define VRPTOVRNODEP(unit,cowp,vrp) \
 ((cowp)->mappingTable[VRINDEX(unit,vrp)-(cowp)->firstVrIndex])
#endif

#define SCREEN_SLAM(ypos,xpos,value)                            \
 if (!debug_directTextScreenMapDone) ;                          \
 else debug_directTextScreenp[(ypos)*80+(xpos)]=(value)

#define warnreturn(errorcode, fmt, args...) do {        \
 warn (fmt , ##args);                                   \
 return (errorcode);                                    \
} while (0)

#define MALLOC_ARRAY(destptr, count)                                       \
 if (((destptr) = malloc ((count)*sizeof(*(destptr)), M_DEVBUF, M_NOWAIT)) \
     != NULL) ;                                                            \
 else warnreturn (ENOMEM, "Can't malloc %d bytes!\n",                      \
                  (count)*sizeof(*(destptr)))

#define ENQUEUE(queue, nodep) do {              \
 if ((queue).headp == NULL)                     \
   (queue).headp = (nodep);                     \
 else                                           \
   (queue).tailp->nextp = (nodep);              \
 (queue).tailp = (nodep);                       \
 (nodep)->nextp = NULL;                         \
} while(0)

#define DEQUEUE(queue) ({                       \
  typeof((queue).headp) retval = (queue).headp; \
  assert (retval != NULL);                      \
  (queue).headp = (queue).headp->nextp;         \
  retval; })

/*------------------------------------------------------------------------*
 * some bits in ATM cell header
 *------------------------------------------------------------------------*/

#define EFCI_OFFSET 1 /* in word 1 */
#define EFCI_BIT_OC3    0x00040000
#define EFCI_BIT_OC12   0x00000400

/*------------------------------------------------------------------------*
 * some other parameters
 *------------------------------------------------------------------------*/

#define VCID_BASE          0x100
#define CELL_SIZE          56

#define FIRST_RATE_VCI    0x400
#define LAST_RATE_VCI     0x403
#define NUM_RATE_VCS      (LAST_RATE_VCI-FIRST_RATE_VCI+1)

#define IDLE_CELLS_PER_VR 50

#define RXDATA_VCI        1
#define RXRM_VCIa         0xaa
#define RXRM_VCIb         0xac
#define CREDIT_VCI        0xcc

#define TX_VPIVCI         0x100
#define INJECT_VPIVCI     0x110

typedef uint16 rateFmt_t;

typedef struct {
    uint32 header[2];
    uint16 pid         : 8;
    uint16 dontCare    : 3;
    uint16 ra          : 1;
    uint16 ni          : 1;
    uint16 ci          : 1;
    uint16 bn          : 1;
    uint16 dir         : 1;
    uint16 er;
    uint16 ccr;
    uint16 mcr;
    uint ql;
    uint sn;
    uint8 reserved1[30];
    uint16 crc         : 10;
    uint16 reserved2   : 6;
} abrRmCell_t;

typedef enum {
    status_tag_lastCellHeader,
    status_tag_rateDesired=8,
    status_tag_fairRate,
    status_tag_datacellcount,
    status_tag_datacelldrop,
    status_tag_rmcellcount,
    status_tag_rmcelldrop,
    status_tag_txidle,
    status_tag_rxBothWatcher,
    status_tag_startTx,
    status_tag_waitTx,
    status_tag_walker,
    status_tag_MACR,
    status_tag_bar
} status_tag_t;

/*------------------------------------------------------------------------*
 * my beautiful data structures
 *------------------------------------------------------------------------*/

/* queues of (pointers to VRs).  Used to maintain pools of free VRs for
 * each unit */

typedef struct vrnode {
    struct vrnode *nextp;
    vr_t *vrp;
    bool recycleMe;
} vrnode_t;

typedef struct {
    vrnode_t *headp, *tailp;
} vrqueue_t;

/* queues of buffer descriptors.  Used to remember what part of the buffer
 * is where */

typedef enum {bdnode_tag_rxdata, bdnode_tag_rxrm, bdnode_tag_idle}
bdnode_tag_t;

typedef struct bdnode {
    struct bdnode *nextp;
    bdnode_tag_t tag;
    vrnode_t *vrnodep;
    void *virtualAddress;
    uint32 physicalAddress;
    int length;
} bdnode_t;

typedef struct {
    bdnode_t *headp, *tailp;
} bdqueue_t;

/*------------------------------------------------------------------------
 * all of our other info goes here
 *------------------------------------------------------------------------*/

/* global info */

typedef struct {
    bool goHappened;
    bool vpcHomogenous;

    int  numUnits;
    int  numRxdataCells;
    int  numRxrmCells;
    int  numDelayLineCells;
    int  cellsPerVr;
    int  outputPortFullThreshold;
    int  congestionThreshold;
    bool wantEPRCA;
    int  DQT;
    int  rmCellMergeUnit;
    int  kernelLoopCount;

    int vrTableSize;

    bool injectHappened;
    int  injectVcid;
} megacow_t;

/* per unit info */

typedef struct {
    int numCells;
    int numDroppedCells;
    bool overrunHappened;
    int cellsInTx; /* number of cells in txqueue and wait queue */
    char *statusMsg;
    uint32 hexData;
    bool hexDataValid;
} watcherStats_t;

typedef struct {
    int otherUnit;
    mailbox_t mailbox;
    freelist_t rxdataFreelist, rxrmFreelist;
    vcid_t rxdataVcid, rxrmVcida, rxrmVcidb, txVcid;
    vr_t *mailboxHeadp;

    bdnode_t *idleBdnodeChunkp;

    vr_t **vrTable;
    int firstVrIndex, lastVrIndex;
    vrnode_t **mappingTable;

    vrqueue_t vrPool;
    vrnode_t *vrPoolMemoryp;

    bdqueue_t rxdataQueue;
    bdnode_t *rxdataQueueMemoryp;

    bdqueue_t rxrmQueue;
    bdnode_t *rxrmQueueMemoryp;

    bdqueue_t idleQueue;
    bdnode_t *idleQueueMemoryp;

    bdqueue_t txQueue, waitQueue;

    watcherStats_t rxdataStats, rxrmStats;

    char *startTxMsg, *waitTxMsg, *walkerMsg;
    bool startTxHexDataValid, waitTxHexDataValid;
    uint32 startTxHexData, waitTxHexData, walkerHexData;

    bool congestionHappened;

    int idleInTx;   /* number of idle cells in txqueue & waitqueue */

    int maxBothInTx; /* high water mark for (data+rm) cells */
    int maxIdleInTx; /* high water mark for idle cells */

    /* keep track of last cell headers */
    uint32 lastCellHeader[8][2];

    uint32 desiredRate[NUM_RATE_VCS];
    uint32 fairShare;
  
    /* EPRCA crapola */

    uint32 MACR, DQT;
} cow_t;

private megacow_t megacow;
private cow_t *cows;

#if 0
vrnode_t *VRPTOVRNODEP (int unit, cow_t *cowp, vr_t *vrp)
{
    if (0)
	warn ("unit is %d, cowp is 0x%x, vrindex is 0x%x\n",
	      unit, (uint32)cowp, VRINDEX(unit, vrp));
    if (0)
	warn ("first is 0x%x, last is 0x%x\n", cowp->firstVrIndex,
	      cowp->lastVrIndex);

    {
	int index = VRINDEX(unit,vrp);
	if (index < cowp->firstVrIndex)
	    warn ("mega error 0x%x is less than 0x%x\n", index, cowp->firstVrIndex);
	if (index > cowp->lastVrIndex)
	    warn ("mega error 0x%x is greater than 0x%x\n", index,
		  cowp->lastVrIndex);
    }

    return cowp->mappingTable[VRINDEX(unit,vrp)-cowp->firstVrIndex];
}
#endif

/*------------------------------------------------------------------------*/

public int vpcopen (dev_t dev, int flags, int mode, struct proc *p);
public int vpcclose (dev_t dev, int flags, int mode, struct proc *p);
public int
vpcioctl (dev_t dev, int cmd, caddr_t addr, int flag, struct proc *p);
private int VpcGo (int numUnits,
                   int numRxdataCells,
                   int numRxrmCells,
                   int numDelayLineCells,
                   int cellsPerVr, /*applies only to rxdata */
                   int outputPortFullThreshold,
                   int congestionThreshold,
                   int wantEPRCA,
                   int DQT,
                   int rmCellMergeUnit,
                   int kernelLoopCount);
private int Setup (cow_t *cowp, int otherUnit);
private int
BuildFreelist (cow_t *cowp, int freelist, bdqueue_t *qp, bdnode_t **qdatapp,
               int numVrs, int cellsPerVr, bdnode_tag_t bdnodeTag,
               void *bufferAddress);
private void VpcStop (void);
private void UnSetup (cow_t *cowp);
private int VpcPoll (void);
private void UpdateScreen (cow_t *cowp);
typedef enum {whoami_tag_rxdata, whoami_tag_rxrm} whoami_tag_t;
private void RxBothWatcherMan(cow_t *cowp, bdqueue_t *qp, whoami_tag_t whoami);
private void StartTxMan (cow_t *cowp);
private void WaitTxMan (cow_t *cowp);
private void MailboxWalker (cow_t *cowp);
typedef enum {setup_tag_tx, setup_tag_rx} setup_tag_t;
private void SetupVr (bdnode_t *bdnodep, setup_tag_t tag);
private void UpdateBar (int newValue, int *oldValuep, int maxValue, int ypos);
private int Inject (void);
private void InjectRmCells (uint32 *mp);
private void MakeRmCell (uint32 *mp, int cellNumber, int vcid,
                         int dir, int ccrnz, int ccrexp, int ccrman);
private void MakeDataCell (uint32 *mp, int cellNumber, int vci, int congested,
                           int endofpdu);
private void ProcessRMCell (cow_t *incowp, cow_t *outcowp, abrRmCell_t *cellp);
private uint32 RateFmtToInt (rateFmt_t rate);
private rateFmt_t IntToRateFmt (uint32 value);
private void DumpScreen (int unit, int ypos, char *msg);
private void DumpStr (char *msg);
private void DumpHex (uint32 data);

/*------------------------------------------------------------------------
 * the device interface
 *------------------------------------------------------------------------*/

public int vpcopen (dev_t dev, int flags, int mode, struct proc *p)
begin();
{
    if (cows) /* don't allow multiple opens */
	return EACCES;

    MALLOC_ARRAY (cows, NIJET);
    bzero (&megacow, sizeof(megacow));
    bzero (cows, NIJET*sizeof(*cows));

    megacow.goHappened = FALSE;
    return 0;
}
end();


public int vpcclose (dev_t dev, int flags, int mode, struct proc *p)
begin();
{
    if (megacow.goHappened)
	VpcStop ();

    free (cows, M_DEVBUF);
    cows = NULL;

    return 0;
}
end();


public int
vpcioctl (dev_t dev, int cmd, caddr_t addr, int flag, struct proc *p)
begin();
{
    int32 *data = (int32*)addr;

    switch (cmd) {
    case VPC_IOCTL_GO_ORIG: {
	return VpcGo (data[0], data[1], data[2], data[3], data[4], data[5],
		      data[6], data[7], data[8], data[9], data[10]);
    } break;

    case VPC_IOCTL_POLL: {
	return VpcPoll ();
    } break;

    default: {
	warnreturn (EINVAL, "ioctl 0x%x not implemented\n", cmd);
    } break;
    }
}
end();


private int VpcGo (int numUnits,
                   int numRxdataCells,
                   int numRxrmCells,
                   int numDelayLineCells,
                   int cellsPerVr, /*applies only to rxdata */
                   int outputPortFullThreshold,
                   int congestionThreshold,
                   int wantEPRCA,
                   int DQT,
                   int rmCellMergeUnit,
                   int kernelLoopCount)
begin();
{
    int error;

    if (numUnits<0 || numUnits>2)
	warnreturn (EINVAL, "%d is an absurd value for numUnits\n", numUnits);

#define cowify(param) megacow.param = param
    cowify (numUnits);
    cowify (numRxdataCells);
    cowify (numRxrmCells);
    cowify (numDelayLineCells);
    cowify (cellsPerVr);
    cowify (outputPortFullThreshold);
    cowify (congestionThreshold);
    cowify (wantEPRCA);
    cowify (DQT);
    cowify (rmCellMergeUnit);
    cowify (kernelLoopCount);
#undef cowify

    if (numUnits == 1)
	error = Setup (&cows[0], 0);
    else {
	if (!(error = Setup (&cows[0], 1)))
	    error = Setup (&cows[1], 0);
    }

    if (!error)
	error = Inject();

    if (!error)
	megacow.goHappened = TRUE;

    if (jet_oc12[0] != jet_oc12[1])
	megacow.vpcHomogenous = FALSE;

    return error;
}
end();


private int Setup (cow_t *cowp, int otherUnit)
begin();
{
    int unit = cowp-cows;

    cowp->otherUnit = otherUnit;

    /* allocate the VRs we need and establish the vrnode<-->vrp mapping */
    {
	/* This includes:
	 * incoming data cells
	 * incoming rm cells
	 * outgoing (data or rm) cells
	 * outgoing delay cells
	 * slop
	 */
	/* the 2* here is a little bonus to keep it from crashing */
	int vrsNeeded = 2*megacow.numRxdataCells/megacow.cellsPerVr
	    + megacow.numRxrmCells
	    + megacow.outputPortFullThreshold
	    + megacow.numDelayLineCells/IDLE_CELLS_PER_VR
	    + 16;
	int count, i;

	warn ("unit %d: Asking for %d vrs\n", unit, vrsNeeded);
	megacow.vrTableSize = vrsNeeded;

	MALLOC_ARRAY (cowp->vrTable, vrsNeeded);
	if ((count = ll_AllocateVrs (unit, vrsNeeded, cowp->vrTable))
	    != vrsNeeded)
	    warnreturn (ENETDOWN, "Unit %d couldn't get the %d VRs that it wanted\n",
			unit, vrsNeeded);
	{
	    int mappingSize;

	    /* set up the mapping from vr pointers to vrnode pointers */
	    cowp->firstVrIndex = VRINDEX(unit, cowp->vrTable[0]);
	    cowp->lastVrIndex  = VRINDEX(unit, cowp->vrTable[vrsNeeded-1]);

	    mappingSize = cowp->lastVrIndex-cowp->firstVrIndex+1;
	    MALLOC_ARRAY (cowp->mappingTable, mappingSize);
	}

	cowp->vrPool.headp = NULL;
	MALLOC_ARRAY (cowp->vrPoolMemoryp, vrsNeeded);
	for (i=0; i<vrsNeeded; i++) {
	    vrnode_t *vrnodep = &cowp->vrPoolMemoryp[i];
	    int index;

	    vrnodep->vrp = cowp->vrTable[i];
	    index = VRINDEX (unit, vrnodep->vrp) - cowp->firstVrIndex;
	    cowp->mappingTable[index] = vrnodep;
	    ENQUEUE (cowp->vrPool, vrnodep);
	}
    }

    /* we get "optimistic notifications" of receive/transmit done because
     * we peer directly into the VRs.  However, we still process the mailbox
     * in the usual way so that we don't return VRs to the free pool until
     * the ASIC is done with them. */
    {
	static vr_t hostVr = {{0}};
	vrnode_t *vrnodep = DEQUEUE (cowp->vrPool);
	vrnodep->recycleMe = TRUE;
	cowp->mailboxHeadp = vrnodep->vrp;

	if ((cowp->mailbox = ll_AllocMailbox (unit, NULL, NULL,
					      cowp->mailboxHeadp)) < 0)
	    warnreturn (ENETDOWN, "Unit %d can't open mailbox (error %d)\n",
			unit, cowp->mailbox);
	*cowp->mailboxHeadp = hostVr;
    }


    /* the data freelist */
    if ((cowp->rxdataFreelist = ll_AllocFreelist (unit, NULL, NULL)) < 0)
	warnreturn (ENETDOWN, "Unit %d can't allocate data freelist (error %d)\n",
		    unit, cowp->rxdataFreelist);

    /* the RM cell freelist */
    if ((cowp->rxrmFreelist = ll_AllocFreelist (unit, NULL, NULL)) < 0)
	warnreturn (ENETDOWN, "Unit %d can't allocate RM freelist (error %d)\n",
		    unit, cowp->rxrmFreelist);

    /* I should check error return but ha ha, I won't
     * There is a 1M physically/virtually contiguous region.  It is divvied up
     * like so:
     * 512K for adapter 0, 512K for adapter 1
     * for adapter N:
     *  64K for rm cells
     *  64K*7-4K for data cells
     *  4K for idle cells
     */

    {
	void *nextAddress = (void*)debug_bigBufp + (65536*8*unit);

	bzero (nextAddress, 65536*8);

	(void)BuildFreelist (cowp, cowp->rxrmFreelist,
			     &cowp->rxrmQueue, &cowp->rxrmQueueMemoryp,
			     megacow.numRxrmCells, 1,
			     bdnode_tag_rxrm, nextAddress);
	nextAddress += 65536;

	(void)BuildFreelist (cowp, cowp->rxdataFreelist,
			     &cowp->rxdataQueue, &cowp->rxdataQueueMemoryp,
			     megacow.numRxdataCells/megacow.cellsPerVr,
			     megacow.cellsPerVr,
			     bdnode_tag_rxdata, nextAddress);
	nextAddress += 65536*7-4096;

	/* build the idle queue bdnodes */
	{
	    uint32 physIdleCellRegion = vtophys (nextAddress);
	    int i;

	    cowp->idleQueue.headp = NULL;
	    MALLOC_ARRAY (cowp->idleQueueMemoryp,
			  megacow.numDelayLineCells/IDLE_CELLS_PER_VR);

	    for (i=0; i<megacow.numDelayLineCells/IDLE_CELLS_PER_VR; i++) {
		/* get next bdnode */
		bdnode_t *bdnodep = &cowp->idleQueueMemoryp[i];

		bdnodep->tag = bdnode_tag_idle;

		/* point it to the idle cell region */
		bdnodep->physicalAddress = physIdleCellRegion;
		bdnodep->length          = CELL_SIZE * IDLE_CELLS_PER_VR;

		/* notice that a header of all zero is an idle cell.  This was
		 * provided to us by the bzero above */

		/* add to idle pool */
		ENQUEUE (cowp->idleQueue, bdnodep);
	    }
	}
    }

    /* the other queues are empty */
    cowp->txQueue.headp   = NULL;
    cowp->waitQueue.headp = NULL;

    /* this is the promiscuous version */
#if 1
    {
	int vpivci;

	/* open data VC */
	warn ("Using promiscuous mode\n");
	vpivci = RXDATA_VCI;
	if ((cowp->rxdataVcid = ll_OpenRx (unit, CELL_PROCESSING_RAW,
					   cowp->mailbox,
					   cowp->rxdataFreelist, cowp->rxdataFreelist,
					   &vpivci)) < 0)
	    warnreturn (ENETDOWN, "unit %d can't open rx %d error %d\n",
			unit, vpivci, cowp->rxdataVcid);

	/* open RM VC */
	vpivci = RXRM_VCIa;
	if ((cowp->rxrmVcida = ll_OpenRx (unit, CELL_PROCESSING_RAW,
					  cowp->mailbox,
					  cowp->rxrmFreelist, cowp->rxrmFreelist,
					  &vpivci)) < 0)
	    warnreturn (ENETDOWN, "unit %d can't open rx %d error %d\n",
			unit, vpivci, cowp->rxrmVcida);

	vpivci = RXRM_VCIb;
	if ((cowp->rxrmVcidb = ll_OpenRx (unit, CELL_PROCESSING_RAW,
					  cowp->mailbox,
					  cowp->rxrmFreelist, cowp->rxrmFreelist,
					  &vpivci)) < 0)
	    warnreturn (ENETDOWN, "unit %d can't open rx %d error %d\n",
			unit, vpivci, cowp->rxrmVcidb);

	/* go into promiscuous mode */
	{
	    jet_reg_cfg_reg_t reg = jet_asicBase[unit]->cfg_reg;
	    reg.rxCollectOutOfRangeVcs = 1;
	    jet_asicBase[unit]->cfg_reg= reg;
	}
	jet_asicBase[unit]->vc_err = cowp->rxdataVcid;
    }
#else
    {
	/* this is the simple version */
	int vpivci, vcid;
	warn ("Using simple mode, vcs 256-287\n");

	for (vpivci=256; vpivci<288; vpivci++)
	    if ((vcid = ll_OpenRx (unit, CELL_PROCESSING_RAW,
				   cowp->mailbox,
				   cowp->freelist, cowp->freelist,
				   &vpivci)) < 0)
		warnreturn (ENETDOWN, "can't open %d: error %d\n", vpivci, vcid);

	if (INJECT_VPIVCI<256 | INJECT_VPIVCI>=256+32) {
	    vpivci = INJECT_VPIVCI;
	    if ((vcid = ll_OpenRx (unit, CELL_PROCESSING_RAW,
				   cowp->mailbox,
				   cowp->freelist, cowp->freelist,
				   &vpivci)) < 0)
		warnreturn (ENETDOWN, "can't open %d: error %d\n", vpivci, vcid);
	}

	if (0)
	    jet_asicBase[unit]->vc_oam = 0x24;
    }
#endif

    /* open the transmit vc */
    if ((cowp->txVcid = ll_OpenTx (unit, CELL_PROCESSING_RAW,
				   cowp->mailbox, SCHEDULE_STATIC,
				   TX_VPIVCI)) < 0)
	warnreturn (ENETDOWN, "unit %d can't open tx: error %d\n",
		    unit, cowp->txVcid);

    return 0;
}
end();

/* build the data freelist and the corresponding buffer descriptor
 * structure on the host. */

private int
BuildFreelist (cow_t *cowp, int freelist, bdqueue_t *qp, bdnode_t **qdatapp,
               int numVrs, int cellsPerVr, bdnode_tag_t bdnodeTag,
               void *bufferAddress)
begin();
{
    int unit = cowp-cows;
    int i;
    vr_t *firstVrp=NULL, *lastVrp=NULL;

    warn ("Using virtual address 0x%x, physical address 0x%x\n",
	  (uint32)bufferAddress, (uint32)vtophys(bufferAddress));

    qp->headp = NULL;
    MALLOC_ARRAY (*qdatapp, numVrs);
    for (i=0; i<numVrs; i++) {
	/* get next bdnode */
	bdnode_t *bdnodep = &(*qdatapp)[i];

	bdnodep->tag = bdnodeTag;

	/* compute its physical address */
	bdnodep->virtualAddress  = bufferAddress;
	bdnodep->physicalAddress = vtophys (bufferAddress);
	bdnodep->length          = cellsPerVr * CELL_SIZE;
	bufferAddress += bdnodep->length;

	/* bind it to a vrnode */
	bdnodep->vrnodep = DEQUEUE (cowp->vrPool);

	/* initialize its VR */
	SetupVr (bdnodep, setup_tag_rx);

	/* add to receive pool */
	ENQUEUE (*qp, bdnodep);

	/* add corresponding VR to asic freelist */
	if (0)
	    warn ("unit %d: appending VR 0x%x to freelist %d\n",
		  unit, VRINDEX(unit, bdnodep->vrnodep->vrp), freelist);

	if (!firstVrp)
	    firstVrp = lastVrp = bdnodep->vrnodep->vrp;
	else {
	    lastVrp->vr.nextIndex = VRINDEX (unit, bdnodep->vrnodep->vrp);
	    lastVrp = bdnodep->vrnodep->vrp;
	}
    }
    if (firstVrp)
	ll_AppendVrlistToFreelist (unit, freelist, firstVrp, lastVrp);

    return 0;
}
end();


private void VpcStop (void)
begin();
{
    if (megacow.injectHappened)
	ll_CloseTx (0, megacow.injectVcid);
    UnSetup (&cows[0]);
    if (megacow.numUnits == 2)
	UnSetup (&cows[1]);
}
end();

#define FREE_ARRAY(p) free(p, M_DEVBUF)

private void UnSetup (cow_t *cowp)
begin();
{
    int unit = cowp-cows;

    warn ("Hi!  Shutting down unit %d\n", unit);
    ll_CloseTx (unit, cowp->txVcid);
    ll_CloseRx (unit, cowp->rxdataVcid);
    ll_CloseRx (unit, cowp->rxrmVcida);
    ll_CloseRx (unit, cowp->rxrmVcidb);
    ll_FreeMailbox (unit, cowp->mailbox);
    ll_FreeVrs (unit, megacow.vrTableSize, cowp->vrTable);
    ll_FreeFreelist (unit, cowp->rxdataFreelist);
    ll_FreeFreelist (unit, cowp->rxrmFreelist);

    FREE_ARRAY (cowp->rxrmQueueMemoryp);
    FREE_ARRAY (cowp->rxdataQueueMemoryp);
    FREE_ARRAY (cowp->idleQueueMemoryp);
    FREE_ARRAY (cowp->vrPoolMemoryp);
    FREE_ARRAY (cowp->mappingTable);
    FREE_ARRAY (cowp->vrTable);

    megacow.goHappened = FALSE;
}
end();


private int VpcPoll (void)
begin();
{
    int i, unit, s;

    /*  for (i=0; i<megacow.kernelLoopCount; i++) { 
	for (unit=0; unit<megacow.numUnits; unit++) {
	RxBothWatcherMan (&cows[unit], &cows[unit].rxdataQueue,
	whoami_tag_rxdata);
	RxBothWatcherMan (&cows[unit], &cows[unit].rxrmQueue,
	whoami_tag_rxrm);
	StartTxMan    (&cows[unit]);
	WaitTxMan     (&cows[unit]);
	MailboxWalker (&cows[unit]);
	}
	} */
      
    i = 0;
    s = splimp();
    while (vpcKeepGoing) {
	i++;  
	for (unit=0; unit<megacow.numUnits; unit++) {
	    RxBothWatcherMan (&cows[unit], &cows[unit].rxdataQueue,
			      whoami_tag_rxdata);
	    RxBothWatcherMan (&cows[unit], &cows[unit].rxrmQueue,
			      whoami_tag_rxrm);
	    StartTxMan    (&cows[unit]);
	    WaitTxMan     (&cows[unit]);
	    MailboxWalker (&cows[unit]);
	}
	if (i == 1) {
	    for (unit=0; unit<megacow.numUnits; unit++)
		UpdateScreen (&cows[unit]);
	    i = 0;
	}
    }
    splx(s);

    for (unit=0; unit<megacow.numUnits; unit++)
	UpdateScreen (&cows[unit]);
    
    return 0;
}
end();


private void UpdateScreen (cow_t *cowp)
begin();
{
    int unit=cowp-cows;
    int i;

    if (0)
	for (i=0; i<256; i++)
	    SCREEN_SLAM (0, i, 0x1200+i);

    DumpScreen (unit, status_tag_rxBothWatcher, "dt:");
    DumpStr (cowp->rxdataStats.statusMsg);
    if (cowp->rxdataStats.hexDataValid);
    DumpHex (cowp->rxdataStats.hexData);

    DumpStr ("  rm:");
    DumpStr (cowp->rxrmStats.statusMsg);
    if (cowp->rxrmStats.hexDataValid);
    DumpHex (cowp->rxrmStats.hexData);

    DumpScreen (unit, status_tag_datacellcount, "datacount:");
    DumpHex (cowp->rxdataStats.numCells);
    DumpStr ("in tx:");
    DumpHex (cowp->rxdataStats.cellsInTx);

    DumpScreen (unit, status_tag_datacelldrop,  "data drop:");
    DumpHex (cowp->rxdataStats.numDroppedCells);
    DumpStr("ov:");
    if (cowp->rxdataStats.overrunHappened)
	DumpStr ("!YES");
    else
	DumpStr ("no");
    DumpStr (" EFCI:");
    if (cowp->congestionHappened)
	DumpStr ("!YES");
    else
	DumpStr ("no");

    DumpScreen (unit, status_tag_rmcellcount,   "   rm cnt:");
    DumpHex (cowp->rxrmStats.numCells);
    DumpStr ("in tx:");
    DumpHex (cowp->rxrmStats.cellsInTx);

    DumpScreen (unit, status_tag_rmcelldrop, "  rm drop:");
    DumpHex (cowp->rxrmStats.numDroppedCells);
    DumpStr ("ov:");
    if (cowp->rxrmStats.overrunHappened)
	DumpStr ("!YES");
    else
	DumpStr ("no");

    DumpScreen (unit, status_tag_txidle, "   txidle:");
    DumpHex (cowp->idleInTx);

    if (megacow.wantEPRCA) {
	DumpScreen (unit, status_tag_rateDesired, "ccr:");
	for (i=0; i<4; i++)
	    DumpHex (cowp->desiredRate[i]);
	DumpScreen (unit, status_tag_fairRate, "fair share:");
	DumpHex (cowp->fairShare);
    }

    DumpScreen (unit, status_tag_startTx, cowp->startTxMsg);
    if (cowp->startTxHexDataValid)
	DumpHex (cowp->startTxHexData);

    DumpScreen (unit, status_tag_waitTx, cowp->waitTxMsg);
    if (cowp->waitTxHexDataValid)
	DumpHex (cowp->waitTxHexData);

    DumpScreen (unit, status_tag_walker, cowp->walkerMsg);
    DumpHex (cowp->walkerHexData);

    DumpScreen (unit, status_tag_MACR, "MACR:");
    DumpHex (cowp->MACR);

    UpdateBar (cowp->rxdataStats.cellsInTx + cowp->rxrmStats.cellsInTx,
	       &cowp->maxBothInTx,
	       megacow.outputPortFullThreshold,
	       status_tag_bar+unit);
    if (0)
	UpdateBar (cowp->idleInTx, &cowp->maxIdleInTx,
		   megacow.numDelayLineCells,
		   status_tag_bar+2*unit+1);

    if (1) {
	int i;
	for (i=0; i<8; i++) {
	    DumpScreen (unit, status_tag_lastCellHeader+i, "h:");
	    DumpHex (cowp->lastCellHeader[i][0]);
	    DumpHex (cowp->lastCellHeader[i][1]);
	}
    }
}
end();

/*
 * This routine watches for incoming cells, either data or rm.
 * If data cells, they are passed through virtually untouched (except for
 * setting of the EFCI bit).  rm cells are processed though.
 */

private void RxBothWatcherMan (cow_t *cowp, bdqueue_t *qp, whoami_tag_t whoami)
begin();
{
    int unit = cowp-cows;
    watcherStats_t *watcherStatsp;
    int cellsPerVr;

    if (whoami == whoami_tag_rxdata) {
	watcherStatsp = &cowp->rxdataStats;
	cellsPerVr    = megacow.cellsPerVr;
    } else {
	watcherStatsp = &cowp->rxrmStats;
	cellsPerVr    = 1;
    }

    megatoast = 0;

    for (;;) {
	bdnode_t *bdnodep = qp->headp;

	/* rx queue totally empty?(should only happen in pathological cases) */
	if (bdnodep == NULL) {
	    watcherStatsp->statusMsg       = "!Empty";
	    watcherStatsp->hexDataValid    = FALSE;
	    watcherStatsp->overrunHappened = TRUE;
	    break;
	}

	/* can't proceed until asic fills incoming vr */
	if (bdnodep->vrnodep->vrp->message.remain != 0) {
	    watcherStatsp->statusMsg    = "wait";
	    watcherStatsp->hexData      = VRINDEX(unit,bdnodep->vrnodep->vrp);
	    watcherStatsp->hexDataValid = TRUE;
	    break;
	}
	DEQUEUE (*qp);

	/* slurp up the cell headers */
	if (1)
	    {
		int i, j, wordnum;
		for (wordnum=0; wordnum<2; wordnum++)
		    for (i=0; i<cellsPerVr; i++) {
			for (j=0; j<7; j++)
			    cowp->lastCellHeader[j][wordnum] =
				cowp->lastCellHeader[j+1][wordnum];
			cowp->lastCellHeader[7][wordnum] =
			    ((uint32*)(bdnodep->virtualAddress))[14*i+wordnum];
		    }
	    }

	watcherStatsp->numCells += cellsPerVr;

	/* unbind VR from buffer descriptor.  MailboxWalker will eventually
	 * return it to the pool */
	bdnodep->vrnodep->recycleMe = TRUE;
	bdnodep->vrnodep = NULL;

	/* if output port is "full", drop the cells, recycle the buffer desc */
	{
	    int outunit = cowp->otherUnit;
	    cow_t *outcowp = &cows[outunit];

	    /* WARNING: we never drop RM cells, per Prashant's request */
	    if ((whoami == whoami_tag_rxdata) &&
		((outcowp->rxdataStats.cellsInTx + 
		  outcowp->rxrmStats.cellsInTx)
		 > megacow.outputPortFullThreshold)) {
		watcherStatsp->numDroppedCells += cellsPerVr;
		megatoast++;
		bdnodep->vrnodep = DEQUEUE (cowp->vrPool);
		SetupVr (bdnodep, setup_tag_rx);

		/* link to tail of freelist (man rx linking--yay!) */
		assert (qp->headp != NULL);
		qp->tailp->vrnodep->vrp->vr.nextIndex =
		    VRINDEX (unit, bdnodep->vrnodep->vrp);
		ENQUEUE (*qp, bdnodep);
	    } 
	    else {
		/* if it's an RM cell, process it */
		if (whoami == whoami_tag_rxrm) {
		    abrRmCell_t *cellp = 
			(abrRmCell_t *)bdnodep->virtualAddress;
		    /* horrible Prashant hack merges rm cells onto the same vc
		     * in one direction only--it's a superhack because we
		     * require that RXRM_VCIa and RXRM_VCIb differ only in 
		     their low nibble! */

#if 0
#define HACK_NIBBLE 0x00f00000
#define HACK_BITPOS 20
		    if (unit == megacow.rmCellMergeUnit) {
			uint32 wasHeader = cellp->header[1];
			cellp->header[1] = (cellp->header[1] & ~HACK_NIBBLE)
			    | ((RXRM_VCIa & 0xf)<<HACK_BITPOS);
			if (0)
			    warn ("Unit %d merged: from 0x%x to 0x%x...\n", 
				  unit, wasHeader, cellp->header[1]);
		    }
#undef HACK_NIBBLE
#endif
		}

		if (megacow.wantEPRCA && (whoami == whoami_tag_rxrm))
		    ProcessRMCell (cowp, outcowp,
				   (abrRmCell_t*)bdnodep->virtualAddress);

		/* if we're acting as a delay line, insert the appropriate
		 * number ofdelay cells */

		while ((outcowp->rxdataStats.cellsInTx + 
			outcowp->rxrmStats.cellsInTx
			+ outcowp->idleInTx)
		       < megacow.numDelayLineCells) {
		    /* get a buffer descriptor from out's "idle cell" queue */
		    bdnode_t *idlebdp = DEQUEUE (outcowp->idleQueue);

		    /* bind a VR to this */
		    idlebdp->vrnodep = DEQUEUE (outcowp->vrPool);

		    /* set up the VR. */
		    SetupVr (idlebdp, setup_tag_tx);

		    /* if the tx queue is nonempty, link this VR to the 
		       tail of the previous */

		    if (outcowp->txQueue.headp != NULL)
			outcowp->txQueue.tailp->vrnodep->vrp->vr.nextIndex =
			    VRINDEX (outunit, idlebdp->vrnodep->vrp);

		    /* Put this buffer descriptor on the transmit queue */
		    ENQUEUE (outcowp->txQueue, idlebdp);

		    outcowp->idleInTx += IDLE_CELLS_PER_VR;
		}

		/* set the congestion bit appropriately */

		if (!megacow.wantEPRCA)		    
		    if ((outcowp->rxdataStats.cellsInTx 
			 + outcowp->rxrmStats.cellsInTx)
			> megacow.congestionThreshold) {
			if (jet_oc12[unit]) 
			    ((uint32*)bdnodep->virtualAddress)[EFCI_OFFSET]
				|= EFCI_BIT_OC12;
			else
			    ((uint32*)bdnodep->virtualAddress)[EFCI_OFFSET]
				|= EFCI_BIT_OC3;
			cowp->congestionHappened = TRUE;
		    }

		/* 
		 * Adjust raw cell format when working between OC-3 and OC-12 
		 * units.
		 */
		if (!megacow.vpcHomogenous) {
		    uint32 *headerp;
		    int i;

		    for (i = 0; i < cellsPerVr; i++) {
			headerp = (uint32 *) 
			    &(((uint32 *)bdnodep->virtualAddress)[14*i]);
			if (jet_oc12[unit]) {
			    /* Input is OC12 and output is OC3 */
			    headerp[1] = 
				(headerp[1] << 8) | (headerp[0] >> 24);
			    headerp[0] = (headerp[0] << 8);
			}
			else {
			    /* Input is OC3 and output is OC12 */
			    headerp[0] = 
				(headerp[0] >> 8) | (headerp[1] << 24);
			    headerp[1] = (headerp[1] >> 8);
			}
		    }
		}

		/* now finally append the buffer descriptor of the data */

		/* get a VR from out's pool, bind to our buffer descriptor */
		bdnodep->vrnodep = DEQUEUE (outcowp->vrPool);
	
		/* set up the VR. */
		SetupVr (bdnodep, setup_tag_tx);

		/* if the tx queue is nonempty, link this VR to the tail of the
		   previous */

		if (outcowp->txQueue.headp != NULL)
		    outcowp->txQueue.tailp->vrnodep->vrp->vr.nextIndex =
			VRINDEX (outunit, bdnodep->vrnodep->vrp);

		/* Put this buffer descriptor on the transmit queue */
		ENQUEUE (outcowp->txQueue, bdnodep);

		if (whoami == whoami_tag_rxdata)
		    outcowp->rxdataStats.cellsInTx += cellsPerVr;
		else
		    outcowp->rxrmStats.cellsInTx ++;
	    }
	}
    }
}
end();

/*
 * If the transmit vcid is free, transmit the whole chain waiting
 * in the txQueue (the VRs have already been linked together)
 */

private void StartTxMan (cow_t *cowp)
begin ();
{
    int unit = cowp-cows;

    {
	bdnode_t *headp = cowp->txQueue.headp;

	/* nothing to transmit? */
	if (headp == NULL) {
	    cowp->startTxMsg     = "tx empty";
	    cowp->startTxHexDataValid = FALSE;
	    return;
	}

	/* is my vcid free? */
	if (ll_txTableBase[unit][cowp->txVcid].vrIndex != 0) {
	    cowp->startTxMsg = "manlink wait VC:";
	    cowp->startTxHexData = cowp->txVcid;
	    cowp->startTxHexDataValid = TRUE;
	    return;
	}

	/* transmit the whole pile */
	ll_txTableBase[unit][cowp->txVcid].vrIndex =
	    VRINDEX (unit, headp->vrnodep->vrp);
    }

    /* Append the new buffer descriptors onto the waitQueue */
    if (cowp->waitQueue.headp == NULL)
	cowp->waitQueue = cowp->txQueue;
    else {
	cowp->waitQueue.tailp->nextp = cowp->txQueue.headp;
	cowp->waitQueue.tailp = cowp->txQueue.tailp;
    }
    cowp->txQueue.headp = NULL;
}
end();


private void WaitTxMan (cow_t *cowp)
begin();
{
    int unit=cowp-cows;
    int inunit = cowp->otherUnit;
    cow_t *incowp = &cows[inunit];

    for (;;) {
	bdnode_t *bdnodep = cowp->waitQueue.headp;

	if (bdnodep == NULL) { /* nothing to wait for? */
	    cowp->waitTxMsg     = "wait tx empty";
	    cowp->waitTxHexDataValid = FALSE;
	    break;
	}

	/* VR not transmitted yet? */
	if (bdnodep->vrnodep->vrp->message.remain != 0) {
	    cowp->waitTxMsg     = "wait complete VR:";
	    cowp->waitTxHexDataValid = TRUE;
	    cowp->waitTxHexData = VRINDEX(unit, bdnodep->vrnodep->vrp);
	    break;
	}
	DEQUEUE (cowp->waitQueue);

	/* unbind vrnode */
	bdnodep->vrnodep->recycleMe = TRUE;
	bdnodep->vrnodep = NULL;

	/* return buffer descriptor to the appropriate queue */
	if (bdnodep->tag == bdnode_tag_rxdata) {
	    cowp->rxdataStats.cellsInTx -= megacow.cellsPerVr;
	    /* get a fresh VR from in's pool */
	    bdnodep->vrnodep = DEQUEUE (incowp->vrPool);

	    SetupVr (bdnodep, setup_tag_rx);

	    /* add this buffer descriptor to in's rxQueue, and append the new
	     * VR to in's freelist: MAN RX LINKING---yay! */

	    assert (incowp->rxdataQueue.headp != NULL);
	    incowp->rxdataQueue.tailp->vrnodep->vrp->vr.nextIndex =
		VRINDEX (inunit, bdnodep->vrnodep->vrp);
	    ENQUEUE (incowp->rxdataQueue, bdnodep);
	} else if (bdnodep->tag == bdnode_tag_rxrm) {
	    cowp->rxrmStats.cellsInTx--;
	    /* get a fresh VR from in's pool */
	    bdnodep->vrnodep = DEQUEUE (incowp->vrPool);
	    SetupVr (bdnodep, setup_tag_rx);

	    /* add this buffer descriptor to in's rxQueue, and append the new
	     * VR to in's freelist: MAX RX LINKING----yay! */
	    assert (incowp->rxrmQueue.headp != NULL);
	    incowp->rxrmQueue.tailp->vrnodep->vrp->vr.nextIndex =
		VRINDEX (inunit, bdnodep->vrnodep->vrp);
	    ENQUEUE (incowp->rxrmQueue, bdnodep);
	} else {
	    assert (bdnodep->tag == bdnode_tag_idle);
	    cowp->idleInTx -= IDLE_CELLS_PER_VR;
	    ENQUEUE (cowp->idleQueue, bdnodep);
	}
    }
}
end();


private void MailboxWalker (cow_t *cowp)
begin();
{
    int unit = cowp-cows;
    int nextIndex;

    if (cowp->mailboxHeadp->message.nextIndex == 0) {
	cowp->walkerMsg = "wait head:";
	cowp->walkerHexData = VRINDEX (unit, cowp->mailboxHeadp);
    } else {
	while ((nextIndex=cowp->mailboxHeadp->message.nextIndex) != 0) {
	    vrnode_t *vrnodep = VRPTOVRNODEP (unit, cowp, cowp->mailboxHeadp);
	    if (!vrnodep->recycleMe) {
		cowp->walkerMsg = "recycle:";
		cowp->walkerHexData = VRINDEX (unit, cowp->mailboxHeadp);
		return;
	    }
	    ENQUEUE (cowp->vrPool, vrnodep);
	    if ((nextIndex<cowp->firstVrIndex)||(nextIndex > cowp->lastVrIndex)) {
		warn ("**** MEGA WARNING: VR 0x%x has nextIndex 0x%x::how absurd\n",
		      VRINDEX(unit, cowp->mailboxHeadp), nextIndex);
		panic ("cow");
	    } else
		cowp->mailboxHeadp = VRP (unit, nextIndex);
	}
    }
}
end();


private void SetupVr (bdnode_t *bdnodep, setup_tag_t tag)
begin();
{
    static vr_t hostVr = {{0}};

    /* guess what: the "which" parameter doesn't matter */
    (void)tag;

    hostVr.vr.sarLocation           = SAR_HOST;
    hostVr.vr.address               = bdnodep->physicalAddress;
    hostVr.vr.remain                = bdnodep->length;
    /* hostVr.vr.nextIndex defaults to 0 */

    bdnodep->vrnodep->recycleMe = FALSE;
    *(bdnodep->vrnodep->vrp) = hostVr; /* slam into SRAM */
}
end();

/* Inject a cell into the system.  Somewhat hacky.  */

#define NUM_CELLS_TO_INJECT 70

private int Inject (void)
begin();
{
    static vr_t hostVr = {{0}};
    static uint32 megaPayload[1024*2];
    uint32 *mp;
    vrnode_t *vrnodep;
    int i;

    /* find a sequence of 1024 physically contiguous words */
    mp = (uint32*)((((uint32)megaPayload)+0xfff)&~0xfff);

    warn ("Inject is using virtual 0x%x physical 0x%x\n",
	  (uint32)mp, (uint32)vtophys(mp));

    if (1)
	for (i=0; i<NUM_CELLS_TO_INJECT; i++)
	    mp[14*i+1] = 0x00004000;

    InjectRmCells (mp);

    if ((megacow.injectVcid = ll_OpenTx (0, CELL_PROCESSING_RAW,
					 cows[0].mailbox, SCHEDULE_STATIC,
					 INJECT_VPIVCI)) < 0)
	warnreturn (ENETDOWN, "can't open Inject vc: error %d\n",
		    megacow.injectVcid);

    warn ("***** %d vcid is %d\n", INJECT_VPIVCI, megacow.injectVcid);

    /* steal a VR */
    vrnodep = DEQUEUE (cows[0].vrPool);
    vrnodep->recycleMe = TRUE;

    hostVr.vr.sarLocation           = SAR_HOST;
    hostVr.vr.address               = vtophys(mp);
    hostVr.vr.remain                = 56*NUM_CELLS_TO_INJECT;
    hostVr.vr.endOfPdu              = 1;
    hostVr.vr.gfc                   = 0xa;
    hostVr.vr.pti                   = 1;
    hostVr.vr.clp                   = 1;
    /* hostVr.vr.nextIndex defaults to 0 */

    *vrnodep->vrp = hostVr; /* slam into SRAM */

    ll_txTableBase[0][megacow.injectVcid].vrIndex = VRINDEX(0, vrnodep->vrp);

    /* hack--remove in final version */
    if (0)
	reg_WriteStaticBitVector (0, megacow.injectVcid, 1);

    megacow.injectHappened = TRUE;

    return 0;
}
end();


/* set up a simple test to see if RM cell processing is working */

private void InjectRmCells (uint32 *mp)
begin();
{
    MakeRmCell (mp, 2, 0x400, 0, 1, 27, 250); /* 0x400:200M */
    MakeRmCell (mp, 4, 0x401, 0, 1, 26, 250); /* 0x401:100M */
    MakeRmCell (mp, 6, 0x402, 0, 1, 23, 98);  /* 0x402:10M */
    MakeRmCell (mp, 8, 0x400, 0, 1, 23, 98);  /* 0x400:10M */
    MakeRmCell (mp, 10, 0x402, 0, 0, 15, 15);  /* 0x402: zero */

    if (0) {
	MakeDataCell (mp, 0, 0x400, 0, 0);
	MakeDataCell (mp, 1, 0x400, 0, 0);
	MakeDataCell (mp, 3, 0x400, 0, 1);
	MakeDataCell (mp, 5, 0x400, 0, 0);

	MakeDataCell (mp, 7, 0x400, 0, 0);
	MakeDataCell (mp, 9, 0x400, 1, 0);
	MakeDataCell (mp, 10, 0x400, 0, 0);
	MakeDataCell (mp, 11, 0x400, 0, 0);

	MakeDataCell (mp, 12, 0x400, 1, 0);
	MakeDataCell (mp, 13, 0x400, 1, 0);
	MakeDataCell (mp, 14, 0x400, 0, 0);
	MakeDataCell (mp, 15, 0x400, 0, 0);

	MakeDataCell (mp, 16, 0x400, 0, 0);
	MakeDataCell (mp, 17, 0x400, 0, 0);
	MakeDataCell (mp, 18, 0x400, 0, 0);
	MakeDataCell (mp, 19, 0x400, 0, 0);
    }
}
end();


private void MakeRmCell (uint32 *mp, int cellNumber, int vcid,
                         int dir, int ccrnz, int ccrexp, int ccrman)
begin();
{
    uint32 *cellp = &mp[cellNumber*14];

    cellp[0] = 0;
    cellp[1] = 0x00a00a00;
    cellp[2] = dir<<15;
    cellp[3] = (ccrnz<<14) | (ccrexp<<9) | (ccrman);
    cellp[5] = vcid;
}
end();


private void MakeDataCell (uint32 *mp, int cellNumber, int vci, int congested,
                           int endofpdu)
begin();
{
    uint32 *cellp = &mp[cellNumber*14];
    int vci0, vci1, vci2, vci3;

    vci0 = vci&0xf;
    vci1 = (vci>>4)&0xf;
    vci2 = (vci>>8)&0xf;
    vci3 = (vci>>12)&0xf;

    cellp[0] = 0;
    cellp[1] = (vci0<<20) | (vci1<<8) | (vci2<<12) | (vci3) | (congested<<18)
	| (endofpdu << 17);
}
end();

/* Rate code helper routines */

private void ProcessRMCell (cow_t *incowp, cow_t *outcowp, abrRmCell_t *cellp)
begin();
{
    cow_t *cowp;
    uint32 vci = cellp->sn;
    uint32 Q, ACR, MACR, DQT;
    bool congested;

    if (0)
	warn ("vci 0x%x, dir %d, ccr 0x%x\n", vci, cellp->dir, cellp->ccr);

    if ((vci < FIRST_RATE_VCI) || (vci > LAST_RATE_VCI))
	return;

    /* Q is the queue length */

    if (cellp->dir == 0)
	cowp = outcowp;
    else
	cowp = incowp;

    Q = cowp->rxdataStats.cellsInTx + cowp->rxrmStats.cellsInTx;
    congested = Q > megacow.congestionThreshold;

    ACR  = RateFmtToInt (cellp->ccr);
    MACR = cowp->MACR;
    DQT  = cowp->DQT;

    if (cellp->dir == 0) { /* forward */
	if ((congested && (ACR < MACR)) || (!congested && (ACR > MACR*7/8)))
	    cowp->MACR = (MACR*15/16) + (ACR/16);  /* 1/16 is the AV */
    } else { /* backward */
	if (congested) {
	    uint32 ER = RateFmtToInt (cellp->er);

	    if (Q > DQT)
		cellp->er = IntToRateFmt (min (MACR/4, ER));
	    else {
		if (ACR>MACR*7/8) { /* 7/8 is the DPF */
		    cellp->er = IntToRateFmt (min (MACR*15/16, ER));/*15/16 is the erf*/
		}
	    }
	}
    }
}
end();

#if 0
index = vci-FIRST_RATE_VCI;

cowp->desiredRate[index] = RateFmtToInt (cellp->ccr);
cowp->fairShare =
RecomputeFairShare (NUM_RATE_VCS, cowp->desiredRate);
}
  else { /* backward */
    if (0)
      warn ("backward er is native 0x%x int 0x%x, fairshare is 0x%x\n",
            cellp->er, RateFmtToInt(cellp->er), cowp->fairShare);
    if (RateFmtToInt(cellp->er) > cowp->fairShare) {
      cellp->er = IntToRateFmt (cowp->fairShare);
      if (0)
        warn ("Setting to native 0x%x\n", IntToRateFmt(cowp->fairShare));
    }
  }
end();


private uint32 RecomputeFairShare (int numItems, uint32 *desiredRate)
begin();
{
  return megalinkrate;
}
end();

  uint32 fairShare = megalinkrate / numItems;

  /* pass 1 */
  for (i=0; i<numItems; i++) {
    if (desiredRate[i] < fairShare) {
      isPig[i] = FALSE;
      fairRate[i] = desiredRate[i];
      numPigs--;
      linkRateDeduction += desiredRate[i];
    } else
      isPig[i] = TRUE;
  }

  fairShare = (megalinkrate - linkRateDeduction) / numPigs;
  for (i=0; i<numItems; i++)
    if (isPig[i] && (desiredRate[i] < fairShare)) {

      isPig
    if (!isPiglet[i])
      }

  int permute[numItems];
  int i,j;
  uint32 totalPie;

  {
    uint32 total = 0;
    for (i=0; i<numItems; i++)
      total += desiredRate[i];
    if (total < megalinkrate)
      return megalinkrate/numItems;
  }

  /* sort according to increasing rate */
  for (i=0; i<numItems; i++)
    permute[i] = i;

  /* use bubble sort because numItems is small */
  for (i=0; i<numItems-1; i++) {
    for (j=i+1; j<numItems; j++) {
      if (desiredRate[permute[i]] > desiredRate[permute[j]]) {
        int temp = permute[i];
        permute[i] = permute[j];
        permute[j] = temp;
      }
    }
  }

  /* do the fair share algorithm */
  
  totalPie = megalinkrate;
  for (i=0; i<numItems; i++) {
    uint32 fairShare = totalPie/(numItems-i);

    if (desiredRate[permute[i]] < fairShare)
      totalPie -= desiredRate[permute[i]];
    else
      return fairShare;
  }
  notreached;
}
end();
#endif


private uint32 RateFmtToInt (rateFmt_t rate)
begin();
{
  int nz = (rate >> 14) & 0x1;
  int e  = (rate >> 9)  & 0x1f;
  int m  = (rate     )  & 0x1ff;

  if (nz == 0)
    return 0;
  else if (e>=9)
    return (m+512)<<(e-9);
  else
    return (m+512)>>(9-e);
}
end();


private rateFmt_t IntToRateFmt (uint32 value)
begin();
{
  int e, m;
  for (e=31;e>=0;e--)
    if (value & (1<<e))
      break;
  if (e == -1)
    return 0;
  if (e >= 9)
    m = (value>>(e-9)) & 0x1ff;
  else
    m = (value<<(9-e)) & 0x1ff;

  return (1<<14) | (e<<9) | m;
}
end();

typedef enum {
  color_black,
  color_blue,
  color_green,
  color_aqua,
  color_red,
  color_purple,
  color_orange,
  color_grey,
  attrib_intense=0x800,
  attrib_blink=0x8000
} color_t;

#define FG(x) ((x)<<8)
#define BG(x) ((x)<<12)
#define COLOR_NORMAL   (attrib_intense | FG(color_orange) | BG(color_blue))
#define COLOR_EMPHASIS (attrib_intense | FG(color_red)    | BG(color_blue))

private int screen_ypos, screen_xpos, screen_color;

private void DumpScreen (int unit, int ypos, char *msg)
begin();
{
  screen_ypos = ypos;
  screen_xpos = 40*unit;
  DumpStr (msg);
}
end();


private void DumpStr (char *msg)
begin();
{
  screen_color = COLOR_NORMAL;
  while (*msg) {
    if (*msg == '!')
      screen_color = COLOR_EMPHASIS;
    else {
      SCREEN_SLAM (screen_ypos, screen_xpos, screen_color+*msg);
      screen_xpos++;
    }
    msg++;
  }
}
end();


private void DumpHex (uint32 data)
begin();
{
  static char hextable[] = "0123456789abcdef";
  int i;

  for (i=7; i>=0; i--) {
    SCREEN_SLAM (screen_ypos, screen_xpos+i, screen_color+hextable[data&0xf]);
    data = data>>4;
  }
  SCREEN_SLAM (screen_ypos, screen_xpos+8, screen_color+' ');
  screen_xpos += 9;
}
end();


#define BAR_COLOR_VALUE     (attrib_intense | FG(color_green))
#define BAR_COLOR_WATERMARK FG(color_green)
#define BAR_NEVER_VALUE     1
#define BAR_HASH_VALUE      2

private void UpdateBar (int newValue, int *highWaterMarkp, int maxValue,
                        int ypos)
begin();
{
  int i;
  int valueIndex=newValue;
  int highWaterMarkIndex = *highWaterMarkp;

  if (newValue > *highWaterMarkp)
    *highWaterMarkp = newValue;

  if (maxValue > 80) {
    valueIndex         *= 80;
    highWaterMarkIndex *= 80;
    valueIndex         /= maxValue;
    highWaterMarkIndex /= maxValue;
  }

  for (i=0; i<valueIndex; i++)
    SCREEN_SLAM (ypos, i, BAR_COLOR_VALUE     | BAR_HASH_VALUE);
  for (; i<highWaterMarkIndex; i++)
    SCREEN_SLAM (ypos, i, BAR_COLOR_WATERMARK | BAR_HASH_VALUE);
  for (; i<80; i++)
    SCREEN_SLAM (ypos, i, BAR_COLOR_WATERMARK | BAR_NEVER_VALUE);
}
end();
