#include <sys/types.h>
#include <sys/malloc.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/errno.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/syslog.h>
#include <sys/device.h>
#include <sys/malloc.h>
#include <sys/proc.h>

#include <vm/vm.h>
#include <vm/vm_param.h>
#include <vm/vm_extern.h>

#include <net/if.h>
#include <net/if_types.h>
#include <net/if_dl.h>
#include <net/netisr.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>

#include <machine/cpu.h>
#include <machine/pio.h>

#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_ll.h>
#include <dev/pci/jetland/include/ijet_reg.h>
#include <dev/pci/jetland/src/uworld/uworld_user.h>

extern vm_map_t kernel_map;

public int uworldopen (dev_t dev, int flags, int mode, struct proc *p);
public int uworldclose (dev_t dev, int flags, int mode, struct proc *p);
public int
uworldioctl (dev_t dev, int cmd, caddr_t addr, int flag, struct proc *p);


public int uworldopen (dev_t dev, int flags, int mode, struct proc *p)
begin();
{
  return 0;
}
end();


public int uworldclose (dev_t dev, int flags, int mode, struct proc *p)
begin();
{
  return 0;
}
end();


public int
uworldioctl (dev_t dev, int cmd, caddr_t addr, int flag, struct proc *p)
begin();
{
  uint32 *p = (uint32*)addr;
  switch (cmd) {
  case UWORLD_IOCTL_DVR_LINK: return DoDvrLink (p[0], p[1], p[2], p[3]);
  default: return EINVAL;
  }
}
end();


public int DoDvrLink (int unit, uint32 p0, uint32 p1, uint32 p2)
begin();
{
  uint32 parms[3];
  parms[0] = p0 | JET_DYN_VR_LINK_OPCODE<<27;
  parms[1] = p1;
  parms[2] = p2;
  warn ("unit %d is issuing 0x%x 0x%x 0x%x\n", unit,
        parms[0], parms[1], parms[2]);
  IssueSchedulerCommand_func (unit, parms, 3);
  return 0;
}
end();
