void cow1(){}
void cow2(){}
void cow3(){}
/* decade deface facade This has corey's mod32 hack */

/*
 * FIX:    fix this soon
 * NOTE:   various types of notes about the implementation
 * ASK:    questions to be answered
 * CHECK:  check this at some later date
 */

/*
 * these are the defines that change the behavior of this driver, they
 * can be set as options in the kernel config files.  they could be
 * set here if you really wanted to.

 IJET_LOOPBACK              software loopback in ijetifoutput()
 IJET_CELL_COUNTS           keep rcv and xmt cell counts
 IJET_INTELMERGESPACKETS    try to handle merged packets
 IJET_N48HACK               avoid merged packets and assume we don't get any
 IJET_LOSES_INTERRUPTS      assume we lose interrupts occasionally
 IJET_CREDIT                must have credit to xmt
 */

/* check some things for sanity */
/* must not have both of these defined at the same time*/
#if defined(IJET_N48HACK) && defined(IJET_INTELMERGESPACKETS)
#error do not define both IJET_N48HACK and IJET_INTELMERGESPACKETS
#endif

#define IJET_CREDIT_VR_SIZE 48

/*
 * This macro uses % twice since the way % handles negative
 * operands is compiler dependent.
 */
#define ATM_DATA_SIZE     48
#define TRAILER_ALIGNMENT 40
#define TRAILER_OFFSET(x) \
   ((ATM_DATA_SIZE+TRAILER_ALIGNMENT-((x)%ATM_DATA_SIZE))%ATM_DATA_SIZE)

/* FIX: get rid of unnecessary includes */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/errno.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/syslog.h>
#include <sys/device.h>
#include <sys/malloc.h>

#include <vm/vm.h>
#include <vm/vm_param.h>
#include <vm/vm_extern.h>

extern vm_map_t kernel_map;

#include <net/if.h>
#include <net/if_types.h>
#include <net/if_dl.h>
#include <net/netisr.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>

#include <dev/pci/pcireg.h>
#include <dev/pci/pcivar.h>

#include <machine/bus.h>
#include <machine/intr.h>

#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_sonet.h>
#include <dev/pci/jetland/include/if_ijet.h>
#include <dev/pci/jetland/include/if_ijet_user.h>


/*
 * if we want profiling to work....redefine private
 */
#undef private
#define private 


#define DEV2UNIT(dev) (minor(dev))
#define IJETS2UNIT(ijets) ((ijets)->ijet_dev.dv_unit)
#define UNIT2IJETS(unit) (ijet_cd.cd_devs[unit])
#define BLI bufferLengthIndicator

#define jet_Vrp2VrIndex(unit, vrp) ((vr_t *) (vrp)-ll_vrBase[unit])
#define jet_Vrp2VrIndex0(unit, vrp) ((vr_t *) (vrp)-ll_vrPartition[unit])
#define jet_VrIndex2Vrp(unit, index) (&ll_vrBase[unit][index])

/*
 * FIX::
 *   change these to vm_offset_t??
 */
#define IJET_SRAM2MIRROR(vrp) ((vr_t *) (((vm_offset_t) (vrp)) - \
					 ijets->mirror2sramoffset))
#define IJET_MIRROR2SRAM(mvrp) ((vr_t *) (((vm_offset_t) (mvrp)) + \
					 ijets->mirror2sramoffset))

#define jet_MVrp2VrIndex(unit, mvrp) \
   jet_Vrp2VrIndex(unit, IJET_MIRROR2SRAM(mvrp))
#define jet_MVrp2VrIndex0(unit, mvrp) \
   jet_Vrp2VrIndex0(unit, IJET_MIRROR2SRAM(mvrp))
#define jet_VrIndex2MVrp(unit, index) \
   IJET_SRAM2MIRROR(jet_VrIndex2Vrp(unit, index))


/*
 * FIX:: make everything take ijets rather than unit.
 */
private int ijetprobe     (struct device *parent, void *match,
			   void *aux);
private void ijetattach    (struct device *parent, struct device *self,
			    void *aux);
private int  ijetintr      (void *ijets);

private bool ijetifinit    (int unit);
private void ijetifstop    (int unit);
int ijetifioctl(struct ifnet *ifp, u_long command, caddr_t data);
private int  ijetifoutput  (struct ifnet *ifp, struct mbuf *mbuf,
			    struct sockaddr *sa, struct rtentry *rt);
private int  ijetifwatchdog(short unit);

private bool ijetrcvinit   (int unit);
private void ijetrcv       (int unit, vr_t *vrp, bool mboxtail);

private void ijetIpvcTimer (void *arg);
private bool ijetxmtinit   (int unit);
private void ijetxmt       (int unit, struct mbuf *m, vcid_t VCid);
private void ijetxmtbuildvrs (ijet_softc_t *ijets, vcid_t vcid);
private void ijetxmtdone   (int unit, vr_t *vrp, bool mboxtail);
private void ijetcheckxmt  (ijet_softc_t *ijets);
private void ijetaddxmtvr  (ijet_softc_t *ijets, vr_t *vrp);
private void ijetxmtdoxmt(ijet_softc_t *ijets, vcid_t vcid);

private void ijetrcvwalker(int unit);
private void ijetxmtwalker(int unit);
private void ijetflist     (int unit, freelist_t freelist);
#ifdef IJET_CREDIT
private bool ijetcreditinit(ijet_softc_t *ijets);
private void ijetaddcreditvr(ijet_softc_t *ijets, vr_t *vrp);
private void ijetcreditwalker(int unit);
private void ijetupdatecredit(int unit);
private void ijetcreditmboxhandler(int unit);
private void ijetcreditflist(int unit, freelist_t freelist);
private vcid_t cellvpivci(ijet_credit_cell_t *cell);
#endif

public  int  ijetopen      (dev_t dev, int flag);
public  int  ijetclose     (dev_t dev, int flag, int mode, struct proc *p);
public  int  ijetioctl     (dev_t dev, u_long cmd, caddr_t data, int flag,
                                        struct proc *p);

private void ijetifstop    (int unit);
private void ijetreset     (int unit);
private bool ijetcheckcfg  (ijet_softc_t *ijets, ijet_ioctl_setup_t *setup);
public void bcopyvrp      (vr_t *vrsrc, vr_t *vrdst);
public void bzerovrp      (vr_t *vrp);
#ifdef IJET_INTELMERGESPACKETS
private int  findEndingVr  (int unit, vr_t *headp, vr_t *tailp,
			    int traileroffset, vr_t **nextpkt, int pdulen);
#endif
private void VrFreeRoutine (int unit, vr_t *vrp, int bli);
private void VrAttachRoutine(int unit);

extern int hz;                  /* No. of clock ticks per second */


/*
 * This is referenced by ioconf.c:  a file created during the config
 * process.  It is how our probe and attach routines get registered.
 * The standard open/close/ioctl routines are registed in the
 * conf.c file.
 */
public struct cfattach ijet_ca = {
  sizeof(ijet_softc_t), ijetprobe, ijetattach
};

public struct cfdriver ijet_cd = {
  NULL, "ijet", DV_IFNET
};

/*
 * Standard simple probe routine.   We should be called for every
 * PCI device on the bus.  We check the configuration ID to see
 * if it matches ours.  Return True on success.
 */
private int ijetprobe(struct device *parent, void *match, void *aux)
     begin(ijetprobe);
{
  struct pci_attach_args *pa = aux;

  /* Check that this PCI board is ours. */
  if (pa->pa_id != IJET_CONFIG_ID)
    return 0;

  return 1;
}
end(ijetprobe);


/*
 * ijetattach()
 *
 * Now that the board has been found, we can do some basic initialization.
 *
 * Map in the various memory segments, and initialize the interface
 * structure.  Notify the lower level that the board is present.
 */
void ijetattach(struct device *parent, struct device *self, void *aux)
     begin(ijetattach);
{
  ijet_softc_t *ijets = (void *) self;
  struct pci_attach_args *pa = aux;
  struct ifnet *ifp = &ijets->ijet_if;
  bus_chipset_tag_t bc = pa->pa_bc;
  pci_chipset_tag_t pc = pa->pa_pc;
  
  bus_mem_addr_t physaddr;
  bus_mem_size_t size;
  
  uint32 pcihack;
  
  pci_intr_handle_t intrhandle;
  const char *intrstr;
  
  int cacheable, loop;

  ijets->ijet_bc = bc;
  ijets->ijet_pc = pc;
  ijets->pcitag = pa->pa_tag;
    
  
  /*
   * PCIFIX: detects the chipset type and does the appropriate fixes.
   * Also changes the latency timer
   */
  {
      static bool chipsetFix = FALSE;      
      uint32 chipset, val;
      pcitag_t ptag;

      if (!chipsetFix) {
	  * (uint32 *) &ptag = 0x80000000;
	  chipset = pci_conf_read (ijets->ijet_pc, ptag, 0x0);
	  if ((chipset != 0x122d8086) || (chipset != 0x12508086)){
	      * (uint32 *) &ptag = 0x00f0c000;
	      chipset = pci_conf_read (ijets->ijet_pc, ptag, 0x0);
	      if (chipset != 0x4a38086)
		  warn ("\nUnknown PCI chipset ... skipping fixes\n");
	      else {
		  warn ("\nUsing Neptune chipset ... applying fixes\n");
		  pci_conf_write (ijets->ijet_pc, ptag, 0x54, 0x25000007);
		  * (uint32 *) &ptag = 0x00f0c200;
		  pci_conf_write (ijets->ijet_pc, ptag, 0x40, 0x700427);
	      }
	  }
	  else {
	      warn ("\nUsing Triton chipset ... applying fixes\n");
	  }
	  chipsetFix = TRUE;
      }

      /* Set the latency timer */
      val = pci_conf_read(ijets->ijet_pc, pa->pa_tag, 0xc);
      warn("\nchanging register 0xc from 0x%x", val);
      pci_conf_write(ijets->ijet_pc, pa->pa_tag, 0xc, val | 0xff00);
      val = pci_conf_read(ijets->ijet_pc, pa->pa_tag, 0xc);
      warn("to 0x%x, pa_tag = 0x%x\n", val, pa->pa_tag);
  }

  /*
   * Map the pci memory segments.
   * The 4 regions are local memory, registers, SONET, flash
   */
  if (pci_mem_find(pc, pa->pa_tag, IJET_PCI_SRAM, &physaddr,
		   &size, &cacheable)) {
    warn("couldn't find memory region for SRAM!\n");
    return;
  }
  cacheable = 1;
  printf("SRAM physaddr %p, size 0x%x, cacheable %d\n", (void *) physaddr,
	 (uint32) size, cacheable);
  if (bus_mem_map(pa->pa_bc, physaddr, size, cacheable,
		  (bus_mem_handle_t *) &ijets->sramBase)) {
    warn("couldn't map memory region for SRAM!\n");
    return;
  }
  
  if (pci_mem_find(pc, pa->pa_tag, IJET_PCI_ASIC, &physaddr,
		   &size, &cacheable)) {
    warn("couldn't find memory region for ASIC!\n");
    return;
  }
  cacheable = 0;
  printf("ASIC physaddr %p, size 0x%x, cacheable %d\n", (void *) physaddr,
	 (uint32) size, cacheable);
#ifdef alpha
  pcihack = 0x84000000+IJETS2UNIT(ijets)*0x2000;
  physaddr = pcihack;
  pci_conf_write(ijets->ijet_pc, ijets->pcitag, IJET_PCI_ASIC, pcihack);
#endif
  printf("ASIC physaddr %p, size 0x%x, cacheable %d\n", (void *) physaddr,
  	 (uint32) size, cacheable);
  
  if (bus_mem_map(pa->pa_bc, physaddr, size, cacheable,
		  (bus_mem_handle_t *) &ijets->asicBase)) {
    warn("couldn't map memory region for ASIC!\n");
    return;
  }
  
  if (pci_mem_find(pc, pa->pa_tag, IJET_PCI_SONET, &physaddr,
		   &size, &cacheable)) {
    warn("couldn't find memory region for SONET!\n");
    return;
  }
  cacheable = 0;
  printf("SONET physaddr %p, size 0x%x, cacheable %d\n", (void *) physaddr,
	 (uint32) size, cacheable);
#ifdef alpha
  pcihack += 0x1000;
  physaddr = pcihack;
  pci_conf_write(ijets->ijet_pc, ijets->pcitag, IJET_PCI_SONET, pcihack);
#endif
  printf("SONET physaddr %p, size 0x%x, cacheable %d\n", (void *) physaddr,
	 (uint32) size, cacheable);

  if (bus_mem_map(pa->pa_bc, physaddr, size, cacheable,
		  (bus_mem_handle_t *) &ijets->sonetBase)) {
    warn("couldn't map memory region for SONET!\n");
    return;
  }

  /*
   * Reset the board.
   */
  ijetreset(ijets->ijet_dev.dv_unit);

  /*
   * Now set up the interrupt mappings.
   */
  if (pci_intr_map(pc, pa->pa_intrtag, pa->pa_intrpin,
		   pa->pa_intrline, &intrhandle)) {
    printf("Couldn't map interrupt!\n");
    return;
  }

  intrstr = pci_intr_string(pc, intrhandle);
  ijets->ijet_ih = pci_intr_establish(pc, intrhandle, IPL_NET,
				      ijetintr, ijets);
  if (ijets->ijet_ih == NULL) {
    printf("Couldn't establish interrupt!");
    if (intrstr != NULL)
      printf(" at %s", intrstr);
    printf("\n");
    ret;
  }
  if (intrstr != NULL)
    warn("interrupting at %s\n", intrstr);

  bcopy(self->dv_xname, ifp->if_xname, IFNAMSIZ);
  ifp->if_softc = ijets;
  ifp->if_mtu =      IJET_ATM_MTU;
  ifp->if_type =     IFT_OTHER;
  ifp->if_addrlen =  sizeof(vcid_t);    /* ??USEFUL?? */
  ifp->if_hdrlen =   IJET_ATM_HDR;
#ifdef IJET_N48HACK
  ifp->if_hdrlen =   IJET_ATM_HDR+sizeof(uint32);
#endif
  ifp->if_timer =    0;
  ifp->if_reset =    0;
  ifp->if_output =   ijetifoutput;
  ifp->if_start =    0;
  ifp->if_ioctl =    (typeof (ifp->if_ioctl)) ijetifioctl;  /* HACK */
  ifp->if_watchdog = (void *) ijetifwatchdog;
  ifp->if_flags =   (IFF_NOTRAILERS | IFF_MULTICAST);

  /* attach the interface */
  if_attach(ifp);

  /*
   * Initialize Vince stuff
   */
  ijets->vince_flag = FALSE;
  ijets->vince_proc = 0;
  ijets->next_arp = -1;
  for (loop=0; loop<MAX_ARPS; loop++) ijets->pending_arps[loop] = 0;
  

  /*
   * Initialize address resolution table.
   *
   * Put all available entries on the free list.
   * Start hash table empty, users must fill via ioctl.
   */
  ijets->art_free = &ijets->art_pool[0];
  for(loop=0; loop<IJET_ART_SIZE-1; loop++)
    ijets->art_pool[loop].next = &ijets->art_pool[loop+1];
  ijets->art_pool[loop].next = NULL;
  
  for(loop=0; loop<IJET_ART_HASH; loop++)
    ijets->art[loop] = NULL;

  if (0) /* hang HACK */
    timeout(ijetIpvcTimer, ijets, 5*hz);  /* poll idle vcs every 5 sec */
  warn("device attached ok! PCI tag is 0x%x\n", pa->pa_tag);
  ret;
}
end(ijetattach);

/*
 * ijetintr()
 *
 * A short stub routine primarily for testing...we just pass the
 * interrupt on to the lower level.  We will eventually call the
 * lower level interrupt routine directly.
 */
int ijetintr(void *arg)
     begin(ijetintr);
{
  ijet_softc_t *ijets = (ijet_softc_t *) arg;
  static int entry = 0;
  if (++entry > 1)
    warn("ijetintr():  in handler multiple times!!!!!\n");
  ijet_InterruptHandler(IJETS2UNIT(ijets));
  entry--;
  ret 0;
}
end(ijetintr);

/*
 * ijetIpvcTimer()   
 *
 * Times out all IP SVCs according to RFC 1577.  Any IP SVC idle for more
 * than 15 minutes is removed from the hash table and the tx and rx tables.
 *
 */
private void ijetIpvcTimer(void *arg)
{ 
    int loop;
    int unit;
    int s = splhigh();
    ijet_art_ent_t *harteprev, *harte;
    ijet_softc_t *ijets = (void *) arg;
   
    unit = IJETS2UNIT(ijets);
    for (loop = 0; loop < IJET_ART_HASH; loop++) {
        harte = ijets->art[loop];
        harteprev = NULL;
        while (harte != NULL) {
            if (harte->flag & IP_SVC) {
                harte->idle += 5; /* increment idle time by 5 sec */
                if (harte->idle > LLC_VC_TIMEOUT) {
                    char ip[60];
                    warn ("Timed out VC for 0x%x\n", harte->ipaddr);
                    ll_CloseRx(unit, harte->rx_VCid);
                    ll_CloseTx(unit, harte->tx_VCid);
                    sprintf (ip, "ijetCloseIpVc %d %d\n", harte->tx_VCid,
                                        harte->rx_VCid);  
                    warn ("Sending command %s\n", ip);
                    skip_jetmsg_rx_interface(ip, strlen(ip));
                    if (harteprev == NULL) {
                        ijets->art[loop] = harte->next;
                        harte->next = ijets->art_free;
                        ijets->art_free = harte;
                        harte = ijets->art[loop];
                    }
                    else {
                        harteprev->next = harte->next;
                        harte->next = ijets->art_free;
                        ijets->art_free = harte;
                        harte = harteprev->next;
                    }
                }
                else {
                    harteprev = harte;
                    harte = harte->next;
                }
            }
            else {
                harteprev = harte;
                harte = harte->next;
            }
        }
    }
    timeout(ijetIpvcTimer, ijets, 5*hz); /* scheduler anothe timer interrupt */
                                         /* after 5 seconds */
    splx(s);
}



/*
 * ijetifinit()
 *
 * I don't know when this should normally get called.  For now, we're
 * going to call it when we are ifconfig'd up.  Return success/failure.
 *
 * FIX:: We do not have a way to reset/reinitialize/stop....well, not
 *       more than once.
 */
bool ijetifinit(int unit)
     begin(ijetifinit);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  vr_t *vrp;
  struct ifnet *ifp = &ijets->ijet_if;
  int i;

  if ((ijets->flags&IJET_FL_UCODEIS) == 0) {
    warn("ijet%d: ijetifinit(): No ucode downloaded\n", unit);
    ret FALSE;
  }
  if ((ijets->flags&IJET_FL_CFGINIT) == 0) {
    warn("ijet%d: ijetifinit(): No setup paramaters configured!\n", unit);
    ret FALSE;
  }

  /*
   * We need to know the maximum number of VRs that we'll use...
   * plus a few extra for slop.
   * ASK:  how important are the extra VRs??
   */
  ijets->total_vrs = ijets->xmt_VRs;
  for (i=0; i<IJET_NUM_FREELISTS; i++)
    ijets->total_vrs += ijets->rcv_cnt[i];
  ijets->total_vrs += IJET_EXTRA_VRS;

#ifdef IJET_CREDIT
  ijets->total_vrs += ijets->credit_VRs;
#endif  
  {
      ll_error_t error;
      /* kosak HACK the +1024 is for my harp stuff */
      if ((error = ll_Init(unit, ijets->rcv_VCids, ijets->xmt_VCids,
                           ijets->total_vrs + 1024,
                           IJET_STATIC_TABLE_SIZE, IJET_DYNO_LISTS,
                           IJET_DYNO_ENTRIES, IJET_RXVC_EXTRACT,
                           ijets->ucode, ijets->ucodesize)) < 0) {
          ijetreset(unit);
          warn ("Init error!  code is %d\n", error);
          panic ("init error");  /* kosak HACK */
          ret FALSE;
      }
  }
  
  if (!ijetxmtinit(unit) || !ijetrcvinit(unit)
#ifdef IJET_CREDIT      
      || !ijetcreditinit(ijets)
#endif
      ) {
    ijetreset(unit);
    ret FALSE;
  }
  
  /* create something to handle our mailboxes */
  vrp = ijets->rcv_mbox_vrp;
  bzerovrp(vrp);
  ijets->rcv_mbox_free = TRUE;
  ijets->rcv_mbox = ll_AllocMailbox(unit, NULL, ijetrcvwalker, vrp);

  vrp = ijets->xmt_mbox_vrp;
  bzerovrp(vrp);
  ijets->xmt_mbox_free = TRUE;
  ijets->xmt_mbox = ll_AllocMailbox(unit, ijetxmtwalker,
				    ijetxmtwalker, vrp);

#ifdef IJET_CREDIT  
  vrp = ijets->credit_mbox_vrp;
  bzerovrp(vrp);
  ijets->credit_mbox_free = TRUE;
  ijets->credit_mbox = ll_AllocMailbox(unit, NULL, NULL, vrp);
#endif
  
  ifp->if_flags |= IFF_RUNNING;	        /* CHECK:: correct place for this? */
  ret TRUE;
}
end(ijetifinit);

int ijetifioctl(struct ifnet *ifp, u_long command, caddr_t data)
     begin(ijetifioctl);
{
  ijet_softc_t *ijets = (ijet_softc_t *) (ifp->if_softc);
  int unit = IJETS2UNIT(ijets);
  struct ifaddr *ifa = (struct ifaddr *)data;
  int s, error=0;
  
  s = splhigh();
  
  switch (command) {
  case SIOCSIFADDR:
    ifp->if_flags |= IFF_UP;
    switch (ifa->ifa_addr->sa_family) {
    case AF_INET:
      debug("calling ijetifinit() from AF_INET\n");
      ijetifinit(unit);
      break;
    }
    break;
  case SIOCSIFFLAGS:
    if ((ifp->if_flags & IFF_UP) == 0 &&
	(ifp->if_flags & IFF_RUNNING) != 0) {
      /*
       * If interface is marked down and it is running, then
       * stop it.
       */
      ijetifstop(unit);
      ifp->if_flags &= ~IFF_RUNNING;
    } else if ((ifp->if_flags & IFF_UP) != 0 &&
	       (ifp->if_flags & IFF_RUNNING) == 0) {
      /*
       * If interface is marked up and it is stopped, then
       * start it.
       */
      debug("calling ijetifinit() because marked up and is stopped\n");
      ijetifinit(unit);
    } else {
      /*
       * Reset the interface to pick up changes in any other
       * flags that affect hardware registers.  None that I
       * am aware of at this time.
       */
      warn("ifp->if_flags = 0x%x\n", ifp->if_flags);
      /*      ijetifstop(unit);
	      ijetifinit(unit); */
    }
    break;

  default: {
    warn ("ioctl 0x%x not implemented\n", command);
    error = EINVAL;
  } break;

  }

  (void) splx(s);
  ret error;
}
end(ijetifioctl);

int ijetifwatchdog(short unit)
     begin(ijetifwatchdog);
{
  ret 0;
}
end(ijetifwatchdog);

int  ijetifoutput(struct ifnet *ifp, struct mbuf *m,
		  struct sockaddr *dst, struct rtentry *rt)
     begin(ijetifoutput);
{
  ijet_softc_t *ijets = (ijet_softc_t *) (ifp->if_softc);
  int unit = IJETS2UNIT(ijets);
  int s, error=0;
  uint32 ip_dst, vcid=0; /* kosak HACK avoid compiler warning */
  ijet_art_ent_t *harte;
  uint16 type;
  struct llc *llc;
  int loop;
  
  if ((ifp->if_flags & (IFF_UP|IFF_RUNNING)) != (IFF_UP|IFF_RUNNING)) {
    error = ENETDOWN;
    goto bad;
  }

#ifdef IJET_LOOPBACK  
  {
    struct ifqueue *inq;

    s = splhigh();
    schednetisr(NETISR_IP);
    inq = &ipintrq;

    if (IF_QFULL(inq)) {
      warn("IF_QFULL!!\n");
      IF_DROP(inq);		/* CHECK:: what does IF_DROP() do??? */
      m_freem(m);
      ijets->ijet_if.if_ierrors++;
    } else {
      IF_ENQUEUE(inq, m);
      ijets->ijet_if.if_ipackets++;
    }

    splx(s);
    ret error;
  }
#endif

  switch (dst->sa_family) {
  case AF_INET:
    /*
     * Translate the internet address to a VCid
     */
    ip_dst = ((struct sockaddr_in *)dst)->sin_addr.s_addr;
    harte = ijets->art[(ip_dst >> 24) & (IJET_ART_HASH - 1)];
    while(harte != NULL){
      if(harte->ipaddr == ip_dst){
	/*
	 * Found entry in table for this destination.
	 */
	vcid = harte->tx_VCid;
        harte->idle = 0;
	break;
      }
      harte = harte->next;
    }
    if(harte == NULL){
      /*
       * No entry in table for this destination.
       */
      if (ijets->vince_flag) {
         int found = 0;
         char ip[60];

         for (loop=0; loop<MAX_ARPS; loop++)
           if (ijets->pending_arps[loop] == ip_dst) found = 1;
         if (found || (ijets->next_arp == MAX_ARPS - 1)) goto bad;
         ijets->next_arp++;
         ijets->pending_arps[ijets->next_arp] = ip_dst;
         debug("ijetifoutput: asking vince to establish SVC for %x\n",
                        ip_dst);
         sprintf (ip, "ijetGetIpVc ip:%d.%d.%d.%d\n",
                ip_dst & 255, (ip_dst >> 8) & 255,
                (ip_dst >> 16) & 255, ip_dst >> 24);
          warn ("Sending command %s\n", ip);
          skip_jetmsg_rx_interface (ip, strlen(ip));
         /*
          * In the meantime, we have queue the packet somewhere.  For now
          * I will just drop it.
          */
         goto bad;
      }

      else {
        debug("ijetifoutput: no entry in our table for %x\n", ip_dst);
        error = EHOSTUNREACH;
        goto bad;
      }
    }
    type = ETHERTYPE_IP;
    break;
  default:
    /*
     * Nothing else is currently supported.
     */
    warn("ijet%d:: ijetifoutput: can't support af%d\n", unit,
	   dst->sa_family);
    error = EAFNOSUPPORT;
    goto bad;
  };

  /*
   * place snap
   */
  M_PREPEND(m, sizeof(struct llc), M_DONTWAIT);
  if (m == NULL) {
      error = ENOBUFS;
      goto bad;
  };
  
  llc = (struct llc *) (mtod(m, caddr_t));
  llc->llc_dsap = LLC_SNAP_LSAP;
  llc->llc_ssap = LLC_SNAP_LSAP;
  llc->llc_un.type_snap.control = LLC_UI;
  llc->llc_un.type_snap.org_code[0] = 0;
  llc->llc_un.type_snap.org_code[1] = 0;
  llc->llc_un.type_snap.org_code[2] = 0;
  llc->llc_un.type_snap.ether_type = htons((u_short)type);
  
#ifdef IJET_N48HACK
  {
    struct mbuf *mtmp = m;
    int len = 0;
    while (mtmp) {
      len += mtmp->m_len;
      mtmp = mtmp->m_next;
    }

    if ((len%48) != 40) {
      int extra = 40-(len%48);
      if (extra<4) /* negative or too small to hold header */
        extra += 48;
      M_PREPEND(m, extra, M_DONTWAIT);
      if (m == NULL) {
        error = ENOBUFS;
        goto bad;
      };
      *(mtod(m, uint32*)) = 0xfacade00 | extra;
    }
  }
#endif

  /*
   * Queue message on interface, and start output if interface
   * not yet active.
   */

  if (ijets->xmt_mbuf_pool == NULL) {
    error = ENOBUFS;
    goto bad;
  }

  s = splhigh();
  ijetxmt(unit, m, vcid);
  splx(s);
  
  ret error;
    
 bad:
  s = splhigh();
  if (m) {
    m_freem(m);
    /*
     * Be agressive w/ receive buffers.
     */

#ifdef IJET_LOSES_INTERRUPTS
    ijetrcvwalker(unit);		/* HACK:: */
#ifdef IJET_CREDIT      
    ijetupdatecredit(unit);	        /* HACK:: */
#endif      
    ijetxmtwalker(unit);		/* HACK:: */
#endif
    VrAttachRoutine(unit);
  }
  
  ijets->ijet_if.if_oerrors++;

  /* splx(s); kosak hang hack */
  ret error;
}
end(ijetifoutput);

bool ijetrcvinit(int unit)
     begin(ijetrcvinit);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  vr_t **vr_table;
  int i, j, num_vcids;
  ijet_rcv_vc_t *rcv_vcs;
  vm_offset_t *vabase;
  
  /*
   * we need to allocate two freelist vr pools....the mailbox will
   * be created by the init routine.  These pages need to be wired
   * down.  The way this gets done is highly OS dependent.
   * kmem_alloc() locks the pages for us.
   */

  /* Create a table for physical to virtual mappings */
  if ((vabase=(vm_offset_t *) malloc(ijets->total_vrs*
				     sizeof(vm_offset_t),
				     M_DEVBUF, M_NOWAIT)) == NULL) {
    warn("ijetrcvinit(): malloc failed for phys-virt mappings\n");
    ret FALSE;
  }
  ijets->ptov = vabase;

  /*
   * Make them NULL to begin with
   */
  bzero(vabase, ijets->total_vrs*sizeof(vm_offset_t));

  /* set up the free lists */
  for (i=0; i<IJET_NUM_FREELISTS; i++) {
    int num_vrs = ijets->rcv_cnt[i];
    
    if ((ijets->rcv_flist[i]=ll_AllocFreelist(unit, NULL, ijetflist)) < 0) {
      warn("ijetrcvinit(): failed to allocate freelist!\n");
      ret FALSE;
    }
    
    /* Allocate a temporary table to store the VR pointers. */
    if ((vr_table= (vr_t **) malloc(num_vrs*sizeof(vr_t *),
				    M_TEMP, M_NOWAIT)) == NULL) {
      warn("ijetrcvinit(): malloc failed for temporary vr table!\n");
      ret FALSE;
    }
    
    /* Allocate the VRs */
    if (ll_AllocateVrs(unit, num_vrs, vr_table) != num_vrs) {
      warn("ijetrcvinit(): couldn't allocate %d VRs!\n", num_vrs);
      free(vr_table, M_TEMP);
      ret FALSE;
    }
    
    /* Put them on the freelist */
    for (j=0; j<num_vrs; j++)
      if (i==0 && j== 0) {
	/*
	 * Before we attach to the freelist we're going to "borrow"
	 * one of the VRs to use for our initial mbox entry
	 */
	ijets->rcv_mbox_vrp = vr_table[0];
	bzerovrp(ijets->rcv_mbox_vrp);
      }
      else
	VrFreeRoutine(unit, IJET_SRAM2MIRROR(vr_table[j]), i);
    
    free(vr_table, M_TEMP);   /* clean up */
  }
  
  /*
   * That should take care of the freelist initialization.
   * now we need to allocate some structures for rcv pdu
   * reassembly, since we will end up taking things out of
   * the mbox prior to pdu completion for some VCs.
   */
  
  num_vcids = ijets->rcv_VCids;
  if ((rcv_vcs=(ijet_rcv_vc_t *) malloc(sizeof(ijet_rcv_vc_t)*num_vcids,
					    M_DEVBUF, M_NOWAIT)) == NULL) {
    warn("ijetrcvinit(): malloc failed for vcidlist!\n");
    ret FALSE;
  }
  
  /*
   * Make all the vr chains empty.
   */
  ijets->rcvvc = rcv_vcs;
  for (i=0; i<num_vcids; i++)
    rcv_vcs[i].vr_chain_head = rcv_vcs[i].vr_chain_tail = NULL;

  /*
   * OK...allocate whatever VRs we can
   */
  VrAttachRoutine(unit);
  
  ret TRUE;
}
end(ijetrcvinit);

/*
 * ijetrcv()
 *
 * this routine gets called as a result of the interrupt handler
 * handing us a notification of pkt arrival.  Basically just transfers
 * a packet up to the "if" layer.
 *
 * We need to store our VRs on a per VC basis until we get end
 * of packet.
 */
void ijetrcv(int unit, vr_t *mvrp, bool mboxtail)
     begin(ijetrcv);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  ijet_rcv_vc_t *rcv_vc;
  vr_t *headp, *nextp, *pktendvrp, *nextpktvrp = NULL;
  vcid_t vcid;
  int totlen, pdulen, nextoffset=0, size;
  vm_offset_t base;
  bool pdu_end; 
  struct ifqueue *inq;
  struct mbuf *m, *top, **mp;
  bool merged = FALSE;
  int n48hack = 0;
  uint16 snapEtherType;

  /*
   * Grab the fields out of the vrp.  if accesses into sram
   * are slow we should grab 32 bit chunks at a time;  assuming
   * 32 bit bus accesses.
   */
  vcid = mvrp->message.vcid;
  rcv_vc = &ijets->rcvvc[vcid];
  pdu_end = mvrp->message.endOfPdu;
  
  /*
   * We may be receiving from multiple VC's at the
   * same time, so we need to have a way to link VRs on a
   * per VC basis until the packet is complete.
   *
   * For now, the VR chains sit in an array indexed by VCid.
   */
  if (rcv_vc->vr_chain_head == NULL) {
    rcv_vc->vr_chain_head = rcv_vc->vr_chain_tail = mvrp;
  }
  else {
    rcv_vc->vr_chain_tail->message.nextIndex = jet_MVrp2VrIndex(unit, mvrp);
    rcv_vc->vr_chain_tail = mvrp;
  }
  
  if (!pdu_end)
    ret;

  while (1) {
    /*
     * We need to find pkt end since it may not be the vrp we just
     * received.
     */
    pktendvrp = rcv_vc->vr_chain_head;
    size = MCLBYTES-pktendvrp->message.remain;
    while (!(pktendvrp->message.endOfPdu)) {
      pktendvrp = jet_VrIndex2MVrp(unit, pktendvrp->message.nextIndex);
      size += MCLBYTES-pktendvrp->message.remain;
    }

#ifdef IJET_CELL_COUNTS
    /* FIX::
     *   no magic numbers
     */
    rcv_vc->cellcount += ((size+8)+47)/48;
#endif
    
#ifndef IJET_INTELMERGESPACKETS

    /*
     * Check for a CRC error, dropping the packet if found...
     * no reason to do anything else.
     */
    if (pktendvrp->message.crcError) {
      warn("received pkt w/ crcError, vr index = %d\n",
	     jet_MVrp2VrIndex(unit, pktendvrp));
      ijets->ijet_if.if_ierrors++;
      goto rcv_drop;
    }
#endif IJET_INTELMERGESPACKETS
    
    headp = rcv_vc->vr_chain_head;
    
    /* FIX:: if the adaptor worked this would be headp->message.BLI */
    base = ijets->ptov[jet_MVrp2VrIndex0(unit, headp)];
    
    /*
     * If this is not the first time through, we may have an offset
     * to contend with.
     */
    if (merged) {
      base     += nextoffset;
      size     -= nextoffset;
    }
    else {
      nextoffset = 0;
      nextpktvrp = NULL;
    }
    
#ifdef IJET_N48HACK
    {
      uint32 firstword = *(uint32*)base;
      if ((firstword & 0xffffff00) == 0xfacade00) {
        int extra = firstword & 0xff;
        base   += extra;
        n48hack = extra;
      } else
        n48hack = 0;
    }
#endif

    /*
     * NOTE:: FIX:: we should check that we have a valid
     * snap header, especially since we can't trust the
     * pdulen in merged packets.
     */
    /*JETMSG*/
    debug ("Checking LLC header\n");
    {
      struct llc *llc = (struct llc *) base;
      {
        debug ("dsap 0x%x ssap 0x%x control 0x%x orgcode 0x%x 0x%x 0x%x "
               "ether_type 0x%x\n",
               llc->llc_dsap, llc->llc_ssap, llc->llc_un.type_snap.control,
               llc->llc_un.type_snap.org_code[0],
               llc->llc_un.type_snap.org_code[1],
               llc->llc_un.type_snap.org_code[2],
               llc->llc_un.type_snap.ether_type);
      }
          
      if ((llc->llc_dsap == LLC_SNAP_LSAP) &&
          (llc->llc_ssap == LLC_SNAP_LSAP) &&
          (llc->llc_un.type_snap.control == LLC_UI) &&
          (llc->llc_un.type_snap.org_code[0] == 0) &&
          (llc->llc_un.type_snap.org_code[1] == 0) &&
          (llc->llc_un.type_snap.org_code[2] == 0)) {
        snapEtherType = ntohs(llc->llc_un.type_snap.ether_type);
        debug ("valid LLC header, type=%d\n", snapEtherType);
      } else {
        debug ("BAD LLC header\n");
        goto rcv_drop; /* is this right? */
      }
    }
      
    base += sizeof(struct llc);

#ifdef IJET_INTELMERGESPACKETS
    if (pktendvrp->message.crcError) {
      int traileroffset;
      /*
       * We're going to try and retrieve the first packet anyway.
       */

      debug("ijetrcv(): received pkt w/ crcError, trying anyway\n");
      pdulen = ntohs(* (unsigned short *) (base+sizeof(short)));

      totlen = pdulen+sizeof(struct llc);
      merged = TRUE;

      if (totlen > size) {
	warn("dropping pkt because totlen %d > rcv'd bytes! %d\n",
	       totlen, size);

	ijets->ijet_if.if_ierrors++;
	merged = FALSE;
	goto rcv_drop;
      }

      /*
       * TRAILEROFFSET is always 40 since the problem occurs w/ pkts
       * of 48*n
       */
      /*      traileroffset = totlen+TRAILER_OFFSET(totlen); */
      traileroffset = totlen+40;

      /*
       * If there was a previous merged packet, we may not be on a
       * VR boundary.
       */
      traileroffset += nextoffset;

      if ((totlen % 48) ||
	  ((nextoffset=findEndingVr(unit, headp, pktendvrp, 
				    traileroffset, &nextpktvrp,
				    totlen))) < 0) {
	merged = FALSE;
	if (totlen != pktendvrp->message.pduLength) {
	  /*
	   * Didn't find a matching trailer, and the pdulen
	   * is not that of the vr w/ endOfPdu set.
	   */
	  warn("dropping pkt because findEndingVr failed!\n");
          warn("totlen = %d, pktendvrp->pdulen = %d\n",
                 totlen, pktendvrp->message.pduLength);
	  ijets->ijet_if.if_ierrors++;
	  goto rcv_drop;
	}
	else {
          debug("No matching trailer, but pdulen %d = iplen!\n", pdulen);
	  /*
	   * Didn't find the matching trailer, but our length is that
	   * of the VR w/ endOfPdu set.
	   *
	   * Assume that this is the last pkt.  This may not be
	   * true...but there is no valid trailer anyway.
	   *
	   * Treat it as if it was an ok packet.
	   */
	}
      }
      else
        debug("found matching trailer...the world is great!\n");
    }
    else
#endif IJET_INTELMERGESPACKETS
      {
	pdulen = pktendvrp->message.pduLength-sizeof(struct llc)-n48hack;
	merged = FALSE;
      }
    
    MGETHDR(m, M_DONTWAIT, MT_DATA);
    if (m == NULL) {            /* hmmm...no mbuf headers */
      warn ("MGETHDR failed\n");
      ijets->ijet_if.if_ierrors++;
      goto rcv_drop;
    }
    m->m_pkthdr.rcvif = &ijets->ijet_if;
    
    top = NULL;
    mp = &top;
    m->m_pkthdr.len = pdulen;

    /*
     * Note the following loop does *not* use endOfPdu, because we
     * may not have the bit set due to adaptor bug.  We'll trust
     * the length.
     */
    totlen = pdulen;
    while (totlen > 0) {
      if (top) {
	/*
	 * not the first time through the loop...so grab another
	 * mbuf
	 */
	MGET(m, M_DONTWAIT, MT_DATA);
	if (m == NULL) {
	  m_freem(top);
	  warn("MGET FAILED!\n");
          ijets->ijet_if.if_ierrors++;
          goto rcv_drop;
	}
      }

      /*
       * We dma'd directly into an mbuf...so be clever.
       * basically do the same things that MCLGET does except
       * we do not allocate another buffer, just up the
       * reference count.
       *
       * NOTE:: if we were certain we wouldn't get multiple packets
       * in the same VR, we could forget about updating the
       * refcnt and just pass it up the IP stack.  
       */
      m->m_ext.ext_buf = (caddr_t)
	ijets->ptov[jet_MVrp2VrIndex0(unit, headp)];
      m->m_data = (caddr_t) base;
      m->m_ext.ext_size = MCLBYTES;
      m->m_flags |= M_EXT;
      m->m_len = min(totlen, MCLBYTES-(m->m_data-m->m_ext.ext_buf));
      ++mclrefcnt[mtocl(m->m_ext.ext_buf)];
      
      *mp = m;
      mp = &m->m_next;
      
      totlen -= m->m_len;

      if (totlen)
	if (headp != mvrp) {
	  headp = jet_VrIndex2MVrp(unit, headp->message.nextIndex);
          base = ijets->ptov[jet_MVrp2VrIndex0(unit, headp)];
        }
	else {
	  warn("ijetrcv: tried to read beyond last VR!\n");
	  m_freem(top);
          ijets->ijet_if.if_ierrors++;
	  goto rcv_drop;
	}
    }
    
    debug("ijetrcv: pkt of length %d arrived on vcid %d\n",
          top->m_pkthdr.len, vcid);
    debug("ijetrcv: and was passed up the IP stack!\n");
    /*
     * Hand the packet to the network module
     */

    if (snapEtherType == ETHERTYPE_IP) {
      debug ("it's an IP thing, so go the usual way\n");
      schednetisr(NETISR_IP);
      inq = &ipintrq;
      
      if (IF_QFULL(inq)) {
        IF_DROP(inq);		/* CHECK:: what does IF_DROP() do??? */
        m_freem(top);
        warn("IF_QFULL!!\n");
        ijets->ijet_if.if_ierrors++;
      } else {
        IF_ENQUEUE(inq, top);
        ijets->ijet_if.if_ipackets++;
      }
    } else {
      debug ("it's my thing, so go my way.  vpivci=%d?\n", vcid);
      /*HACK: vcid should actually be "vpivci", but for receive they're
        often the same, if the phase of the moon is right.  Fix later */
      ip_jetmsg_rx_interface (unit, top, vcid, snapEtherType);
    }
    
  rcv_drop:
    /*
     * Now walk through and free the VRs on the chain.  We have
     * to free the cluster mbuf too since we don't yet support
     * external free calls.
     */
    headp = rcv_vc->vr_chain_head;
    while (1) {

      /*
       * Don't free the VR if it's where the next merged pkt starts
       */
      if (merged && (headp == nextpktvrp))
	break;

      /*
       * Don't free it if it is end of PDU
       */
      if (headp->message.endOfPdu)
	break;
      /*
       * We have to stuff them on one at a time, since they may be of
       * differing sizes... we *might* be able to stuff the first
       * one seperately and the rest *should* be the same size if we're
       * doing header/data split.
       */
      nextp = jet_VrIndex2MVrp(unit, headp->message.nextIndex);
      
      /*
       * Free the VR and associated mbuf
       */
      VrFreeRoutine(unit, headp, 0);
      headp = nextp;
    }

    /*
     * We're done if we don't have merged packets and this is vr that
     * caused this routine to be called.
     */
    if ((!merged) && (headp == mvrp))
      break;

    rcv_vc->vr_chain_head = headp;
      
    if ((!merged) || (headp != nextpktvrp)) {
      if (!merged)
	warn("hmm...adjusting vr chain and we're not merged!\n");
      /*
       * Hmmm...still more stuff on the chain, prepare to go back through
       * the loop again, handling the next packet
       */
      
      /* adjust the head of chain */
      rcv_vc->vr_chain_head = jet_VrIndex2MVrp(unit, headp->message.nextIndex);
      VrFreeRoutine(unit, headp, 0);
    }

    /*
     * If there is another merged packet, we have to be at the correct
     * vr now.  If not, we'll just blow the entire chain away.
     */
    if (merged && (rcv_vc->vr_chain_head != nextpktvrp)) {
      warn("Merged packet, but something doesn't add up!\n");
      merged = FALSE;
      goto rcv_drop;
    }
  }

  /*
   * Here, we're done w/ the entire chain...nothing is left.
   */
  if (mboxtail) {
    /*
     * However, we can't free the last vrp if we still need it in
     * the mailbox.
     */
    ijets->rcv_mbox_free = TRUE;
  }
  else {
    /*
     * OK...we can free it, since there is still more in our
     * mbox to work on.
     */

    /* FIX:: should be flist headp->message.BLI */
    VrFreeRoutine(unit, headp, 0);
  }
  
  /* in any case, rcv_vc is now empty ....well it better be */
  rcv_vc->vr_chain_head = rcv_vc->vr_chain_tail = NULL;
}
end(ijetrcv);

/*
 * ijetxmtinit()
 *
 * set up the necessary buffers and vr pools for this device
 */
bool ijetxmtinit(int unit)
     begin(ijetxmtinit);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  vr_t **vr_table;
  int num_vrs, num_vcids, i, num_mbufs;
  ijet_xmt_vc_t *perVC;
  ijet_mbuf_t *mbuf_pool;
  char *sram;

  /*
   * Allocate some space to mirror SRAM.
   * NOTE::
   *   We should just mirror the VR space.  We could wire
   *   this space down, but then grabbing contiguous space
   *   becomes a problem.  For now, we'll just malloc the space.
   */

  if ((sram=malloc(IJET_SRAM_SIZE, M_DEVBUF, M_NOWAIT)) == NULL) {
    warn("ijetxmtinit(): couldn't malloc sram mirror!\n");
    ret FALSE;
  }
  ijets->sram = (vr_t *) sram;
  ijets->mirror2sramoffset = (vm_offset_t) ll_vrBase[unit] -
	 (vm_offset_t) sram;
  warn("sram mirror from 0x%x - 0x%x\n", (vm_offset_t) sram,
	 (vm_offset_t) sram+IJET_SRAM_SIZE);
  warn("sram at 0x%x - 0x%x\n", (vm_offset_t) ll_vrBase[unit],
	 (vm_offset_t) ll_vrBase[unit] + IJET_SRAM_SIZE);
  bzero(sram, IJET_SRAM_SIZE);
  
  /*
   * We need some number of vr pointers, this can either
   * be done statically, or we can allow our user agent to
   * set this for us.  in either case, we'll assume that our 
   * interface structure has this number.
   */

  num_vrs = ijets->xmt_VRs;
  debug("ijetxmtinit(): getting %d xmt vrs", num_vrs);
  if ((vr_table = malloc(sizeof(vr_t *)*num_vrs, M_TEMP, M_NOWAIT)) == NULL) {
    warn ("couldn't get memory for vr_table for %d vrs!\n", num_vrs);
    return FALSE;
  }
  if (ll_AllocateVrs(unit, num_vrs, vr_table) != num_vrs) {
    warn("ijetxmtinit(): couldn't allocate %d VRs!\n", num_vrs);
    free(vr_table, M_TEMP);
    ret FALSE;
  }

  cow1();
  /*
   * Link all the VRs together and put them on the freelist.
   */
  for (i=0; i<num_vrs; i++)
    if (i==0 || i==num_vrs-1)
      IJET_SRAM2MIRROR(vr_table[i])->vr.nextIndex = IJET_NO_NEXT_VR;
    else
      IJET_SRAM2MIRROR(vr_table[i])->vr.nextIndex =
	jet_Vrp2VrIndex(unit, vr_table[i+1]);
  cow2();

  /*
   * steal one for the mailbox
   */
  ijets->xmt_mbox_vrp = vr_table[0];
  ijets->xmt_freeVR_head = IJET_SRAM2MIRROR(vr_table[1]);
  ijets->xmt_freeVR_tail = IJET_SRAM2MIRROR(vr_table[num_vrs-1]);
  ijets->xmt_VR_freecnt = num_vrs-1;
  free(vr_table, M_TEMP);
  cow3();
  
  num_vcids = ijets->xmt_VCids;
  if ((perVC = (ijet_xmt_vc_t *) malloc(num_vcids*sizeof(ijet_xmt_vc_t),
                                        M_DEVBUF, M_DONTWAIT)) == NULL) {
    warn("ijet%d: ijetxmtinit():: Couldn't allocate per VC memory!\n",
	   unit);
    ret FALSE;
  }

  /*
   * Make everything NULL to start with.
   */
  bzero(perVC, num_vcids*sizeof(ijet_xmt_vc_t));
  ijets->xmtvc = perVC;

  for (i=0; i<num_vcids; i++)
    ijets->xmtvc[i].credit = 0xff;
  
  /*
   * Allocate a pool of ijet_mbuf_t structs.  There should be at least
   * as many as we will have packets outstanding.  Link them together
   * and save as pool.  Initialize pool_cnt to num created.
   */
  num_mbufs = ijets->xmt_mbufs;
  if ((mbuf_pool = (ijet_mbuf_t *) malloc(num_mbufs*sizeof(ijet_mbuf_t),
					  M_DEVBUF, M_DONTWAIT)) == NULL) {
    warn("ijet%d: ijetxmtinit(): Couldn't allocate xmt mbuf pool!\n",
	   unit);
    ret FALSE;
  }

  bzero(mbuf_pool, num_mbufs*sizeof(ijet_mbuf_t));
  /*
   * Link all these together.
   */
  for (i=0; i<num_mbufs; i++)
    if (i == num_mbufs-1)
      mbuf_pool[i].next = NULL;
    else
      mbuf_pool[i].next = &mbuf_pool[i+1];

  ijets->xmt_mbuf_pool = mbuf_pool;
  ijets->xmt_mbuf_base = mbuf_pool;
 
  /* kosak moved the vpivci2vcid stuff here because he wants it! */
         
  /*
   * Create a table for vpivci to vcid mappings.
   */
         
  {
    uint32 *region;
  
    if ((region=malloc(ijets->maxvpivci*sizeof(uint32), 
                       M_DEVBUF, M_NOWAIT)) == NULL) {
      warn("ijetcreditinit(): malloc failed for vcid mappings!\n");
      ret FALSE;
    }  
    ijets->vpivci2vcid = region;
    bzero(region, ijets->maxvpivci*sizeof(uint32));
  }
  

  ret TRUE;
}
end(ijetxmtinit);

#ifdef IJET_CREDIT
bool ijetcreditinit(ijet_softc_t *ijets)
     begin(ijetcreditinit);
{
  int unit = IJETS2UNIT(ijets);
  int num_vrs, i, size, vrsperpage, numpages, index0;
  vr_t **vr_table;
  vm_offset_t base;

  /*
   * Create a freelist for credit VRs.
   */
  if ((ijets->credit_flist=ll_AllocFreelist(unit, ijetcreditmboxhandler,
					    ijetcreditflist)) < 0) {
    warn("ijetcreditinit(): failed to allocate freelist!\n");
    ret FALSE;
  }

  num_vrs = ijets->credit_VRs;;
  /* Allocate a temporary table to store the VR pointers. */
  if ((vr_table= (vr_t **) malloc(num_vrs*sizeof(vr_t *),
				  M_TEMP, M_NOWAIT)) == NULL) {
    warn("ijetcreditinit(): malloc failed for temporary vr table!\n");
    ret FALSE;
  }
    
  /* Allocate the VRs */
  if (ll_AllocateVrs(unit, num_vrs, vr_table) != num_vrs) {
    warn("ijetcreditinit(): couldn't allocate %d VRs!\n", num_vrs);
    free(vr_table, M_TEMP);
    ret FALSE;
  }
  warn("creditinit: first vr is 0x%x, last 0x%x\n",
	 (uint32) vr_table[0], (uint32) vr_table[num_vrs-1]);

  /*
   * HACK:: FIX::
   * this should be user settable
   */
  ijets->creditinterval = num_vrs>>2;	/* must be at least 2 */
  ijets->creditmarker = 0;
  
  /*
   * Allocate some space for them to point to.  Use kmem_alloc so it is
   * wired down.
   */
  vrsperpage = NBPG/IJET_CREDIT_VR_SIZE;
  numpages = (num_vrs+vrsperpage-1)/vrsperpage;
  size = numpages*NBPG;

  if ((base=kmem_alloc(kernel_map, size)) <= 0) {
    warn("ijetcreditinit(): couldn't allocate kernel memory for VRs!\n");
    free(vr_table, M_TEMP);
    ret FALSE;
  }
  ijets->credit_base = base;
  ijets->credit_base_size = size;

  for (i=0; i<num_vrs; i++) {
    bzerovrp(vr_table[i]);
    if (i==0 || i==num_vrs-1)
      vr_table[i]->vr.nextIndex = IJET_NO_NEXT_VR;
    else
      vr_table[i]->vr.nextIndex = jet_Vrp2VrIndex(unit, vr_table[i+1]);

    /* note where the first credit cell will be written */
    if (i==1)
      ijets->currentcreditva = (ijet_credit_cell_t *) base;
    
    index0 = jet_Vrp2VrIndex0(unit, vr_table[i]);
    ijets->ptov[index0] = base;

    /* fill the credit value w/ the marker value */
    ((ijet_credit_cell_t *) base)->unused0 = 0xBABE;
    
    vr_table[i]->vr.address = vtophys(base);
    vr_table[i]->vr.remain  = IJET_CREDIT_VR_SIZE;
    vr_table[i]->vr.length  = IJET_CREDIT_VR_SIZE;
    vr_table[i]->vr.sarLocation = SAR_HOST;

    base += IJET_CREDIT_VR_SIZE;
    if ((base&(NBPG-1))+IJET_CREDIT_VR_SIZE > NBPG)
      base = (base+IJET_CREDIT_VR_SIZE)&~(NBPG-1);

    if (i==0)			/* We saved one for the mbox.  */
      ijets->credit_mbox_vrp = vr_table[0];
    else			/* attach the rest to the freelist */
      ijetaddcreditvr(ijets, vr_table[i]);
  }
  ijets->lastcreditva = (ijet_credit_cell_t *) base;

  free(vr_table, M_TEMP);

  ret TRUE;
}
end(ijetcreditinit);
#endif

/*
 * Credit change:  july 3rd
 *
 * Just set up the VR chain here, we'll actually check for
 * credit prior to xmittal.
 */
void ijetxmtbuildvrs(ijet_softc_t *ijets, vcid_t vcid)
     begin(ijetxmtbuildvrs);
{
  int unit = IJETS2UNIT(ijets);
  ijet_xmt_vc_t *xmtvcp = &ijets->xmtvc[vcid];
  int len, pdulen;
  vr_t *mvrp=NULL, *vrp, *vr_head, *vr_tail;
  struct mbuf *m;
  
  while (xmtvcp->pre_head) {

    /*
     * Make sure we can schedule the entire packet now.
     *
     * NOTE::
     * We're going w/ the dumb, straightforward approach to credit.  We
     * only schedule packets while we have enough credit to send the
     * entire thing.  For IP, this is probably ok.
     *
     * The correct, slower approach is to keep sending while we have
     * credit; making sure that we always end on packet boundaries or
     * send complete cells.
     */
    m = xmtvcp->pre_head->m;
    
    if (xmtvcp->pre_head->count > ijets->xmt_VR_freecnt)
      break;

    vr_head = vr_tail = NULL;
    xmtvcp->pre_head->head = xmtvcp->pre_head->tail = NULL;
    pdulen = 0;

    /*
     * walk the entire chain and schedule it
     */
    while (m) {
      while (m && m->m_len <= 0)
        m = m->m_next;

      if (m == NULL) {
        if (mvrp == NULL) {
	  /*
	   * Don't really need to panic(), but I'd like to know if this
	   * case ever happens.
	   */
          warn("zero or negative length mbuf!!!\n");
          panic("<= 0 length mbuf");
        }
        break;
      }
        
      len = m->m_len;

      mvrp = ijets->xmt_freeVR_head;
      if (--ijets->xmt_VR_freecnt == 0)
        ijets->xmt_freeVR_head = ijets->xmt_freeVR_tail = NULL;
      else
        ijets->xmt_freeVR_head = jet_VrIndex2MVrp(unit, mvrp->vr.nextIndex);

      bzerovrp(mvrp);
      mvrp->vr.address = vtophys(mtod(m, uint32));
      mvrp->vr.length = vcid;
      mvrp->vr.remain = len;
      mvrp->vr.sarLocation = SAR_HOST;
      pdulen += len;

      /*
       * Place this onto our VR chain (if any).
       */
      if (vr_head)
        vr_tail->vr.nextIndex = jet_MVrp2VrIndex(unit, mvrp);
      else
        vr_head = mvrp;
      vr_tail = mvrp;

      m = m->m_next;
    }

    /* Mark endOfPdu.*/
    mvrp->vr.endOfPdu = 1;
    mvrp->vr.pduLength = pdulen;
    mvrp = NULL;

    /*
     * How much credit do we need?  At least 1 for trailer, may be safer
     * to add 2 due to padding.
     */
    xmtvcp->pre_head->count = pdulen/ATM_DATA_SIZE+1;

    /* Copy to SRAM, save the head and tail for scheduling */
    xmtvcp->pre_head->head = vrp = IJET_MIRROR2SRAM(vr_head);
    bcopyvrp(vr_head, vrp);
    while (vr_head->vr.nextIndex) {
      vr_head = jet_VrIndex2MVrp(unit, vr_head->vr.nextIndex);
      vrp = IJET_MIRROR2SRAM(vr_head);
      bcopyvrp(vr_head, vrp);
    }
    xmtvcp->pre_head->tail = vrp;

    /* We can move this whole list to the done queue. */
    if (xmtvcp->asm_head)
      xmtvcp->asm_tail->next = xmtvcp->pre_head;
    else
      xmtvcp->asm_head = xmtvcp->pre_head;
    xmtvcp->asm_tail = xmtvcp->pre_head;
    xmtvcp->pre_head = xmtvcp->pre_head->next;
    if (xmtvcp->pre_head == NULL)
      xmtvcp->pre_tail = NULL;
    xmtvcp->asm_tail->next = NULL;
    
    ijets->xmt_asm_needed--;
  }

  if (xmtvcp->asm_head) {
#ifdef IJET_CREDIT    
    /* HACK:: check for credit */
    ijetupdatecredit(unit);
#endif
    ijetxmtdoxmt(ijets, vcid);
  }
}
end(ijetxmtbuildvrs);


/*    
 * jetmsg_ip_tx_interface:
 *      
 * the jetmsg driver calls this entry point when it wants to transmit something
 *       
 * the mbuf should have:
 *  space for a vcid_t
 *  a snap/llc header
 *  the data
 */     
         
void jetmsg_ip_tx_interface (int unit, struct mbuf *m, vpivci_t vpivci)
begin();
{         
  int level = splhigh();
  ijet_softc_t *ijets = UNIT2IJETS(unit);  
  vcid_t vcid = ijets->vpivci2vcid[vpivci];
        
  warn ("Converted vpivci %d into vcid %d\n", vpivci, vcid);
  if (ijets->xmt_mbuf_pool == NULL) {
    splx(level);
    warn ("sorry, no mbufs\n");
    ret;  
  }     
  warn ("Calling ijetxmt to transmit mbuf on vcid %d\n", vcid);
  ijetxmt (unit, m, vcid);
  splx(level); 
}       
end();    

/*
 * ijetxmt()
 *
 * This does the real work in queueing up a pkt for transmission
 * on the adaptor.  This routine gets called from ijetifoutstart().
 *
 */
void ijetxmt(int unit, struct mbuf *m, vcid_t VCid)
     begin(ijetxmt);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  ijet_mbuf_t *ijetmbufp, *tail;
  ijet_xmt_vc_t *xmtvcp;
  struct mbuf *mtmp;
  int cnt;

  /*
   * At this point we know we have enough resources, else the mbuf
   * wouldn't have been dequeued and we would have never been
   * called.  Therefore, just pass this down to the lower
   * level where it will be xmitted on one of the VCs
   */

  xmtvcp = &ijets->xmtvc[VCid];

  /*
   * FIX::
   * basic process is to:
   *  tack mbuf chain onto the per VC ijet_mbuf_t chain.
   *  call our credit_xmt routine
   */

  /*
   * Grab an mbuf chain link from the free list.
   */
  ijetmbufp = ijets->xmt_mbuf_pool;
  ijets->xmt_mbuf_pool = ijets->xmt_mbuf_pool->next;
  
  ijetmbufp->m = m;
  for (mtmp=m, cnt=0; mtmp; mtmp=mtmp->m_next, cnt++);
  ijetmbufp->count = cnt;

  ijetmbufp->next = NULL;
  
  tail = xmtvcp->pre_tail;

  if (tail == NULL)
    xmtvcp->pre_head = ijetmbufp;
  else
    tail->next = ijetmbufp;
    
  xmtvcp->pre_tail = ijetmbufp;

  ijets->xmt_asm_needed++;
  ijetxmtbuildvrs(ijets, VCid);
}
end(ijetxmt);

/*
 * ijetxmtdone()
 *
 * We shouldn't try to free anything until we get end of pdu.
 * Also, this means the adaptor must GUARANTEE that things are transmitted
 * in order for a particular VCid.
 */
void ijetxmtdone(int unit, vr_t *mvrp, bool mboxtail)
     begin(ijetxmtdone);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  vcid_t vcid = mvrp->message.vcid;
  bool pdu_end = mvrp->message.endOfPdu;
  ijet_xmt_vc_t *xmtvcp;

  /*
   * End of PDU is our signal to free the mbuf chain.  Otherwise,
   * we just free the xmt VRs
   */

  if (mboxtail)
    ijets->xmt_mbox_free = TRUE;
  else
    ijetaddxmtvr(ijets, mvrp);

  if (!pdu_end)
    ret;

  /*
   * Update our pkt stats.
   */
  ijets->ijet_if.if_opackets++;

  /*
   * We could sanity check the VCid for boundedness, but we don't.
   * If we get a bogus VCid, we're hosed anyway...but the statement
   * below could get a VM pagefault trap if we're really unlucky.
   */
  xmtvcp = &ijets->xmtvc[vcid];
  if (xmtvcp->done_head == NULL) {
    warn("ijet%d: ijetxmtdone(): Received endOfPdu on VC %d w/o xmt!\n",
	   unit, vcid);
    ret;
  }

  m_freem(xmtvcp->done_head->m);

  {
    ijet_mbuf_t *tmp = xmtvcp->done_head->next;
    xmtvcp->done_head->next = ijets->xmt_mbuf_pool;
    ijets->xmt_mbuf_pool = xmtvcp->done_head;
    xmtvcp->done_head = tmp;
  }

  if (xmtvcp->done_head == NULL)
    xmtvcp->done_tail = NULL;

  /* NOTE:: maybe a better place for this?? */
  if (xmtvcp->asm_head) {
#ifdef IJET_CREDIT      
    ijetupdatecredit(unit);
#endif
    ijetxmtdoxmt(ijets, vcid);
  }
  
  /* HACK::
   * See if we can place any more rcv VRs out there.
   */
  VrAttachRoutine(unit);
  
  ret;
}
end(ijetxmtdone);

/*
 * standard device interface routines
 */

/*
 * ijetopen()
 *
 * open our device.  make sure the device exists.  do we want to
 * allow exclusive opens?
 *
 * return: 0 on success
 */
int ijetopen(dev_t dev, int flag)
     begin(ijetopen);
{
  int unit = DEV2UNIT(dev);
  ijet_softc_t *ijets;

  debug("ijetopen: called!\n");
  if (unit<0 || unit>=ijet_cd.cd_ndevs) {
    warn("ijet%d: ijetopen: invalid unit number for device!\n", unit);
    ret ENXIO;
  }

  ijets = ijet_cd.cd_devs[unit];

  /* we don't use this next value at the present time */
  ijets->opencnt++;
  ret 0;
}
end(ijetopen);

/*
 * ijetclose()
 *
 * just here for completeness right now
 */
int ijetclose(dev_t dev, int flag, int mode, struct proc *p)
     begin(ijetclose);
{
  ijet_softc_t *ijets = ijet_cd.cd_devs[DEV2UNIT(dev)];
 int loop;

  ijets->opencnt--;
  if (p == ijets->vince_proc) {
    ijets->vince_flag = FALSE; 
    ijets->vince_proc = 0;
    ijets->next_arp = -1;
    for (loop=0; loop<MAX_ARPS; loop++) ijets->pending_arps[loop] = 0;
  } 
  ret 0;
}
end(ijetclose);

/*
 * ijetioctl()
 *
 * handle ioctl requests from the user via an open file descriptor
 *
 * here we can return status blocks, load ucode, etc
 */
int ijetioctl(dev_t dev, u_long cmd, caddr_t data, int flag, struct proc *p)
begin(ijetioctl); 
{
  int unit = DEV2UNIT(dev);
  ijet_softc_t *ijets = ijet_cd.cd_devs[unit];
  int error=0;
	
  /*
   * So we don't have to muck w/ alignment for the time being, we'll
   * stage memory transfers through a temporary buffer.   This isn't
   * necessary on the i386, I believe.
   */

  /*
   * Main ioctl processing switch
   */
  switch(cmd) {
  case IJETIOC_LOAD_UCODE: {
    iocopy_req_t *iocpr = (iocopy_req_t *) data;
    if (ijets->ucode)
      free(ijets->ucode, M_DEVBUF);
    ijets->ucodesize = iocpr->len;
    if((ijets->ucode = malloc(ijets->ucodesize, M_DEVBUF, M_NOWAIT)) == NULL)
      ret ENOMEM;
    copyin((char *)iocpr->user, ijets->ucode, ijets->ucodesize);
    ijets->flags |= IJET_FL_UCODEIS;
  }
    break;
    
  case IJETIOC_GET_MEM: {
    /* this staging is probably not necessary CHECK THIS */
    iocopy_req_t *iocpr = (iocopy_req_t *) data;
    copyout(iocpr->system, iocpr->user, iocpr->len);
  }
    break;

  case IJETIOC_PUT_MEM: {
    iocopy_req_t *iocpr = (iocopy_req_t *) data;
    copyin(iocpr->user, iocpr->system, iocpr->len);
  }
    break;
    
  case IJETIOC_GET_UINT8:
    * (uint32 *) data = (uint32) (**(uint8 **) data);
    break;
    
  case IJETIOC_PUT_UINT8:
    * (uint8 *) (((uint32*) data)[0])  = ((uint32 *)data)[1];
    break;
    
  case IJETIOC_GET_UINT32:
    * (uint32 *) data = **(uint32 **) data;
    break;
    
  case IJETIOC_PUT_UINT32:
    * (((uint32 **) data)[0]) = ((uint32 *)data)[1];
    break;
    
  case IJETIOC_SETUP: {
    ijet_ioctl_setup_t *setup = (ijet_ioctl_setup_t *) data;
    if (!ijetcheckcfg(ijets, setup))
      error = ERANGE;		/* better than EINVAL?? */
    else
      ijets->flags |= IJET_FL_CFGINIT;
  }
    break;

  case IJETIOC_STRUCT_ADDR:
    /* return the address (in our space) of the primary data
     * structure.  The _GET_MEM ioctl can then be used to get
     * the data
     */
    *(ijet_softc_t **) data = ijets;
    break;

  case IJETIOC_ADD_ART: {
    ijet_art_ent_t **artehead, *arte, *newarte=NULL;
    uint32 tmp;
    int found, loop;
    /* we just add this ARP entry to the chain, we need to decide
     * if we want to statically allocate some number of entries, or
     * to malloc them as needed
     */
    tmp = ((uint32 *) data)[0];         /* IP address */
    artehead = &ijets->art[(tmp>>24)&(IJET_ART_HASH-1)];
    arte = *artehead;

      if ((newarte=ijets->art_free) == NULL)
        ret ENOSPC;

      /* add new entry to head of chain */
      ijets->art_free = newarte->next;
      newarte->next = *artehead;
      *artehead = newarte;
      newarte->ipaddr = tmp;

      /* update pending arps array */
      found = -1;
      for (loop = 0; loop < MAX_ARPS; loop++)
         if (ijets->pending_arps[loop] == newarte->ipaddr) {
            found = loop;
            break;
         }
      if (found != -1) {
         ijets->next_arp--;
         for (loop = found; loop < MAX_ARPS - 1; loop++)
           ijets->pending_arps[loop] = ijets->pending_arps[loop+1];
      }
  
    newarte->tx_VCid = ((uint32 *) data)[1];
    newarte->rx_VCid = ((uint32 *) data)[2];
    newarte->flag = ((unsigned int *) data)[3];
    newarte->idle = 0;
  }
    break;

  case IJETIOC_DEL_ART: {
    ijet_art_ent_t *arte, **arteprev;
    uint32 tmp = * (uint32 *) data;		/* ip address */
    /* remove an ARP table entry */
    arteprev = &ijets->art[(tmp>>24)&(IJET_ART_HASH-1)];
    arte = *arteprev;
    while (arte!=NULL && arte->ipaddr!=tmp) {
      arteprev = &arte->next;
      arte = arte->next;
    }

    if (arte == NULL)			/* not found on chain */
      error = EINVAL;
    else {
      unit = IJETS2UNIT(ijets);
      ll_CloseRx(unit, arte->rx_VCid);  /* close tx and rx VCs */
      ll_CloseTx(unit, arte->tx_VCid);
      *arteprev = arte->next;		/* update whatever pointed to us */
      arte->next = ijets->art_free;	/* add free list to us */
      ijets->art_free = arte;		/* point free list to me */
    }
  }
    break;

  case IJETIOC_GET_ART: {
    /* Get the ARP table */
    uint32 *p = (uint32 *) data;
    ijet_art_ent_t *arte;
    int loop, nate = p[0];		/* No. of arp entries requested */
    typedef struct {
        uint32 ipaddr;
        uint32 vpvc;
        uint32 flag;
        uint32 idle;
    } arpent_t;

    arpent_t *userArtBuffer = (arpent_t *) p[1];
    arpent_t *kernelArtBuffer = NULL;
    int n = 0;			/* No. of arp entries returned */
   
    debug ("Number of ARP entries requested %d\n", nate);
    if ((kernelArtBuffer = (arpent_t *) 
	malloc(nate*sizeof(arpent_t), M_DEVBUF, M_WAITOK)) == NULL)
		ret ENOMEM;
    for (loop = 0; loop < IJET_ART_HASH; loop++) {
	arte = ijets->art[loop];
	while (arte != NULL) {
		if (n < nate) {
			kernelArtBuffer[n].ipaddr = arte->ipaddr;
			kernelArtBuffer[n].vpvc = arte->rx_VCid; /* Hack */
			kernelArtBuffer[n].flag = arte->flag;
			kernelArtBuffer[n].idle = arte->idle;
			debug ("IP addr 0x%x Vpvc %d Flag %d idle %d\n",
				arte->ipaddr, arte->rx_VCid, arte->flag,
				arte->idle);
			n++;
		}
		arte = arte->next;
	}
    }
    p[0] = n;
    debug ("Number of ARP entries returned %d\n", n);
    copyout(kernelArtBuffer, userArtBuffer, n*sizeof(arpent_t));
    free(kernelArtBuffer, M_DEVBUF);
    }
    break;

  case IJETIOC_GET_NATE: {
    /* Get the number of ARP table entries */
    ijet_art_ent_t *arte;
    int loop, nate = 0;
    
    for (loop = 0; loop < IJET_ART_HASH; loop++) {
	arte = ijets->art[loop];
	while (arte != NULL) {
		nate++;
		arte = arte->next;
	}
    }
    * (uint32 *) data = nate;
  }
  break;
    
  case IJETIOC_FLUSH_ART: {
    ijet_art_ent_t *arte, **arteprev;
    int loop;
    /* flush ARP table */
    for (loop = 0; loop < IJET_ART_HASH; loop++) {
	arteprev = &ijets->art[loop];
	arte = *arteprev;
	while (arte != NULL) {
	    ll_CloseRx(unit, arte->rx_VCid);  /* close tx and rx VCs */
	    ll_CloseTx(unit, arte->tx_VCid);
	    *arteprev = arte->next;
	    arte->next = ijets->art_free;     /* place entry on freelist */
	    ijets->art_free = arte;
 	    arte = *arteprev;
	}
    }
  }
  break;

  case IJETIOC_OPEN_TX:
    {
      /* NOTE: do some error checking on this one... */
      ijet_ioctl_open_tx_t *txp = (ijet_ioctl_open_tx_t *) data;
      txp->vcid = ll_OpenTx(unit, txp->processing_type, ijets->xmt_mbox,
			    txp->scheduling_type, txp->vpivci);
      if (txp->vpivci < 65536)  /* kosak HACK */
          ijets->vpivci2vcid[txp->vpivci] = txp->vcid;
      else
          warn ("-----------------YOU GOTTA FIX THIS------------\n");
    }
    break;
    
  case IJETIOC_OPEN_RX:
    {
      /* NOTE: do some error checking on this one... */
      ijet_ioctl_open_rx_t *rxp = (ijet_ioctl_open_rx_t *) data;
      /*
       * FIX::  if the adaptor worked...we'd have different
       *   head/data flists
       */
      if ((rxp->vcid = ll_OpenRx(unit, rxp->processing_type, ijets->rcv_mbox,
			    ijets->rcv_flist[0], ijets->rcv_flist[0],
			    &(rxp->vpivci))) < 0) {
		ret EINVAL;
      }
    }
    break;

#ifdef IJET_CREDIT    
  case IJETIOC_OPEN_CREDIT:
    {
      /* NOTE: do some error checking on this one... */
      ijet_ioctl_open_rx_t *rxp = (ijet_ioctl_open_rx_t *) data;
      /*
       * FIX::  if the adaptor worked...we'd have different
       *   head/data flists
       */
      if ((rxp->vcid = ll_OpenRx(unit, rxp->processing_type, ijets->credit_mbox,
			    ijets->credit_flist, ijets->credit_flist,
			    &(rxp->vpivci))) < 0) {
		ret EINVAL;
      }
    }
    break;
  case IJETIOC_RESET_CREDIT:
    {
      int i;
      for (i=0; i<ijets->xmt_VCids; i++)
        ijets->xmtvc[i].credit = *(uint32*)data;
      ijetcheckxmt(ijets);
    }
  break;
#endif    

  case IJETIOC_READ_PCI: {
    int reg = ((uint32 *) data)[0];
    pcitag_t tag = (pcitag_t) ((uint32 *) data)[2];
    warn("tag = 0x%x, reg = 0x%x\n", * (uint32 *) &tag, reg);
    ((uint32 *) data)[1] = pci_conf_read(ijets->ijet_pc, tag, reg);
  }
    break;

  case IJETIOC_WRITE_PCI: {
    int reg = ((uint32 *) data)[0];
    pcitag_t tag = (pcitag_t) ((uint32 *) data)[2];
    pcireg_t value = (pcireg_t) ((uint32 *) data)[1];
    pci_conf_write(ijets->ijet_pc, tag, reg, value);
  }
    break;
    
#if IJETD      
  case IJETIOC_DEBUG_MASK:
    ijet_debugmask = *(uint32*)data;
    warn("setting debug mask to %d\n", ijet_debugmask);
    break;
#endif      

#if IJETD
  case IJETIOC_READLOG: {
    uint32 *p = (uint32*)data;
    int   userStart  = p[0];
    char *userBuffer = (char*)(p[1]);
    int   userLength = p[2];
    
    p[2] = 0;
    if (userStart != ijet_debugLogIndex) {
      int bytesTransferred;
      
      if (userStart > ijet_debugLogIndex) { /* handle wrap case */
        bytesTransferred =
          min (IJET_DEBUG_LOG_SIZE-userStart, userLength);
        copyout(&ijet_debugLogBuffer[userStart], userBuffer,
                bytesTransferred);
        userLength -= bytesTransferred;
        userBuffer += bytesTransferred;
        userStart   = 0;
        
        p[2] += bytesTransferred;
      }
      
      bytesTransferred = min(ijet_debugLogIndex-userStart, userLength);
      copyout(&ijet_debugLogBuffer[userStart], userBuffer,
              bytesTransferred);
      p[2] += bytesTransferred;
      p[0] = (userStart+bytesTransferred) % IJET_DEBUG_LOG_SIZE;
    }
  } break;
#endif
    
  case IJETIOC_SET_SCHEDULER: {
    uint32 *p = (uint32*)data;
    ll_SetScheduler (unit, p[0], p[1], p[2], p[3]);
  }
    break;

  case IJETIOC_VINCE_INIT: {
    int loop;
    ijets->vince_flag = TRUE;
    ijets->vince_proc = p;
    ijets->next_arp = -1;
    for(loop=0;loop<MAX_ARPS;loop++) ijets->pending_arps[loop] = 0;
  }
    break;

#ifdef IJET_CELL_COUNTS
  case IJETIOC_CLR_CELL_COUNTS: {
    int loop;
    /* rcv */
    for (loop=0; loop<ijets->rcv_VCids; loop++)
      ijets->rcvvc[loop].cellcount = 0;
    /* xmt */
    for (loop=0; loop<ijets->xmt_VCids; loop++)
      ijets->xmtvc[loop].cellcount = 0;
  }
    break;

  case IJETIOC_GET_CELL_COUNTS: {
    ijet_cell_count_ioctl_t *cc = (ijet_cell_count_ioctl_t *) data;
    int *user_buffer = cc->buffer;
    int loop;

    switch (cc->dir) {
    case IJET_XMT:
      if (cc->bufferlen == 0) {
	cc->bufferlen = ijets->xmt_VCids;
	ret 0;
      }
      cc->bufferlen = min(cc->bufferlen, ijets->xmt_VCids);
      for (loop=0; loop<cc->bufferlen; loop++)
	copyout(&ijets->xmtvc[loop].cellcount, user_buffer++, sizeof(int));
      break;

    case IJET_RCV:
      if (cc->bufferlen == 0) {
	cc->bufferlen = ijets->rcv_VCids;
	ret 0;
      }
      cc->bufferlen = min(cc->bufferlen, ijets->rcv_VCids);
      for (loop=0; loop<cc->bufferlen; loop++)
	copyout(&ijets->rcvvc[loop].cellcount, user_buffer++, sizeof(int));
      break;
    default:
      ret EINVAL;
    }
    
  } break;
#endif
    
  default:
    ret EINVAL;
  }

  ret error;
}
end(ijetioctl);

/*
 * ijetmboxhandler()
 *
 * this routine is the mailbox walker for the ip stuff.
 *
 * NOTE:: the mbox_vrp is an actual vr address in SRAM, while we
 *   pass the mirrored copy to the rcv() routine
 */
int toastme = TRUE;
void qqq_ijetrcvwalker (int unit)
begin();
{
  debug_directTextScreenp[82]++;
  if (toastme)
    return;
}
end();

void ijetrcvwalker(int unit)
begin(ijetrcvwalker);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  int nextIndex;
  vr_t *vrp, *mvrp;
  bool last_item = FALSE;

  vrp = ijets->rcv_mbox_vrp;
  mvrp = IJET_SRAM2MIRROR(vrp);
  nextIndex = vrp->message.nextIndex;

  while (nextIndex != IJET_NO_NEXT_VR) {
    /*
     * copy the nextIndex into mirrorland...
     *
     * HACK HACK HACK FIX FIX FIX
     *  can this work?? due to race conditions...think about it!!!!
     */
    if (0) /* hang hack */
      mvrp->message.nextIndex = nextIndex;

    if (ijets->rcv_mbox_free) {
      VrFreeRoutine(unit, mvrp, 0);
      ijets->rcv_mbox_free = FALSE;
    }

    vrp = jet_VrIndex2Vrp(unit, nextIndex);

    if (vrp == ijets->rcv_mbox_vrp) {
      warn("yikess....VR looped onto itself in rcv!!\n");
      panic("vr loop");
    }
    
    ijets->rcv_mbox_vrp = vrp;
    

    /*
     * copy the whole thing over...
     */
    mvrp = IJET_SRAM2MIRROR(vrp);
    bcopyvrp(vrp, mvrp);
    
    nextIndex = vrp->message.nextIndex;
    if (nextIndex == IJET_NO_NEXT_VR)
      last_item = TRUE;
    
    ijetrcv(unit, mvrp, last_item);
  }
}
end(ijetrcvwalker);

void ijetxmtwalker(int unit)
begin(ijetxmtwalker);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  int nextIndex;
  vr_t *vrp, *mvrp;
  vcid_t vcid;
  bool last_item = FALSE;

  vrp = ijets->xmt_mbox_vrp;
  mvrp = IJET_SRAM2MIRROR(vrp);
  nextIndex = vrp->message.nextIndex;

  while (nextIndex != IJET_NO_NEXT_VR) {

    if (ijets->xmt_mbox_free) {
      ijetaddxmtvr(ijets, mvrp);
      ijets->xmt_mbox_free = FALSE;
    }

    vrp = jet_VrIndex2Vrp(unit, nextIndex);
    ijets->xmt_mbox_vrp = vrp;

    /*
     * copy the whole thing over...
     */
    mvrp = IJET_SRAM2MIRROR(vrp);
    bcopyvrp(vrp, mvrp);
    vcid = mvrp->message.vcid;
    
    nextIndex = vrp->message.nextIndex;
    if (nextIndex == IJET_NO_NEXT_VR)
      last_item = TRUE;
    
    ijetxmtdone(unit, mvrp, last_item);
  }
}
end(ijetxmtwalker);

void ijetflist(int unit, freelist_t freelist)
     begin(ijetflist);
{
  /* ijet_softc_t *ijets = UNIT2IJETS(unit); */

  warn("ijetflist:: out of VR's on freelist %d\n", freelist);
  /*
   * I think the adaptor doesn't recover from this error at all.
   * Just in case I'm wrong, check immediately for available VRs.
   * If none, walk the mbox in case we missed any.
   */
  VrAttachRoutine(unit);
  /*
   * FIX::
   *  what should I call???
   */
  ijetrcvwalker(unit);
}
end(ijetflist);

#ifdef IJET_CREDIT
void ijetcreditflist(int unit, freelist_t freelist)
     begin(ijetcreditflist);
{
  /*
   * Just call the credit handler.
   */
  ijetcreditmboxhandler(unit);
}
end(ijetcreditflist);
#endif

void ijetifstop(int unit)
     begin(ijetifstop);
{
  /*
   * We may want stop to be different than reset
   * ASK corey if there is a way to just stop reception
   * of packets.  I can stop transmittal by marking the
   * interface down.
   *
   * For now, we'll just call ijetreset.
   */
  ijetreset(unit);
}
end(ijetifstop);

/*
 * This is an entire reset.
 */
void ijetreset(int unit)
     begin(ijetreset);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  uint32 pciregs[IJET_PCI_SAVE];
  int i, len;

  /*
   * Save our pci state.
   */
  for (i=0; i<IJET_PCI_SAVE; i+=sizeof(uint32))
    pciregs[i] = pci_conf_read(ijets->ijet_pc, ijets->pcitag, i);
  
  /*
   * reset the adapter
   */
  pci_conf_write(ijets->ijet_pc, ijets->pcitag, IJET_PCI_RESET, 0x1);

  /* Now wait for the interrupt line to become 0 or we've spun enough */
  for (i=0; i<IJET_RESET_WAIT; i++)
    if ((pci_conf_read(ijets->ijet_pc, ijets->pcitag, PCI_INTERRUPT_REG)&
	 PCI_INTERRUPT_LINE_MASK) == 0)
      break;

  /*
   * The board is (hopefully) reset.
   * Write our state back.  We might want to write the command
   * register last??  CHECK::
   */
  for (i=0; i<IJET_PCI_SAVE; i+=sizeof(uint32))
    pci_conf_write(ijets->ijet_pc, ijets->pcitag, i, pciregs[i]);

  /*
   * Now we need to free/invalidate our state.  We'll call a lower
   * level routine to notify it of the reset when we're done.
   */

  /*
   * Some random buffers we've allocated.
   */
  if (ijets->xmt_mbuf_base)
    free(ijets->xmt_mbuf_base, M_DEVBUF);
  if (ijets->rcvvc)
    free(ijets->rcvvc, M_DEVBUF);
  if (ijets->ptov)
    free(ijets->ptov, M_DEVBUF);
  
  /*
   * Zero out most of the ijets struct.  We could use offsetof(), but
   * that's probably not very portable.  We'll use the following, which
   * is what offsetof() probably does anyway.
   */
  len = sizeof(ijet_softc_t) - (uint) &((ijet_softc_t *)NULL)->flags;
  bzero((char *) &ijets->flags, len);
  
  /* mark the freelists as invalid */
  for (i=0; i<IJET_NUM_FREELISTS; i++)
    ijets->rcv_flist[i] = -1;

  /*
   * Now notify the lower level that everything has been reset.
   */
  jet_Goose(ijets->ijet_dev.dv_unit, ijets->sramBase, IJET_SRAM_SIZE,
	    ijets->asicBase, ijets->sonetBase);
}
end(ijetreset);

bool ijetcheckcfg(ijet_softc_t *ijets, ijet_ioctl_setup_t *setup)
     begin(ijetcheckcfg);
{
  int *val = (int *) setup;
  int i;

  /* FIX:: check if there are any other restrictions */
  /* all values must be >= 0 */
  for (i=0; i<sizeof(ijet_ioctl_setup_t)/sizeof(int); i++)
    if (val[i] < 0)
      ret FALSE;

  /*
   * The cfg params seem to be OK.  Go ahead and save them in the
   * ijets struct.
   */
  ijets->xmt_VRs = setup->xmt_VRs;
  ijets->xmt_VCids = setup->xmt_VCids;
  ijets->xmt_mbufs = setup->xmt_mbufs;
  for (i=0; i<IJET_NUM_FREELISTS; i++)
    ijets->rcv_cnt[i] = setup->rcv_cnt[i];
  ijets->rcv_VCids = setup->rcv_VCids;
  ijets->credit_VRs = setup->credit_VRs;
  ijets->maxvpivci = setup->maxvpivci;
  
  ret TRUE;
}
end(ijetcheckcfg);

/*
 * Hopefully, this will be faster than a regular bzero, since
 * we know we can make word-sized accesses.  Also, hopefully, the PCI
 * bus manager will put these into a single burst.
 */
void bzerovrp(vr_t *vrp)
     begin(bzerovrp);
{
  uint32 *word = (uint32 *) vrp;

  /* NOTE:: this is dependent on sizeof(vr_t) == 16 */
  word[0] = 0;
  word[1] = 0;
  word[2] = 0;
  word[3] = 0;
}
end(bzerovrp);

void bcopyvrp(vr_t *vrsrc, vr_t *vrdst)
     begin(bcopyvrp);
{
  uint32 *src = (uint32 *) vrsrc;
  uint32 *dst = (uint32 *) vrdst;
  dst[0] = src[0]; 
  dst[1] = src[1]; 
  dst[2] = src[2]; 
  dst[3] = src[3]; 
}
end(bcopyvrp);

#ifdef IJET_INTELMERGESPACKETS
/*
 * This routine checks that the pdulen found in the trailer equals
 * ip_len+snap.  If not, return -1; otherwise, return offset of
 * where the next pkt would begin and set nextpkt to that vrp.
 *
 * Assumes pdulen is found on an even byte boundary.  If you allocate
 * odd-sized VRs you deserve to die.
 */
private int findEndingVr(int unit, vr_t *headp, vr_t *tailp,
			 int traileroffset, vr_t **nextpkt, int pdulen)
     begin(findEndingVr);
{
  int trailerexcess = 6;
  int pdulenoffset = traileroffset+2; /* FIX:: no magic numbers */
  int datainvr, tpdulen;
  vm_offset_t base;
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  
  if (traileroffset < 0)
    return -1;

  while (1) {
    datainvr = MCLBYTES-headp->message.remain;
    
    if (datainvr > pdulenoffset) {
      base = ijets->ptov[jet_MVrp2VrIndex0(unit, headp)]+pdulenoffset;

      if ((tpdulen=ntohs(*(unsigned short *) base)) != pdulen) {
	debug("pdulen in trailer (%d) did not match IP len (%d)\n",
	       tpdulen, pdulen);
	return -1;
      }

      /*
       * Now find the start of the next packet.
       */
      if (datainvr > pdulenoffset+trailerexcess) {
	*nextpkt = headp;
	return pdulenoffset+trailerexcess;
      }

      /*
       * Crap.  Only part of the trailer was in this VR.
       */
      if (headp == tailp)
	return -1;

      *nextpkt = jet_VrIndex2MVrp(unit, headp->message.nextIndex);
      return pdulenoffset+trailerexcess-datainvr;
    }

    pdulenoffset -= datainvr;
    if (headp == tailp)
      return -1;

    headp = jet_VrIndex2MVrp(unit, headp->message.nextIndex);
  } 
}
end(findEndingVr);
#endif IJET_INTELMERGESPACKETS

void VrAttachRoutine(int unit)
begin(VrAttachRoutine);
{
  vr_t *mvrp, *vrp;
  int index0;
  caddr_t base;
  ijet_softc_t *ijets = UNIT2IJETS(unit);

  /* try to associate an mbuf w/ the head of the list */
  while ((mvrp=ijets->rcv_VR_head) != NULL) {
    
    MCLALLOC(base, M_DONTWAIT);
    if (base == NULL) {
      debug("VrAttachRoutine:: MCLALLOC failed!\n");
      ret;
    }
    
    if (ijets->rcv_VR_tail == mvrp) {
      ijets->rcv_VR_head = NULL;
      ijets->rcv_VR_tail = NULL;
    }
    else
      ijets->rcv_VR_head = jet_VrIndex2MVrp(unit, mvrp->vr.nextIndex);
    
    /*
     * Put it back on the freelist.
     */
    index0 = jet_MVrp2VrIndex0(unit, mvrp);
    ijets->ptov[index0] = (vm_offset_t) base;
    bzerovrp (mvrp); /* hang hack */
    if (1) /* hang hack */
      mvrp->vr.address = vtophys(base);
    else
      mvrp->vr.address = 0xb8000;
    mvrp->vr.remain = MCLBYTES;
    mvrp->vr.sarLocation = SAR_HOST;
    mvrp->vr.nextIndex = IJET_NO_NEXT_VR;

    vrp = IJET_MIRROR2SRAM(mvrp);
    bcopyvrp(mvrp, vrp);
    /*
     * NOTE::
     * we're not handling BLI's correctly yet
     */
    assert (mvrp->vr.BLI == 0);
    ll_AppendVrlistToFreelist(unit, ijets->rcv_flist[mvrp->vr.BLI],
			      vrp, vrp);
  }
}
end(VrAttachRoutine);

void VrFreeRoutine(int unit, vr_t *mvrp, int bli)
     begin(VrFreeRoutine);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  int index0 = jet_MVrp2VrIndex0(unit, mvrp);

  bzerovrp(mvrp);
  mvrp->vr.BLI = bli;
  
  /*
   * Free any associated cluster mbuf.  We can't just reuse this cluster
   * since it may have data moving up the IP stack already.
   */
  if (ijets->ptov[index0]) {
    MCLFREE(ijets->ptov[index0]);
    ijets->ptov[index0] = 0;
  }

  if (ijets->rcv_VR_head == NULL)
    ijets->rcv_VR_head = mvrp;
  else
    ijets->rcv_VR_tail->vr.nextIndex = jet_MVrp2VrIndex(unit, mvrp);

  ijets->rcv_VR_tail = mvrp;

  /*
   * Check to see if there are any available clusters.
   */
  VrAttachRoutine(unit);
}
end(VrFreeRoutine);

void ijetcheckxmt(ijet_softc_t *ijets)
     begin(ijetcheckxmt);
{
  int vcid = ijets->xmt_round_robin;
  int last = vcid;

  while (ijets->xmt_asm_needed && ijets->xmt_VR_freecnt > 0) {
    if (ijets->xmtvc[vcid].pre_head)
      ijetxmtbuildvrs(ijets, vcid);

    vcid = (vcid+1) % ijets->xmt_VCids;

    if (vcid == last)
      break;
  }

  ijets->xmt_round_robin = vcid;
}
end(ijetcheckxmt);

void ijetaddxmtvr(ijet_softc_t *ijets, vr_t *mvrp)
     begin(ijetaddxmtvr);
{
  int unit = IJETS2UNIT(ijets);

  mvrp->vr.nextIndex = IJET_NO_NEXT_VR;
  
  if (ijets->xmt_freeVR_head)
    ijets->xmt_freeVR_tail->vr.nextIndex = jet_MVrp2VrIndex(unit, mvrp);
  else
    ijets->xmt_freeVR_head = mvrp;

  ijets->xmt_freeVR_tail = mvrp;
  ijets->xmt_VR_freecnt++;
  if (ijets->xmt_asm_needed) {
    /*
     * Hmm...we were xmt VR starved prior to this and something is
     * waiting for VRs.
     */
    ijetcheckxmt(ijets);
  }
}
end(ijetaddxmtvr);


#ifdef IJET_CREDIT
/*
 * This routine is the mailbox handler for credit cells.
 *
 * Since we don't want to use old credit cells, we adapt the following
 * scheme:
 *
 * --  walk the entire mailbox, updating the credit values in the xmtvc
 *     table.  create a link from each of these vcs to the next.
 * --  once the mailbox is empty, we now follow this linked list through
 *     the xmt vc table, scheduling packets as appropriate.
 * --  we should probably check the mbox for new credit cells from time
 *     to time if we feel this process may take too long
 *
 */
void ijetcreditwalker(int unit)
     begin(ijetcreditwalker);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  int nextIndex, index0;
  vr_t *mboxvrp = ijets->credit_mbox_vrp;
  vr_t *mvrp;
  ijet_credit_cell_t *cell;
  vcid_t vcid;
  ijet_xmt_vc_t *xmtvc_head=NULL, *xmtvc_tail=NULL, *xmtvcp;
  /*
   * HACK HACK HACK::
   *  correct way is to get endofpdu bit
   */
  nextIndex = mboxvrp->message.nextIndex;

  while (1) {

    /*
     * pull everything out of the credit mailbox
     */
    while (nextIndex != IJET_NO_NEXT_VR) {
      
      /*
       * put the VR back on the free list
       */
      mvrp = IJET_SRAM2MIRROR(mboxvrp);
      bzerovrp(mvrp);
      index0 = jet_Vrp2VrIndex0(unit, mboxvrp);
      mvrp->vr.address = vtophys(ijets->ptov[index0]);
      mvrp->vr.remain = IJET_CREDIT_VR_SIZE;
      mvrp->vr.sarLocation = SAR_HOST;
      mvrp->vr.nextIndex = IJET_NO_NEXT_VR;
      bcopyvrp(mvrp, mboxvrp);
      ijetaddcreditvr(ijets, mboxvrp);
      
      mboxvrp = jet_VrIndex2Vrp(unit, nextIndex);

      /* grab the credit value of the mbox head*/
      cell = (ijet_credit_cell_t *) ijets->ptov[jet_Vrp2VrIndex0(unit,
								 mboxvrp)];
      vcid = ijets->vpivci2vcid[cellvpivci(cell)];
      xmtvcp = &ijets->xmtvc[vcid];
      xmtvcp->credit = cell->value;
      debugd("credit value for vcid %d is now 0x%x\n", vcid, cell->value);

      /*
       * If this VC was already in our linked list, we don't link to it
       * again.
       */
      if (!(xmtvcp->flags&IJET_XF_NEWCREDIT)) {
	xmtvcp->flags |= IJET_XF_NEWCREDIT;
	if (xmtvc_tail)
	  xmtvc_tail->nextxmtvc = xmtvcp;
	else
	  xmtvc_head = xmtvcp;
	
	xmtvc_tail = xmtvcp;
      }
      
      nextIndex = mboxvrp->message.nextIndex;
    }

    /*
     * mailbox is now empty, now follow the linked list scheduling
     * packets as appropriate
     */
    if (xmtvc_head == NULL)
      break;

    /*
     * FIX:: ??
     * should we check those VRs in BUSYWAIT too?
     */
    if (xmtvc_head->flags&IJET_XF_CREDITWAIT)
      ijetxmtdoxmt(ijets, xmtvc_head-ijets->xmtvc);

    xmtvc_head->flags &= ~IJET_XF_NEWCREDIT;
    if (xmtvc_head == xmtvc_tail)
      xmtvc_head = xmtvc_tail = NULL;
    else
      xmtvc_head = xmtvc_head->nextxmtvc;
  }
  
  ijets->credit_mbox_vrp = mboxvrp;
}
end(ijetcreditwalker);

void ijetupdatecredit(int unit)
     begin(ijetupdatecredit);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  ijet_credit_cell_t *cell = ijets->currentcreditva;
  vcid_t vcid;
  ijet_xmt_vc_t *xmtvc_head=NULL, *xmtvc_tail=NULL, *xmtvcp;

  while (1) {
    /* walk the circular buffer */
    while (cell->unused0 != 0xBABE) {
      vcid = ijets->vpivci2vcid[cellvpivci(cell)];
      xmtvcp = &ijets->xmtvc[vcid];
      xmtvcp->credit = cell->value;
      debugd("credit value for vcid %d is now 0x%x\n", vcid, cell->value);
      cell->unused0 = 0xBABE;

      /* move the cell address...jumping page boundaries where
       * appropriate
       */
      cell++;
      if (((vm_offset_t)(cell+1)&(NBPG-1)) < IJET_CREDIT_VR_SIZE)
	cell = (ijet_credit_cell_t *) (((vm_offset_t) (++cell)) & ~ (NBPG-1));

      /* if we're past the end of our circular buffer,
       * reset back to the beginning
       */
      if (cell >= ijets->lastcreditva)
        cell = (ijet_credit_cell_t *) ijets->credit_base;
      
      /*
       * If this VC was already in our linked list, we don't link to it
       * again.
       */
      if (!(xmtvcp->flags&IJET_XF_NEWCREDIT)) {
	xmtvcp->flags |= IJET_XF_NEWCREDIT;
	if (xmtvc_tail)
	  xmtvc_tail->nextxmtvc = xmtvcp;
	else
	  xmtvc_head = xmtvcp;
	
	xmtvc_tail = xmtvcp;
      }
    }

    /* check for outgoing transmits */
    if (xmtvc_head == NULL)
      break;

    if (xmtvc_head->flags&IJET_XF_CREDITWAIT)
      ijetxmtdoxmt(ijets, xmtvc_head-ijets->xmtvc);
  
    xmtvc_head->flags &= ~IJET_XF_NEWCREDIT;
    if (xmtvc_head == xmtvc_tail)
      xmtvc_head = xmtvc_tail = NULL;
    else
      xmtvc_head = xmtvc_head->nextxmtvc;
  }

  ijets->currentcreditva = cell;
}
end(ijetupdatecredit);

void ijetcreditmboxhandler(int unit)
     begin(ijetcreditmboxhandler);
{
  ijet_softc_t *ijets = UNIT2IJETS(unit);
  int nextIndex, index0;
  vr_t *mboxvrp = ijets->credit_mbox_vrp;
  vr_t *mvrp;

  nextIndex = mboxvrp->message.nextIndex;
  while (nextIndex != IJET_NO_NEXT_VR) {
    /* put the VR back on the free list */
    mvrp = IJET_SRAM2MIRROR(mboxvrp);
    bzerovrp(mvrp);
    index0 = jet_Vrp2VrIndex0(unit, mboxvrp);
    mvrp->vr.address = vtophys(ijets->ptov[index0]);
    mvrp->vr.remain = IJET_CREDIT_VR_SIZE;
    mvrp->vr.sarLocation = SAR_HOST;
    mvrp->vr.nextIndex = IJET_NO_NEXT_VR;
    bcopyvrp(mvrp, mboxvrp);
    ijetaddcreditvr(ijets, mboxvrp);
    
    mboxvrp = jet_VrIndex2Vrp(unit, nextIndex);
    nextIndex = mboxvrp->message.nextIndex;
  }

  ijets->credit_mbox_vrp = mboxvrp;
  ijetupdatecredit(unit);
}
end(ijetcreditmboxhandler);

/*
 * Add creditvrs, the last vr in the chain will be treated as a freelist
 * marker due to the 2nd word hack.  since we have some vrs that we wish
 * to use as markers anyway, we wait for one of these to arrive before
 * appending.
 */
void ijetaddcreditvr(ijet_softc_t *ijets, vr_t *vrp)
     begin(ijetaddcreditvr);
{
  int unit = IJETS2UNIT(ijets);
  
  /* if a chain exists, attach it to the end */
  if (ijets->creditvrtail != NULL)
    ijets->creditvrtail->vr.nextIndex = jet_Vrp2VrIndex(unit, vrp);
  else
    ijets->creditvrhead = vrp;
  
  ijets->creditvrtail = vrp;
  
  /* return if this one should not have a freelist marker */
  if (++ijets->creditmarker != ijets->creditinterval)
    ret;
  
  vrp->vr.freeListMarker = 1;
  ijets->creditmarker = 0;
  
  ll_AppendVrlistToFreelist(unit, ijets->credit_flist,
			    ijets->creditvrhead, vrp);
  
  ijets->creditvrtail = NULL;
}
end(ijetaddcreditvr);
#endif

void ijetxmtdoxmt(ijet_softc_t *ijets, vcid_t vcid)
     begin(ijetxmtdoxmt);
{
  int unit = IJETS2UNIT(ijets);
  ijet_xmt_vc_t *xmtvcp = &ijets->xmtvc[vcid];
  
  if (ll_txBusy(unit, vcid)) {
    xmtvcp->flags |= IJET_XF_BUSYWAIT;
    ret;
  }

  xmtvcp->flags &= ~IJET_XF_BUSYWAIT;
  
  if (xmtvcp->asm_head == NULL)
    ret;
    
#ifdef IJET_CREDIT
  /*
   * note:: it's possible to get here from the creditwalker routine,
   * therefore we should not call creditwalker from here.
   */
  if (xmtvcp->asm_head->count > xmtvcp->credit) {
    debugx("not sending due to lack of credit %d < %d!\n",
	   xmtvcp->asm_head->count, xmtvcp->credit);
    if (!(xmtvcp->flags&IJET_XF_CREDITWAIT)) {
      xmtvcp->flags |= IJET_XF_CREDITWAIT;
      /* here we schedule buffer switch interrupts if necessary */
      if (++ijets->credit_waiting == 1) {
	debugx("Turning end of PDU interrupts on!\n");
	ll_ChangeEndOfPDUHandler(unit, ijets->credit_mbox, ijetupdatecredit);
      }
    }
    ret;
  }

  if (xmtvcp->flags&IJET_XF_CREDITWAIT) {
    if (--ijets->credit_waiting == 0) {
      debugx("Turning end of PDU interrupts off!\n");
      ll_ChangeEndOfPDUHandler(unit, ijets->credit_mbox, NULL);
    }
    
    xmtvcp->flags &= ~IJET_XF_CREDITWAIT;
  }
  
  xmtvcp->credit -= xmtvcp->asm_head->count;
#endif

#ifdef IJET_CELL_COUNTS
  {
    /* if we know we're only transmitting a single packet, we can trust
     * the pdulength field in the final vr.  otherwise, we have to run
     * the through the entire list.
     *
     * FIX::
     *  no magic numbers
     */
    xmtvcp->cellcount +=
      ((xmtvcp->asm_head->tail->vr.pduLength+8)+47)/48;
  }
#endif
  
  /* schedule */
  ll_AppendVrThenScheduleStatic(unit, vcid,
				xmtvcp->asm_head->head,
				xmtvcp->asm_head->tail); 

  /* move to the done list */
  if (xmtvcp->done_tail)
    xmtvcp->done_tail->next = xmtvcp->asm_head;
  else
    xmtvcp->done_head = xmtvcp->asm_head;
  xmtvcp->done_tail = xmtvcp->asm_head;
  xmtvcp->asm_head = xmtvcp->asm_head->next;
  if (xmtvcp->asm_head == NULL)
    xmtvcp->asm_tail = NULL;
  xmtvcp->done_tail->next = NULL;
  
}
end(ijetxmtdoxmt);

vcid_t cellvpivci(ijet_credit_cell_t *cell)
     begin(cellvpivci);
{
  vcid_t rvalue = (cell->highvci<<4)+cell->lowvci;
  ret rvalue;
}
end(cellvpivci);
