#include <sys/types.h>
#include <sys/time.h>
#include <sys/systm.h>
#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_jet.h>
#include <dev/pci/jetland/include/ijet_ll.h>
#include <dev/pci/jetland/include/ijet_reg.h>

int zeronwords = 4;
int coreolis = 1;

/*
 * Download microcode into the adaptor
 *
 * The buffer is composed of triplets.
 * Each triplet contains:
 *    uint32 microcode address
 *    uint32 low 32 bits of opcode
 *    uint32 high 12 bits of opcode (stored in low 12 bits of this parameter)
 *
 * Parameters:
 *  unit - unit
 *  buffer - buffer
 *  length - length of buffer in bytes (this better be a multiple of 12)
 *
 */

public int jet_DownloadUcode (int unit, uint32 *buffer, uint32 length)
begin (jet_DownloadUcode);
{
  jet_reg_cmd_reg_t cmd_reg_save = jet_asicBase[unit]->cmd_reg;  /* save old */

  /* disable asic */
  {
    jet_reg_cmd_reg_t temp = cmd_reg_save;
    temp.enable = 0;
    jet_asicBase[unit]->cmd_reg = temp;
  }

  if (length % 12 != 0) {
    printf ("You suck!  Length must be a multiple of 12\n");
    return LL_ERROR_UCODE_NOT_AN_EVEN_DOZEN;
  }

  debug ("Loading microcode\n");

  while (length) {
    uint32 addr=   *buffer++;
    uint32 opLow=  *buffer++;
    uint32 opHigh= *buffer++;
        
    reg_WriteStaticRegister (unit, JET_STATIC_DRAM_REG0, opLow);
    reg_WriteStaticRegister (unit, JET_STATIC_DRAM_REG1, opHigh);
    reg_WriteStaticRegister (unit, JET_STATIC_DRAM_ADDR, addr);
        
    length -= 3 * sizeof (uint32);
  }

  /* restore enable status */
  jet_asicBase[unit]->cmd_reg = cmd_reg_save;
  return SUCCESS;
}
end (jet_DownloadUcode);



public int jet_LbiInit (int unit)
begin (jet_LbiInit);
{
  debug ("Writing to LBI registers\n");

  jet_asicBase[unit]->arbiter= 0;
  jet_asicBase[unit]->arbiter= 0xc005ef; /* hack: was 0xc00000 */
  jet_asicBase[unit]->io0= 0x0fff0fff;
  jet_asicBase[unit]->io1= 0x00030fff;

  return SUCCESS;
}
end (jet_LbiInit);



public int jet_AsicInit (int unit)
begin (jet_AsicInit);
{
  debug ("Setting up asic, baby\n");

  /* Tx Rx arbitration register */
  {
    static jet_reg_txrx_arb_t reg;  /* fields initially zero */
    reg.rxCount= 4;
    reg.txCount= 4;
    jet_asicBase[unit]->txrx_arb= reg;
  }

  /* Configuration register:  */
  {
    static jet_reg_cfg_reg_t reg;  /* fields initially zero */
    reg.linkLevelFlowControl    = TRUE;
    reg.rxCollectOutOfRangeVcs  = TRUE;   /* must be true for OC-12 */
    reg.notificationBufferEnable= FALSE;
    jet_asicBase[unit]->cfg_reg = reg;
  }

  {
    static jet_reg_cmd_reg_t reg;  /* all fields zero */
    static uint32 tmp;

    jet_asicBase[unit]->cmd_reg = reg;
    jet_asicBase[unit]->vc_oam = tmp;
    jet_asicBase[unit]->vc_err = tmp;
  }

    if (coreolis) {
	/* Set the Rx FIFO Full reg to max value 
	 * becasue of glitch in our board
	 */
	
	jet_asicBase[unit]->rx_full = 0x7f;
	/* Dont set Tx FIFO Full reg above 0x2a
	 * must leave 3 cells empty at the top of FIFO
	 */
	jet_asicBase[unit]->tx_full = 0x2a;
    }

  return SUCCESS;
}
end (jet_AsicInit);



public int jet_SramInit (int unit)
begin (jet_SramInit);
{
  int i;
  uint32 *p= (uint32*)jet_sramBase[unit];

  if (jet_oc12[unit]) 
      p = (uint32 *) (jet_sramBase[unit] + 0x1a0000);
  else
      p = (uint32 *) jet_sramBase[unit];

  for (i = 0; i < zeronwords; i++)
    p[i] = 0;
  for (i = zeronwords; i < 0x40000 / sizeof(uint32); i++)  /* HACK */
    p[i] = 0x0;

  return SUCCESS;
}
end (jet_SramInit);
