#include <sys/types.h>
#include <sys/malloc.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/errno.h>
#include <sys/mbuf.h>
#include <sys/buf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/syslog.h>
#include <sys/device.h>
#include <sys/malloc.h>
#include <sys/proc.h>

#include <vm/vm.h>
#include <vm/vm_param.h>
#include <vm/vm_extern.h>

#include <net/if.h>
#include <net/if_types.h>
#include <net/if_dl.h>
#include <net/netisr.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>

#include <machine/cpu.h>
#include <machine/pio.h>

#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_ll.h>

#include "debug_user.h"

extern vm_map_t kernel_map;

#define PAGESIZE        4096
#define PG1             (PAGESIZE-1)

public int debugopen (dev_t dev, int flags, int mode, struct proc *p);
public int debugclose (dev_t dev, int flags, int mode, struct proc *p);
public int
debugioctl (dev_t dev, int cmd, caddr_t addr, int flag, struct proc *p);


private int ReadSram (int unit, uint32 addr, uint32 length, uint32 hostDest);
private int WriteSram (int unit, uint32 addr, uint32 length,
                       uint32 hostSource);
private int ReadAsicReg (int unit, uint32 regAddress, uint32 *valuep);
private int WriteAsicReg (int unit, uint32 regAddress, uint32 value);

bool        debug_directTextScreenMapDone;
uint16     *debug_directTextScreenp;
pt_entry_t *debug_directTextScreenMap;

pt_entry_t *debug_bigBufMap;
void       *debug_bigBufp;

public int debugopen (dev_t dev, int flags, int mode, struct proc *p)
{
  if (!debug_directTextScreenMapDone) {
    vm_offset_t spa = (vm_offset_t) 0xb8000;

    debug_directTextScreenMapDone = TRUE;
    pmap_enter(pmap_kernel(),
               (vm_offset_t)debug_directTextScreenp, trunc_page(spa),
               VM_PROT_READ|VM_PROT_WRITE, TRUE);

    printf ("debug screen virt 0x%x phys 0x%x\n",
            (uint32)debug_directTextScreenp,
            (uint32)vtophys(debug_directTextScreenp));
    
    printf ("bigBufp: virt 0x%x phys 0x%x\n",
            (uint32)debug_bigBufp, (uint32)vtophys(debug_bigBufp));
  }
  return 0;
}


public int debugclose (dev_t dev, int flags, int mode, struct proc *p)
{
  return 0;
}


public int
debugioctl (dev_t dev, int cmd, caddr_t addr, int flag, struct proc *p)
{
  uint32 *data = (uint32*)addr;
  switch (cmd) {
  case DEBUG_IOCTL_READ_SRAM: return ReadSram (data[0], data[1], data[2], data[3]);
  case DEBUG_IOCTL_WRITE_SRAM: return WriteSram (data[0], data[1], data[2], data[3]);
  case DEBUG_IOCTL_READ_ASIC_REG: return ReadAsicReg (data[0], data[1], &data[2]);
  case DEBUG_IOCTL_WRITE_ASIC_REG: return WriteAsicReg (data[0], data[1], data[2]);
  default: return ERANGE;
  }
}


public void debug_DumpToScreen (char ch, char *s)
{
  uint16 *sp;
  int i;
  static int scrpos = 160;
  static int digit='0';

  if (!debug_directTextScreenMapDone)
    return;

  /* erase old arrow */
  debug_directTextScreenp[scrpos] = 0;
  scrpos += 80;
  if (scrpos == 80*25)
    scrpos = 160;

  sp = &debug_directTextScreenp[scrpos];

  /* completely erase new line */
  for (i=0; i<80; i++)
    sp[i] = 0;
  
  *sp++ = 0x8e10;      /*blinking intense yellow arrow on black*/
  *sp++ = 0x0e00 | digit;
  if (digit++ == '9')
    digit='0';
  for (i=0; i<ijet_debug_indentLevel; i++)
    *sp++ = 0x0c00 | '.';
  *sp++ = 0x2000 | ch; /* black character on green */
  *sp++ = 0; 
  while (*s)
    *sp++ = 0x0c00 | *s++;  /* intense red on black */
  *sp++ = 0;
  *sp++ = 0;
}


private int ReadSram (int unit, uint32 addr, uint32 length, uint32 hostDest)
begin();
{
  uint32 *source = (void*)jet_sramBase[unit]+addr;
  uint32 *dest   = (void*)hostDest;
  if (0) {
    warn ("Request is: read SRAM addr 0x%x length 0x%x\n", addr, length);
    warn ("copyout(0x%x, 0x%x, 0x%x)\n", (uint32)source, (uint32)dest, length);
  }
  copyout (source, dest, length);
  return 0;
}
end();


private int WriteSram (int unit, uint32 addr, uint32 length, uint32 hostSource)
begin();
{
  uint32 *source = (void*)hostSource;
  uint32 *dest   = (void*)jet_sramBase[unit]+addr;
  if (0) {
    warn ("Request is: write SRAM addr 0x%x length 0x%x\n", addr, length);
    warn ("copyout(0x%x, 0x%x, 0x%x)\n", (uint32)source, (uint32)dest, length);
  }
  copyin (source, dest, length);
  return 0;
}
end();


private int ReadAsicReg (int unit, uint32 regAddress, uint32 *valuep)
begin();
{
  if (0) {
    warn ("Reading register 0x%x\n", regAddress);
    warn ("that address would be 0x%x\n", 
          (uint32)(&((uint32*)jet_asicBase[unit])[regAddress/4]));
  }
  *valuep = ((uint32*)jet_asicBase[unit])[regAddress/4];
  if (0)
    warn ("value is 0x%x\n", *valuep);
  return 0;
}
end();


private int WriteAsicReg (int unit, uint32 regAddress, uint32 value)
begin();
{
  if (0)
    warn ("Writing 0x%x to register 0x%x\n", value, regAddress);
  ((uint32*)jet_asicBase[unit])[regAddress/4] = value;
  return 0;
}
end();




