
/*  A Bison parser, made from parser.y with Bison version GNU Bison version 1.22
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	CR	258
#define	PFX_W	259
#define	NUM	260
#define	ANYTEXT	261
#define	CMD_TTY	262
#define	CMD_WATCH	263

#line 1 "parser.y"

  #include "glob.h"
  #include "../src/debug/debug_user.h"

  class adaptor_t {
  public:
    const int memorySize = 65536*8*4;  /* oc12 hack: was 65536*8 */
    uint32 mirror[memorySize/4];
    void ReadSram (range_t &range);
    void WriteSram (range_t &range);
    uint32 ReadAsicReg (uint32 address);
    void WriteAsicReg (uint32 address, uint32 data);
  };

  void SetUnit (int unit);
  void ShowUnit (void);
  void ShowSramRange (range_t &range);
  void SetSramRange (range_t &range, dynarray_t<int> &list);
  void ShowAsicReg (uint32 address);
  void SetAsicReg (uint32 address, uint32 value);
  void SetWatchDevice (char *name);
  void Watch (range_t &range);

  int debugFd;

  adaptor_t adaptor;
  dynarray_t<int> list;

  int unitNumber;
  uint32 lastAddress;
  bool lastIsAsicReg;

  extern "C" int megaDone;

#line 36 "parser.y"
typedef union {
  uint32  num;
  char   *text;
  range_t range;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		52
#define	YYFLAG		-32768
#define	YYNTBASE	15

#define YYTRANSLATE(x) ((unsigned)(x) <= 263 ? yytranslate[x] : 23)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,    12,    11,     9,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    13,    14,     2,
     2,     2,     2,    10,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     5,     7,    10,    14,    17,    22,    27,    34,
    38,    44,    50,    58,    59,    60,    67,    72,    74,    77,
    79,    83,    85,    88,    90
};

static const short yyrhs[] = {    16,
     0,    15,    16,     0,     3,     0,     9,     3,     0,     5,
     9,     3,     0,    19,     3,     0,     5,     9,    19,     3,
     0,    19,    22,    21,     3,     0,     5,     9,    19,    22,
    21,     3,     0,    10,     5,     3,     0,     5,     9,    10,
     5,     3,     0,    10,     5,    22,     5,     3,     0,     5,
     9,    10,     5,    22,     5,     3,     0,     0,     0,    11,
     7,    17,     6,    18,     3,     0,    11,     8,    20,     3,
     0,    20,     0,     4,    20,     0,     5,     0,     5,    12,
     5,     0,     5,     0,    21,     5,     0,    13,     0,    14,
     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    52,    53,    56,    69,    73,    77,    83,    90,    96,   103,
   109,   116,   122,   129,   129,   130,   133,   139,   143,   150,
   154,   161,   166,   172,   172
};

static const char * const yytname[] = {   "$","error","$illegal.","CR","PFX_W",
"NUM","ANYTEXT","CMD_TTY","CMD_WATCH","'/'","'@'","'.'","'-'","':'","';'","all",
"command","@1","@2","addressRange","range","list","colon",""
};
#endif

static const short yyr1[] = {     0,
    15,    15,    16,    16,    16,    16,    16,    16,    16,    16,
    16,    16,    16,    17,    18,    16,    16,    19,    19,    20,
    20,    21,    21,    22,    22
};

static const short yyr2[] = {     0,
     1,     2,     1,     2,     3,     2,     4,     4,     6,     3,
     5,     5,     7,     0,     0,     6,     4,     1,     2,     1,
     3,     1,     2,     1,     1
};

static const short yydefact[] = {     0,
     3,     0,    20,     0,     0,     0,     0,     1,     0,    18,
    20,    19,     0,     0,     4,     0,    14,     0,     2,     6,
    24,    25,     0,     5,     0,     0,    21,    10,     0,     0,
     0,    22,     0,     0,     7,     0,     0,    15,    17,     8,
    23,    11,     0,     0,    12,     0,     0,     9,    16,    13,
     0,     0
};

static const short yydefgoto[] = {     7,
     8,    30,    46,     9,    10,    33,    23
};

static const short yypact[] = {    19,
-32768,    -2,    27,     5,    20,    40,     2,-32768,     1,-32768,
    25,-32768,    30,    33,-32768,     6,-32768,    -2,-32768,-32768,
-32768,-32768,    41,-32768,    44,    13,-32768,-32768,    45,    46,
    42,-32768,    38,    18,-32768,    41,    48,-32768,-32768,-32768,
-32768,-32768,    49,    39,-32768,    50,    52,-32768,-32768,-32768,
    56,-32768
};

static const short yypgoto[] = {-32768,
    51,-32768,-32768,    47,    -1,    21,   -16
};


#define	YYLAST		60


static const short yytable[] = {    29,
    12,    51,    11,    20,     1,     2,     3,    15,    28,    36,
     4,     5,     6,    21,    22,    35,    31,    43,    21,    22,
    42,     1,     2,     3,    16,    21,    22,     4,     5,     6,
    21,    22,    24,     2,    11,    13,    14,    27,    14,    25,
    40,    48,    41,    41,    39,    32,    17,    18,    34,    37,
    45,    38,    49,    47,    50,    52,    44,    19,     0,    26
};

static const short yycheck[] = {    16,
     2,     0,     5,     3,     3,     4,     5,     3,     3,    26,
     9,    10,    11,    13,    14,     3,    18,    34,    13,    14,
     3,     3,     4,     5,     5,    13,    14,     9,    10,    11,
    13,    14,     3,     4,     5,     9,    12,     5,    12,    10,
     3,     3,     5,     5,     3,     5,     7,     8,     5,     5,
     3,     6,     3,     5,     3,     0,    36,     7,    -1,    13
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Added YYPARSE_RETURN_TYPE hack to allow parsers to return
   pointers on non-32-bit machines like alphas.
      SNL 7 April 1995 */

#ifndef YYPARSE_RETURN_TYPE
#define YYPARSE_RETURN_TYPE int
#endif /* YYPARSE_RETURN_TYPE */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
YYPARSE_RETURN_TYPE yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "/usr/local/lib/bison.simple"
YYPARSE_RETURN_TYPE
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 3:
#line 57 "parser.y"
{
            if (lastIsAsicReg) {
              ShowAsicReg (lastAddress);
              lastAddress += 4;
            } else {
              range_t range;
              range.lo = lastAddress;
              range.hi = lastAddress | (7*4);
              ShowSramRange (range);
              lastAddress = range.hi + 4;
            }
          ;
    break;}
case 4:
#line 70 "parser.y"
{
            ShowUnit();
          ;
    break;}
case 5:
#line 74 "parser.y"
{
            SetUnit (yyvsp[-2].num);
          ;
    break;}
case 6:
#line 78 "parser.y"
{
            ShowSramRange (yyvsp[-1].range);
            lastAddress = yyvsp[-1].range.hi+4;
            lastIsAsicReg = false;
          ;
    break;}
case 7:
#line 84 "parser.y"
{
            SetUnit (yyvsp[-3].num);
            ShowSramRange (yyvsp[-1].range);
            lastAddress = yyvsp[-1].range.hi+4;
            lastIsAsicReg = false;
          ;
    break;}
case 8:
#line 91 "parser.y"
{
            SetSramRange (yyvsp[-3].range, list);
            lastAddress = yyvsp[-3].range.hi+4;
            lastIsAsicReg = false;
          ;
    break;}
case 9:
#line 97 "parser.y"
{
            SetUnit (yyvsp[-5].num);
            SetSramRange (yyvsp[-3].range, list);
            lastAddress = yyvsp[-3].range.hi+4;
            lastIsAsicReg = false;
          ;
    break;}
case 10:
#line 104 "parser.y"
{
            ShowAsicReg (yyvsp[-1].num);
            lastAddress = yyvsp[-1].num+4;
            lastIsAsicReg = true;
          ;
    break;}
case 11:
#line 110 "parser.y"
{
            SetUnit (yyvsp[-4].num);
            ShowAsicReg (yyvsp[-1].num);
            lastAddress = yyvsp[-1].num+4;
            lastIsAsicReg = true;
          ;
    break;}
case 12:
#line 117 "parser.y"
{
            SetAsicReg (yyvsp[-3].num, yyvsp[-1].num);
            lastAddress = yyvsp[-3].num+4;
            lastIsAsicReg = true;
          ;
    break;}
case 13:
#line 123 "parser.y"
{
            SetUnit (yyvsp[-6].num);
            SetAsicReg (yyvsp[-3].num, yyvsp[-1].num);
            lastAddress = yyvsp[-3].num+4;
            lastIsAsicReg = true;
          ;
    break;}
case 14:
#line 129 "parser.y"
{lex_anytext=true;;
    break;}
case 15:
#line 129 "parser.y"
{lex_anytext=false;;
    break;}
case 16:
#line 130 "parser.y"
{
            SetWatchDevice (yyvsp[-2].text);
          ;
    break;}
case 17:
#line 134 "parser.y"
{          
            Watch (yyvsp[-1].range);
          ;
    break;}
case 18:
#line 140 "parser.y"
{
            yyval.range = yyvsp[0].range;
          ;
    break;}
case 19:
#line 144 "parser.y"
{          
            yyval.range.lo = yyvsp[0].range.lo * 4;
            yyval.range.hi = yyvsp[0].range.hi * 4;
          ;
    break;}
case 20:
#line 151 "parser.y"
{
            yyval.range.lo = yyval.range.hi = yyvsp[0].num;
          ;
    break;}
case 21:
#line 155 "parser.y"
{ 
            yyval.range.lo = yyvsp[-2].num;
            yyval.range.hi = yyvsp[0].num;
          ;
    break;}
case 22:
#line 162 "parser.y"
{
            list.size = 1;
            list[0] = yyvsp[0].num;
          ;
    break;}
case 23:
#line 167 "parser.y"
{
            list[list.size] = yyvsp[0].num;
          ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 465 "/usr/local/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 174 "parser.y"


int main ()
{
  debug_.SetMask("");
  if ((debugFd = open ("/dev/debug0", O_RDONLY)) < 0)
    crash (.form ("Error opening /dev/debug0, code=%d\n", errno));
  while (!megaDone) {
    yyparse ();
    debug.form ("Restarting\n");
  }
}


void yyerror (char *text)
{
  cout.form ("wow--%s\n", text);
}


void SetUnit (int unit)
{
  unitNumber = unit;
  ShowUnit ();
}


void ShowUnit (void)
{
  cout.form ("Unit is %d\n", unitNumber);
}


void ShowSramRange (range_t &range)
{
  uint32 addr;
  if (!range.Fix())
    return;
  adaptor.ReadSram (range);
  for (addr=range.lo; addr<=range.hi; addr+=4) {
    if ((addr==range.lo) | (addr % (8*4) == 0))
      cout.form ("%06x:", addr);
    cout.form ("%08x ", adaptor.mirror[addr/4]);
    if (addr % (8*4) == (7*4))
      cout.form ("\n");
  }
  if (addr % (8*4) != 0)
    cout.form ("\n");
}

void SetSramRange (range_t &range, dynarray_t<int> &list)
{
  uint32 addr;
  int index;
  if (!range.Fix())
    return;
  index = 0;
  // handle the case where the list is bigger than the range
  uint32 listHi = (list.size-1)*4+range.lo;
  if (range.hi < listHi)
    range.hi = listHi;
  for (addr=range.lo; addr<=range.hi; addr+=4) {
    adaptor.mirror[addr/4] = list[index];
    index++;
    if (index == list.size)
      index = 0;
  }
  adaptor.WriteSram (range);
}


void ShowAsicReg (uint32 address)
{
  cout.form ("@%06x:%08x\n", address, adaptor.ReadAsicReg (address));
}


void SetAsicReg (uint32 address, uint32 value)
{
  adaptor.WriteAsicReg (address, value);
  ShowAsicReg (address);
}


void SetWatchDevice (char *name)
{
  cout.form ("Setting watch device to \"%s\"\n", name);
}


void Watch (range_t &range)
{
  cout.form ("Starting watch on [%8x...%8x]\n", range.lo, range.hi);
}


void adaptor_t::ReadSram (range_t &range)
{
  int error;
  int length = range.hi + 4 - range.lo;
  int parms[4] = {unitNumber, range.lo, length, (int)&mirror[range.lo/4]};
  if ((error = ioctl (debugFd, DEBUG_IOCTL_READ_SRAM, parms)) < 0)
    crash (.form ("ioctl error %d\n", errno));
}


void adaptor_t::WriteSram (range_t &range)
{
  int error;
  int length = range.hi + 4 - range.lo;
  int parms[4] = {unitNumber, range.lo, length, (int)&mirror[range.lo/4]};
  if ((error = ioctl (debugFd, DEBUG_IOCTL_WRITE_SRAM, parms)) < 0)
    crash (.form ("ioctl error %d\n", errno));
}


uint32 adaptor_t::ReadAsicReg (uint32 address)
{
  int error;
  int parms[3] = {unitNumber, address, 0};
  if ((error = ioctl (debugFd, DEBUG_IOCTL_READ_ASIC_REG, parms)) < 0)
    crash (.form ("ioctl error %d\n", errno));
  return parms[2];
}


void adaptor_t::WriteAsicReg (uint32 address, uint32 data)
{
  int error;
  int parms[3] = {unitNumber, address, data};
  if ((error = ioctl (debugFd, DEBUG_IOCTL_WRITE_ASIC_REG, parms)) < 0)
    crash (.form ("ioctl error %d\n", errno));
}


bool range_t::Fix ()
{
  lo &= ~3;
  hi &= ~3;
  if (hi < lo)
    hi = lo;
  if (hi > adaptor_t::memorySize) {
    cout.form ("%08x is out of range\n", hi);
    return false;
  }
  return true;
}

