%{
#include "glob.h"
#include "parser.tab.h"
#define ECHO warn.form ("I got confused by \"%s\"\n", yytext)

bool lex_anytext=false;
%}

%%

w             return PFX_W;

[[:xdigit:]]+ {
                  if (lex_anytext)
                    REJECT;

                  yylval.num = 0;

                  for (char *s=yytext; *s; s++) {
                    yylval.num *= 16;
                    switch (*s) {
                    case '0'...'9': yylval.num += *s-'0'; break;
                    case 'a'...'f': yylval.num += *s-'a'+10; break;
                    case 'A'...'F': yylval.num += *s-'A'+10; break;
                    default: notreached;
                    }
                    debug.form ("num is %d\n", yylval.num);
                  }
                  return NUM;
                }

@               return '@';
-               return '-';
:               return ':';
;               return ';';
\.              return '.';
\/              return '/';
tty             return CMD_TTY;
watch           return CMD_WATCH;

[ \t]
\n              return CR;

[[:graph:]]+    {
                  if (!lex_anytext)
                    REJECT;
                  int length = strlen(yytext);
                  debug.form ("cow text is %s, length %d\n", yytext, length);
                  yylval.text = (char*) Malloc (length + 1);
                  strcpy (yylval.text, yytext);
                  return ANYTEXT;
                }

%%

