#ifndef _CODING_H_
#define _CODING_H_

#include "glob.h"

/*--------------------------------------------------------------------------*
 * other "extensions" to C
 *--------------------------------------------------------------------------*/

#define notreached assert(false)
#define NL << "\n"

#undef NULL
#define NULL ((void*)0)

typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned int   uint32;
typedef unsigned long  uint64;

typedef char  int8;
typedef short int16;
typedef int   int32;
typedef long  int64;

#define Swap(A,B)          \
 ({typeof(A) _swap_temp=A; \
   A=B;                    \
   B=_swap_temp;           \
 })

#define arsize(a) (sizeof(a)/sizeof(a[0]))

/*--------------------------------------------------------------------------* 
 * classes & macros for debugging/tracing
 *--------------------------------------------------------------------------*/

class output_t {
  ostream &stream;
  
public:
  uint32 mask;

  output_t(ostream &s) : stream(s), mask(1) {}

  ostream &operator()(const char *func        =NULL,
                      const char *file        =NULL,
                      const int line          =-1);
  void SetMask (char *s);
};

extern output_t out_, warn_, debug_;

#define out    if (!out_.mask)  ; else out_()
#define warn   if (!warn_.mask) ; else warn_() 

#define debugX(x)  if (!(debug_.mask&(1<<(x)))) ; else debug_(__FUNCTION__)
#define pdebugX(x) if (!(debug_.mask&(1<<(x)))) ; else debug_()

#define debug  debug5
#define pdebug pdebug5

#define debug0 debugX(0)
#define debug1 debugX(1)
#define debug2 debugX(2)
#define debug3 debugX(3)
#define debug4 debugX(4)
#define debug5 debugX(5)
#define debuga debugX(6)
#define debugb debugX(7)
#define debugc debugX(8)
#define debugd debugX(9)
#define debuge debugX(10)
#define debugf debugX(11)
#define debugg debugX(12)
#define debugh debugX(13)
#define debugi debugX(14)
#define debugj debugX(15)
#define debugk debugX(16)
#define debugl debugX(17)
#define debugm debugX(18)
#define debugn debugX(19)
#define debugo debugX(20)
#define debugp debugX(21)
#define debugq debugX(22)
#define debugr debugX(23)
#define debugs debugX(24)
#define debugt debugX(25)
#define debugu debugX(26)
#define debugv debugX(27)
#define debugw debugX(28)
#define debugx debugX(29)
#define debugy debugX(30)
#define debugz debugX(31)

#define pdebug0 pdebugX(0)
#define pdebug1 pdebugX(1)
#define pdebug2 pdebugX(2)
#define pdebug3 pdebugX(3)
#define pdebug4 pdebugX(4)
#define pdebug5 pdebugX(5)
#define pdebuga pdebugX(6)
#define pdebugb pdebugX(7)
#define pdebugc pdebugX(8)
#define pdebugd pdebugX(9)
#define pdebuge pdebugX(10)
#define pdebugf pdebugX(11)
#define pdebugg pdebugX(12)
#define pdebugh pdebugX(13)
#define pdebugi pdebugX(14)
#define pdebugj pdebugX(15)
#define pdebugk pdebugX(16)
#define pdebugl pdebugX(17)
#define pdebugm pdebugX(18)
#define pdebugn pdebugX(19)
#define pdebugo pdebugX(20)
#define pdebugp pdebugX(21)
#define pdebugq pdebugX(22)
#define pdebugr pdebugX(23)
#define pdebugs pdebugX(24)
#define pdebugt pdebugX(25)
#define pdebugu pdebugX(26)
#define pdebugv pdebugX(27)
#define pdebugw pdebugX(28)
#define pdebugx pdebugX(29)
#define pdebugy pdebugX(30)
#define pdebugz pdebugX(31)

/*--------------------------------------------------------------------------* 
 * Assert, etc.
 *--------------------------------------------------------------------------*/

#if 1
#define assert(CONDITION) if (CONDITION) ; \
 else crash(<< "assertion failed:  \"" #CONDITION "\"\n")
#else
#define assert(CONDITION)
#endif

#define crash(args...) do { \
 warn_ (__FUNCTION__, __FILE__, __LINE__) args; \
 exit(1); } \
while(0)

#endif /* _CODING_H_ */

