%{
#include <string.h>
#include "jmexe.h"
#include "y.tab.h"

typedef struct {
    char *text;
    int token;
    int state;
} command_t;

command_t commands [] = {
    {"help",     CMD_HELP,     flex_eat },
    {"atm_open", CMD_ATM_OPEN, flex_arg }
};

#define MATCH_NONE (-2)
#define MATCH_MANY (-1)

private int MatchCommand (char *text)
{
    int count, which=0, i;
    int length = strlen(text);
    count = 0;
    for (i=0; i<arsize(commands); i++)
        if (strncmp (commands[i].text, text, length) == 0) {
            which = i;
            count++;
        }

    if (count == 0)
        return MATCH_NONE;
    if (count > 2)
        return MATCH_MANY;
    return which;
}
%}

%x flex_eat
%x flex_arg

%%

<INITIAL,flex_arg,flex_eat>[ \t]*      ; /* eat whitespace */
<INITIAL,flex_arg,flex_eat>\n          BEGIN INITIAL; return NL;

\?          BEGIN flex_eat; return CMD_HELP;

[A-Za-z][A-Za-z0-9_]* {
                int which = MatchCommand (yytext);
                if (which == MATCH_NONE) {
                    BEGIN flex_eat;
                    return CMD_UNKNOWN;
                }
                if (which == MATCH_MANY) {
                    BEGIN flex_eat;
                    return CMD_AMBIGUOUS;
                }
                printf ("%s:", commands[which].text);
                BEGIN  commands[which].state;
                return commands[which].token;
            }

<flex_arg>[A-Za-z][A-Za-z0-9]* {
                strncpy (yylval.ident, yytext, MAX_IDENT_LENGTH);
                yylval.ident[MAX_IDENT_LENGTH-1] = 0;
                return IDENT;
            }

<flex_eat>.* {
                BEGIN INITIAL;
                return JUNK;
            }

%%




