/* Read some test messages */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <jetmsg.h>

extern int close (int); /* HACK */

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)

#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

char device[] = "/dev/jetmsg0";

void doit (int fd)
{
    int retval;
    int i;
    char buffer[16];

    for (i=0; i<16; i++)
        buffer[i] = 0;
    
    warn ("(fd %d):", fd);
    if ((retval = atm_recv (fd, buffer, sizeof(buffer))) < 0)
      crash ("atm_recv failed, errno %d\n", errno);
    warn ("(bytes %4d):", retval);
        
    warn ("data:[");
    for (i=0; i<retval; i++)
      if (buffer[i]>=' ')
        warn ("%c",buffer[i]);
      else
        warn ("(%d)",buffer[i]);
    warn ("]\n");
}

int main(int argc, char **argv)
{
    int fd0, fd1;
    int vpivci0, vpivci1, snap;
    int error;

    if (argc == 4) {
        vpivci0 = atoi(argv[1]);
        vpivci1 = atoi(argv[2]);
        snap    = atoi(argv[3]);
    }
    else
        crash ("Usage: %s vpivci vpivci snap\n", argv[0]);

    if ((fd0 = atm_open(device, O_RDONLY)) < 0)
        crash ("atm_open \"%s\" failed, errno %d!\n", device, errno);
    if ((fd1 = atm_open(device, O_RDONLY)) < 0)
        crash ("atm_open \"%s\" failed, errno %d!\n", device, errno);
    warn ("Using fd's %d and %d\n", fd0, fd1);

    if ((error = atm_bind_pvc (fd0, vpivci0, 0, 0, 0, 0)) < 0)
        crash ("atm_bind_pvc failed, errno %d\n", errno);
    if ((error = atm_bind_rx_ipvc (fd1, vpivci1, snap)) < 0)
        crash ("atm_bind_rx_ipvc failed, errno %d\n", errno);
    
    for (;;) {
        int retval;
        doit (fd0);
    }
    
    if ((error = atm_close (fd0)) < 0)
        crash ("atm_close failed!\n");
    if ((error = atm_close (fd1)) < 0)
        crash ("atm_close failed!\n");

    return 0;
}



