/* WARNING: THIS IS NOT THE ORIGINAL FILE               */
/*          ANY MODIFICATIONS TO THIS FILE WILL BE LOST */
/* WARNING: THIS IS NOT THE ORIGINAL FILE               */
/*          ANY MODIFICATIONS TO THIS FILE WILL BE LOST */
/* WARNING: THIS IS NOT THE ORIGINAL FILE               */
/*          ANY MODIFICATIONS TO THIS FILE WILL BE LOST */
/*
 * Module: network driver interface
 * File:   if_ijet.h
 * Author: Todd Mummert
 *
 * This file contains various structures and defines that are needed
 * for the network driver.
 *
 * User level visible routines and ioctl interfaces are in if_ijet_user.h
 *
 */
#ifndef IF_IJETH                /* don't do this more than once */
#define IF_IJETH

#include <dev/pci/pcivar.h>
#include <net/if_llc.h>
#include <dev/pci/jetland/include/ijet_ll.h>
#include <dev/pci/jetland/include/if_ijet.h>

/* we have 2 freelists for rcv */
/* FIX:: if the adaptor worked..we'd have separate header/data flists */
#define IJET_NUM_FREELISTS 1

/*
 * Structure for linking vr chains and containing the mapping
 * back to the locked mbuf.
 */
typedef struct ijet_mbuf {
  struct mbuf *m;               /* the mbuf we need to remember */
  struct ijet_mbuf *next;       /* the next one in the chain */
  vr_t *head;
  vr_t *tail;
  int count;                    /* either a count of mbufs or credit */
} ijet_mbuf_t;

/*
 * Struct for xmt for items that are needed on a per VCid basis.
 */
#define IJET_XF_CREDITWAIT   0x1
#define IJET_XF_BUSYWAIT     0x2
#define IJET_XF_NEWCREDIT    0x4

typedef struct ijet_xmt_vc {
  ijet_mbuf_t *pre_head, *pre_tail, *asm_head, *asm_tail,
  *done_head, *done_tail;
  int credit;
  uint flags;
  struct ijet_xmt_vc *nextxmtvc;
  int cellcount;
} ijet_xmt_vc_t;

/* Structure for linking rcv vr chains. */
typedef struct ijet_rcv_vc {
  vr_t *vr_chain_head;		/* so we know to start taking items */
  vr_t *vr_chain_tail;		/* so we can place things quickly */
  int cellcount;
} ijet_rcv_vc_t;

/* we use the following structure to reduce the number of SRAM
 * accesses across the PCI bus
 */

/* now a small struct for ARP entries
 * NOTE: we might want to add a flags struct to indicate the current
 * state of this VC
 *
 * depending on how many ARP entries we will be handling, we may want
 * to create a hash table for these entries
 */

#define IJET_ART_HASH 16
#define IJET_ART_SIZE 1024              /* we may want to kalloc this space */
#define IP_SVC  1
#define IP_PVC  2
#define LLC_VC_TIMEOUT 900              /* 15 minutes idle timer */ 
typedef struct ijet_art_ent {
  uint32 ipaddr;                        /* internet address */
  vcid_t tx_VCid;                       /* Transmit VCid */
  vcid_t rx_VCid;                       /* Receive VCid */
  int flag;                             /* SVC or PVC */
  int idle;                             /* idle timer */
  struct ijet_art_ent *next;            /* next one in the chain */
} ijet_art_ent_t;


/*
 * Credit cell format...all 48 bytes
 */
typedef struct {
  uint   unused0:16;
  uint   highvci:8;
  uint   unused1:4;
  uint   lowvci:4;
  uint   unused2:8;
  uint   value:8;
  uint   unused3:8;
  uint   valueredux:8;
  uint32 deadbeef;
  uint32 unused4[9];
} ijet_credit_cell_t;

/* basic structure for containing the device specific information */
#define IJET_HW_ADDR_LEN 6
typedef struct {
  struct device ijet_dev;               /* this has to be first?? */
  void *ijet_ih;
  struct ifnet ijet_if;
  bus_chipset_tag_t ijet_bc;
  pci_chipset_tag_t ijet_pc;
  pcitag_t pcitag;
                                        /* common stuff */

  vm_offset_t sramBase;
  vm_offset_t asicBase;
  vm_offset_t sonetBase;
  
  uint8 address[IJET_HW_ADDR_LEN];      /* hardware address */

  int opencnt;

  /* ucode stuff */
  caddr_t ucode;
  int     ucodesize;

  /* now some stuff for arp entries */
  ijet_art_ent_t art_pool[IJET_ART_SIZE];
  ijet_art_ent_t *art[IJET_ART_HASH];   /* art entry chains */
  ijet_art_ent_t *art_free;             /* free list */

  /* Everything from here on down will be zero'd when the
   * board reset routine is called.
   * NOTE:: flags has to be the first entry to be zero'd
   */
  int flags;                            /* device flags */

  /*
   * Transmit stuff.
   */
  mailbox_t xmt_mbox;		        /* the mbox where we get msg's */
  bool xmt_mbox_free;
  vr_t *xmt_mbox_vrp;
  int xmt_VRs;                          /* set by user agent */
  int xmt_VR_freecnt;                   /* how many we can use */
  vr_t *xmt_freeVR_head;	        /* the actual list of free VRs */
  vr_t *xmt_freeVR_tail;
  
  int xmt_VCids;                        /* set by user agent */
  ijet_xmt_vc_t *xmtvc;                 /* things on a per vc basis */
  int xmt_mbufs;			/* set by user agent */
  ijet_mbuf_t *xmt_mbuf_pool;		/* where we keep them */
  ijet_mbuf_t *xmt_mbuf_base;	        /* so we can free it later */
  int xmt_asm_needed;
  int xmt_round_robin;			/* so we can be somewhat fair */

  /*
   * rcv stuff
   */
  mailbox_t rcv_mbox;		        /* the mbox where we get msg's */
  bool rcv_mbox_free;
  freelist_t rcv_flist[IJET_NUM_FREELISTS]; /* rcv freelists */
  uint32 rcv_cnt[IJET_NUM_FREELISTS];       /* set by user agent */
  vr_t *rcv_mbox_vrp;
  vr_t *rcv_VR_head;
  vr_t *rcv_VR_tail;
  vm_offset_t *ptov;			/* virtual address of buffers */
  int rcv_VCids;			/* set by user agent */
  ijet_rcv_vc_t *rcvvc;			/* for reassembly chaining */

  /*
   * credit stuff
   */
  mailbox_t credit_mbox;	        /* the mbox where we get msg's */
  bool credit_mbox_free;
  freelist_t credit_flist;
  uint32 credit_VRs;		        /* number of credit_VRs */
  vr_t *credit_mbox_vrp;
  vm_offset_t credit_base;
  uint32 credit_base_size;
  int credit_waiting;		        /* count of number of vcs waiting */
  int creditmarker;
  int creditinterval;
  vr_t *creditvrhead;
  vr_t *creditvrtail;
  ijet_credit_cell_t *currentcreditva;
  ijet_credit_cell_t *lastcreditva;
  uint32 maxvpivci;
  uint32 *vpivci2vcid;			/* credit values */

  /* misc stuff */
  int total_vrs;
  vm_offset_t mirror2sramoffset;
  vr_t *sram;
 
  /* vince stuff */
  #define MAX_ARPS      10
  bool vince_flag;                      /* is vince running? */
  struct proc *vince_proc;              /* vince process id */
  uint32 pending_arps[MAX_ARPS];        /* ARP requests pending */
  int next_arp;

} ijet_softc_t;

/* various defines to allow us to free the last VR in the mbox */
#define IJET_VRTYPE_XMT     0x1         /* was a xmt mbuf */
#define IJET_VRTYPE_RCV     0x2         /* off a rcv freelist */

/* various ijet_flags defines */
#define IJET_FL_EXISTS      0x1         /* if we find the board */
#define IJET_FL_CFGINIT     0x2         /* if userlevel cfg happened */
#define IJET_FL_UCODEIS     0x4	        /* ucode is in a kernel buffer */

/* various if_flags defines */

#define IJET_NO_NEXT_VR 0

#define IJET_ATM_HDR   (sizeof(struct llc)+sizeof(vcid_t))
#define IJET_ATM_MTU   (9180+IJET_ATM_HDR)

/* we need to be able to break apart the status bits */
#define IJET_STATUS_XMT 0
#define IJET_STATUS_RCV 1

/* PCI device numbers */
#define IJET_CONFIG_ID  (0x12348086ul)

/* PCI memory locations ...offsets in configuration space */
#define IJET_PCI_SRAM   0x10
#define IJET_PCI_ASIC   0x14
#define IJET_PCI_SONET  0x18
#define IJET_PCI_FLASH  0x1c
#define IJET_PCI_RESET  0x4c

/* some defines used in board reset */
#define IJET_PCI_SAVE   0x48
#define IJET_RESET_WAIT 0x1000000

#define IJET_SRAM_SIZE  0x40000	        /* 256k */

#define IJET_EXTRA_VRS  0x10
#define IJET_STATIC_TABLE_SIZE 0x400

#define IJET_DYNO_LISTS    0x2
#define IJET_DYNO_ENTRIES  0x40
#define IJET_RXVC_EXTRACT  0x6
#endif
