/* this is a test of the ioctl routine */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>


#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int); /* HACK */

void main(int argc, char **argv)
{
  int fd;
  char *data = (char *) 0xdeadbeef;
  iocopy_req_t iocpr;
  ijet_softc_t ijets;
  uint offset, addr;

  if (argc<2 || sscanf(argv[1], "0x%x", &offset) != 1)
    offset = 0x64;

  offset<<=2;
  
  printf("using offset 0x%x\n", offset);
  if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
    printf("failed to open device!\n");
    exit(1);
  }

  if (ioctl(fd, IJETIOC_STRUCT_ADDR, &data) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }

  printf("value of ijets = 0x%08x\n", (int) data);

  iocpr.system = data;
  iocpr.user = (char *) &ijets;
  iocpr.len = sizeof(ijet_softc_t);
  
  if (ioctl(fd, IJETIOC_GET_MEM, &iocpr) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }

  addr = ijets.sonetBase + offset;
  printf("value at address 0x%08x", addr);
  fflush(stdout);
  if (ioctl(fd, IJETIOC_GET_UINT8, &addr) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }
  printf(" is 0x%x\n", addr);
  
  close(fd);
  exit(0);
}
