/* this is a test of the ioctl routine */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <unistd.h>

#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

typedef struct {
  uint32 ip_addr;
  uint32 vcid;
  char   string[16];
} arp_entry_t;

#define VP1 65536

extern int close (int); /* HACK */

void DoIoctl (int fd, uint32 command, void *param);
void DoArp (int fd, int vpivci, char *ipAddr, int rxNeeded);

void main(int argc, char **argv)
{
    static arp_entry_t arptable[] = {
        {0, 28, "192.80.210.28"},   /* hendrix */
        {0, 29, "192.80.210.29"},   /* janis */
        {0, 39, "192.80.210.39"},   /* river */
	{0, 41, "192.80.210.41"},   /* joplin */
        {0, 45, "192.80.210.45"},   /* hephaestus */
        {0, 82, "192.80.210.82"},   /* argus */
        {0, 141, "192.80.210.141"}, /* marilyn */
	{0, 200, "192.80.210.200"}, /* ibis */
	{0, 201, "192.80.210.201"}  /* lark */
    };

    int fd;
    arp_entry_t *ate;

    if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
        printf("failed to open device!\n");
        exit(1);
    }

    for (ate = arptable; ate < arptable + arsize(arptable); ate++)
        DoArp (fd, ate->vcid, ate->string, TRUE);

    if (0)
    {
        char s[128];
        int i;
        for (i=256; i < 768; i++) {
            sprintf (s, "128.90.%d.%d", i/256, i%256);
            DoArp (fd, i, s, FALSE);
        }
    }

    {
        static ijet_ioctl_open_rx_t open_rx = {
            CELL_PROCESSING_AAL5,
            0, 0 };

        open_rx.vpivci = 0xcc;     /* kosak HACK */
        if (ioctl(fd, IJETIOC_OPEN_CREDIT, &open_rx) < 0) {
            printf ("credit boy:ioctl failed, errno = %d\n", errno);
            exit(1);
        }
        printf("credit vpivci = %d vcid = %d\n", open_rx.vpivci,
               open_rx.vcid);
    }
  
    close(fd);
    exit(0);
}


void DoArp (int fd, int vpivci, char *ipAddr, int rxNeeded)
{
    ijet_ioctl_open_tx_t open_tx ={
        CELL_PROCESSING_AAL5,
        SCHEDULE_STATIC,
        0, 0
    };
    ijet_ioctl_open_rx_t open_rx = {
        CELL_PROCESSING_AAL5,
        0, 0
    };
    arp_entry_t ate;

    ate.ip_addr = inet_addr(ipAddr);
    open_tx.vpivci = vpivci;
    
    open_tx.vpivci = vpivci;
    DoIoctl(fd, IJETIOC_OPEN_TX, &open_tx);
    printf ("%20s vpivci %-9d vcid %-9d\n", ipAddr, vpivci, open_tx.vcid);

    if (rxNeeded) {
        open_rx.vpivci = vpivci;
        DoIoctl(fd, IJETIOC_OPEN_RX, &open_rx);
        printf("   rx vcid = %d\n", open_rx.vcid);
    }

    ate.vcid = open_tx.vcid;
    DoIoctl(fd, IJETIOC_ADD_ART, &ate);
}


void DoIoctl (int fd, uint32 command, void *param)
{
    int error;
    if ((error = ioctl (fd, command, param)) < 0) {
        printf ("ioctl 0x%x failed: error %d\n", command, error);
        exit (1);
    }
}
